/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splusserver.api.bridge;

import com.insightful.splusserver.api.bridge.CommonServerBridge;
import com.insightful.splusserver.api.bridge.IAdminServiceBridge;
import com.insightful.splusserver.exception.JobDoesNotExistException;
import com.insightful.splusserver.exception.NotAuthenticatedException;
import com.insightful.splusserver.exception.ServerNotRespondingException;
import com.insightful.splusserver.exception.api.BridgeException;
import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AdminServiceBridgeUrl
extends CommonServerBridge
implements IAdminServiceBridge {
    public AdminServiceBridgeUrl(String serviceUrl) throws BridgeException, ServerNotRespondingException {
        this.setServiceUrl(serviceUrl);
        this.ping();
    }

    public AdminServiceBridgeUrl(String userName, String password, String serviceUrl) throws BridgeException, NotAuthenticatedException, ServerNotRespondingException {
        this.setServiceUrl(serviceUrl);
        if (this.ping().booleanValue()) {
            this.setUserName(userName);
            this.setPassword(password);
            if (!this.validateUserCredentials().booleanValue()) {
                throw new NotAuthenticatedException("Invalid credentials");
            }
        }
    }

    public String getJob(String jobId) throws BridgeException, JobDoesNotExistException, NotAuthenticatedException {
        try {
            String url = this.getServiceUrl() + "/api/administration/" + "getJob" + "?" + "jobId" + "=" + jobId;
            String xml = this.readUrlResult(url);
            if ("<authentication status=\"false\" />".equals(xml)) {
                throw new NotAuthenticatedException();
            }
            if (xml == null || xml.indexOf("HTTP Status 500") >= 0) {
                throw new JobDoesNotExistException("Job does not exists for: " + jobId);
            }
            return xml;
        }
        catch (MalformedURLException e) {
            throw new BridgeException("Creation of URL failed", (Throwable)e);
        }
        catch (IOException e) {
            throw new BridgeException("Creation of URL failed", (Throwable)e);
        }
        catch (Exception e) {
            throw new JobDoesNotExistException((Throwable)e);
        }
    }

    public String getJobs(String userId) throws NotAuthenticatedException, BridgeException {
        try {
            String url = this.getServiceUrl() + "/api/administration/" + "getJobs" + (!StringUtils.isEmpty((String)userId) ? "?userId=" + userId : "");
            String xml = this.readUrlResult(url);
            if ("<authentication status=\"false\" />".equals(xml)) {
                throw new NotAuthenticatedException();
            }
            return xml;
        }
        catch (MalformedURLException e) {
            throw new BridgeException("Creation of URL failed", (Throwable)e);
        }
        catch (IOException e) {
            throw new BridgeException("Creation of URL failed", (Throwable)e);
        }
    }

    public String interrupt(String jobId) throws BridgeException, NotAuthenticatedException {
        try {
            String url = this.getServiceUrl() + "/api/administration/" + "interrupt" + "?" + "jobId" + "=" + jobId;
            String xml = this.readUrlResult(url);
            if ("<authentication status=\"false\" />".equals(xml)) {
                throw new NotAuthenticatedException();
            }
            return xml;
        }
        catch (MalformedURLException e) {
            throw new BridgeException("Creation of URL failed", (Throwable)e);
        }
        catch (IOException e) {
            throw new BridgeException("Creation of URL failed", (Throwable)e);
        }
    }

    public String purge(String jobId) throws BridgeException, NotAuthenticatedException {
        try {
            String url = this.getServiceUrl() + "/api/administration/" + "purge" + "?" + "jobId" + "=" + jobId;
            String xml = this.readUrlResult(url);
            if ("<authentication status=\"false\" />".equals(xml)) {
                throw new NotAuthenticatedException();
            }
            return xml;
        }
        catch (MalformedURLException e) {
            throw new BridgeException("Creation of URL failed", (Throwable)e);
        }
        catch (IOException e) {
            throw new BridgeException("Creation of URL failed", (Throwable)e);
        }
    }

    public String getServerTime() throws BridgeException, NotAuthenticatedException {
        try {
            String url = this.getServiceUrl() + "/api/administration/" + "getServerTime";
            String xml = this.readUrlResult(url);
            if ("<authentication status=\"false\" />".equals(xml)) {
                throw new NotAuthenticatedException();
            }
            return xml;
        }
        catch (MalformedURLException e) {
            throw new BridgeException("Creation of URL failed", (Throwable)e);
        }
        catch (IOException e) {
            throw new BridgeException("Creation of URL failed", (Throwable)e);
        }
    }

    protected Log getLogger() {
        return LogFactory.getLog(AdminServiceBridgeUrl.class);
    }
}

