/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splusserver.api.java;

import com.insightful.splusserver.api.CommonApi;
import com.insightful.splusserver.api.bridge.ExpressionServiceBridgeUrl;
import com.insightful.splusserver.api.bridge.IExpressionServiceBridge;
import com.insightful.splusserver.domain.SplusDataResult;
import com.insightful.splusserver.exception.IException;
import com.insightful.splusserver.exception.NotAuthenticatedException;
import com.insightful.splusserver.exception.ServerNotRespondingException;
import com.insightful.splusserver.exception.api.ApiException;
import com.insightful.splusserver.exception.api.BridgeException;
import com.insightful.splusserver.util.XmlUtil;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class ExpressionService
extends CommonApi
implements Serializable {
    private static final long serialVersionUID = 5102L;
    private IExpressionServiceBridge mExpressionServiceBridge = null;

    public ExpressionService(String serviceUrl) throws ApiException, NotAuthenticatedException, ServerNotRespondingException {
        try {
            this.mExpressionServiceBridge = new ExpressionServiceBridgeUrl(serviceUrl);
            this.setServerBridge(this.mExpressionServiceBridge);
        }
        catch (BridgeException e) {
            throw new ApiException("Creation of ServerBridge failed", (Throwable)e);
        }
    }

    public ExpressionService(String userName, String password, String serviceUrl) throws ApiException, NotAuthenticatedException, ServerNotRespondingException {
        try {
            this.mExpressionServiceBridge = new ExpressionServiceBridgeUrl(userName, password, serviceUrl);
            this.setServerBridge(this.mExpressionServiceBridge);
        }
        catch (BridgeException e) {
            throw new ApiException("Creation of ServerBridge failed", (Throwable)e);
        }
    }

    IExpressionServiceBridge getExpressionServiceBridge() {
        return this.mExpressionServiceBridge;
    }

    void setExpressionServiceBridge(IExpressionServiceBridge serviceBridge) {
        this.mExpressionServiceBridge = serviceBridge;
        this.setServerBridge(serviceBridge);
    }

    protected Log getLogger() {
        return LogFactory.getLog(ExpressionService.class);
    }

    public SplusDataResult eval(String cmd, Boolean async) throws IException {
        SplusDataResult splus = null;
        String xml = null;
        try {
            Object unmarshalledObj;
            if (!async.booleanValue()) {
                this.getExpressionServiceBridge().resetTimeouts();
            }
            splus = SplusDataResult.class.isInstance(unmarshalledObj = XmlUtil.unmarshal(SplusDataResult.class, (String)(xml = this.getExpressionServiceBridge().eval(cmd, async)))) ? XmlUtil.unmarshalSplusDataResult((String)xml) : (SplusDataResult)XmlUtil.unmarshal(SplusDataResult.class, (String)xml);
            if (!async.booleanValue()) {
                this.getExpressionServiceBridge().setTimeouts();
            }
        }
        catch (BridgeException e) {
        }
        catch (MarshalException e) {
            if (xml != null) {
                this.checkException(xml);
            }
        }
        catch (MappingException e) {
        }
        catch (ValidationException e) {
            // empty catch block
        }
        return splus;
    }

    public SplusDataResult eval(String cmd, Date date) throws IException {
        SplusDataResult splus = null;
        String xml = null;
        try {
            xml = this.getExpressionServiceBridge().eval(cmd, date.getTime());
            Object unmarshalledObj = XmlUtil.unmarshal(SplusDataResult.class, (String)xml);
            splus = SplusDataResult.class.isInstance(unmarshalledObj) ? XmlUtil.unmarshalSplusDataResult((String)xml) : (SplusDataResult)XmlUtil.unmarshal(SplusDataResult.class, (String)xml);
        }
        catch (BridgeException e) {
        }
        catch (MarshalException e) {
            if (xml != null) {
                this.checkException(xml);
            }
        }
        catch (MappingException e) {
        }
        catch (ValidationException e) {
            // empty catch block
        }
        return splus;
    }

    public SplusDataResult getJob(String jobId) throws IException {
        SplusDataResult splus = null;
        String xml = null;
        try {
            xml = this.getExpressionServiceBridge().getJob(jobId);
            Object unmarshalledObj = XmlUtil.unmarshal(SplusDataResult.class, (String)xml);
            splus = SplusDataResult.class.isInstance(unmarshalledObj) ? XmlUtil.unmarshalSplusDataResult((String)xml) : (SplusDataResult)XmlUtil.unmarshal(SplusDataResult.class, (String)xml);
        }
        catch (BridgeException e) {
        }
        catch (MarshalException e) {
            if (xml != null) {
                this.checkException(xml);
            }
        }
        catch (MappingException e) {
        }
        catch (ValidationException e) {
            // empty catch block
        }
        return splus;
    }
}

