/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.record;

import com.insightful.gdevice.XMLElement;
import com.insightful.splus.SplusSystem;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Robot;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;

public class UserInputPlayer {
    private Frame parent;
    private Point frameLocation;
    private Dimension frameSize;
    private Robot robot;
    private XMLElement fullList = new XMLElement();
    private LocalThread playThread;
    private boolean isRunningFlag = false;

    public UserInputPlayer(Frame frame, String string) throws AWTException, FileNotFoundException, IOException {
        this(frame, new InputStreamReader(SplusSystem.getServerFileHandler().getServerFileInputStream(string)));
    }

    public UserInputPlayer(Frame frame, Reader reader) throws AWTException, FileNotFoundException, IOException {
        this.parent = frame;
        this.robot = new Robot();
        this.playThread = new LocalThread();
        this.frameLocation = frame == null ? new Point(0, 0) : frame.getLocationOnScreen();
        this.fullList.parseFromReader(reader);
        if (!this.fullList.getTagName().equalsIgnoreCase("UserInputRecording")) {
            throw new IllegalArgumentException("File does not contain a UserInputRecording");
        }
        try {
            int n = Integer.parseInt(this.fullList.getProperty("FRAMEWIDTH"));
            int n2 = Integer.parseInt(this.fullList.getProperty("FRAMEHEIGHT"));
            this.frameSize = new Dimension(n, n2);
        }
        catch (Exception exception) {
            throw new RuntimeException("FRAMEWIDTH or FRAMEHEIGHT property is not specified for UserInputRecording");
        }
    }

    public void start() {
        this.setRunning(true);
        this.playThread.start();
    }

    public void stop() {
        this.setRunning(false);
    }

    public synchronized boolean isRunning() {
        return this.isRunningFlag;
    }

    private synchronized void setRunning(boolean bl) {
        this.isRunningFlag = bl;
    }

    public static void playFile(String string) throws AWTException, FileNotFoundException, IOException {
        UserInputPlayer userInputPlayer = new UserInputPlayer(SplusSystem.getDefaultFrame(), string);
        userInputPlayer.start();
    }

    private class LocalThread
    extends Thread {
        private LocalThread() {
        }

        public void run() {
            if (UserInputPlayer.this.parent != null && ((UserInputPlayer)UserInputPlayer.this).frameSize.height != 0 && ((UserInputPlayer)UserInputPlayer.this).frameSize.width != 0) {
                UserInputPlayer.this.parent.setSize(UserInputPlayer.this.frameSize);
                UserInputPlayer.this.parent.validate();
            }
            Enumeration enumeration = UserInputPlayer.this.fullList.enumerateChildren();
            while (UserInputPlayer.this.isRunning() && enumeration.hasMoreElements()) {
                XMLElement xMLElement = (XMLElement)enumeration.nextElement();
                String string = xMLElement.getTagName();
                if (string.equalsIgnoreCase("D")) {
                    long l;
                    for (l = Long.parseLong(xMLElement.getProperty("MS", "0")); l > 60000L; l -= 60000L) {
                        UserInputPlayer.this.robot.delay(60000);
                    }
                    UserInputPlayer.this.robot.delay((int)l);
                    continue;
                }
                if (string.equalsIgnoreCase("KP")) {
                    int n = Integer.parseInt(xMLElement.getProperty("KEYCODE"));
                    UserInputPlayer.this.robot.keyPress(n);
                    continue;
                }
                if (string.equalsIgnoreCase("KR")) {
                    int n = Integer.parseInt(xMLElement.getProperty("KEYCODE"));
                    UserInputPlayer.this.robot.keyRelease(n);
                    continue;
                }
                if (string.equalsIgnoreCase("MM")) {
                    int n = ((UserInputPlayer)UserInputPlayer.this).frameLocation.x + Integer.parseInt(xMLElement.getProperty("X"));
                    int n2 = ((UserInputPlayer)UserInputPlayer.this).frameLocation.y + Integer.parseInt(xMLElement.getProperty("Y"));
                    UserInputPlayer.this.robot.mouseMove(n, n2);
                    continue;
                }
                if (string.equalsIgnoreCase("MP")) {
                    int n = Integer.parseInt(xMLElement.getProperty("BUTTONS"));
                    UserInputPlayer.this.robot.mousePress(n);
                    continue;
                }
                if (string.equalsIgnoreCase("MR")) {
                    int n = Integer.parseInt(xMLElement.getProperty("BUTTONS"));
                    UserInputPlayer.this.robot.mouseRelease(n);
                    continue;
                }
                throw new RuntimeException("Cannot generate event of type " + string);
            }
            UserInputPlayer.this.setRunning(false);
        }
    }
}

