/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.statdlg;

import com.insightful.controls.SplusBoxFiller;
import com.insightful.controls.SplusCheckBox;
import com.insightful.controls.SplusDialog;
import com.insightful.controls.SplusFunctionInfo;
import com.insightful.controls.SplusGroupPanel;
import com.insightful.controls.SplusIntegerSpinner;
import com.insightful.controls.SplusRadioButtonGroup;
import com.insightful.controls.SplusTextField;
import com.insightful.splus.SplusDataColumnComboBox;
import com.insightful.splus.SplusDataColumnListBox;
import com.insightful.splus.SplusDataColumnListProvider;
import com.insightful.splus.SplusDataSetComboBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class ArimaDialog
extends SplusDialog {
    SplusDataSetComboBox dataSet;
    SplusDataColumnComboBox dataColumn;
    SplusRadioButtonGroup seasonality;
    SplusIntegerSpinner periodSpinner;
    SplusCheckBox enterInitial;
    SplusCheckBox addCovariates;
    SplusTextField arCoef;
    SplusTextField maCoef;
    SplusDataColumnListBox covariateList;

    public ArimaDialog() {
        super("ARIMA Modeling");
        JTabbedPane jTabbedPane = new JTabbedPane();
        SplusFunctionInfo splusFunctionInfo = new SplusFunctionInfo("menuArima");
        this.setFunctionInfo(splusFunctionInfo);
        JPanel jPanel = new JPanel();
        jTabbedPane.addTab("Model", jPanel);
        Box box = new Box(1);
        Box box2 = new Box(1);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(box);
        jPanel.add(box2);
        SplusGroupPanel splusGroupPanel = new SplusGroupPanel("Data");
        box.add(splusGroupPanel);
        this.dataSet = new SplusDataSetComboBox();
        splusGroupPanel.add(this.dataSet);
        splusFunctionInfo.add(this.dataSet, "data.x");
        this.dataColumn = new SplusDataColumnComboBox(this.dataSet);
        splusGroupPanel.add(this.dataColumn);
        splusFunctionInfo.add(this.dataColumn, "x", true);
        SplusGroupPanel splusGroupPanel2 = new SplusGroupPanel("ARIMA Model Order");
        box.add(splusGroupPanel2);
        SplusIntegerSpinner splusIntegerSpinner = new SplusIntegerSpinner("Autoregressive (p):", 'R', 0, 100, 1);
        splusGroupPanel2.add(splusIntegerSpinner);
        splusFunctionInfo.add(splusIntegerSpinner, "model.ar");
        SplusIntegerSpinner splusIntegerSpinner2 = new SplusIntegerSpinner("Difference (d):", 'D', 0, 100, 1);
        splusGroupPanel2.add(splusIntegerSpinner2);
        splusFunctionInfo.add(splusIntegerSpinner2, "model.d");
        SplusIntegerSpinner splusIntegerSpinner3 = new SplusIntegerSpinner("Moving Avg. (q):", 'M', 0, 100, 1);
        splusGroupPanel2.add(splusIntegerSpinner3);
        splusFunctionInfo.add(splusIntegerSpinner3, "model.ma");
        SplusGroupPanel splusGroupPanel3 = new SplusGroupPanel("ARIMA Model Periodicity");
        box.add(splusGroupPanel3);
        this.seasonality = new SplusRadioButtonGroup("Seasonality", 'E', new String[]{"None (1)", "Quarterly (4)", "Monthly (12)", "Other"});
        this.seasonality.setValue("None (1)");
        splusGroupPanel3.add(this.seasonality);
        splusFunctionInfo.add(this.seasonality, "model.period", true);
        this.periodSpinner = new SplusIntegerSpinner("Period", 'P', 0, 100, 1);
        this.periodSpinner.setEnabled(false);
        splusGroupPanel3.add(this.periodSpinner);
        splusFunctionInfo.add(this.periodSpinner, "model.period.other");
        this.seasonality.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ArimaDialog.this.seasonality.getValue().equals("Other");
                ArimaDialog.this.periodSpinner.setEnabled(bl);
            }
        });
        box.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel4 = new SplusGroupPanel("Initial Parameters");
        box2.add(splusGroupPanel4);
        this.enterInitial = new SplusCheckBox("Enter Initial Parameter Values", 'N');
        splusGroupPanel4.add(this.enterInitial);
        splusFunctionInfo.add(this.enterInitial, "model.init.p");
        this.arCoef = new SplusTextField("AR coefficients", 'C');
        this.arCoef.setValue("0");
        this.arCoef.setEnabled(false);
        splusGroupPanel4.add(this.arCoef);
        splusFunctionInfo.add(this.arCoef, "model.init.ar");
        this.maCoef = new SplusTextField("MA Coefficients", 'O');
        this.maCoef.setValue("0");
        this.maCoef.setEnabled(false);
        splusGroupPanel4.add(this.maCoef);
        splusFunctionInfo.add(this.maCoef, "model.init.ma");
        this.enterInitial.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ArimaDialog.this.enterInitial.getValue().equals("T");
                ArimaDialog.this.arCoef.setEnabled(bl);
                ArimaDialog.this.maCoef.setEnabled(bl);
            }
        });
        SplusGroupPanel splusGroupPanel5 = new SplusGroupPanel("Other Predictors");
        box2.add(splusGroupPanel5);
        this.addCovariates = new SplusCheckBox("Add Covariates", 'A');
        splusGroupPanel5.add(this.addCovariates);
        splusFunctionInfo.add(this.addCovariates, "xreg.p");
        this.covariateList = new SplusDataColumnListBox("Variables", 'B', (SplusDataColumnListProvider)this.dataSet);
        this.covariateList.setValue("");
        this.covariateList.setEnabled(false);
        splusGroupPanel5.add(this.covariateList);
        splusFunctionInfo.add(this.covariateList, "xreg", true, true);
        this.addCovariates.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ArimaDialog.this.addCovariates.getValue().equals("T");
                ArimaDialog.this.covariateList.setEnabled(bl);
            }
        });
        SplusGroupPanel splusGroupPanel6 = new SplusGroupPanel("Results");
        box2.add(splusGroupPanel6);
        SplusTextField splusTextField = new SplusTextField("Save As", 'S');
        splusGroupPanel6.add(splusTextField);
        splusFunctionInfo.setResultControl(splusTextField);
        SplusCheckBox splusCheckBox = new SplusCheckBox("Print Results", 'P');
        splusCheckBox.setValue("T");
        splusGroupPanel6.add(splusCheckBox);
        splusFunctionInfo.add(splusCheckBox, "print.p");
        box2.add(new SplusBoxFiller());
        JPanel jPanel2 = new JPanel();
        jTabbedPane.addTab("Options", jPanel2);
        Box box3 = new Box(1);
        Box box4 = new Box(1);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(box3);
        jPanel2.add(box4);
        SplusGroupPanel splusGroupPanel7 = new SplusGroupPanel("Maximum Numbers");
        box3.add(splusGroupPanel7);
        SplusTextField splusTextField2 = new SplusTextField("Iterations", 'I');
        splusTextField2.setValue("15");
        splusGroupPanel7.add(splusTextField2);
        splusFunctionInfo.add(splusTextField2, "nlmin.max.iter");
        SplusTextField splusTextField3 = new SplusTextField("Likelihood Evals", 'L');
        splusTextField3.setValue("30");
        splusGroupPanel7.add(splusTextField3);
        splusFunctionInfo.add(splusTextField3, "nlmin.max.fcal");
        box3.add(new SplusBoxFiller());
        box4.add(new SplusBoxFiller());
        JPanel jPanel3 = new JPanel();
        jTabbedPane.addTab("Diagnostics", jPanel3);
        Box box5 = new Box(1);
        Box box6 = new Box(1);
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(box5);
        jPanel3.add(box6);
        SplusGroupPanel splusGroupPanel8 = new SplusGroupPanel("Save");
        box5.add(splusGroupPanel8);
        SplusDataSetComboBox splusDataSetComboBox = new SplusDataSetComboBox("Save In", 'I');
        splusDataSetComboBox.setValue("");
        splusGroupPanel8.add(splusDataSetComboBox);
        splusFunctionInfo.add(splusDataSetComboBox, "diag.save.name", true);
        SplusCheckBox splusCheckBox2 = new SplusCheckBox("Autocorrelation of Residuals", 'C');
        splusGroupPanel8.add(splusCheckBox2);
        splusFunctionInfo.add(splusCheckBox2, "diag.acf.resid");
        SplusCheckBox splusCheckBox3 = new SplusCheckBox("Portmanteau Statistic", 'P');
        splusGroupPanel8.add(splusCheckBox3);
        splusFunctionInfo.add(splusCheckBox3, "diag.gof.lag");
        SplusCheckBox splusCheckBox4 = new SplusCheckBox("Residuals", 'R');
        splusGroupPanel8.add(splusCheckBox4);
        splusFunctionInfo.add(splusCheckBox4, "diag.resid");
        SplusCheckBox splusCheckBox5 = new SplusCheckBox("Standardized Residuals", 'T');
        splusGroupPanel8.add(splusCheckBox5);
        splusFunctionInfo.add(splusCheckBox5, "diag.std.resid");
        box5.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel9 = new SplusGroupPanel("Plots");
        box6.add(splusGroupPanel9);
        SplusCheckBox splusCheckBox6 = new SplusCheckBox("Plot Diagnostics", 'D');
        splusGroupPanel9.add(splusCheckBox6);
        splusFunctionInfo.add(splusCheckBox6, "diag.plot");
        box6.add(new SplusBoxFiller());
        JPanel jPanel4 = new JPanel();
        jTabbedPane.addTab("Forecast", jPanel4);
        Box box7 = new Box(1);
        Box box8 = new Box(1);
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(box7);
        jPanel4.add(box8);
        SplusGroupPanel splusGroupPanel10 = new SplusGroupPanel("Parameters");
        box7.add(splusGroupPanel10);
        SplusTextField splusTextField4 = new SplusTextField("Time Periods to Forecast", 'T');
        splusTextField4.setValue("5");
        splusGroupPanel10.add(splusTextField4);
        splusFunctionInfo.add(splusTextField4, "forecast.n");
        SplusTextField splusTextField5 = new SplusTextField("Innovations Variance", 'I');
        splusGroupPanel10.add(splusTextField5);
        splusFunctionInfo.add(splusTextField5, "forecast.sigma2");
        box7.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel11 = new SplusGroupPanel("Plots");
        box8.add(splusGroupPanel11);
        SplusCheckBox splusCheckBox7 = new SplusCheckBox("Plot Forecast", 'P');
        splusGroupPanel11.add(splusCheckBox7);
        splusFunctionInfo.add(splusCheckBox7, "forecast.plot.p");
        SplusGroupPanel splusGroupPanel12 = new SplusGroupPanel("");
        box8.add(splusGroupPanel12);
        SplusDataSetComboBox splusDataSetComboBox2 = new SplusDataSetComboBox("Save Forecast As", 'S');
        splusDataSetComboBox2.setValue("");
        splusGroupPanel12.add(splusDataSetComboBox2);
        splusFunctionInfo.add(splusDataSetComboBox2, "fore.save.name", true);
        box8.add(new SplusBoxFiller());
        this.setCenterPanel(jTabbedPane);
    }

    public boolean isComplete() {
        boolean bl;
        boolean bl2 = bl = this.warnIfEmpty(this.dataSet) && this.warnIfEmpty(this.dataColumn);
        if (bl && this.seasonality.getValue().equals("Other")) {
            bl = this.warnIfEmpty(this.periodSpinner);
        }
        if (bl && this.enterInitial.getValue().equals("T")) {
            boolean bl3 = bl = this.warnIfEmpty(this.arCoef) && this.warnIfEmpty(this.maCoef);
        }
        if (bl && this.addCovariates.getValue().equals("T")) {
            bl = this.warnIfEmpty(this.covariateList);
        }
        return bl;
    }
}

