/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.statdlg;

import com.insightful.controls.SplusBoxFiller;
import com.insightful.controls.SplusCheckBox;
import com.insightful.controls.SplusComboBox;
import com.insightful.controls.SplusDialog;
import com.insightful.controls.SplusFunctionInfo;
import com.insightful.controls.SplusGroupPanel;
import com.insightful.controls.SplusListBox;
import com.insightful.controls.SplusRadioButton;
import com.insightful.controls.SplusTextField;
import com.insightful.splus.SplusObjectComboBox;
import com.insightful.splus.util.StringUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;

public class CompareModelsDialog
extends SplusDialog {
    SplusListBox modelObjects;
    SplusComboBox modelClass;
    SplusTextField nameStringMatch;
    String[] unfilteredObjectList;
    static final int C_TESTS = 6;
    SplusRadioButton[] aTests = new SplusRadioButton[6];
    SplusRadioButton bogusTest = new SplusRadioButton("Bogus", 'Q');
    static final String[] astrTestNames = new String[]{"F", "Chi-Square", "Cp", "None", "Robust Wald", "Robust F"};
    static final char[] achMnemonics = new char[]{'F', 'Q', 'P', 'N', 'W', 'R'};
    static final String[] astrParamNames = new String[]{"f.test", "chi.test", "cp.test", "no.test", "rn2.test", "tau.test"};
    static final String[] classNames = new String[]{"aov", "censorReg", "discrim", "gam", "glm", "gls", "gnls", "lm", "lme", "lmRobMM", "loess", "nlme", "nls", "survReg"};
    static final int[] defaultTest = new int[]{0, 1, -1, 0, 0, -1, -1, 0, -1, 5, 0, -1, 0, 1};
    static final boolean[][] enableState = new boolean[][]{{true, true, true, true, false, false}, {false, true, false, true, false, false}, {false, false, false, false, false, false}, {true, true, true, true, false, false}, {true, true, true, true, false, false}, {false, false, false, false, false, false}, {false, false, false, false, false, false}, {true, true, true, true, false, false}, {false, false, false, false, false, false}, {false, false, false, false, true, true}, {true, false, true, true, false, false}, {false, false, false, false, false, false}, {true, true, true, true, false, false}, {false, true, false, true, false, false}};

    public CompareModelsDialog() {
        super("Compare Models (Likelihood Ratio Test)");
        JPanel jPanel = new JPanel();
        Box box = new Box(1);
        Box box2 = new Box(1);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(box);
        jPanel.add(box2);
        SplusFunctionInfo splusFunctionInfo = new SplusFunctionInfo("menuAnova");
        this.setFunctionInfo(splusFunctionInfo);
        SplusGroupPanel splusGroupPanel = new SplusGroupPanel("Select Model");
        box.add(splusGroupPanel);
        this.modelObjects = new SplusListBox("Model Objects", 'O');
        splusGroupPanel.add(this.modelObjects);
        splusFunctionInfo.add(this.modelObjects, "objectslist", false, true);
        this.nameStringMatch = new SplusTextField("Name String Match", 'N');
        splusGroupPanel.add(this.nameStringMatch);
        splusFunctionInfo.add(this.nameStringMatch, "");
        this.modelClass = new SplusComboBox("Model Class", 'C', classNames);
        this.modelClass.setEditable(false);
        this.modelClass.setValue("lm");
        splusGroupPanel.add(this.modelClass);
        splusFunctionInfo.add(this.modelClass, "");
        this.refreshObjectList(false);
        this.nameStringMatch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CompareModelsDialog.this.filterObjectList();
            }
        });
        this.modelClass.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CompareModelsDialog.this.refreshObjectList(true);
            }
        });
        this.modelClass.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = CompareModelsDialog.this.modelClass.getValue();
                int n = 2;
                for (int i = 0; i < classNames.length; ++i) {
                    if (!string.equals(classNames[i])) continue;
                    n = i;
                    break;
                }
                boolean[] blArray = enableState[n];
                for (int i = 0; i < CompareModelsDialog.this.aTests.length; ++i) {
                    CompareModelsDialog.this.aTests[i].setEnabled(blArray[i]);
                    CompareModelsDialog.this.aTests[i].setValue("F");
                }
                if (defaultTest[n] != -1) {
                    System.out.println("Setting one");
                    CompareModelsDialog.this.aTests[defaultTest[n]].setValue("T");
                } else {
                    CompareModelsDialog.this.bogusTest.setValue("T");
                }
            }
        });
        box.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel2 = new SplusGroupPanel("Test Statistic");
        box2.add(splusGroupPanel2);
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < 6; ++i) {
            this.aTests[i] = new SplusRadioButton(astrTestNames[i], achMnemonics[i]);
            this.aTests[i].setValue(i == 0 ? "T" : "F");
            splusGroupPanel2.add(this.aTests[i]);
            splusFunctionInfo.add(this.aTests[i], astrParamNames[i]);
            buttonGroup.add(this.aTests[i].getAbstractButton());
        }
        buttonGroup.add(this.bogusTest.getAbstractButton());
        SplusGroupPanel splusGroupPanel3 = new SplusGroupPanel("Results");
        box2.add(splusGroupPanel3);
        SplusTextField splusTextField = new SplusTextField("Save As", 'S');
        splusGroupPanel3.add(splusTextField);
        splusFunctionInfo.setResultControl(splusTextField);
        SplusCheckBox splusCheckBox = new SplusCheckBox("Print Results", 'P');
        splusCheckBox.setValue("T");
        splusGroupPanel3.add(splusCheckBox);
        splusFunctionInfo.add(splusCheckBox, "print.p");
        box2.add(new SplusBoxFiller());
        this.setCenterPanel(jPanel);
    }

    private void filterObjectList() {
        this.modelObjects.setOptionList(StringUtilities.getElementsContainingPattern(this.unfilteredObjectList, this.nameStringMatch.getValue()));
    }

    private void refreshObjectList(boolean bl) {
        this.unfilteredObjectList = SplusObjectComboBox.getObjectsOfClass(this.modelClass.getValue());
        if (!bl) {
            this.modelObjects.setOptionList(this.unfilteredObjectList);
        } else {
            this.filterObjectList();
        }
    }

    public boolean isComplete() {
        return this.warnIfEmpty(this.modelObjects);
    }
}

