/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.statdlg;

import com.insightful.controls.SplusBoxFiller;
import com.insightful.controls.SplusButton;
import com.insightful.controls.SplusCheckBox;
import com.insightful.controls.SplusComboBox;
import com.insightful.controls.SplusDialog;
import com.insightful.controls.SplusFunctionInfo;
import com.insightful.controls.SplusGroupPanel;
import com.insightful.controls.SplusTextField;
import com.insightful.controls.SplusWideBoxFiller;
import com.insightful.splus.SplusDataColumnComboBox;
import com.insightful.splus.SplusDataColumnListBox;
import com.insightful.splus.SplusDataColumnListProvider;
import com.insightful.splus.SplusDataSetComboBox;
import com.insightful.splus.SplusSubsetField;
import com.insightful.splus.SplusWideFormulaField;
import com.insightful.splus.statdlg.RegressionFormulaDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RandomAnovaDialog
extends SplusDialog {
    SplusDataSetComboBox dataSet;
    SplusDataColumnComboBox dependentColumn;
    SplusDataColumnComboBox weightsColumn;
    SplusDataColumnComboBox contrastColumn;
    SplusDataColumnListBox independentColumnList;
    SplusWideFormulaField formulaField;
    SplusButton formulaButton;
    SplusComboBox contrastType;
    SplusTextField contrastsField;
    SplusCheckBox plotPartialResid;
    SplusCheckBox includeFitPartialResid;
    SplusCheckBox rugplotPartialResid;
    SplusCheckBox scalePartialResid;
    String[] contrastDisplayName = new String[]{"Helmert", "Orthogonal Polynomial", "Sum", "Treatment", ""};
    String[] contrastFunctionName = new String[]{"contr.helmert", "contr.poly", "contr.sum", "contr.treatment", ""};

    public RandomAnovaDialog() {
        super("Random Effects Analysis of Variance");
        JTabbedPane jTabbedPane = new JTabbedPane();
        SplusFunctionInfo splusFunctionInfo = new SplusFunctionInfo("menuRaov");
        this.setFunctionInfo(splusFunctionInfo);
        JPanel jPanel = new JPanel();
        jTabbedPane.addTab("Model", jPanel);
        Box box = new Box(0);
        Box box2 = new Box(0);
        Box box3 = new Box(1);
        Box box4 = new Box(1);
        box.add(box3);
        box.add(box4);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(box);
        jPanel.add(box2);
        SplusGroupPanel splusGroupPanel = new SplusGroupPanel("Data");
        box3.add(splusGroupPanel);
        this.dataSet = new SplusDataSetComboBox();
        splusGroupPanel.add(this.dataSet);
        splusFunctionInfo.add(this.dataSet, "data");
        this.weightsColumn = new SplusDataColumnComboBox("Weights", 'W', (SplusDataColumnListProvider)this.dataSet);
        this.weightsColumn.setValue("");
        splusGroupPanel.add(this.weightsColumn);
        splusFunctionInfo.add(this.weightsColumn, "weights");
        SplusSubsetField splusSubsetField = new SplusSubsetField();
        splusGroupPanel.add(splusSubsetField);
        splusFunctionInfo.add(splusSubsetField, "subset");
        SplusCheckBox splusCheckBox = new SplusCheckBox("Omit Rows with Missing Values", 'M');
        splusCheckBox.setValue("T");
        splusGroupPanel.add(splusCheckBox);
        splusFunctionInfo.add(splusCheckBox, "na.omit.p");
        box4.add(new SplusBoxFiller(3));
        SplusGroupPanel splusGroupPanel2 = new SplusGroupPanel("Save Model Object");
        box4.add(splusGroupPanel2);
        SplusTextField splusTextField = new SplusTextField("Save As", 'S');
        splusGroupPanel2.add(splusTextField);
        splusFunctionInfo.setResultControl(splusTextField);
        SplusGroupPanel splusGroupPanel3 = new SplusGroupPanel("Variables");
        box2.add(splusGroupPanel3);
        this.dependentColumn = new SplusDataColumnComboBox("Dependent", 'E', (SplusDataColumnListProvider)this.dataSet);
        this.dependentColumn.setValue("");
        splusGroupPanel3.add(this.dependentColumn);
        splusFunctionInfo.add(this.dependentColumn, "");
        this.independentColumnList = new SplusDataColumnListBox("Independent", 'I', (SplusDataColumnListProvider)this.dataSet);
        this.independentColumnList.setPrepend(new String[]{"<ALL>"});
        splusGroupPanel3.add(this.independentColumnList);
        splusFunctionInfo.add(this.independentColumnList, "");
        this.formulaField = new SplusWideFormulaField();
        splusGroupPanel3.add(this.formulaField);
        splusFunctionInfo.add(this.formulaField, "formula");
        this.dependentColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RandomAnovaDialog.this.formulaField.setDependentValue(RandomAnovaDialog.this.dependentColumn.getValue());
            }
        });
        this.independentColumnList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                RandomAnovaDialog.this.formulaField.setIndependentValue(RandomAnovaDialog.this.independentColumnList.getValue());
            }
        });
        this.formulaButton = new SplusButton("Create Formula", 'C');
        this.formulaButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new RegressionFormulaDialog(RandomAnovaDialog.this.formulaField, RandomAnovaDialog.this.dataSet, 3).show();
            }
        });
        Box box5 = new Box(0);
        box5.add(Box.createHorizontalStrut(5));
        box5.add(this.formulaButton);
        box5.add(Box.createHorizontalGlue());
        splusGroupPanel3.add(Box.createVerticalStrut(5));
        splusGroupPanel3.add(box5);
        splusGroupPanel3.add(Box.createVerticalStrut(5));
        jPanel.add(new SplusWideBoxFiller());
        JPanel jPanel2 = new JPanel();
        jTabbedPane.addTab("Options", jPanel2);
        Box box6 = new Box(1);
        Box box7 = new Box(1);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(box6);
        jPanel2.add(box7);
        SplusGroupPanel splusGroupPanel4 = new SplusGroupPanel("Contrasts");
        box6.add(splusGroupPanel4);
        this.contrastType = new SplusComboBox("Assign Contrast", 'A', new String[]{"Helmert", "Orthogonal Polynomial", "Sum", "Treatment", ""});
        this.contrastType.setValue("");
        this.contrastType.setEditable(false);
        splusGroupPanel4.add(this.contrastType);
        splusFunctionInfo.add(this.contrastType, "");
        this.contrastType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RandomAnovaDialog.this.contrastColumn.setValue("");
            }
        });
        this.contrastColumn = new SplusDataColumnComboBox("  to Variable", 'V', (SplusDataColumnListProvider)this.dataSet);
        splusGroupPanel4.add(this.contrastColumn);
        splusFunctionInfo.add(this.contrastColumn, "");
        this.contrastColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = RandomAnovaDialog.this.contrastType.getValue().trim();
                String string2 = RandomAnovaDialog.this.contrastColumn.getValue().trim();
                String string3 = RandomAnovaDialog.this.contrastsField.getValue();
                if (string2.length() > 0) {
                    int n;
                    int n2;
                    String string4 = "";
                    for (n2 = 0; n2 < RandomAnovaDialog.this.contrastDisplayName.length; ++n2) {
                        if (!string.equals(RandomAnovaDialog.this.contrastDisplayName[n2])) continue;
                        string4 = RandomAnovaDialog.this.contrastFunctionName[n2];
                        break;
                    }
                    if (string3.length() > 0 && string3.indexOf(string2 + "=") > -1 && (string3 = (n = string3.indexOf(",", n2 = string3.indexOf(string2 + "="))) < 0 ? string3.substring(0, n2) : string3.substring(0, n2) + string3.substring(n)).startsWith(",")) {
                        string3 = string3.substring(1);
                    }
                    string3 = string3.trim();
                    if (string4.length() > 0) {
                        if (string3.length() > 0 && !string3.endsWith(",")) {
                            string3 = string3 + ",";
                        }
                        string3 = string3 + string2 + "=" + string4;
                    }
                    RandomAnovaDialog.this.contrastsField.setValue(string3);
                }
            }
        });
        this.contrastsField = new SplusTextField("Contrasts", 'C');
        splusGroupPanel4.add(this.contrastsField);
        splusFunctionInfo.add(this.contrastsField, "contrasts", false, true);
        box6.add(new SplusBoxFiller());
        box7.add(new SplusBoxFiller());
        JPanel jPanel3 = new JPanel();
        jTabbedPane.addTab("Results", jPanel3);
        Box box8 = new Box(1);
        Box box9 = new Box(1);
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(box8);
        jPanel3.add(box9);
        SplusGroupPanel splusGroupPanel5 = new SplusGroupPanel("Printed Results");
        box8.add(splusGroupPanel5);
        SplusCheckBox splusCheckBox2 = new SplusCheckBox("Short Output", 'S');
        splusCheckBox2.setValue("T");
        splusGroupPanel5.add(splusCheckBox2);
        splusFunctionInfo.add(splusCheckBox2, "print.object.p");
        SplusCheckBox splusCheckBox3 = new SplusCheckBox("Type I Sums of Squares", 'I');
        splusCheckBox3.setValue("T");
        splusGroupPanel5.add(splusCheckBox3);
        splusFunctionInfo.add(splusCheckBox3, "anova.p");
        SplusCheckBox splusCheckBox4 = new SplusCheckBox("Estimated Coefficients", 'C');
        splusGroupPanel5.add(splusCheckBox4);
        splusFunctionInfo.add(splusCheckBox4, "coef.p");
        SplusCheckBox splusCheckBox5 = new SplusCheckBox("Estimated K-Coef. for K Level Factor", 'K');
        splusGroupPanel5.add(splusCheckBox5);
        splusFunctionInfo.add(splusCheckBox5, "dummy.coef.p");
        SplusCheckBox splusCheckBox6 = new SplusCheckBox("Means", 'M');
        splusGroupPanel5.add(splusCheckBox6);
        splusFunctionInfo.add(splusCheckBox6, "means.p");
        box8.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel6 = new SplusGroupPanel("Saved Results");
        box9.add(splusGroupPanel6);
        SplusDataSetComboBox splusDataSetComboBox = new SplusDataSetComboBox("Save In", 'I');
        splusDataSetComboBox.setValue("");
        splusGroupPanel6.add(splusDataSetComboBox);
        splusFunctionInfo.add(splusDataSetComboBox, "save.results", true);
        SplusCheckBox splusCheckBox7 = new SplusCheckBox("Fitted Values", 'F');
        splusGroupPanel6.add(splusCheckBox7);
        splusFunctionInfo.add(splusCheckBox7, "save.fitted.p");
        SplusCheckBox splusCheckBox8 = new SplusCheckBox("Residuals", 'R');
        splusGroupPanel6.add(splusCheckBox8);
        splusFunctionInfo.add(splusCheckBox8, "save.resid.p");
        box9.add(new SplusBoxFiller());
        JPanel jPanel4 = new JPanel();
        jTabbedPane.addTab("Plot", jPanel4);
        Box box10 = new Box(1);
        Box box11 = new Box(1);
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(box10);
        jPanel4.add(box11);
        SplusGroupPanel splusGroupPanel7 = new SplusGroupPanel("Plots");
        box10.add(splusGroupPanel7);
        SplusCheckBox splusCheckBox9 = new SplusCheckBox("Residuals vs Fit", 'R');
        splusGroupPanel7.add(splusCheckBox9);
        splusFunctionInfo.add(splusCheckBox9, "plotResidVsFit.p");
        SplusCheckBox splusCheckBox10 = new SplusCheckBox("Sqrt Abs Residuals vs Fit", 'Q');
        splusGroupPanel7.add(splusCheckBox10);
        splusFunctionInfo.add(splusCheckBox10, "plotSqrtAbsResid.p");
        SplusCheckBox splusCheckBox11 = new SplusCheckBox("Response vs Fit", 'P');
        splusGroupPanel7.add(splusCheckBox11);
        splusFunctionInfo.add(splusCheckBox11, "plotResponseVsFit.p");
        SplusCheckBox splusCheckBox12 = new SplusCheckBox("Residuals Normal QQ", 'Q');
        splusGroupPanel7.add(splusCheckBox12);
        splusFunctionInfo.add(splusCheckBox12, "plotQQ.p");
        SplusCheckBox splusCheckBox13 = new SplusCheckBox("Residual-Fit Spread", 'S');
        splusGroupPanel7.add(splusCheckBox13);
        splusFunctionInfo.add(splusCheckBox13, "plotRFSpread.p");
        SplusCheckBox splusCheckBox14 = new SplusCheckBox("Cook's Distance", 'C');
        splusGroupPanel7.add(splusCheckBox14);
        splusFunctionInfo.add(splusCheckBox14, "plotCooks.p");
        this.plotPartialResid = new SplusCheckBox("Partial Residuals", 'P');
        splusGroupPanel7.add(this.plotPartialResid);
        splusFunctionInfo.add(this.plotPartialResid, "plotPartialResid.p");
        box10.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel8 = new SplusGroupPanel("Options");
        box11.add(splusGroupPanel8);
        SplusCheckBox splusCheckBox15 = new SplusCheckBox("Include Smooth", 'M');
        splusCheckBox15.setValue("T");
        splusGroupPanel8.add(splusCheckBox15);
        splusFunctionInfo.add(splusCheckBox15, "smooths.p");
        SplusCheckBox splusCheckBox16 = new SplusCheckBox("Include Rugplot", 'G');
        splusGroupPanel8.add(splusCheckBox16);
        splusFunctionInfo.add(splusCheckBox16, "rugplot.p");
        SplusTextField splusTextField2 = new SplusTextField("Number of Extreme Points to Identify:", 'X');
        splusTextField2.setValue("3");
        splusGroupPanel8.add(splusTextField2);
        splusFunctionInfo.add(splusTextField2, "id.n");
        SplusGroupPanel splusGroupPanel9 = new SplusGroupPanel("Partial Residual Plot Options");
        box11.add(splusGroupPanel9);
        this.includeFitPartialResid = new SplusCheckBox("Include Partial Fit", 'F');
        this.includeFitPartialResid.setEnabled(false);
        splusGroupPanel9.add(this.includeFitPartialResid);
        splusFunctionInfo.add(this.includeFitPartialResid, "plotPartialFit.p");
        this.rugplotPartialResid = new SplusCheckBox("Include Rugplot", 'T');
        this.rugplotPartialResid.setEnabled(false);
        splusGroupPanel9.add(this.rugplotPartialResid);
        splusFunctionInfo.add(this.rugplotPartialResid, "rugplotPartialResid.p");
        this.scalePartialResid = new SplusCheckBox("Common Y-axis Scale");
        this.scalePartialResid.setValue("T");
        this.scalePartialResid.setEnabled(false);
        splusGroupPanel9.add(this.scalePartialResid);
        splusFunctionInfo.add(this.scalePartialResid, "scalePartialResid.p");
        this.plotPartialResid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = RandomAnovaDialog.this.plotPartialResid.getValue().equals("T");
                RandomAnovaDialog.this.includeFitPartialResid.setEnabled(bl);
                RandomAnovaDialog.this.rugplotPartialResid.setEnabled(bl);
                RandomAnovaDialog.this.scalePartialResid.setEnabled(bl);
            }
        });
        box11.add(new SplusBoxFiller());
        this.setCenterPanel(jTabbedPane);
    }

    public boolean isComplete() {
        return this.warnIfEmpty(this.dataSet) && this.warnIfEmpty(this.formulaField);
    }
}

