/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.Fop;
import org.jfor.jfor.converter.Converter;
import org.jfor.jfor.converter.ConverterLogChannel;
import org.jfor.jfor.converter.IConverterOption;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLTransformUtilities {
    public static final int XSL_HTML = 9;
    public static final int XSL_XML = 9;
    public static final int XSL_FO_PDF = 1;
    public static final int XSL_FO_PS = 6;
    public static final int XSL_FO_RTF = 10;
    public static final int LOG_LEVEL_DEBUG = 0;
    public static final int LOG_LEVEL_INFO = 1;
    public static final int LOG_LEVEL_WARN = 2;
    public static final int LOG_LEVEL_ERROR = 3;
    public static final int LOG_LEVEL_FATAL = 4;
    public static final int LOG_LEVEL_DISABLED = 5;
    private static String m_encoding = "UTF-8";
    private static EntityResolver m_cachedEntityResolver = null;
    private static DocumentBuilder m_cachedBuilder = null;
    private static boolean g_parserPropsSet = false;
    private static String PARSER_FACTORY_PROP_NAME = "javax.xml.parsers.SAXParserFactory";
    private static String TRANSFORMER_FACTORY_PROP_NAME = "javax.xml.transform.TransformerFactory";
    private static String BUILDER_FACTORY_PROP_NAME = "javax.xml.parsers.DocumentBuilderFactory";
    private static String XALAN_PARSER_FACTORY = "org.apache.crimson.jaxp.SAXParserFactoryImpl";
    private static String XALAN_TRANSFORMER_FACTORY = "org.apache.xalan.processor.TransformerFactoryImpl";
    private static String XALAN_BUILDER_FACTORY = "org.apache.xalan.processor.DocumentBuilderFactoryImpl";
    private static String JDK_15_PARSER_FACTORY = "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl";
    private static String JDK_15_TRANSFORMER_FACTORY = "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl";
    private static String JDK_15_BUILDER_FACTORY = "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl";

    private XMLTransformUtilities() {
    }

    public static void setEncoding(String string) {
        m_encoding = string;
        XMLTransformUtilities.getBuilder();
    }

    public static String getEncoding() {
        return m_encoding;
    }

    public static void createReport(String string, String string2, String string3, int n, int n2) throws Exception {
        switch (n) {
            case 9: {
                XMLTransformUtilities.transformWithXSL(string, string2, string3);
                return;
            }
            case 10: {
                XMLTransformUtilities.transformWithJFOR(string, string2, string3, n2);
                return;
            }
        }
        XMLTransformUtilities.transformWithFOP(string, string2, string3, n, n2);
    }

    public static void createReport(String string, String string2, String string3, int n) throws Exception {
        XMLTransformUtilities.createReport(string, string2, string3, 2);
    }

    public static void setParserProperties() {
        if (g_parserPropsSet) {
            return;
        }
        if (!"T".equals(System.getProperty("use.xalan", "F"))) {
            System.setProperty(PARSER_FACTORY_PROP_NAME, JDK_15_PARSER_FACTORY);
            System.setProperty(TRANSFORMER_FACTORY_PROP_NAME, JDK_15_TRANSFORMER_FACTORY);
            System.setProperty(BUILDER_FACTORY_PROP_NAME, JDK_15_BUILDER_FACTORY);
        } else {
            System.setProperty(PARSER_FACTORY_PROP_NAME, XALAN_PARSER_FACTORY);
            System.setProperty(TRANSFORMER_FACTORY_PROP_NAME, XALAN_TRANSFORMER_FACTORY);
            System.setProperty(BUILDER_FACTORY_PROP_NAME, XALAN_BUILDER_FACTORY);
        }
        g_parserPropsSet = true;
    }

    public static XMLReader createXmlReader() throws Exception {
        XMLTransformUtilities.setParserProperties();
        SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
        XMLReader xMLReader = sAXParser.getXMLReader();
        xMLReader.setEntityResolver(XMLTransformUtilities.getEntityResolver());
        return xMLReader;
    }

    public static SAXSource createXmlSource(String string) throws Exception {
        XMLTransformUtilities.setParserProperties();
        XMLReader xMLReader = XMLTransformUtilities.createXmlReader();
        InputSource inputSource = new InputSource();
        inputSource.setByteStream(new FileInputStream(XMLTransformUtilities.getAbsolutePath(string)));
        return new SAXSource(xMLReader, inputSource);
    }

    public static Transformer createTransformer(String string) throws Exception {
        XMLTransformUtilities.setParserProperties();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = transformerFactory.newTemplates(XMLTransformUtilities.createXmlSource(string)).newTransformer();
        }
        catch (Exception exception) {
            System.err.println("Could not create Template-based XSLT transformer.");
            exception.printStackTrace();
            transformer = transformerFactory.newTransformer(XMLTransformUtilities.createXmlSource(string));
        }
        return transformer;
    }

    private static void transformWithXSL(String string, String string2, String string3) throws Exception {
        XMLTransformUtilities.setParserProperties();
        StreamSource streamSource = new StreamSource(XMLTransformUtilities.getAbsolutePath(string));
        FileOutputStream fileOutputStream = new FileOutputStream(XMLTransformUtilities.getAbsolutePath(string3));
        StreamResult streamResult = new StreamResult(fileOutputStream);
        streamResult.setSystemId(XMLTransformUtilities.getAbsolutePath(string3));
        Transformer transformer = XMLTransformUtilities.createTransformer(string2);
        transformer.transform(streamSource, streamResult);
        fileOutputStream.flush();
        ((OutputStream)fileOutputStream).close();
    }

    private static void transformWithFOP(String string, String string2, String string3, int n, int n2) throws Exception {
        OutputStream outputStream = new FileOutputStream(XMLTransformUtilities.getAbsolutePath(string3));
        outputStream = new BufferedOutputStream(outputStream);
        StreamSource streamSource = new StreamSource(XMLTransformUtilities.getAbsolutePath(string));
        XMLTransformUtilities.transformWithFOP(streamSource, string2, outputStream);
    }

    public static void transformWithFOP(Source source, String string, OutputStream outputStream) throws Exception {
        XMLTransformUtilities.setParserProperties();
        Fop fop = new Fop(1);
        fop.setOutputStream(outputStream);
        Transformer transformer = XMLTransformUtilities.createTransformer(string);
        SAXResult sAXResult = new SAXResult(fop.getDefaultHandler());
        transformer.transform(source, sAXResult);
        outputStream.flush();
        outputStream.close();
    }

    private static void transformWithJFOR(String string, String string2, String string3, int n) throws Exception {
        StreamSource streamSource = new StreamSource(XMLTransformUtilities.getAbsolutePath(string));
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(XMLTransformUtilities.getAbsolutePath(string3)));
        XMLTransformUtilities.transformWithJFOR(streamSource, string2, outputStreamWriter, n);
    }

    public static void transformWithJFOR(Source source, String string, Writer writer, int n) throws Exception {
        XMLTransformUtilities.setParserProperties();
        Transformer transformer = XMLTransformUtilities.createTransformer(string);
        SplusConverterOption splusConverterOption = new SplusConverterOption(n);
        SAXResult sAXResult = new SAXResult((ContentHandler)new Converter(writer, (IConverterOption)splusConverterOption));
        transformer.transform(source, sAXResult);
        writer.flush();
        writer.close();
    }

    public static String convertStringToXML(String string) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        block7: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                default: {
                    stringBuffer.append(string.charAt(i));
                }
            }
        }
        return stringBuffer.toString();
    }

    private static String getAbsolutePath(String string) {
        if (!new File(string).isAbsolute()) {
            return System.getProperty("user.dir") + "/" + string;
        }
        return string;
    }

    public static EntityResolver getEntityResolver() {
        if (m_cachedEntityResolver == null) {
            m_cachedEntityResolver = new EntityResolver(){

                public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                    if (string != null && string.startsWith("PMML") || string2 != null) {
                        return new InputSource(new ByteArrayInputStream(("<?xml version='1.0' encoding='" + m_encoding + "'?>").getBytes()));
                    }
                    return null;
                }
            };
        }
        return m_cachedEntityResolver;
    }

    public static DocumentBuilder getBuilder() {
        if (m_cachedBuilder != null) {
            return m_cachedBuilder;
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            m_cachedBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilderFactory = null;
            m_cachedBuilder.setEntityResolver(XMLTransformUtilities.getEntityResolver());
            return m_cachedBuilder;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            m_cachedBuilder = null;
            return m_cachedBuilder;
        }
    }

    public static Node readFrdomFile(InputStream inputStream) throws Exception {
        try {
            NodeList nodeList = XMLTransformUtilities.getBuilder().parse(inputStream).getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                return node;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
            throw new Exception("out of memory while reading XML stream");
        }
        return null;
    }

    public static void serializeXML(Node node, OutputStream outputStream) {
        try {
            Class<?> clazz = null;
            Class<?> clazz2 = null;
            try {
                clazz = Class.forName("com.sun.org.apache.xml.internal.serialize.OutputFormat");
                clazz2 = Class.forName("com.sun.org.apache.xml.internal.serialize.XMLSerializer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = Class.forName("org.apache.xml.serialize.OutputFormat");
                clazz2 = Class.forName("org.apache.xml.serialize.XMLSerializer");
            }
            Object obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            clazz.getMethod("setEncoding", String.class).invoke(obj, "UTF-8");
            clazz.getMethod("setIndenting", Boolean.TYPE).invoke(obj, new Boolean(true));
            clazz.getMethod("setOmitXMLDeclaration", Boolean.TYPE).invoke(obj, new Boolean(false));
            clazz.getMethod("setPreserveSpace", Boolean.TYPE).invoke(obj, new Boolean(true));
            Object obj2 = clazz2.getConstructor(OutputStream.class, clazz).newInstance(outputStream, obj);
            clazz2.getMethod("serialize", Document.class).invoke(obj2, node.getOwnerDocument());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static class SplusConverterOption
    implements IConverterOption {
        private IConverterOption defaultOption;

        public SplusConverterOption(int n) {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
            switch (n) {
                case 0: {
                    this.init(outputStreamWriter, outputStreamWriter, outputStreamWriter, outputStreamWriter);
                    break;
                }
                case 1: {
                    this.init(null, outputStreamWriter, outputStreamWriter, outputStreamWriter);
                    break;
                }
                case 2: {
                    this.init(null, null, outputStreamWriter, outputStreamWriter);
                    break;
                }
                case 3: 
                case 4: {
                    this.init(null, null, null, outputStreamWriter);
                    break;
                }
                case 5: {
                    this.init(null, null, null, null);
                    break;
                }
                default: {
                    throw new RuntimeException("Logging level value must be between 0 and 5.");
                }
            }
        }

        public SplusConverterOption(Writer writer, Writer writer2, Writer writer3, Writer writer4) {
            this.init(writer, writer2, writer3, writer4);
        }

        private void init(Writer writer, Writer writer2, Writer writer3, Writer writer4) {
            this.defaultOption = Converter.createConverterOption((Writer)writer, (Writer)writer2, (Writer)writer3, (Writer)writer4);
        }

        public ConverterLogChannel getLog() {
            return this.defaultOption.getLog();
        }

        public void setRtfExternalGraphicCompressionRate(int n) {
            this.defaultOption.setRtfExternalGraphicCompressionRate(n);
        }

        public int getRtfExternalGraphicCompressionRate() {
            return this.defaultOption.getRtfExternalGraphicCompressionRate();
        }

        public XMLReader getXmlReader() throws Exception {
            XMLReader xMLReader = XMLTransformUtilities.createXmlReader();
            return xMLReader;
        }
    }
}

