/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.data.CategoryDataset;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public abstract class BarRenderer {
    protected static final double BAR_OUTLINE_WIDTH_THRESHOLD = 3.0;
    protected double categorySpan;
    protected double categoryGapSpan;
    protected double itemSpan;
    protected double itemGapSpan;
    protected double itemWidth;
    protected double zeroInJava2D;

    public abstract int barWidthsPerCategory(CategoryDataset var1);

    public abstract boolean hasItemGaps();

    protected void calculateCategoryAndItemSpans(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryDataset categoryDataset, double d) {
        int n = categoryDataset.getSeriesCount();
        int n2 = categoryDataset.getCategoryCount();
        int n3 = this.barWidthsPerCategory(categoryDataset);
        this.categorySpan = 0.0;
        this.categoryGapSpan = 0.0;
        if (n2 > 1) {
            double d2 = 1.0 - categoryPlot.getIntroGapPercent() - categoryPlot.getTrailGapPercent() - categoryPlot.getCategoryGapsPercent();
            this.categorySpan = d * d2;
            this.categoryGapSpan = d * categoryPlot.getCategoryGapsPercent();
        } else {
            double d3 = 1.0 - categoryPlot.getIntroGapPercent() - categoryPlot.getTrailGapPercent();
            this.categorySpan = d * d3;
        }
        this.itemSpan = this.categorySpan;
        this.itemGapSpan = 0.0;
        if (n > 1 && this.hasItemGaps()) {
            this.itemGapSpan = d * categoryPlot.getItemGapsPercent();
            this.itemSpan -= this.itemGapSpan;
        }
        this.itemWidth = this.itemSpan / (double)(n2 * this.barWidthsPerCategory(categoryDataset));
        this.zeroInJava2D = categoryPlot.getRangeAxis().translateValueToJava2D(0.0, rectangle2D);
    }

    public boolean isStacked() {
        return false;
    }
}

