/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.data;

import com.jrefinery.chart.data.PlotFitAlgorithm;
import com.jrefinery.data.DefaultXYDataset;
import com.jrefinery.data.XYDataset;

public class PlotFit {
    protected XYDataset dataset;
    protected PlotFitAlgorithm alg;

    public PlotFit(XYDataset xYDataset, PlotFitAlgorithm plotFitAlgorithm) {
        this.dataset = xYDataset;
        this.alg = plotFitAlgorithm;
    }

    public void setXYDataset(XYDataset xYDataset) {
        this.dataset = xYDataset;
    }

    public void setPlotFitAlgorithm(PlotFitAlgorithm plotFitAlgorithm) {
        this.alg = plotFitAlgorithm;
    }

    public Object[][][] getResults() {
        this.alg.setXYDataset(this.dataset);
        int n = 0;
        int n2 = this.dataset.getSeriesCount();
        int n3 = 0;
        while (n3 < n2) {
            if (this.dataset.getItemCount(n3) > n) {
                n = this.dataset.getItemCount(n3);
            }
            ++n3;
        }
        Object[][][] objectArray = new Object[n2 * 2][n][2];
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < this.dataset.getItemCount(n4)) {
                Number number = this.dataset.getXValue(n4, n5);
                objectArray[n4][n5][0] = number;
                objectArray[n4][n5][1] = this.dataset.getYValue(n4, n5);
                Number number2 = this.alg.getY(n4, number);
                if (number2 != null) {
                    objectArray[n4 + n2][n5][0] = number;
                    objectArray[n4 + n2][n5][1] = number2;
                } else {
                    objectArray[n4 + n2][n5][0] = null;
                    objectArray[n4 + n2][n5][1] = null;
                }
                ++n5;
            }
            ++n4;
        }
        return objectArray;
    }

    public XYDataset getFit() {
        int n = this.dataset.getSeriesCount();
        String[] stringArray = new String[n * 2];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.dataset.getSeriesName(n2);
            stringArray[n2 + n] = this.dataset.getSeriesName(n2) + " " + this.alg.getName();
            ++n2;
        }
        return new DefaultXYDataset(stringArray, this.getResults());
    }
}

