/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Fop;

public class InputHandler
implements ErrorListener {
    private File sourcefile = null;
    private File stylesheet = null;
    private Vector xsltParams = null;
    protected Log log = LogFactory.getLog(class$org$apache$fop$apps$InputHandler == null ? (class$org$apache$fop$apps$InputHandler = InputHandler.class$("org.apache.fop.apps.InputHandler")) : class$org$apache$fop$apps$InputHandler);
    static /* synthetic */ Class class$org$apache$fop$apps$InputHandler;

    public InputHandler(File xmlfile, File xsltfile, Vector params) {
        this.sourcefile = xmlfile;
        this.stylesheet = xsltfile;
        this.xsltParams = params;
    }

    public InputHandler(File fofile) {
        this.sourcefile = fofile;
    }

    public void render(Fop fop) throws FOPException {
        if (fop.getUserAgent().getBaseURL() == null) {
            String baseURL = null;
            try {
                baseURL = new File(this.sourcefile.getAbsolutePath()).getParentFile().toURL().toExternalForm();
            }
            catch (Exception e) {
                baseURL = "";
            }
            fop.getUserAgent().setBaseURL(baseURL);
        }
        try {
            Transformer transformer;
            TransformerFactory factory = TransformerFactory.newInstance();
            if (this.stylesheet == null) {
                transformer = factory.newTransformer();
            } else {
                transformer = factory.newTransformer(new StreamSource(this.stylesheet));
                if (this.xsltParams != null) {
                    for (int i = 0; i < this.xsltParams.size(); i += 2) {
                        transformer.setParameter((String)this.xsltParams.elementAt(i), (String)this.xsltParams.elementAt(i + 1));
                    }
                }
            }
            transformer.setErrorListener(this);
            StreamSource src = new StreamSource(this.sourcefile);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
        }
        catch (Exception e) {
            throw new FOPException(e);
        }
    }

    public void warning(TransformerException exc) {
        this.log.warn(exc.toString());
    }

    public void error(TransformerException exc) {
        this.log.error(exc.toString());
    }

    public void fatalError(TransformerException exc) throws TransformerException {
        throw exc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

