/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.util.ArrayList;
import org.apache.fop.area.BlockParent;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.Trait;

public class Block
extends BlockParent {
    public static final int STACK = 0;
    public static final int RELATIVE = 1;
    public static final int ABSOLUTE = 2;
    public static final int FIXED = 3;
    private int stacking = 2;
    private int positioning = 0;

    public void addBlock(Block block) {
        this.addBlock(block, true);
    }

    public void addBlock(Block block, boolean autoHeight) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        if (autoHeight) {
            this.bpd += block.getAllocBPD();
        }
        this.children.add(block);
    }

    public void addLineArea(LineArea line) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.bpd += line.getBPD();
        this.children.add(line);
    }

    public void setPositioning(int pos) {
        this.positioning = pos;
    }

    public int getPositioning() {
        return this.positioning;
    }

    public int getStartIndent() {
        Integer startIndent = (Integer)this.getTrait(Trait.START_INDENT);
        return startIndent != null ? startIndent : 0;
    }
}

