/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fo.CharIterator;
import org.apache.fop.fo.FOElementMapping;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.fo.OneCharIterator;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.extensions.ExtensionElementMapping;
import org.apache.fop.fo.extensions.svg.SVGElementMapping;
import org.apache.fop.fo.pagination.Root;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public abstract class FONode
implements Cloneable {
    protected static String FO_URI = FOElementMapping.URI;
    protected FONode parent;
    public Locator locator;
    private static Log log = LogFactory.getLog(class$org$apache$fop$fo$FONode == null ? (class$org$apache$fop$fo$FONode = FONode.class$("org.apache.fop.fo.FONode")) : class$org$apache$fop$fo$FONode);
    static /* synthetic */ Class class$org$apache$fop$fo$FONode;

    protected FONode(FONode parent) {
        this.parent = parent;
    }

    public FONode clone(FONode parent, boolean removeChildren) throws FOPException {
        FONode foNode = (FONode)this.clone();
        foNode.parent = parent;
        parent.addChildNode(foNode);
        return foNode;
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void setLocator(Locator locator) {
        if (locator != null) {
            this.locator = locator;
        }
    }

    public FOEventHandler getFOEventHandler() {
        return this.parent.getFOEventHandler();
    }

    public FOUserAgent getUserAgent() {
        return this.getFOEventHandler().getUserAgent();
    }

    public Log getLogger() {
        return log;
    }

    public void processNode(String elementName, Locator locator, Attributes attlist, PropertyList parent) throws FOPException {
        log.debug("name = " + elementName);
    }

    protected PropertyList createPropertyList(PropertyList parent, FOEventHandler foEventHandler) throws FOPException {
        return null;
    }

    protected void validateChildNode(Locator loc, String namespaceURI, String localName) throws ValidationException {
    }

    protected void addCharacters(char[] data, int start, int end, PropertyList pList, Locator locator) throws FOPException {
    }

    protected void startOfNode() throws FOPException {
    }

    protected void endOfNode() throws FOPException {
    }

    protected void addChildNode(FONode child) throws FOPException {
    }

    public void removeChild(FONode child) {
    }

    public FONode getParent() {
        return this.parent;
    }

    public ListIterator getChildNodes() {
        return null;
    }

    public ListIterator getChildNodes(FONode childNode) {
        return null;
    }

    public CharIterator charIterator() {
        return new OneCharIterator('\u0000');
    }

    public static String getNodeString(String namespaceURI, String localName) {
        if (namespaceURI.equals(FOElementMapping.URI)) {
            return "fo:" + localName;
        }
        if (namespaceURI.equals(ExtensionElementMapping.URI)) {
            return "fox:" + localName;
        }
        if (namespaceURI.equals(SVGElementMapping.URI)) {
            return "svg:" + localName;
        }
        return "(Namespace URI: \"" + namespaceURI + "\", " + "Local Name: \"" + localName + "\")";
    }

    protected void attributeError(String problem) throws ValidationException {
        throw new ValidationException(FONode.errorText(this.locator) + this.getName() + ", " + problem, this.locator);
    }

    protected void attributeWarning(String problem) {
        this.getLogger().warn(FONode.errorText(this.locator) + this.getName() + ", " + problem);
    }

    protected void tooManyNodesError(Locator loc, String nsURI, String lName) throws ValidationException {
        throw new ValidationException(FONode.errorText(loc) + "For " + this.getName() + ", only one " + FONode.getNodeString(nsURI, lName) + " may be declared.", loc);
    }

    protected void tooManyNodesError(Locator loc, String offendingNode) throws ValidationException {
        throw new ValidationException(FONode.errorText(loc) + "For " + this.getName() + ", only one " + offendingNode + " may be declared.", loc);
    }

    protected void nodesOutOfOrderError(Locator loc, String tooLateNode, String tooEarlyNode) throws ValidationException {
        throw new ValidationException(FONode.errorText(loc) + "For " + this.getName() + ", " + tooLateNode + " must be declared before " + tooEarlyNode + ".", loc);
    }

    protected void invalidChildError(Locator loc, String nsURI, String lName) throws ValidationException {
        this.invalidChildError(loc, nsURI, lName, null);
    }

    protected void invalidChildError(Locator loc, String nsURI, String lName, String ruleViolated) throws ValidationException {
        throw new ValidationException(FONode.errorText(loc) + FONode.getNodeString(nsURI, lName) + " is not a valid child element of " + this.getName() + (ruleViolated != null ? ": " + ruleViolated : "."), loc);
    }

    protected void missingChildElementError(String contentModel) throws ValidationException {
        throw new ValidationException(FONode.errorText(this.locator) + this.getName() + " is missing child elements. \nRequired Content Model: " + contentModel, this.locator);
    }

    protected void missingPropertyError(String propertyName) throws ValidationException {
        throw new ValidationException(FONode.errorText(this.locator) + this.getName() + " is missing required \"" + propertyName + "\" property.", this.locator);
    }

    protected static String errorText(Locator loc) {
        if (loc == null) {
            return "Error(Unknown location): ";
        }
        return "Error(" + loc.getLineNumber() + "/" + loc.getColumnNumber() + "): ";
    }

    protected static String warningText(Locator loc) {
        if (loc == null) {
            return "Warning(Unknown location): ";
        }
        return "Warning(" + loc.getLineNumber() + "/" + loc.getColumnNumber() + "): ";
    }

    public Root getRoot() {
        return this.parent.getRoot();
    }

    public String getName() {
        return null;
    }

    public int getNameId() {
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

