/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;

public class AreaAdditionUtil {
    public static void addAreas(BlockStackingLayoutManager bslm, PositionIterator parentIter, LayoutContext layoutContext) {
        LayoutManager childLM = null;
        LayoutContext lc = new LayoutContext(0);
        LayoutManager firstLM = null;
        LayoutManager lastLM = null;
        Position firstPos = null;
        Position lastPos = null;
        LinkedList<Position> positionList = new LinkedList<Position>();
        while (parentIter.hasNext()) {
            Position pos = (Position)parentIter.next();
            if (pos.getIndex() >= 0) {
                if (firstPos == null) {
                    firstPos = pos;
                }
                lastPos = pos;
            }
            if (!(pos instanceof NonLeafPosition)) continue;
            positionList.add(((NonLeafPosition)pos).getPosition());
            lastLM = ((NonLeafPosition)pos).getPosition().getLM();
            if (firstLM != null) continue;
            firstLM = lastLM;
        }
        if (bslm.markers != null) {
            bslm.getCurrentPV().addMarkers(bslm.markers, true, bslm.isFirst(firstPos), bslm.isLast(lastPos));
        }
        StackingIter childPosIter = new StackingIter(positionList.listIterator());
        while ((childLM = childPosIter.getNextChildLM()) != null) {
            lc.setFlags(32, childLM == firstLM);
            lc.setFlags(128, childLM == lastLM);
            lc.setSpaceAdjust(layoutContext.getSpaceAdjust());
            lc.setSpaceBefore(childLM == firstLM ? layoutContext.getSpaceBefore() : 0);
            lc.setSpaceAfter(layoutContext.getSpaceAfter());
            lc.setStackLimit(layoutContext.getStackLimit());
            childLM.addAreas(childPosIter, lc);
        }
        if (bslm.markers != null) {
            bslm.getCurrentPV().addMarkers(bslm.markers, false, bslm.isFirst(firstPos), bslm.isLast(lastPos));
        }
    }

    private static class StackingIter
    extends PositionIterator {
        StackingIter(Iterator parentIter) {
            super(parentIter);
        }

        protected LayoutManager getLM(Object nextObj) {
            return ((Position)nextObj).getLM();
        }

        protected Position getPos(Object nextObj) {
            return (Position)nextObj;
        }
    }
}

