/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.LineArea;
import org.apache.fop.fonts.Font;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.LMiter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.InlineLevelLayoutManager;
import org.apache.fop.layoutmgr.inline.LineLayoutManager;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;

public class BlockLayoutManager
extends BlockStackingLayoutManager {
    private Block curBlockArea;
    protected ListIterator proxyLMiter;
    private int lead = 12000;
    private int lineHeight = 14000;
    private int follow = 2000;
    private int middleShift = 0;
    protected List childBreaks = new ArrayList();

    public BlockLayoutManager(org.apache.fop.fo.flow.Block inBlock) {
        super(inBlock);
        this.proxyLMiter = new ProxyLMiter();
        Font fs = this.getBlockFO().getCommonFont().getFontState(this.getBlockFO().getFOEventHandler().getFontInfo());
        this.lead = fs.getAscender();
        this.follow = -fs.getDescender();
        this.middleShift = -fs.getXHeight() / 2;
        this.lineHeight = this.getBlockFO().getLineHeight().getOptimum().getLength().getValue();
        this.initialize();
    }

    private void initialize() {
        this.foSpaceBefore = new SpaceVal(this.getBlockFO().getCommonMarginBlock().spaceBefore).getSpace();
        this.foSpaceAfter = new SpaceVal(this.getBlockFO().getCommonMarginBlock().spaceAfter).getSpace();
        this.bpUnit = 0;
        if (this.bpUnit == 0) {
            this.adjustedSpaceBefore = this.getBlockFO().getCommonMarginBlock().spaceBefore.getSpace().getOptimum().getLength().getValue();
            this.adjustedSpaceAfter = this.getBlockFO().getCommonMarginBlock().spaceAfter.getSpace().getOptimum().getLength().getValue();
        } else {
            this.adjustedSpaceBefore = this.getBlockFO().getCommonMarginBlock().spaceBefore.getSpace().getMinimum().getLength().getValue();
            this.adjustedSpaceAfter = this.getBlockFO().getCommonMarginBlock().spaceAfter.getSpace().getMinimum().getLength().getValue();
        }
    }

    public boolean createNextChildLMs(int pos) {
        while (this.proxyLMiter.hasNext()) {
            LayoutManager lm = (LayoutManager)this.proxyLMiter.next();
            if (lm instanceof InlineLevelLayoutManager) {
                LineLayoutManager lineLM = this.createLineManager(lm);
                this.addChildLM(lineLM);
            } else {
                this.addChildLM(lm);
            }
            if (pos >= this.childLMs.size()) continue;
            return true;
        }
        return false;
    }

    private LineLayoutManager createLineManager(LayoutManager firstlm) {
        LineLayoutManager llm = new LineLayoutManager(this.getBlockFO(), this.lineHeight, this.lead, this.follow, this.middleShift);
        ArrayList<LayoutManager> inlines = new ArrayList<LayoutManager>();
        inlines.add(firstlm);
        while (this.proxyLMiter.hasNext()) {
            LayoutManager lm = (LayoutManager)this.proxyLMiter.next();
            if (lm instanceof InlineLevelLayoutManager) {
                inlines.add(lm);
                continue;
            }
            this.proxyLMiter.previous();
            break;
        }
        llm.addChildLMs(inlines);
        return llm;
    }

    private int getIPIndents() {
        int iIndents = 0;
        iIndents += this.getBlockFO().getCommonMarginBlock().startIndent.getValue();
        return iIndents += this.getBlockFO().getCommonMarginBlock().endIndent.getValue();
    }

    public boolean mustKeepTogether() {
        return this.getParent() instanceof BlockLevelLayoutManager && ((BlockLevelLayoutManager)this.getParent()).mustKeepTogether() || !this.getBlockFO().getKeepTogether().getWithinPage().isAuto() || !this.getBlockFO().getKeepTogether().getWithinColumn().isAuto();
    }

    public boolean mustKeepWithPrevious() {
        return !this.getBlockFO().getKeepWithPrevious().getWithinPage().isAuto() || !this.getBlockFO().getKeepWithPrevious().getWithinColumn().isAuto();
    }

    public boolean mustKeepWithNext() {
        return !this.getBlockFO().getKeepWithNext().getWithinPage().isAuto() || !this.getBlockFO().getKeepWithNext().getWithinColumn().isAuto();
    }

    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        PositionIterator childPosIter;
        this.getParentArea(null);
        if (layoutContext.getSpaceBefore() > 0) {
            this.addBlockSpacing(0.0, new MinOptMax(layoutContext.getSpaceBefore()));
        }
        LayoutManager childLM = null;
        LayoutManager lastLM = null;
        LayoutContext lc = new LayoutContext(0);
        if (layoutContext.getSpaceAfter() > 0) {
            lc.setSpaceAfter(layoutContext.getSpaceAfter());
        }
        LinkedList<Position> positionList = new LinkedList<Position>();
        boolean bSpaceBefore = false;
        boolean bSpaceAfter = false;
        Position firstPos = null;
        Position lastPos = null;
        while (parentIter.hasNext()) {
            Position pos = (Position)parentIter.next();
            if (pos.getIndex() >= 0) {
                if (firstPos == null) {
                    firstPos = pos;
                }
                lastPos = pos;
            }
            Position innerPosition = pos;
            if (pos instanceof NonLeafPosition) {
                innerPosition = ((NonLeafPosition)pos).getPosition();
            }
            if (innerPosition == null) {
                if (positionList.size() == 0) {
                    bSpaceBefore = true;
                    continue;
                }
                bSpaceAfter = true;
                continue;
            }
            if (innerPosition.getLM() == this && !(innerPosition instanceof BlockStackingLayoutManager.MappingPosition)) continue;
            positionList.add(innerPosition);
            lastLM = innerPosition.getLM();
        }
        this.getPSLM().addIDToPage(this.getBlockFO().getId());
        if (this.markers != null) {
            this.getCurrentPV().addMarkers(this.markers, true, this.isFirst(firstPos), this.isLast(lastPos));
        }
        if (this.bpUnit == 0) {
            childPosIter = new BlockStackingLayoutManager.StackingIter(positionList.listIterator());
        } else {
            LinkedList<KnuthElement> splitList = new LinkedList<KnuthElement>();
            int splitLength = 0;
            int iFirst = ((BlockStackingLayoutManager.MappingPosition)positionList.getFirst()).getFirstIndex();
            int iLast = ((BlockStackingLayoutManager.MappingPosition)positionList.getLast()).getLastIndex();
            ListIterator storedListIterator = this.storedList.listIterator(iFirst);
            while (storedListIterator.nextIndex() <= iLast) {
                KnuthElement element = (KnuthElement)storedListIterator.next();
                if (element.getLayoutManager() == this) continue;
                splitList.add(element);
                splitLength += element.getW();
                lastLM = element.getLayoutManager();
            }
            if (bSpaceBefore && bSpaceAfter) {
                this.foSpaceBefore = new SpaceVal(this.getBlockFO().getCommonMarginBlock().spaceBefore).getSpace();
                this.foSpaceAfter = new SpaceVal(this.getBlockFO().getCommonMarginBlock().spaceAfter).getSpace();
                this.adjustedSpaceBefore = (this.neededUnits(splitLength + this.foSpaceBefore.min + this.foSpaceAfter.min) * this.bpUnit - splitLength) / 2;
                this.adjustedSpaceAfter = this.neededUnits(splitLength + this.foSpaceBefore.min + this.foSpaceAfter.min) * this.bpUnit - splitLength - this.adjustedSpaceBefore;
            } else if (bSpaceBefore) {
                this.adjustedSpaceBefore = this.neededUnits(splitLength + this.foSpaceBefore.min) * this.bpUnit - splitLength;
            } else {
                this.adjustedSpaceAfter = this.neededUnits(splitLength + this.foSpaceAfter.min) * this.bpUnit - splitLength;
            }
            childPosIter = new KnuthPossPosIter(splitList, 0, splitList.size());
        }
        double adjust = layoutContext.getSpaceAdjust();
        this.addBlockSpacing(adjust, this.foSpaceBefore);
        this.foSpaceBefore = null;
        while ((childLM = childPosIter.getNextChildLM()) != null) {
            lc.setFlags(128, layoutContext.isLastArea() && childLM == lastLM);
            lc.setStackLimit(layoutContext.getStackLimit());
            childLM.addAreas(childPosIter, lc);
        }
        if (this.markers != null) {
            this.getCurrentPV().addMarkers(this.markers, false, this.isFirst(firstPos), this.isLast(lastPos));
        }
        this.flush();
        this.addBlockSpacing(adjust, this.foSpaceAfter);
        this.curBlockArea = null;
    }

    public Area getParentArea(Area childArea) {
        if (this.curBlockArea == null) {
            this.curBlockArea = new Block();
            TraitSetter.addBreaks(this.curBlockArea, this.getBlockFO().getBreakBefore(), this.getBlockFO().getBreakAfter());
            this.parentLM.getParentArea(this.curBlockArea);
            TraitSetter.setProducerID(this.curBlockArea, this.getBlockFO().getId());
            TraitSetter.addBorders(this.curBlockArea, this.getBlockFO().getCommonBorderPaddingBackground());
            TraitSetter.addBackground(this.curBlockArea, this.getBlockFO().getCommonBorderPaddingBackground());
            TraitSetter.addMargins(this.curBlockArea, this.getBlockFO().getCommonBorderPaddingBackground(), this.getBlockFO().getCommonMarginBlock());
            int contentIPD = this.referenceIPD - this.getIPIndents();
            this.curBlockArea.setIPD(contentIPD);
            this.setCurrentArea(this.curBlockArea);
        }
        return this.curBlockArea;
    }

    public void addChildArea(Area childArea) {
        if (this.curBlockArea != null) {
            if (childArea instanceof LineArea) {
                this.curBlockArea.addLineArea((LineArea)childArea);
            } else {
                this.curBlockArea.addBlock((Block)childArea);
            }
        }
    }

    public void resetPosition(Position resetPos) {
        if (resetPos == null) {
            this.reset(null);
            this.childBreaks.clear();
        } else {
            LayoutManager layoutManager = resetPos.getLM();
        }
    }

    protected org.apache.fop.fo.flow.Block getBlockFO() {
        return (org.apache.fop.fo.flow.Block)this.fobj;
    }

    protected class ProxyLMiter
    extends LMiter {
        public ProxyLMiter() {
            super(BlockLayoutManager.this);
            this.listLMs = new ArrayList(10);
        }

        public boolean hasNext() {
            return this.curPos < this.listLMs.size() ? true : this.createNextChildLMs(this.curPos);
        }

        protected boolean createNextChildLMs(int pos) {
            List newLMs = BlockLayoutManager.this.createChildLMs(pos + 1 - this.listLMs.size());
            if (newLMs != null) {
                this.listLMs.addAll(newLMs);
            }
            return pos < this.listLMs.size();
        }
    }
}

