/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.LinkedList;
import java.util.List;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.fo.flow.Character;
import org.apache.fop.fonts.Font;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;
import org.apache.fop.layoutmgr.inline.LeafNodeLayoutManager;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;

public class CharacterLayoutManager
extends LeafNodeLayoutManager {
    private Character fobj;
    private MinOptMax letterSpaceIPD;
    private int hyphIPD;
    private Font fs;

    public CharacterLayoutManager(Character node) {
        super(node);
        this.fobj = node;
        InlineArea inline = this.getCharacterInlineArea(node);
        this.setCurrentArea(inline);
        this.setAlignment(this.fobj.getVerticalAlign());
        this.fs = this.fobj.getCommonFont().getFontState(this.fobj.getFOEventHandler().getFontInfo());
        SpaceVal ls = SpaceVal.makeLetterSpacing(this.fobj.getLetterSpacing());
        this.letterSpaceIPD = ls.getSpace();
        this.hyphIPD = this.fs.getCharWidth(this.fobj.getCommonHyphenation().hyphenationCharacter);
    }

    private InlineArea getCharacterInlineArea(Character node) {
        org.apache.fop.area.inline.Character ch = new org.apache.fop.area.inline.Character(node.getCharacter());
        TraitSetter.setProducerID(ch, node.getId());
        TraitSetter.addTextDecoration(ch, this.fobj.getTextDecoration());
        return ch;
    }

    protected void offsetArea(InlineArea area, LayoutContext context) {
        int bpd = area.getBPD();
        switch (this.verticalAlignment) {
            case 84: {
                area.setOffset(context.getMiddleBaseline() + this.fs.getXHeight() / 2);
                break;
            }
            case 145: {
                area.setOffset(this.fs.getAscender());
                break;
            }
            case 20: {
                area.setOffset(context.getLineHeight() - bpd + this.fs.getAscender());
                break;
            }
            default: {
                area.setOffset(context.getBaseline());
            }
        }
    }

    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        this.curArea = this.get(context);
        LinkedList<KnuthElement> returnList = new LinkedList<KnuthElement>();
        if (this.curArea == null) {
            this.setFinished(true);
            return null;
        }
        MinOptMax ipd = new MinOptMax(this.fs.getCharWidth(((org.apache.fop.area.inline.Character)this.curArea).getChar().charAt(0)));
        this.curArea.setIPD(ipd.opt);
        this.curArea.setBPD(this.fs.getAscender() - this.fs.getDescender());
        this.curArea.addTrait(Trait.FONT_NAME, this.fs.getFontName());
        this.curArea.addTrait(Trait.FONT_SIZE, new Integer(this.fs.getFontSize()));
        this.curArea.addTrait(Trait.COLOR, this.fobj.getColor());
        int bpd = this.curArea.getBPD();
        int lead = 0;
        int total = 0;
        int middle = 0;
        switch (this.verticalAlignment) {
            case 84: {
                middle = bpd / 2;
                break;
            }
            case 20: 
            case 145: {
                total = bpd;
                break;
            }
            default: {
                lead = this.fs.getAscender();
                total = bpd;
            }
        }
        this.areaInfo = new LeafNodeLayoutManager.AreaInfo(this, 0, ipd, false, lead, total, middle);
        if (this.letterSpaceIPD.min == this.letterSpaceIPD.max) {
            returnList.add(new KnuthInlineBox(this.areaInfo.ipdArea.opt, this.areaInfo.lead, this.areaInfo.total, this.areaInfo.middle, new LeafPosition(this, 0), false));
        } else {
            returnList.add(new KnuthInlineBox(this.areaInfo.ipdArea.opt, this.areaInfo.lead, this.areaInfo.total, this.areaInfo.middle, new LeafPosition(this, 0), false));
            returnList.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), true));
            returnList.add(new KnuthGlue(0, 0, 0, new LeafPosition(this, -1), true));
            returnList.add(new KnuthInlineBox(0, 0, 0, 0, new LeafPosition(this, -1), true));
        }
        this.setFinished(true);
        return returnList;
    }

    public void getWordChars(StringBuffer sbChars, Position bp) {
        sbChars.append(((org.apache.fop.area.inline.Character)this.curArea).getChar());
    }

    public void hyphenate(Position pos, HyphContext hc) {
        if (hc.getNextHyphPoint() == 1) {
            this.areaInfo.bHyphenated = true;
            this.bSomethingChanged = true;
        }
        hc.updateOffset(1);
    }

    public boolean applyChanges(List oldList) {
        this.setFinished(false);
        return this.bSomethingChanged;
    }

    public LinkedList getChangedKnuthElements(List oldList, int flaggedPenalty, int alignment) {
        if (this.isFinished()) {
            return null;
        }
        LinkedList<KnuthElement> returnList = new LinkedList<KnuthElement>();
        if (this.letterSpaceIPD.min == this.letterSpaceIPD.max || this.areaInfo.iLScount == 0) {
            returnList.add(new KnuthInlineBox(this.areaInfo.ipdArea.opt, this.areaInfo.lead, this.areaInfo.total, this.areaInfo.middle, new LeafPosition(this, 0), false));
            if (this.areaInfo.bHyphenated) {
                returnList.add(new KnuthPenalty(this.hyphIPD, flaggedPenalty, true, new LeafPosition(this, -1), false));
            }
        } else {
            returnList.add(new KnuthInlineBox(this.areaInfo.ipdArea.opt - this.areaInfo.iLScount * this.letterSpaceIPD.opt, this.areaInfo.lead, this.areaInfo.total, this.areaInfo.middle, new LeafPosition(this, 0), false));
            returnList.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), true));
            returnList.add(new KnuthGlue(this.areaInfo.iLScount * this.letterSpaceIPD.opt, this.areaInfo.iLScount * this.letterSpaceIPD.max - this.letterSpaceIPD.opt, this.areaInfo.iLScount * this.letterSpaceIPD.opt - this.letterSpaceIPD.min, new LeafPosition(this, -1), true));
            returnList.add(new KnuthInlineBox(0, 0, 0, 0, new LeafPosition(this, -1), true));
            if (this.areaInfo.bHyphenated) {
                returnList.add(new KnuthPenalty(this.hyphIPD, flaggedPenalty, true, new LeafPosition(this, -1), false));
            }
        }
        this.setFinished(true);
        return returnList;
    }

    protected void addId() {
        this.getPSLM().addIDToPage(this.fobj.getId());
    }
}

