/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.list;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.fo.flow.AbstractListItemPart;
import org.apache.fop.fo.flow.ListItemBody;
import org.apache.fop.fo.flow.ListItemLabel;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.TraitSetter;

public class ListItemContentLayoutManager
extends BlockStackingLayoutManager {
    private Block curBlockArea;
    private int xoffset;
    private int itemIPD;

    public ListItemContentLayoutManager(ListItemLabel node) {
        super(node);
    }

    public ListItemContentLayoutManager(ListItemBody node) {
        super(node);
    }

    protected AbstractListItemPart getPartFO() {
        return (AbstractListItemPart)this.fobj;
    }

    public void setXOffset(int off) {
        this.xoffset = off;
    }

    public LinkedList getChangedKnuthElements(List oldList, int alignment) {
        return super.getChangedKnuthElements(oldList, alignment);
    }

    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        this.getParentArea(null);
        this.getPSLM().addIDToPage(this.getPartFO().getId());
        LayoutManager childLM = null;
        LayoutContext lc = new LayoutContext(0);
        LayoutManager firstLM = null;
        LayoutManager lastLM = null;
        Position firstPos = null;
        Position lastPos = null;
        LinkedList<Position> positionList = new LinkedList<Position>();
        while (parentIter.hasNext()) {
            Position pos = (Position)parentIter.next();
            if (pos.getIndex() >= 0) {
                if (firstPos == null) {
                    firstPos = pos;
                }
                lastPos = pos;
            }
            if (!(pos instanceof NonLeafPosition)) continue;
            positionList.add(((NonLeafPosition)pos).getPosition());
            lastLM = ((NonLeafPosition)pos).getPosition().getLM();
            if (firstLM != null) continue;
            firstLM = lastLM;
        }
        if (this.markers != null) {
            this.getCurrentPV().addMarkers(this.markers, true, this.isFirst(firstPos), this.isLast(lastPos));
        }
        StackingIter childPosIter = new StackingIter(positionList.listIterator());
        while ((childLM = childPosIter.getNextChildLM()) != null) {
            lc.setFlags(32, childLM == firstLM);
            lc.setFlags(128, childLM == lastLM);
            lc.setSpaceAdjust(layoutContext.getSpaceAdjust());
            lc.setStackLimit(layoutContext.getStackLimit());
            childLM.addAreas(childPosIter, lc);
        }
        if (this.markers != null) {
            this.getCurrentPV().addMarkers(this.markers, false, this.isFirst(firstPos), this.isLast(lastPos));
        }
        this.flush();
        this.curBlockArea = null;
    }

    public Area getParentArea(Area childArea) {
        if (this.curBlockArea == null) {
            this.curBlockArea = new Block();
            this.curBlockArea.setPositioning(2);
            this.curBlockArea.setXOffset(this.xoffset);
            this.curBlockArea.setIPD(this.itemIPD);
            TraitSetter.setProducerID(this.curBlockArea, this.getPartFO().getId());
            Area parentArea = this.parentLM.getParentArea(this.curBlockArea);
            int referenceIPD = parentArea.getIPD();
            this.curBlockArea.setIPD(referenceIPD);
            this.setCurrentArea(this.curBlockArea);
        }
        return this.curBlockArea;
    }

    public void addChildArea(Area childArea) {
        if (this.curBlockArea != null) {
            this.curBlockArea.addBlock((Block)childArea);
        }
    }

    public void resetPosition(Position resetPos) {
        if (resetPos == null) {
            this.reset(null);
        } else {
            this.setFinished(false);
        }
    }

    public boolean mustKeepTogether() {
        return ((BlockLevelLayoutManager)this.getParent()).mustKeepTogether() || !this.getPartFO().getKeepTogether().getWithinPage().isAuto() || !this.getPartFO().getKeepTogether().getWithinColumn().isAuto();
    }

    private static class StackingIter
    extends PositionIterator {
        StackingIter(Iterator parentIter) {
            super(parentIter);
        }

        protected LayoutManager getLM(Object nextObj) {
            return ((Position)nextObj).getLM();
        }

        protected Position getPos(Object nextObj) {
            return (Position)nextObj;
        }
    }
}

