/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.fo.flow.Table;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.fo.properties.TableColLength;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.table.ColumnSetup;
import org.apache.fop.layoutmgr.table.TableContentLayoutManager;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;

public class TableLayoutManager
extends BlockStackingLayoutManager
implements BlockLevelLayoutManager {
    private Table fobj;
    private TableContentLayoutManager contentLM;
    private ColumnSetup columns = null;
    private Block curBlockArea;
    private int referenceIPD;
    private boolean autoLayout = true;
    private MinOptMax spaceBefore;
    private MinOptMax spaceAfter;

    public TableLayoutManager(Table node) {
        super(node);
        this.fobj = node;
        this.columns = new ColumnSetup(node);
        this.initialize();
    }

    public Table getTable() {
        return this.fobj;
    }

    public ColumnSetup getColumns() {
        return this.columns;
    }

    private void initialize() {
        this.spaceBefore = new SpaceVal(this.fobj.getCommonMarginBlock().spaceBefore).getSpace();
        this.spaceAfter = new SpaceVal(this.fobj.getCommonMarginBlock().spaceAfter).getSpace();
        if (!this.fobj.isAutoLayout() && this.fobj.getInlineProgressionDimension().getOptimum().getEnum() != 9) {
            this.autoLayout = false;
        }
    }

    private int getIPIndents() {
        int iIndents = 0;
        iIndents += this.fobj.getCommonMarginBlock().startIndent.getValue();
        return iIndents += this.fobj.getCommonMarginBlock().endIndent.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        LinkedList returnList = new LinkedList();
        if (!this.bBreakBeforeServed) {
            try {
                if (this.addKnuthElementsForBreakBefore(returnList)) {
                    LinkedList linkedList = returnList;
                    return linkedList;
                }
            }
            finally {
                this.bBreakBeforeServed = true;
            }
        }
        this.referenceIPD = context.getRefIPD();
        if (this.fobj.getInlineProgressionDimension().getOptimum().getEnum() != 9) {
            this.referenceIPD = this.fobj.getInlineProgressionDimension().getOptimum().getLength().getValue();
        }
        if (this.referenceIPD > context.getRefIPD()) {
            log.warn("Allocated IPD exceeds available reference IPD");
        }
        int contentIPD = this.referenceIPD - this.getIPIndents();
        MinOptMax stackSize = new MinOptMax();
        if (this.spaceAfter != null) {
            stackSize.add(this.spaceAfter);
        }
        if (this.spaceBefore != null) {
            stackSize.add(this.spaceBefore);
        }
        this.fobj.setLayoutDimension(PercentBase.BLOCK_IPD, this.referenceIPD);
        this.fobj.setLayoutDimension(PercentBase.BLOCK_BPD, context.getStackLimit().opt);
        this.fobj.setLayoutDimension(PercentBase.REFERENCE_AREA_IPD, this.referenceIPD);
        this.fobj.setLayoutDimension(PercentBase.REFERENCE_AREA_BPD, context.getStackLimit().opt);
        int sumCols = 0;
        float factors = 0.0f;
        Iterator i = this.columns.iterator();
        while (i.hasNext()) {
            TableColumn column = (TableColumn)i.next();
            Length width = column.getColumnWidth();
            sumCols += width.getValue();
            if (!(width instanceof TableColLength)) continue;
            factors = (float)((double)factors + ((TableColLength)width).getTableUnits());
        }
        if (sumCols < contentIPD && (double)this.fobj.getLayoutDimension(PercentBase.TABLE_UNITS).floatValue() == 0.0) {
            this.fobj.setLayoutDimension(PercentBase.TABLE_UNITS, (float)(contentIPD - sumCols) / factors);
        }
        LinkedList returnedList = null;
        LinkedList contentList = new LinkedList();
        LayoutContext childLC = new LayoutContext(0);
        childLC.setStackLimit(MinOptMax.subtract(context.getStackLimit(), stackSize));
        childLC.setRefIPD(context.getRefIPD());
        if (this.contentLM == null) {
            this.contentLM = new TableContentLayoutManager(this);
        }
        returnedList = this.contentLM.getNextKnuthElements(childLC, alignment);
        if (childLC.isKeepWithNextPending()) {
            log.debug("TableContentLM signals pending keep-with-next");
            context.setFlags(512);
        }
        if (childLC.isKeepWithPreviousPending()) {
            log.debug("TableContentLM signals pending keep-with-previous");
            context.setFlags(1024);
        }
        Iterator iter = returnedList.iterator();
        while (iter.hasNext()) {
            KnuthElement el = (KnuthElement)iter.next();
            this.notifyPos(el.getPosition());
        }
        log.debug(returnedList);
        if (returnedList.size() == 1 && ((KnuthElement)returnedList.getFirst()).isPenalty() && ((KnuthPenalty)returnedList.getFirst()).getP() == -1000) {
            if (returnList.size() == 0) {
                // empty if block
            }
            contentList.addAll(returnedList);
            returnedList = new LinkedList();
            this.wrapPositionElements(contentList, returnList);
            return returnList;
        }
        contentList.addAll(returnedList);
        if (returnedList.size() > 0 && ((KnuthElement)returnedList.getLast()).isPenalty() && ((KnuthPenalty)returnedList.getLast()).getP() == -1000) {
            returnedList = new LinkedList();
            this.wrapPositionElements(contentList, returnList);
            return returnList;
        }
        this.wrapPositionElements(contentList, returnList);
        this.addKnuthElementsForBreakAfter(returnList);
        this.setFinished(true);
        return returnList;
    }

    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        this.getParentArea(null);
        this.getPSLM().addIDToPage(this.fobj.getId());
        double adjust = layoutContext.getSpaceAdjust();
        this.addBlockSpacing(adjust, this.spaceBefore);
        this.spaceBefore = null;
        int startXOffset = this.fobj.getCommonMarginBlock().startIndent.getValue();
        int tableHeight = 0;
        LayoutContext lc = new LayoutContext(0);
        lc.setRefIPD(this.referenceIPD - this.getIPIndents());
        this.contentLM.setStartXOffset(startXOffset);
        this.contentLM.addAreas(parentIter, lc);
        this.curBlockArea.setBPD(tableHeight += this.contentLM.getUsedBPD());
        if (this.fobj.isSeparateBorderModel()) {
            TraitSetter.addBorders(this.curBlockArea, this.fobj.getCommonBorderPaddingBackground());
        }
        TraitSetter.addBackground(this.curBlockArea, this.fobj.getCommonBorderPaddingBackground());
        TraitSetter.addMargins(this.curBlockArea, this.fobj.getCommonBorderPaddingBackground(), this.fobj.getCommonMarginBlock());
        TraitSetter.addBreaks(this.curBlockArea, this.fobj.getBreakBefore(), this.fobj.getBreakAfter());
        this.flush();
        this.addBlockSpacing(adjust, this.spaceAfter);
        this.curBlockArea = null;
    }

    public Area getParentArea(Area childArea) {
        if (this.curBlockArea == null) {
            this.curBlockArea = new Block();
            this.parentLM.getParentArea(this.curBlockArea);
            TraitSetter.setProducerID(this.curBlockArea, this.getTable().getId());
            int contentIPD = this.referenceIPD - this.getIPIndents();
            this.curBlockArea.setIPD(contentIPD);
            this.setCurrentArea(this.curBlockArea);
        }
        return this.curBlockArea;
    }

    public void addChildArea(Area childArea) {
        if (this.curBlockArea != null) {
            this.curBlockArea.addBlock((Block)childArea);
        }
    }

    public void resetPosition(Position resetPos) {
        if (resetPos == null) {
            this.reset(null);
        }
    }

    public int negotiateBPDAdjustment(int adj, KnuthElement lastElement) {
        return 0;
    }

    public void discardSpace(KnuthGlue spaceGlue) {
    }

    public boolean mustKeepTogether() {
        return ((BlockLevelLayoutManager)this.getParent()).mustKeepTogether() || !this.fobj.getKeepTogether().getWithinPage().isAuto() || !this.fobj.getKeepTogether().getWithinColumn().isAuto();
    }

    public boolean mustKeepWithPrevious() {
        return !this.fobj.getKeepWithPrevious().getWithinPage().isAuto() || !this.fobj.getKeepWithPrevious().getWithinColumn().isAuto();
    }

    public boolean mustKeepWithNext() {
        return !this.fobj.getKeepWithNext().getWithinPage().isAuto() || !this.fobj.getKeepWithNext().getWithinColumn().isAuto();
    }
}

