/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.BookmarkData;
import org.apache.fop.area.CTM;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.OffDocumentItem;
import org.apache.fop.area.Page;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.Character;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineBlockParent;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.Viewport;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.fonts.FontSetup;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageFactory;
import org.apache.fop.image.XMLImage;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFEncryptionManager;
import org.apache.fop.pdf.PDFFilterList;
import org.apache.fop.pdf.PDFInfo;
import org.apache.fop.pdf.PDFLink;
import org.apache.fop.pdf.PDFOutline;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFState;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFText;
import org.apache.fop.pdf.PDFXObject;
import org.apache.fop.render.PrintRenderer;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.pdf.CTMHelper;
import org.apache.fop.render.pdf.FopPDFImage;
import org.apache.fop.render.pdf.PDFXMLHandler;
import org.apache.fop.traits.BorderProps;
import org.w3c.dom.Document;

public class PDFRenderer
extends PrintRenderer {
    public static final String MIME_TYPE = "application/pdf";
    protected static final boolean WRITE_COMMENTS = true;
    protected PDFDocument pdfDoc;
    protected Map pages = null;
    protected Map pageReferences = new HashMap();
    protected Map pvReferences = new HashMap();
    protected OutputStream ostream;
    protected PDFResources pdfResources;
    protected PDFStream currentStream;
    protected PDFResourceContext currentContext = null;
    protected PDFPage currentPage;
    protected AffineTransform currentBasicTransform;
    protected PDFState currentState = null;
    protected String currentFontName = "";
    protected int currentFontSize = 0;
    protected int pageHeight;
    protected Map filterMap;
    protected boolean textOpen = false;
    protected boolean inTextMode = false;
    protected int prevWordY = 0;
    protected int prevWordX = 0;
    protected int prevWordWidth = 0;

    public void configure(Configuration cfg) throws ConfigurationException {
        this.filterMap = PDFFilterList.buildFilterMapFromConfiguration(cfg);
        List cfgFonts = FontSetup.buildFontListFromConfiguration(cfg);
        if (this.fontList == null) {
            this.fontList = cfgFonts;
        } else {
            this.fontList.addAll(cfgFonts);
        }
    }

    public void setUserAgent(FOUserAgent agent) {
        super.setUserAgent(agent);
        PDFXMLHandler xmlHandler = new PDFXMLHandler();
        this.userAgent.getXMLHandlerRegistry().addXMLHandler(xmlHandler);
    }

    public void startRenderer(OutputStream stream) throws IOException {
        if (this.userAgent == null) {
            throw new IllegalStateException("UserAgent must be set before starting the renderer");
        }
        this.ostream = stream;
        this.pdfDoc = new PDFDocument(this.userAgent.getProducer() != null ? this.userAgent.getProducer() : "");
        this.pdfDoc.setCreator(this.userAgent.getCreator());
        this.pdfDoc.setCreationDate(this.userAgent.getCreationDate());
        this.pdfDoc.getInfo().setAuthor(this.userAgent.getAuthor());
        this.pdfDoc.getInfo().setTitle(this.userAgent.getTitle());
        this.pdfDoc.getInfo().setKeywords(this.userAgent.getKeywords());
        this.pdfDoc.setFilterMap(this.filterMap);
        this.pdfDoc.outputHeader(stream);
        PDFEncryptionManager.setupPDFEncryption(this.userAgent.getPDFEncryptionParams(), this.pdfDoc);
    }

    public void stopRenderer() throws IOException {
        this.pdfDoc.getResources().addFonts(this.pdfDoc, this.fontInfo);
        this.pdfDoc.outputTrailer(this.ostream);
        this.pdfDoc = null;
        this.ostream = null;
        this.pages = null;
        this.pageReferences.clear();
        this.pvReferences.clear();
        this.pdfResources = null;
        this.currentStream = null;
        this.currentContext = null;
        this.currentPage = null;
        this.currentState = null;
        this.currentFontName = "";
    }

    public boolean supportsOutOfOrder() {
        return false;
    }

    public void processOffDocumentItem(OffDocumentItem odi) {
        if (odi instanceof BookmarkData) {
            this.renderBookmarkTree((BookmarkData)odi);
        }
    }

    protected void renderBookmarkTree(BookmarkData bookmarks) {
        for (int i = 0; i < bookmarks.getCount(); ++i) {
            BookmarkData ext = bookmarks.getSubData(i);
            this.renderBookmarkItem(ext, null);
        }
    }

    private void renderBookmarkItem(BookmarkData bookmarkItem, PDFOutline parentBookmarkItem) {
        PDFOutline pdfOutline = null;
        PageViewport pv = bookmarkItem.getPageViewport();
        if (pv != null) {
            Rectangle2D bounds = pv.getViewArea();
            double h = bounds.getHeight();
            float yoffset = (float)h / 1000.0f;
            String intDest = (String)this.pageReferences.get(pv.getKey());
            if (parentBookmarkItem == null) {
                PDFOutline outlineRoot = this.pdfDoc.getOutlineRoot();
                pdfOutline = this.pdfDoc.getFactory().makeOutline(outlineRoot, bookmarkItem.getBookmarkTitle(), intDest, yoffset, bookmarkItem.showChildItems());
            } else {
                pdfOutline = this.pdfDoc.getFactory().makeOutline(parentBookmarkItem, bookmarkItem.getBookmarkTitle(), intDest, yoffset, bookmarkItem.showChildItems());
            }
        }
        for (int i = 0; i < bookmarkItem.getCount(); ++i) {
            this.renderBookmarkItem(bookmarkItem.getSubData(i), pdfOutline);
        }
    }

    protected void comment(String text) {
        this.currentStream.add("% " + text + "\n");
    }

    protected void saveGraphicsState() {
        this.endTextObject();
        this.currentStream.add("q\n");
    }

    protected void restoreGraphicsState() {
        this.endTextObject();
        this.currentStream.add("Q\n");
    }

    protected void beginTextObject() {
        if (!this.inTextMode) {
            this.currentStream.add("BT\n");
            this.inTextMode = true;
        }
    }

    protected void endTextObject() {
        this.closeText();
        if (this.inTextMode) {
            this.currentStream.add("ET\n");
            this.inTextMode = false;
        }
    }

    public void startPageSequence(LineArea seqTitle) {
        if (seqTitle != null) {
            String str = this.convertTitleToString(seqTitle);
            PDFInfo info = this.pdfDoc.getInfo();
            if (info.getTitle() == null) {
                info.setTitle(str);
            }
        }
    }

    public void preparePage(PageViewport page) {
        this.pdfResources = this.pdfDoc.getResources();
        Rectangle2D bounds = page.getViewArea();
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        this.currentPage = this.pdfDoc.getFactory().makePage(this.pdfResources, (int)Math.round(w / 1000.0), (int)Math.round(h / 1000.0));
        if (this.pages == null) {
            this.pages = new HashMap();
        }
        this.pages.put(page, this.currentPage);
        this.pageReferences.put(page.getKey(), this.currentPage.referencePDF());
        this.pvReferences.put(page.getKey(), page);
    }

    public void renderPage(PageViewport page) throws IOException, FOPException {
        Rectangle2D bounds;
        if (this.pages != null && (this.currentPage = (PDFPage)this.pages.get(page)) != null) {
            this.pages.remove(page);
            bounds = page.getViewArea();
            double h = bounds.getHeight();
            this.pageHeight = (int)h;
        } else {
            this.pdfResources = this.pdfDoc.getResources();
            bounds = page.getViewArea();
            double w = bounds.getWidth();
            double h = bounds.getHeight();
            this.pageHeight = (int)h;
            this.currentPage = this.pdfDoc.getFactory().makePage(this.pdfResources, (int)Math.round(w / 1000.0), (int)Math.round(h / 1000.0));
            this.pageReferences.put(page.getKey(), this.currentPage.referencePDF());
            this.pvReferences.put(page.getKey(), page);
        }
        this.currentStream = this.pdfDoc.getFactory().makeStream("content", false);
        this.currentState = new PDFState();
        this.currentStream.add("1 0 0 -1 0 " + Math.round(this.pageHeight / 1000) + " cm\n");
        this.currentBasicTransform = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, Math.round(this.pageHeight / 1000));
        this.currentFontName = "";
        Page p = page.getPage();
        this.renderPageAreas(p);
        this.pdfDoc.registerObject(this.currentStream);
        this.currentPage.setContents(this.currentStream);
        PDFAnnotList annots = this.currentPage.getAnnotations();
        if (annots != null) {
            this.pdfDoc.addObject(annots);
        }
        this.pdfDoc.addObject(this.currentPage);
        this.pdfDoc.output(this.ostream);
    }

    protected void startVParea(CTM ctm) {
        this.currentState.push();
        this.currentState.setTransform(new AffineTransform(CTMHelper.toPDFArray(ctm)));
        this.saveGraphicsState();
        this.currentStream.add(CTMHelper.toPDFString(ctm) + " cm\n");
    }

    protected void endVParea() {
        this.restoreGraphicsState();
        this.currentState.pop();
    }

    protected void handleRegionTraits(RegionViewport region) {
        this.currentFontName = "";
        Rectangle2D viewArea = region.getViewArea();
        float startx = (float)(viewArea.getX() / 1000.0);
        float starty = (float)(viewArea.getY() / 1000.0);
        float width = (float)(viewArea.getWidth() / 1000.0);
        float height = (float)(viewArea.getHeight() / 1000.0);
        if (region.getRegionReference().getRegionClass() == 36) {
            this.currentBPPosition = region.getBorderAndPaddingWidthBefore();
            this.currentIPPosition = region.getBorderAndPaddingWidthStart();
        }
        this.drawBackAndBorders(region, startx, starty, width, height);
    }

    protected void handleBlockTraits(Block block) {
        int borderPaddingStart = block.getBorderAndPaddingWidthStart();
        int borderPaddingBefore = block.getBorderAndPaddingWidthBefore();
        float startx = (float)this.currentIPPosition / 1000.0f;
        float starty = (float)this.currentBPPosition / 1000.0f;
        float width = (float)block.getIPD() / 1000.0f;
        float height = (float)block.getBPD() / 1000.0f;
        startx += (float)block.getStartIndent() / 1000.0f;
        width += (float)borderPaddingStart / 1000.0f;
        height += (float)borderPaddingBefore / 1000.0f;
        this.drawBackAndBorders(block, startx -= (float)block.getBorderAndPaddingWidthStart() / 1000.0f, starty, width += (float)block.getBorderAndPaddingWidthEnd() / 1000.0f, height += (float)block.getBorderAndPaddingWidthAfter() / 1000.0f);
    }

    protected void drawBackAndBorders(Area area, float startx, float starty, float width, float height) {
        float ey1a;
        float sy1a;
        float innerx;
        float ex1a;
        float sx1a;
        float innery;
        boolean[] b;
        BorderProps bpsBefore = (BorderProps)area.getTrait(Trait.BORDER_BEFORE);
        BorderProps bpsAfter = (BorderProps)area.getTrait(Trait.BORDER_AFTER);
        BorderProps bpsStart = (BorderProps)area.getTrait(Trait.BORDER_START);
        BorderProps bpsEnd = (BorderProps)area.getTrait(Trait.BORDER_END);
        Trait.Background back = (Trait.Background)area.getTrait(Trait.BACKGROUND);
        if (back != null) {
            this.endTextObject();
            float sx = startx;
            float sy = starty;
            float paddRectWidth = width;
            float paddRectHeight = height;
            if (bpsStart != null) {
                sx += (float)bpsStart.width / 1000.0f;
                paddRectWidth -= (float)bpsStart.width / 1000.0f;
            }
            if (bpsBefore != null) {
                sy += (float)bpsBefore.width / 1000.0f;
                paddRectHeight -= (float)bpsBefore.width / 1000.0f;
            }
            if (bpsEnd != null) {
                paddRectWidth -= (float)bpsEnd.width / 1000.0f;
            }
            if (bpsAfter != null) {
                paddRectHeight -= (float)bpsAfter.width / 1000.0f;
            }
            if (back.getColor() != null) {
                this.updateColor(back.getColor(), true, null);
                this.currentStream.add(sx + " " + sy + " " + paddRectWidth + " " + paddRectHeight + " re\n");
                this.currentStream.add("f\n");
            }
            if (back.getFopImage() != null) {
                FopImage fopimage = back.getFopImage();
                if (fopimage != null && fopimage.load(1)) {
                    this.saveGraphicsState();
                    this.clip(sx, sy, paddRectWidth, paddRectHeight);
                    int horzCount = (int)(paddRectWidth * 1000.0f / (float)fopimage.getIntrinsicWidth() + 1.0f);
                    int vertCount = (int)(paddRectHeight * 1000.0f / (float)fopimage.getIntrinsicHeight() + 1.0f);
                    if (back.getRepeat() == 96) {
                        horzCount = 1;
                        vertCount = 1;
                    } else if (back.getRepeat() == 113) {
                        vertCount = 1;
                    } else if (back.getRepeat() == 114) {
                        horzCount = 1;
                    }
                    sx *= 1000.0f;
                    sy *= 1000.0f;
                    if (horzCount == 1) {
                        sx += (float)back.getHoriz();
                    }
                    if (vertCount == 1) {
                        sy += (float)back.getVertical();
                    }
                    for (int x = 0; x < horzCount; ++x) {
                        for (int y = 0; y < vertCount; ++y) {
                            Rectangle2D.Float pos = new Rectangle2D.Float(sx + (float)(x * fopimage.getIntrinsicWidth()), sy + (float)(y * fopimage.getIntrinsicHeight()), fopimage.getIntrinsicWidth(), fopimage.getIntrinsicHeight());
                            this.putImage(back.getURL(), pos);
                        }
                    }
                    this.restoreGraphicsState();
                } else {
                    log.warn("Can't find background image: " + back.getURL());
                }
            }
        }
        if (!((b = new boolean[]{bpsBefore != null, bpsEnd != null, bpsAfter != null, bpsStart != null})[0] || b[1] || b[2] || b[3])) {
            return;
        }
        float[] bw = new float[]{b[0] ? (float)bpsBefore.width / 1000.0f : 0.0f, b[1] ? (float)bpsEnd.width / 1000.0f : 0.0f, b[2] ? (float)bpsAfter.width / 1000.0f : 0.0f, b[3] ? (float)bpsStart.width / 1000.0f : 0.0f};
        float[] clipw = new float[]{(float)BorderProps.getClippedWidth(bpsBefore) / 1000.0f, (float)BorderProps.getClippedWidth(bpsEnd) / 1000.0f, (float)BorderProps.getClippedWidth(bpsAfter) / 1000.0f, (float)BorderProps.getClippedWidth(bpsStart) / 1000.0f};
        starty += clipw[0];
        height -= clipw[0];
        height -= clipw[2];
        startx += clipw[3];
        width -= clipw[3];
        width -= clipw[1];
        boolean[] slant = new boolean[]{b[3] && b[0], b[0] && b[1], b[1] && b[2], b[2] && b[3]};
        if (bpsBefore != null) {
            this.endTextObject();
            float sx1 = startx;
            float sx2 = slant[0] ? sx1 + bw[3] - clipw[3] : sx1;
            float ex1 = startx + width;
            float ex2 = slant[1] ? ex1 - bw[1] + clipw[1] : ex1;
            float outery = starty - clipw[0];
            float clipy = outery + clipw[0];
            innery = outery + bw[0];
            this.saveGraphicsState();
            this.moveTo(sx1, clipy);
            sx1a = sx1;
            ex1a = ex1;
            if (bpsBefore.mode == 2) {
                if (bpsStart != null && bpsStart.mode == 2) {
                    sx1a -= clipw[3];
                }
                if (bpsEnd != null && bpsEnd.mode == 2) {
                    ex1a += clipw[1];
                }
                this.lineTo(sx1a, outery);
                this.lineTo(ex1a, outery);
            }
            this.lineTo(ex1, clipy);
            this.lineTo(ex2, innery);
            this.lineTo(sx2, innery);
            this.closePath();
            this.clip();
            this.drawBorderLine(sx1a, outery, ex1a, innery, true, true, bpsBefore.style, bpsBefore.color);
            this.restoreGraphicsState();
        }
        if (bpsEnd != null) {
            this.endTextObject();
            float sy1 = starty;
            float sy2 = slant[1] ? sy1 + bw[0] - clipw[0] : sy1;
            float ey1 = starty + height;
            float ey2 = slant[2] ? ey1 - bw[2] + clipw[2] : ey1;
            float outerx = startx + width + clipw[1];
            float clipx = outerx - clipw[1];
            innerx = outerx - bw[1];
            this.saveGraphicsState();
            this.moveTo(clipx, sy1);
            sy1a = sy1;
            ey1a = ey1;
            if (bpsEnd.mode == 2) {
                if (bpsBefore != null && bpsBefore.mode == 2) {
                    sy1a -= clipw[0];
                }
                if (bpsAfter != null && bpsAfter.mode == 2) {
                    ey1a += clipw[2];
                }
                this.lineTo(outerx, sy1a);
                this.lineTo(outerx, ey1a);
            }
            this.lineTo(clipx, ey1);
            this.lineTo(innerx, ey2);
            this.lineTo(innerx, sy2);
            this.closePath();
            this.clip();
            this.drawBorderLine(innerx, sy1a, outerx, ey1a, false, false, bpsEnd.style, bpsEnd.color);
            this.restoreGraphicsState();
        }
        if (bpsAfter != null) {
            this.endTextObject();
            float sx1 = startx;
            float sx2 = slant[3] ? sx1 + bw[3] - clipw[3] : sx1;
            float ex1 = startx + width;
            float ex2 = slant[2] ? ex1 - bw[1] + clipw[1] : ex1;
            float outery = starty + height + clipw[2];
            float clipy = outery - clipw[2];
            innery = outery - bw[2];
            this.saveGraphicsState();
            this.moveTo(ex1, clipy);
            sx1a = sx1;
            ex1a = ex1;
            if (bpsAfter.mode == 2) {
                if (bpsStart != null && bpsStart.mode == 2) {
                    sx1a -= clipw[3];
                }
                if (bpsEnd != null && bpsEnd.mode == 2) {
                    ex1a += clipw[1];
                }
                this.lineTo(ex1a, outery);
                this.lineTo(sx1a, outery);
            }
            this.lineTo(sx1, clipy);
            this.lineTo(sx2, innery);
            this.lineTo(ex2, innery);
            this.closePath();
            this.clip();
            this.drawBorderLine(sx1a, innery, ex1a, outery, true, false, bpsAfter.style, bpsAfter.color);
            this.restoreGraphicsState();
        }
        if (bpsStart != null) {
            this.endTextObject();
            float sy1 = starty;
            float sy2 = slant[0] ? sy1 + bw[0] - clipw[0] : sy1;
            float ey1 = sy1 + height;
            float ey2 = slant[3] ? ey1 - bw[2] + clipw[2] : ey1;
            float outerx = startx - clipw[3];
            float clipx = outerx + clipw[3];
            innerx = outerx + bw[3];
            this.saveGraphicsState();
            this.moveTo(clipx, ey1);
            sy1a = sy1;
            ey1a = ey1;
            if (bpsStart.mode == 2) {
                if (bpsBefore != null && bpsBefore.mode == 2) {
                    sy1a -= clipw[0];
                }
                if (bpsAfter != null && bpsAfter.mode == 2) {
                    ey1a += clipw[2];
                }
                this.lineTo(outerx, ey1a);
                this.lineTo(outerx, sy1a);
            }
            this.lineTo(clipx, sy1);
            this.lineTo(innerx, sy2);
            this.lineTo(innerx, ey2);
            this.closePath();
            this.clip();
            this.drawBorderLine(outerx, sy1a, innerx, ey1a, false, true, bpsStart.style, bpsStart.color);
            this.restoreGraphicsState();
        }
    }

    private Color lightenColor(Color col, float factor) {
        float[] cols = new float[3];
        cols = col.getColorComponents(cols);
        if (factor > 0.0f) {
            cols[0] = (float)((double)cols[0] + (1.0 - (double)cols[0]) * (double)factor);
            cols[1] = (float)((double)cols[1] + (1.0 - (double)cols[1]) * (double)factor);
            cols[2] = (float)((double)cols[2] + (1.0 - (double)cols[2]) * (double)factor);
        } else {
            cols[0] = cols[0] - cols[0] * -factor;
            cols[1] = cols[1] - cols[1] * -factor;
            cols[2] = cols[2] - cols[2] * -factor;
        }
        return new Color(cols[0], cols[1], cols[2]);
    }

    private void drawBorderLine(float x1, float y1, float x2, float y2, boolean horz, boolean startOrBefore, int style, ColorType col) {
        float w = x2 - x1;
        float h = y2 - y1;
        if (w < 0.0f || h < 0.0f) {
            log.error("Negative extent received. Border won't be painted.");
            return;
        }
        switch (style) {
            case 31: {
                this.setColor(this.toColor(col), false, null);
                if (horz) {
                    float unit = Math.abs(2.0f * h);
                    int rep = (int)(w / unit);
                    if (rep % 2 == 0) {
                        ++rep;
                    }
                    unit = w / (float)rep;
                    this.currentStream.add("[" + unit + "] 0 d ");
                    this.currentStream.add(h + " w\n");
                    float ym = y1 + h / 2.0f;
                    this.currentStream.add(x1 + " " + ym + " m " + x2 + " " + ym + " l S\n");
                    break;
                }
                float unit = Math.abs(2.0f * w);
                int rep = (int)(h / unit);
                if (rep % 2 == 0) {
                    ++rep;
                }
                unit = h / (float)rep;
                this.currentStream.add("[" + unit + "] 0 d ");
                this.currentStream.add(w + " w\n");
                float xm = x1 + w / 2.0f;
                this.currentStream.add(xm + " " + y1 + " m " + xm + " " + y2 + " l S\n");
                break;
            }
            case 36: {
                this.setColor(this.toColor(col), false, null);
                this.currentStream.add("1 J ");
                if (horz) {
                    float unit = Math.abs(2.0f * h);
                    int rep = (int)(w / unit);
                    if (rep % 2 == 0) {
                        ++rep;
                    }
                    unit = w / (float)rep;
                    this.currentStream.add("[0 " + unit + "] 0 d ");
                    this.currentStream.add(h + " w\n");
                    float ym = y1 + h / 2.0f;
                    this.currentStream.add(x1 + " " + ym + " m " + x2 + " " + ym + " l S\n");
                    break;
                }
                float unit = Math.abs(2.0f * w);
                int rep = (int)(h / unit);
                if (rep % 2 == 0) {
                    ++rep;
                }
                unit = h / (float)rep;
                this.currentStream.add("[0 " + unit + " ] 0 d ");
                this.currentStream.add(w + " w\n");
                float xm = x1 + w / 2.0f;
                this.currentStream.add(xm + " " + y1 + " m " + xm + " " + y2 + " l S\n");
                break;
            }
            case 37: {
                this.setColor(this.toColor(col), false, null);
                this.currentStream.add("[] 0 d ");
                if (horz) {
                    float h3 = h / 3.0f;
                    this.currentStream.add(h3 + " w\n");
                    float ym1 = y1 + h3 / 2.0f;
                    float ym2 = ym1 + h3 + h3;
                    this.currentStream.add(x1 + " " + ym1 + " m " + x2 + " " + ym1 + " l S\n");
                    this.currentStream.add(x1 + " " + ym2 + " m " + x2 + " " + ym2 + " l S\n");
                    break;
                }
                float w3 = w / 3.0f;
                this.currentStream.add(w3 + " w\n");
                float xm1 = x1 + w3 / 2.0f;
                float xm2 = xm1 + w3 + w3;
                this.currentStream.add(xm1 + " " + y1 + " m " + xm1 + " " + y2 + " l S\n");
                this.currentStream.add(xm2 + " " + y1 + " m " + xm2 + " " + y2 + " l S\n");
                break;
            }
            case 55: 
            case 119: {
                float colFactor = style == 55 ? 0.4f : -0.4f;
                this.currentStream.add("[] 0 d ");
                Color c = this.toColor(col);
                if (horz) {
                    Color uppercol = this.lightenColor(c, -colFactor);
                    Color lowercol = this.lightenColor(c, colFactor);
                    float h3 = h / 3.0f;
                    this.currentStream.add(h3 + " w\n");
                    float ym1 = y1 + h3 / 2.0f;
                    this.setColor(uppercol, false, null);
                    this.currentStream.add(x1 + " " + ym1 + " m " + x2 + " " + ym1 + " l S\n");
                    this.setColor(c, false, null);
                    this.currentStream.add(x1 + " " + (ym1 + h3) + " m " + x2 + " " + (ym1 + h3) + " l S\n");
                    this.setColor(lowercol, false, null);
                    this.currentStream.add(x1 + " " + (ym1 + h3 + h3) + " m " + x2 + " " + (ym1 + h3 + h3) + " l S\n");
                    break;
                }
                Color leftcol = this.lightenColor(c, -colFactor);
                Color rightcol = this.lightenColor(c, colFactor);
                float w3 = w / 3.0f;
                this.currentStream.add(w3 + " w\n");
                float xm1 = x1 + w3 / 2.0f;
                this.setColor(leftcol, false, null);
                this.currentStream.add(xm1 + " " + y1 + " m " + xm1 + " " + y2 + " l S\n");
                this.setColor(c, false, null);
                this.currentStream.add(xm1 + w3 + " " + y1 + " m " + (xm1 + w3) + " " + y2 + " l S\n");
                this.setColor(rightcol, false, null);
                this.currentStream.add(xm1 + w3 + w3 + " " + y1 + " m " + (xm1 + w3 + w3) + " " + y2 + " l S\n");
                break;
            }
            case 67: 
            case 101: {
                float colFactor = style == 101 ? 0.4f : -0.4f;
                this.currentStream.add("[] 0 d ");
                Color c = this.toColor(col);
                if (horz) {
                    c = this.lightenColor(c, (float)(startOrBefore ? 1 : -1) * colFactor);
                    this.currentStream.add(h + " w\n");
                    float ym1 = y1 + h / 2.0f;
                    this.setColor(c, false, null);
                    this.currentStream.add(x1 + " " + ym1 + " m " + x2 + " " + ym1 + " l S\n");
                    break;
                }
                c = this.lightenColor(c, (float)(startOrBefore ? 1 : -1) * colFactor);
                this.currentStream.add(w + " w\n");
                float xm1 = x1 + w / 2.0f;
                this.setColor(c, false, null);
                this.currentStream.add(xm1 + " " + y1 + " m " + xm1 + " " + y2 + " l S\n");
                break;
            }
            case 57: {
                break;
            }
            default: {
                this.setColor(this.toColor(col), false, null);
                this.currentStream.add("[] 0 d ");
                if (horz) {
                    this.currentStream.add(h + " w\n");
                    float ym = y1 + h / 2.0f;
                    this.currentStream.add(x1 + " " + ym + " m " + x2 + " " + ym + " l S\n");
                    break;
                }
                this.currentStream.add(w + " w\n");
                float xm = x1 + w / 2.0f;
                this.currentStream.add(xm + " " + y1 + " m " + xm + " " + y2 + " l S\n");
            }
        }
    }

    private void updateLineWidth(float width) {
        if (this.currentState.setLineWidth(width)) {
            this.currentStream.add(width + " w\n");
        }
    }

    private void updateLineStyle(int style) {
        switch (style) {
            case 31: {
                this.currentStream.add("[3] 0 d\n");
                break;
            }
            case 36: {
                this.currentStream.add("[1 7] 0 d\n");
                break;
            }
            default: {
                this.currentStream.add("[] 0 d\n");
            }
        }
    }

    private void moveTo(float x, float y) {
        this.currentStream.add(x + " " + y + " m ");
    }

    private void lineTo(float x, float y) {
        this.currentStream.add(x + " " + y + " l ");
    }

    private void closePath() {
        this.currentStream.add("h ");
    }

    private void drawLine(float startx, float starty, float endx, float endy) {
        this.currentStream.add(startx + " " + starty + " m ");
        this.currentStream.add(endx + " " + endy + " l S\n");
    }

    protected void renderBlockViewport(BlockViewport bv, List children) {
        int saveIP = this.currentIPPosition;
        int saveBP = this.currentBPPosition;
        String saveFontName = this.currentFontName;
        CTM ctm = bv.getCTM();
        int borderPaddingStart = bv.getBorderAndPaddingWidthStart();
        int borderPaddingBefore = bv.getBorderAndPaddingWidthBefore();
        float x = (float)(bv.getXOffset() + this.containingIPPosition) / 1000.0f;
        float y = (float)(bv.getYOffset() + this.containingBPPosition) / 1000.0f;
        if (bv.getPositioning() == 2 || bv.getPositioning() == 3) {
            Integer spaceBefore;
            ArrayList<PDFState.Data> breakOutList = null;
            if (bv.getPositioning() == 3) {
                breakOutList = new ArrayList<PDFState.Data>();
                while (true) {
                    PDFState.Data data = this.currentState.getData();
                    if (this.currentState.pop() == null) break;
                    if (breakOutList.size() == 0) {
                        this.comment("------ break out!");
                    }
                    breakOutList.add(0, data);
                    this.restoreGraphicsState();
                }
            }
            CTM tempctm = new CTM(this.containingIPPosition, this.containingBPPosition);
            ctm = tempctm.multiply(ctm);
            float width = (float)bv.getIPD() / 1000.0f;
            float height = (float)bv.getBPD() / 1000.0f;
            Integer spaceStart = (Integer)bv.getTrait(Trait.SPACE_START);
            if (spaceStart != null) {
                x += spaceStart.floatValue() / 1000.0f;
            }
            if ((spaceBefore = (Integer)bv.getTrait(Trait.SPACE_BEFORE)) != null) {
                y += spaceBefore.floatValue() / 1000.0f;
            }
            float bpwidth = (float)(borderPaddingStart + bv.getBorderAndPaddingWidthEnd()) / 1000.0f;
            float bpheight = (float)(borderPaddingBefore + bv.getBorderAndPaddingWidthAfter()) / 1000.0f;
            this.drawBackAndBorders(bv, x, y, width + bpwidth, height + bpheight);
            x += (float)borderPaddingStart / 1000.0f;
            y += (float)borderPaddingBefore / 1000.0f;
            if (bv.getClip()) {
                this.saveGraphicsState();
                this.clip(x, y, width, height);
            }
            this.startVParea(ctm);
            this.currentIPPosition = 0;
            this.currentBPPosition = 0;
            this.renderBlocks(bv, children);
            this.endVParea();
            if (bv.getClip()) {
                this.restoreGraphicsState();
            }
            if (breakOutList != null) {
                this.comment("------ restoring context after break-out...");
                Iterator i = breakOutList.iterator();
                while (i.hasNext()) {
                    PDFState.Data data = (PDFState.Data)i.next();
                    this.currentState.push();
                    this.saveGraphicsState();
                    if (data.concatenations == null) continue;
                    Iterator tr = data.concatenations.iterator();
                    while (tr.hasNext()) {
                        AffineTransform at = (AffineTransform)tr.next();
                        this.currentState.setTransform(at);
                        double[] matrix = new double[6];
                        at.getMatrix(matrix);
                        tempctm = new CTM(matrix[0], matrix[1], matrix[2], matrix[3], matrix[4] * 1000.0, matrix[5] * 1000.0);
                        this.currentStream.add(CTMHelper.toPDFString(tempctm) + " cm\n");
                    }
                }
                this.comment("------ done.");
            }
            this.currentIPPosition = saveIP;
            this.currentBPPosition = saveBP;
        } else {
            Integer spaceBefore = (Integer)bv.getTrait(Trait.SPACE_BEFORE);
            if (spaceBefore != null) {
                this.currentBPPosition += spaceBefore.intValue();
            }
            this.handleBlockTraits(bv);
            CTM tempctm = new CTM(this.containingIPPosition, this.currentBPPosition);
            ctm = tempctm.multiply(ctm);
            x += (float)borderPaddingStart / 1000.0f;
            y += (float)borderPaddingBefore / 1000.0f;
            if (bv.getClip()) {
                this.saveGraphicsState();
                float width = (float)bv.getIPD() / 1000.0f;
                float height = (float)bv.getBPD() / 1000.0f;
                this.clip(x, y, width, height);
            }
            if (ctm != null) {
                this.startVParea(ctm);
                this.currentIPPosition = 0;
                this.currentBPPosition = 0;
            }
            this.renderBlocks(bv, children);
            if (ctm != null) {
                this.endVParea();
            }
            if (bv.getClip()) {
                this.restoreGraphicsState();
            }
            this.currentIPPosition = saveIP;
            this.currentBPPosition = saveBP;
            if (spaceBefore != null) {
                this.currentBPPosition += spaceBefore.intValue();
            }
            this.currentBPPosition += bv.getAllocBPD();
            Integer spaceAfter = (Integer)bv.getTrait(Trait.SPACE_AFTER);
            if (spaceAfter != null) {
                this.currentBPPosition += spaceAfter.intValue();
            }
        }
        this.currentFontName = saveFontName;
    }

    protected void clip(float x, float y, float width, float height) {
        this.currentStream.add(x + " " + y + " " + width + " " + height + " re ");
        this.clip();
    }

    protected void clip() {
        this.currentStream.add("W\n");
        this.currentStream.add("n\n");
    }

    protected void renderLineArea(LineArea line) {
        super.renderLineArea(line);
        this.closeText();
    }

    public void renderInlineParent(InlineParent ip) {
        float start = (float)this.currentIPPosition / 1000.0f;
        float top = (float)(ip.getOffset() + this.currentBPPosition) / 1000.0f;
        float width = (float)ip.getIPD() / 1000.0f;
        float height = (float)ip.getBPD() / 1000.0f;
        this.drawBackAndBorders(ip, start, top, width, height);
        super.renderInlineParent(ip);
        Object tr = ip.getTrait(Trait.INTERNAL_LINK);
        boolean internal = false;
        String dest = null;
        float yoffset = 0.0f;
        if (tr == null) {
            dest = (String)ip.getTrait(Trait.EXTERNAL_LINK);
        } else {
            String pvKey = (String)tr;
            dest = (String)this.pageReferences.get(pvKey);
            if (dest != null) {
                PageViewport pv = (PageViewport)this.pvReferences.get(pvKey);
                Rectangle2D bounds = pv.getViewArea();
                double h = bounds.getHeight();
                yoffset = (float)h / 1000.0f;
                internal = true;
            }
        }
        if (dest != null) {
            Rectangle2D rect = new Rectangle2D.Float(start, top, width, height);
            AffineTransform transform = this.currentState.getTransform();
            rect = transform.createTransformedShape(rect).getBounds2D();
            rect = this.currentBasicTransform.createTransformedShape(rect).getBounds2D();
            int type = internal ? 1 : 0;
            PDFLink pdflink = this.pdfDoc.getFactory().makeLink(rect, dest, type, yoffset);
            this.currentPage.addAnnotation(pdflink);
        }
    }

    protected void renderInlineBlockParent(InlineBlockParent ibp) {
        float start = (float)this.currentIPPosition / 1000.0f;
        float top = (float)(ibp.getOffset() + this.currentBPPosition) / 1000.0f;
        float width = (float)ibp.getIPD() / 1000.0f;
        float height = (float)ibp.getBPD() / 1000.0f;
        this.drawBackAndBorders(ibp, start, top, width, height);
        super.renderInlineBlockParent(ibp);
    }

    public void renderCharacter(Character ch) {
        StringBuffer pdf = new StringBuffer();
        String name = (String)ch.getTrait(Trait.FONT_NAME);
        int size = (Integer)ch.getTrait(Trait.FONT_SIZE);
        Typeface f = (Typeface)this.fontInfo.getFonts().get(name);
        boolean useMultiByte = f.isMultiByte();
        String startText = useMultiByte ? "<" : "(";
        String endText = useMultiByte ? "> " : ") ";
        this.updateFont(name, size, pdf);
        ColorType ct = (ColorType)ch.getTrait(Trait.COLOR);
        if (ct != null) {
            this.updateColor(ct, true, pdf);
        }
        int rx = this.currentIPPosition;
        int bl = this.currentBPPosition + ch.getOffset();
        if (!this.textOpen || bl != this.prevWordY) {
            this.closeText();
            pdf.append("1 0 0 -1 " + (float)rx / 1000.0f + " " + (float)bl / 1000.0f + " Tm " + (float)ch.getTextLetterSpaceAdjust() / 1000.0f + " Tc " + (float)ch.getTextWordSpaceAdjust() / 1000.0f + " Tw [" + startText);
            this.prevWordY = bl;
            this.textOpen = true;
        } else {
            this.closeText();
            pdf.append("1 0 0 -1 " + (float)rx / 1000.0f + " " + (float)bl / 1000.0f + " Tm " + (float)ch.getTextLetterSpaceAdjust() / 1000.0f + " Tc " + (float)ch.getTextWordSpaceAdjust() / 1000.0f + " Tw [" + startText);
            this.textOpen = true;
        }
        this.prevWordWidth = ch.getIPD();
        this.prevWordX = rx;
        String s = ch.getChar();
        FontMetrics metrics = this.fontInfo.getMetricsFor(name);
        Font fs = new Font(name, metrics, size);
        this.escapeText(s, fs, useMultiByte, pdf);
        pdf.append(endText);
        this.currentStream.add(pdf.toString());
        this.renderTextDecoration(fs, ch, bl, rx);
        super.renderCharacter(ch);
    }

    public void renderText(TextArea text) {
        this.beginTextObject();
        StringBuffer pdf = new StringBuffer();
        String name = (String)text.getTrait(Trait.FONT_NAME);
        int size = (Integer)text.getTrait(Trait.FONT_SIZE);
        Typeface f = (Typeface)this.fontInfo.getFonts().get(name);
        boolean useMultiByte = f.isMultiByte();
        String startText = useMultiByte ? "<" : "(";
        String endText = useMultiByte ? "> " : ") ";
        this.updateFont(name, size, pdf);
        ColorType ct = (ColorType)text.getTrait(Trait.COLOR);
        this.updateColor(ct, true, pdf);
        int rx = this.currentIPPosition;
        int bl = this.currentBPPosition + text.getOffset();
        if (!this.textOpen || bl != this.prevWordY) {
            this.closeText();
            pdf.append("1 0 0 -1 " + (float)rx / 1000.0f + " " + (float)bl / 1000.0f + " Tm " + (float)text.getTextLetterSpaceAdjust() / 1000.0f + " Tc " + (float)text.getTextWordSpaceAdjust() / 1000.0f + " Tw [" + startText);
            this.prevWordY = bl;
            this.textOpen = true;
        } else {
            this.closeText();
            pdf.append("1 0 0 -1 " + (float)rx / 1000.0f + " " + (float)bl / 1000.0f + " Tm " + (float)text.getTextLetterSpaceAdjust() / 1000.0f + " Tc " + (float)text.getTextWordSpaceAdjust() / 1000.0f + " Tw [" + startText);
            this.textOpen = true;
        }
        this.prevWordWidth = text.getIPD();
        this.prevWordX = rx;
        String s = text.getTextArea();
        FontMetrics metrics = this.fontInfo.getMetricsFor(name);
        Font fs = new Font(name, metrics, size);
        this.escapeText(s, fs, useMultiByte, pdf);
        pdf.append(endText);
        this.currentStream.add(pdf.toString());
        this.renderTextDecoration(fs, text, bl, rx);
        super.renderText(text);
    }

    protected void renderTextDecoration(Font fs, InlineArea inline, int baseline, int startx) {
        boolean hasTextDeco;
        boolean bl = hasTextDeco = inline.hasUnderline() || inline.hasOverline() || inline.hasLineThrough();
        if (hasTextDeco) {
            float y;
            ColorType ct;
            this.endTextObject();
            this.updateLineStyle(133);
            this.updateLineWidth((float)(fs.getDescender() / -8) / 1000.0f);
            float endx = (float)(startx + inline.getIPD()) / 1000.0f;
            if (inline.hasUnderline()) {
                ct = (ColorType)inline.getTrait(Trait.UNDERLINE_COLOR);
                this.updateColor(ct, false, null);
                y = baseline - fs.getDescender() / 2;
                this.drawLine((float)startx / 1000.0f, y / 1000.0f, endx, y / 1000.0f);
            }
            if (inline.hasOverline()) {
                ct = (ColorType)inline.getTrait(Trait.OVERLINE_COLOR);
                this.updateColor(ct, false, null);
                y = (float)((double)baseline - 1.1 * (double)fs.getCapHeight());
                this.drawLine((float)startx / 1000.0f, y / 1000.0f, endx, y / 1000.0f);
            }
            if (inline.hasLineThrough()) {
                ct = (ColorType)inline.getTrait(Trait.LINETHROUGH_COLOR);
                this.updateColor(ct, false, null);
                y = (float)((double)baseline - 0.45 * (double)fs.getCapHeight());
                this.drawLine((float)startx / 1000.0f, y / 1000.0f, endx, y / 1000.0f);
            }
        }
    }

    public void escapeText(String s, Font fs, boolean useMultiByte, StringBuffer pdf) {
        String startText = useMultiByte ? "<" : "(";
        String endText = useMultiByte ? "> " : ") ";
        boolean kerningAvailable = false;
        Map kerning = fs.getKerning();
        if (kerning != null && !kerning.isEmpty()) {
            kerningAvailable = true;
        }
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            char ch = fs.mapChar(s.charAt(i));
            if (!useMultiByte) {
                if (ch > '\u007f') {
                    pdf.append("\\");
                    pdf.append(Integer.toOctalString(ch));
                } else {
                    switch (ch) {
                        case '(': 
                        case ')': 
                        case '\\': {
                            pdf.append("\\");
                        }
                    }
                    pdf.append(ch);
                }
            } else {
                pdf.append(PDFText.toUnicodeHex(ch));
            }
            if (!kerningAvailable || i + 1 >= l) continue;
            this.addKerning(pdf, new Integer(ch), new Integer(fs.mapChar(s.charAt(i + 1))), kerning, startText, endText);
        }
    }

    private void addKerning(StringBuffer buf, Integer ch1, Integer ch2, Map kerning, String startText, String endText) {
        Integer width;
        Map kernPair = (Map)kerning.get(ch1);
        if (kernPair != null && (width = (Integer)kernPair.get(ch2)) != null) {
            buf.append(endText).append(-width.intValue());
            buf.append(' ').append(startText);
        }
    }

    protected void closeText() {
        if (this.textOpen) {
            this.currentStream.add("] TJ\n");
            this.textOpen = false;
            this.prevWordX = 0;
            this.prevWordY = 0;
            this.currentFontName = "";
        }
    }

    protected void setColor(Color col, boolean fill, StringBuffer pdf) {
        PDFColor color = new PDFColor(col);
        this.closeText();
        if (pdf != null) {
            pdf.append(color.getColorSpaceOut(fill));
        } else {
            this.currentStream.add(color.getColorSpaceOut(fill));
        }
    }

    private Color toColor(ColorType col) {
        return new Color(col.getRed(), col.getGreen(), col.getBlue());
    }

    private void updateColor(ColorType col, boolean fill, StringBuffer pdf) {
        if (col == null) {
            return;
        }
        Color newCol = this.toColor(col);
        boolean update = false;
        update = fill ? this.currentState.setBackColor(newCol) : this.currentState.setColor(newCol);
        if (update) {
            this.setColor(newCol, fill, pdf);
        }
    }

    private void updateFont(String name, int size, StringBuffer pdf) {
        if (!name.equals(this.currentFontName) || size != this.currentFontSize) {
            this.closeText();
            this.currentFontName = name;
            this.currentFontSize = size;
            pdf = pdf.append("/" + name + " " + (float)size / 1000.0f + " Tf\n");
        }
    }

    public void renderImage(Image image, Rectangle2D pos) {
        this.endTextObject();
        String url = image.getURL();
        this.putImage(url, pos);
    }

    protected void putImage(String url, Rectangle2D pos) {
        PDFXObject xobject = this.pdfDoc.getImage(url);
        if (xobject != null) {
            float w = (float)pos.getWidth() / 1000.0f;
            float h = (float)pos.getHeight() / 1000.0f;
            this.placeImage((float)pos.getX() / 1000.0f, (float)pos.getY() / 1000.0f, w, h, xobject.getXNumber());
            return;
        }
        url = ImageFactory.getURL(url);
        ImageFactory fact = ImageFactory.getInstance();
        FopImage fopimage = fact.getImage(url, this.userAgent);
        if (fopimage == null) {
            return;
        }
        if (!fopimage.load(1)) {
            return;
        }
        String mime = fopimage.getMimeType();
        if ("text/xml".equals(mime)) {
            if (!fopimage.load(2)) {
                return;
            }
            Document doc = ((XMLImage)fopimage).getDocument();
            String ns = ((XMLImage)fopimage).getNameSpace();
            this.renderDocument(doc, ns, pos);
        } else if ("image/svg+xml".equals(mime)) {
            if (!fopimage.load(2)) {
                return;
            }
            Document doc = ((XMLImage)fopimage).getDocument();
            String ns = ((XMLImage)fopimage).getNameSpace();
            this.renderDocument(doc, ns, pos);
        } else if ("image/eps".equals(mime)) {
            if (!fopimage.load(2)) {
                return;
            }
            FopPDFImage pdfimage = new FopPDFImage(fopimage, url);
            int xobj = this.pdfDoc.addImage(this.currentContext, pdfimage).getXNumber();
            fact.releaseImage(url, this.userAgent);
        } else if ("image/jpeg".equals(mime)) {
            if (!fopimage.load(2)) {
                return;
            }
            FopPDFImage pdfimage = new FopPDFImage(fopimage, url);
            int xobj = this.pdfDoc.addImage(this.currentContext, pdfimage).getXNumber();
            fact.releaseImage(url, this.userAgent);
            float w = (float)pos.getWidth() / 1000.0f;
            float h = (float)pos.getHeight() / 1000.0f;
            this.placeImage((float)pos.getX() / 1000.0f, (float)pos.getY() / 1000.0f, w, h, xobj);
        } else {
            if (!fopimage.load(4)) {
                return;
            }
            FopPDFImage pdfimage = new FopPDFImage(fopimage, url);
            int xobj = this.pdfDoc.addImage(this.currentContext, pdfimage).getXNumber();
            fact.releaseImage(url, this.userAgent);
            float w = (float)pos.getWidth() / 1000.0f;
            float h = (float)pos.getHeight() / 1000.0f;
            this.placeImage((float)pos.getX() / 1000.0f, (float)pos.getY() / 1000.0f, w, h, xobj);
        }
        try {
            this.pdfDoc.output(this.ostream);
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    protected void placeImage(float x, float y, float w, float h, int xobj) {
        this.saveGraphicsState();
        this.currentStream.add(w + " 0 0 " + -h + " " + ((float)this.currentIPPosition / 1000.0f + x) + " " + ((float)this.currentBPPosition / 1000.0f + h + y) + " cm\n" + "/Im" + xobj + " Do\n");
        this.restoreGraphicsState();
    }

    public void renderForeignObject(ForeignObject fo, Rectangle2D pos) {
        this.endTextObject();
        Document doc = fo.getDocument();
        String ns = fo.getNameSpace();
        this.renderDocument(doc, ns, pos);
    }

    public void renderDocument(Document doc, String ns, Rectangle2D pos) {
        RendererContext context = new RendererContext(this, MIME_TYPE);
        context.setUserAgent(this.userAgent);
        context.setProperty("pdfDoc", this.pdfDoc);
        context.setProperty("outputStream", this.ostream);
        context.setProperty("pdfState", this.currentState);
        context.setProperty("pdfPage", this.currentPage);
        context.setProperty("pdfContext", this.currentContext == null ? this.currentPage : this.currentContext);
        context.setProperty("pdfContext", this.currentContext);
        context.setProperty("pdfStream", this.currentStream);
        context.setProperty("xpos", new Integer(this.currentIPPosition + (int)pos.getX()));
        context.setProperty("ypos", new Integer(this.currentBPPosition + (int)pos.getY()));
        context.setProperty("fontInfo", this.fontInfo);
        context.setProperty("fontName", this.currentFontName);
        context.setProperty("fontSize", new Integer(this.currentFontSize));
        context.setProperty("width", new Integer((int)pos.getWidth()));
        context.setProperty("height", new Integer((int)pos.getHeight()));
        this.renderXML(context, doc, ns);
    }

    public void renderViewport(Viewport viewport) {
        float x = (float)this.currentIPPosition / 1000.0f;
        float y = (float)(this.currentBPPosition + viewport.getOffset()) / 1000.0f;
        float width = (float)viewport.getIPD() / 1000.0f;
        float height = (float)viewport.getBPD() / 1000.0f;
        this.drawBackAndBorders(viewport, x, y, width, height);
        if (viewport.getClip()) {
            this.saveGraphicsState();
            this.clip(x, y, width, height);
        }
        super.renderViewport(viewport);
        if (viewport.getClip()) {
            this.restoreGraphicsState();
        }
    }

    public void renderLeader(Leader area) {
        this.saveGraphicsState();
        int style = area.getRuleStyle();
        boolean alt = false;
        switch (style) {
            case 133: {
                this.currentStream.add("[] 0 d\n");
                break;
            }
            case 36: {
                this.currentStream.add("[2] 0 d\n");
                break;
            }
            case 31: {
                this.currentStream.add("[6 4] 0 d\n");
                break;
            }
            case 37: 
            case 55: 
            case 119: {
                alt = true;
            }
        }
        float startx = (float)this.currentIPPosition / 1000.0f;
        float starty = (float)(this.currentBPPosition + area.getOffset()) / 1000.0f;
        float endx = (float)(this.currentIPPosition + area.getIPD()) / 1000.0f;
        if (!alt) {
            this.updateLineWidth((float)area.getRuleThickness() / 1000.0f);
            this.drawLine(startx, starty, endx, starty);
        } else if (style == 37) {
            float third = (float)area.getRuleThickness() / 3000.0f;
            this.updateLineWidth(third);
            this.drawLine(startx, starty, endx, starty);
            this.drawLine(startx, starty + 2.0f * third, endx, starty + 2.0f * third);
        } else {
            float half = (float)area.getRuleThickness() / 2000.0f;
            this.currentStream.add("1 g\n");
            this.currentStream.add(startx + " " + starty + " m\n");
            this.currentStream.add(endx + " " + starty + " l\n");
            this.currentStream.add(endx + " " + (starty + 2.0f * half) + " l\n");
            this.currentStream.add(startx + " " + (starty + 2.0f * half) + " l\n");
            this.currentStream.add("h\n");
            this.currentStream.add("f\n");
            if (style == 55) {
                this.currentStream.add("0 g\n");
                this.currentStream.add(startx + " " + starty + " m\n");
                this.currentStream.add(endx + " " + starty + " l\n");
                this.currentStream.add(endx + " " + (starty + half) + " l\n");
                this.currentStream.add(startx + half + " " + (starty + half) + " l\n");
                this.currentStream.add(startx + " " + (starty + 2.0f * half) + " l\n");
            } else {
                this.currentStream.add("0 g\n");
                this.currentStream.add(endx + " " + starty + " m\n");
                this.currentStream.add(endx + " " + (starty + 2.0f * half) + " l\n");
                this.currentStream.add(startx + " " + (starty + 2.0f * half) + " l\n");
                this.currentStream.add(startx + " " + (starty + half) + " l\n");
                this.currentStream.add(endx - half + " " + (starty + half) + " l\n");
            }
            this.currentStream.add("h\n");
            this.currentStream.add("f\n");
        }
        this.restoreGraphicsState();
        this.beginTextObject();
        super.renderLeader(area);
    }

    public String getMimeType() {
        return MIME_TYPE;
    }
}

