/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.xml;

import javax.xml.transform.sax.TransformerHandler;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.XMLHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLXMLHandler
implements XMLHandler {
    public static final String HANDLER = "handler";
    private AttributesImpl atts = new AttributesImpl();

    public void handleXML(RendererContext context, Document doc, String ns) throws Exception {
        TransformerHandler handler = (TransformerHandler)context.getProperty(HANDLER);
        this.writeDocument(doc, handler);
    }

    public void writeDocument(Document doc, TransformerHandler handler) throws SAXException {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            this.writeNode(n, handler);
        }
    }

    public void writeNode(Node node, TransformerHandler handler) throws SAXException {
        switch (node.getNodeType()) {
            case 1: {
                Node c;
                this.atts.clear();
                if (node.hasAttributes()) {
                    NamedNodeMap attr = node.getAttributes();
                    int len = attr.getLength();
                    for (int i = 0; i < len; ++i) {
                        Attr a = (Attr)attr.item(i);
                        this.atts.addAttribute("", a.getNodeName(), a.getNodeName(), "CDATA", a.getNodeValue());
                    }
                }
                handler.startElement(node.getNamespaceURI(), node.getLocalName(), node.getLocalName(), this.atts);
                if (c != null) {
                    for (c = node.getFirstChild(); c != null; c = c.getNextSibling()) {
                        this.writeNode(c, handler);
                    }
                }
                handler.endElement(node.getNamespaceURI(), node.getNodeName(), node.getNodeName());
                break;
            }
            case 3: {
                char[] ca = node.getNodeValue().toCharArray();
                handler.characters(ca, 0, ca.length);
                break;
            }
            case 4: {
                char[] ca = node.getNodeValue().toCharArray();
                handler.startCDATA();
                handler.characters(ca, 0, ca.length);
                handler.endCDATA();
                break;
            }
            case 5: {
                System.out.println("Ignoring ENTITY_REFERENCE_NODE. NYI");
                break;
            }
            case 7: {
                handler.processingInstruction(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 8: {
                char[] ca = node.getNodeValue().toCharArray();
                handler.comment(ca, 0, ca.length);
                break;
            }
            case 10: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected node type (" + node.getNodeType() + ")");
            }
        }
    }

    private static String contentToString(String s) {
        StringBuffer result = new StringBuffer();
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    result.append("&lt;");
                    continue block7;
                }
                case '>': {
                    result.append("&gt;");
                    continue block7;
                }
                case '&': {
                    result.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    result.append("&apos;");
                    continue block7;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public String getMimeType() {
        return "application/x-fop-areatree";
    }

    public String getNamespace() {
        return null;
    }
}

