/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcAglm;
import com.insightful.cnkjava.CNKProcAglmFit;
import com.insightful.miner.EngineMessageHandler;
import com.insightful.miner.EngineNode;
import com.insightful.miner.PredictEngineNode;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.io.File;
import java.util.Vector;

class AdaptiveLinearRegressionEngineNode
extends EngineNode {
    public static final String INCLUDE_INTERCEPT_ATTRIBUTE_TAG = "includeIntercept";
    public static final String WEIGHTED_COLUMN_ATTRIBUTE_TAG = "weightedColumn";
    public static final String MAX_ITERATIONS_ATTRIBUTE_TAG = "maxIterations";
    public static final String CONVERGENCE_TOLERANCE_ATTRIBUTE_TAG = "convergenceTolerance";
    public static final String PROBABILITY_FOR_ATTRIBUTE_TAG = "probabilityFor";
    public static final String SPECIFIED_CATEGORY_ATTRIBUTE_TAG = "specifiedCategory";
    public static final String LAST_CATEGORY_ATTRIBUTE_TAG = "lastCategory";
    private String m_xmlFileName = null;
    private boolean m_xmlFileOK = false;
    private String m_modelString = null;
    public static String BEGIN_GENERALREGRESSIONMODEL = "<GeneralRegressionModel modelName=";
    public static String MODEL_TYPE_GENERALLINEAR = "\"generalLinear\"";
    public static String MODEL_TYPE = " modelType=";
    public static String BEGIN_LINEAR_MODEL = "<LinearModel>\n";
    public static String INTERCEPT_VALUE = "<Intercept value=";
    public static String WEIGHTS_VALUE = "<Weights value=";
    public static String BEGIN_TERM = "<Term name=";
    public static String TERMVAR_VALUE = "<TermVar value=";
    public static String END_TERM = "</Term>\n";
    public static String END_LINEAR_MODEL = "</LinearModel>\n";

    public boolean hasCNKProc() {
        return false;
    }

    public boolean hasDataCacheProc() {
        return true;
    }

    public void procExtractResults(CNKProc proc) {
        if (proc instanceof CNKProcAglm) {
            ((CNKProcAglm)proc).closeFile();
            if (this.m_xmlFileName == null) {
                return;
            }
            this.setNodeCache("model", null);
            File fil = new File(this.m_xmlFileName);
            if (!fil.exists()) {
                this.printlnDebug("aglm xml file " + this.m_xmlFileName + " doesn't exist");
                return;
            }
            long totalBytes = fil.length();
            this.printlnInformation("reading tree model xml file " + this.m_xmlFileName + " (" + totalBytes + " bytes)");
            XMLTree xt = null;
            try {
                xt = XMLTree.readFromFile(this.m_xmlFileName);
                this.m_xmlFileOK = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.printlnError("error reading aglm model xml file " + this.m_xmlFileName + ": " + ex);
            }
            this.setNodeCache("model", xt);
        }
    }

    public void procDelete(CNKProc proc) {
        if (proc instanceof CNKProcAglmFit && this.m_xmlFileName != null) {
            File fl = new File(this.m_xmlFileName);
            if (fl.exists()) {
                this.printlnDebug("deleting aglm model xml file " + this.m_xmlFileName);
                fl.delete();
            } else {
                this.printlnDebug("deleting aglm model xml file " + this.m_xmlFileName + " (non-existant)");
            }
        }
        if (proc != null) {
            proc.destroyCNKObj();
        }
    }

    public Vector getOutputSpecs() {
        XTProps props = this.getNodeProperties();
        XTMetaData md = this.getInputMetaData(0);
        String depVar = PredictEngineNode.getFirstDependentVar(props, md, XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG);
        Vector indepVars = PredictEngineNode.getIndependentVars(props, md);
        Vector outputSpecs = PredictEngineNode.getOutputSpecs(md, props, depVar, indepVars);
        return outputSpecs;
    }

    public String getModelType() {
        return MODEL_TYPE_GENERALLINEAR;
    }

    public String getModelAsString() throws Exception {
        XTProps props = this.getNodeProperties();
        XTMetaData md = this.getInputMetaData(0);
        String depCol = PredictEngineNode.getFirstDependentVar(props, md, XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG);
        String modelXML = this.getDataDictionaryAsString();
        int i = modelXML.indexOf("</IMML>", 0);
        if (i > 0) {
            modelXML = modelXML.substring(0, i - 1);
            modelXML = modelXML + "\n";
        }
        modelXML = modelXML + BEGIN_GENERALREGRESSIONMODEL;
        modelXML = depCol != null ? modelXML + "\"" + depCol + "\"" : modelXML + "\"?????\"";
        modelXML = modelXML + MODEL_TYPE + this.getModelType() + "/>\n";
        modelXML = modelXML + BEGIN_LINEAR_MODEL;
        modelXML = modelXML + this.getTermsAsString();
        modelXML = modelXML + END_LINEAR_MODEL;
        modelXML = modelXML + "</IMML>\n";
        return modelXML;
    }

    public String getDataDictionaryAsString() throws Exception {
        XTProps props = this.getNodeProperties();
        XTMetaData md = this.getInputMetaData(0);
        Vector varNames = PredictEngineNode.getIndependentVars(props, md);
        String depCol = PredictEngineNode.getFirstDependentVar(props, md, XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG);
        Vector allNames = varNames;
        allNames.add(depCol);
        String weights = props.getValue(WEIGHTED_COLUMN_ATTRIBUTE_TAG);
        if (weights.length() > 0 && weights.charAt(0) != ' ') {
            allNames.add(weights);
        }
        XTMetaData mdModel = md.selectiveClone(allNames);
        for (int i = 0; i < varNames.size(); ++i) {
            mdModel.setDataFieldRole((String)varNames.get(i), "independent");
        }
        mdModel.setDataFieldRole(depCol, "dependent");
        if (weights.length() > 0 && weights.charAt(0) != ' ') {
            mdModel.setDataFieldRole(weights, "weights");
        }
        return mdModel.writeToString();
    }

    public String getTermsAsString() throws Exception {
        XTProps props = this.getNodeProperties();
        XTMetaData md = this.getInputMetaData(0);
        Vector varNames = PredictEngineNode.getIndependentVars(props, md);
        String modelXML = "";
        for (int i = 0; i < varNames.size(); ++i) {
            modelXML = modelXML + BEGIN_TERM + "\"" + varNames.get(i) + "\">\n";
            modelXML = modelXML + TERMVAR_VALUE + "\"" + varNames.get(i) + "\"/>\n";
            modelXML = modelXML + END_TERM;
        }
        Vector interactionCol1 = props.getSubProperties("interactions");
        Vector interactionCol2 = props.getSubPropertyValues("interactions");
        if (interactionCol1.size() != interactionCol1.size()) {
            throw new Exception("internal error for specified interactions");
        }
        for (int i = 0; i < interactionCol1.size(); ++i) {
            modelXML = modelXML + BEGIN_TERM + "\"" + interactionCol1.get(i) + ":" + interactionCol2.get(i) + "\">\n";
            modelXML = modelXML + TERMVAR_VALUE + "\"" + interactionCol1.get(i) + "\"/>\n";
            modelXML = modelXML + TERMVAR_VALUE + "\"" + interactionCol2.get(i) + "\"/>\n";
            modelXML = modelXML + END_TERM;
        }
        modelXML = modelXML + INTERCEPT_VALUE;
        modelXML = props.getBoolean(INCLUDE_INTERCEPT_ATTRIBUTE_TAG, true) ? modelXML + "\"1\"/>\n" : modelXML + "\"0\"/>\n";
        String weights = props.getValue(WEIGHTED_COLUMN_ATTRIBUTE_TAG);
        if (weights.length() > 0 && weights.charAt(0) != ' ') {
            modelXML = modelXML + WEIGHTS_VALUE + "\"" + weights + "\"/>\n";
        }
        return modelXML;
    }

    public boolean isDataCacheProcOutputMetaDataComplete(int outputNum) {
        return true;
    }

    public boolean executeDataCacheProc() throws Exception {
        boolean ok = true;
        File tempFile = this.createWorkspaceTempFile("aglm", ".xml");
        this.m_xmlFileName = tempFile.getPath();
        String origText = (String)EngineMessageHandler.sendMessageToApp("getStatusText", new Object[0]);
        String str = origText + ": Building model...";
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{str});
        this.printlnVerbose("adaptive linear regression: creating model");
        CNKProcAglm proc1 = new CNKProcAglm();
        proc1.setFile(this.m_xmlFileName);
        this.m_xmlFileOK = false;
        proc1.setModel(this.getModelAsString());
        this.printlnVerbose("adaptive linear regression: creating model");
        ok = this.getNetworkManager().executeCNKProc(this.getNodeID(), proc1);
        this.procDelete(proc1);
        if (!ok || !this.m_xmlFileOK) {
            return false;
        }
        Vector outputSpecs = this.getOutputSpecs();
        if (outputSpecs.size() < 1) {
            return ok;
        }
        this.printlnVerbose("adaptive linear regression: creating CNKProcAglmFit");
        str = origText + ": Predicting...";
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{str});
        CNKProcAglmFit proc2 = new CNKProcAglmFit();
        this.printlnVerbose("adaptive linear regression: calling CNKProcAglmFit.setFile");
        proc2.setFile(this.m_xmlFileName);
        PredictEngineNode.defineOutputsFromSpecs(proc2, outputSpecs);
        this.printlnVerbose("adaptive linear regression: predicting from training data.");
        ok = this.getNetworkManager().executeCNKProc(this.getNodeID(), proc2);
        this.procDelete(proc2);
        this.m_modelString = null;
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{origText});
        return ok;
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        if (outputNum == 0) {
            return PredictEngineNode.calculateOutputMetaDataFromOutputSpecs(this.getOutputSpecs());
        }
        return null;
    }

    protected Vector getLmVarNames() {
        XTProps props = this.getNodeProperties();
        XTMetaData md = this.getInputMetaData(0);
        String depVar = PredictEngineNode.getFirstDependentVar(props, md, XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG);
        Vector indepVars = PredictEngineNode.getIndependentVars(props, md);
        Vector<String> allVars = new Vector<String>();
        allVars.add(depVar);
        allVars.addAll(indepVars);
        return allVars;
    }
}

