/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.GuiMessageHandler;
import com.insightful.miner.MinerApp;
import com.insightful.miner.WorksheetPropertiesManager;
import com.insightful.miner.XTNetwork;
import com.insightful.splus.SplusWinSessionImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class BatchManager {
    private static String m_lastBatchOutput = null;
    private static boolean m_lastBatchHasErrors = false;

    private BatchManager() {
    }

    public static String getLastBatchOutput() {
        return m_lastBatchOutput;
    }

    public static boolean getLastBatchHasErrors() {
        return m_lastBatchHasErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void batchRunIMinerWorksheet(String fileName, String wsdName, String logfile, boolean appendLog, String invalidateNodesString, String runToNodesString) throws Exception {
        System.setProperty("sprime.logfile", "false");
        MinerApp.init(false);
        int oldMessageSeverity = MinerApp.getMessageSeverity();
        int oldLogMessageSeverity = MinerApp.getLogMessageSeverity();
        MinerApp.setMessageSeverity(2);
        MinerApp.setLogMessageSeverity(0);
        try {
            Object obj;
            MinerApp.setBatchLogfile(logfile != null && logfile.length() > 0 ? logfile : null, appendLog);
            MinerApp.startSavingBatchOutput();
            MinerApp.outputText("Begin executing worksheet: " + fileName + "\n", 2, true);
            boolean licenseOK = false;
            String licenseError = "Error getting S-PLUS bd.run.iminer.worksheet (02I) license:\n";
            try {
                Method mt = SplusWinSessionImpl.class.getMethod("checkoutLicenseFeature", String.class);
                Object licenseVal = mt.invoke(null, "02I");
                String licenseString = (String)licenseVal;
                if (licenseString == null || licenseString.length() > 0) {
                    licenseError = licenseError + (licenseString == null ? "license error" : licenseString);
                } else {
                    licenseOK = true;
                }
            }
            catch (InvocationTargetException ex) {
                licenseError = licenseError + ex.getCause().toString();
            }
            catch (Throwable ex) {
                licenseError = licenseError + ex.toString();
            }
            if (!licenseOK) {
                MinerApp.outputText(licenseError + "\n", 4, true);
                m_lastBatchHasErrors = true;
                return;
            }
            XTNetwork net = XTNetwork.readXTNetworkFromFile(fileName);
            MinerApp.applyCommandLineParameters(net);
            String worksheetDirPath = WorksheetPropertiesManager.getWSDDirectoryFromProps(net.getWorksheetProperties());
            if (worksheetDirPath == null || worksheetDirPath.equals("")) {
                worksheetDirPath = MinerApp.getWorksheetDir(fileName);
            }
            if (wsdName != null && wsdName.length() > 0) {
                worksheetDirPath = wsdName;
            }
            if ((obj = GuiMessageHandler.sendMessageToEngine("", "", "createEngineNetworkManager", new Object[]{worksheetDirPath, "", Boolean.FALSE})) == null || obj instanceof Exception) {
                throw new Exception("error getting worksheet ID: " + obj);
            }
            String worksheetID = (String)obj;
            GuiMessageHandler.sendMessageToEngine(worksheetID, "", "saveGuiNetwork", new Object[]{net});
            Vector nodes = net.getFlatNodes();
            Vector nodesToInvalidate = BatchManager.getNodesFromString(invalidateNodesString, nodes);
            Vector nodesToRunTo = BatchManager.getNodesFromString(runToNodesString, nodes);
            Iterator nodeIter = nodesToInvalidate.iterator();
            while (nodeIter.hasNext()) {
                GuiMessageHandler.sendMessageToEngine(worksheetID, "", "invalidateNode", new Object[]{nodeIter.next()});
            }
            GuiMessageHandler.sendMessageToEngine(worksheetID, "", "runToHereInThisThread", new Object[]{nodesToRunTo});
            Object hasErrorsObject = GuiMessageHandler.sendMessageToEngine(worksheetID, "", "runHadErrors", null);
            m_lastBatchHasErrors = hasErrorsObject != null && hasErrorsObject instanceof Boolean ? (Boolean)hasErrorsObject : false;
            GuiMessageHandler.sendMessageToEngine("", "", "closeWorksheet", new Object[]{worksheetID});
            MinerApp.outputText("Finished executing worksheet: " + fileName + "\n", 2, true);
        }
        finally {
            MinerApp.setBatchLogfile(null, false);
            m_lastBatchOutput = MinerApp.stopSavingBatchOutput();
            MinerApp.setMessageSeverity(oldMessageSeverity);
            MinerApp.setLogMessageSeverity(oldLogMessageSeverity);
        }
    }

    public static Vector getNodesFromString(String propVal, List allNodes) {
        if (propVal.equalsIgnoreCase("none")) {
            return new Vector();
        }
        if (propVal.equalsIgnoreCase("all")) {
            return new Vector(allNodes);
        }
        Vector<String> nodes = new Vector<String>();
        String[] nodeStrings = propVal.split(",");
        for (int i = 0; i < nodeStrings.length; ++i) {
            String str;
            if (nodeStrings[i] == null || !allNodes.contains(str = nodeStrings[i].trim())) continue;
            nodes.add(str);
        }
        return nodes;
    }
}

