/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcJavaTransformExec;
import com.insightful.miner.ClassificationAssessmentEngineNode;
import com.insightful.miner.EngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.util.Vector;

public class ClassificationAgreementEngineNode
extends EngineNode
implements CNKProcJavaTransformExec {
    public static String CLASSIFICATION_AGREEMENT_CACHE = "agreement.cache";
    private int m_numInputs;
    private String[] m_observedDepColumnName = null;
    private int[] m_observedDepColumnNums = null;
    private int[] m_predictedColumnNums = null;
    private long[][][] m_counts = null;
    private String[] m_positiveLevelName = null;

    public boolean hasCNKProc() {
        return true;
    }

    public boolean hasDataCacheProc() {
        return false;
    }

    public CNKProc procCreate() {
        CNKProcJavaTransform proc = new CNKProcJavaTransform();
        proc.setExecObject(this);
        return proc;
    }

    public void procSetProperties(CNKProc proc) {
        try {
            this.m_numInputs = this.getNumInputs();
            this.m_observedDepColumnName = new String[this.m_numInputs];
            this.m_positiveLevelName = new String[this.m_numInputs];
            this.m_observedDepColumnNums = new int[this.m_numInputs];
            this.m_predictedColumnNums = new int[this.m_numInputs];
            this.m_counts = new long[this.m_numInputs][][];
            String[] path = new String[]{ClassificationAssessmentEngineNode.INPUTS_ATTRIBUTE_TAG, "", ""};
            XTProps props = this.getNodeProperties();
            Vector inputs = props.getSubProperties(ClassificationAssessmentEngineNode.INPUTS_ATTRIBUTE_TAG);
            for (int i = inputs.size(); i < this.m_numInputs; ++i) {
                inputs.add("NoData");
            }
            for (int inputNum = 0; inputNum < this.m_numInputs; ++inputNum) {
                String inputNodeName = this.getInputNodeName(inputNum);
                String inputNodeID = (String)inputs.get(inputNum);
                XTMetaData md = this.getInputMetaData(inputNum);
                path[1] = inputNodeID;
                path[2] = ClassificationAssessmentEngineNode.USE_ROLE_INFO_ATTRIBUTE_TAG;
                boolean useRoles = props.getBoolean(path, true);
                if (useRoles) {
                    Vector depColumns = md.getDataFieldsWithRole(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG);
                    if (depColumns == null || depColumns.size() == 0) {
                        this.printlnWarning(this.getNodeName() + ": the dependent column was not found in input from " + inputNodeName + ".");
                        this.m_observedDepColumnNums[inputNum] = -1;
                        continue;
                    }
                    this.m_observedDepColumnName[inputNum] = (String)depColumns.get(0);
                    this.m_predictedColumnNums[inputNum] = md.nameToOrdinal("PREDICT.class");
                } else {
                    path[2] = ClassificationAssessmentEngineNode.DEPENDENT_COLUMN_ATTRIBUTE_TAG;
                    this.m_observedDepColumnName[inputNum] = props.getValue(path);
                    path[2] = ClassificationAssessmentEngineNode.EVAL_COLUMN_ATTRIBUTE_TAG;
                    this.m_predictedColumnNums[inputNum] = md.nameToOrdinal(props.getValue(path));
                }
                Vector depLevels = md.getCategoricalDataFieldLevels(this.m_observedDepColumnName[inputNum]);
                this.m_observedDepColumnNums[inputNum] = md.nameToOrdinal(this.m_observedDepColumnName[inputNum]);
                if (this.m_observedDepColumnNums[inputNum] == -1) {
                    this.printlnWarning(this.getNodeName() + ": the dependent column was not found in input from " + inputNodeName + ".");
                    continue;
                }
                if (this.m_predictedColumnNums[inputNum] == -1) {
                    this.printlnWarning(this.getNodeName() + ": probability column not found in " + inputNodeName + ".");
                    continue;
                }
                int numLevels = depLevels.size();
                this.m_counts[inputNum] = new long[numLevels][numLevels];
                this.m_positiveLevelName[inputNum] = this.getPositiveLevelName(this.m_observedDepColumnName[inputNum], md, props, useRoles, inputNodeID);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String getPositiveLevelName(String depName, XTMetaData md, XTProps props, boolean useRoles, String inputNodeID) {
        Vector depLevels = md.getCategoricalDataFieldLevels(depName);
        String posLevel = null;
        for (int i = 0; i < depLevels.size(); ++i) {
            String level = (String)depLevels.get(i);
            if (i == 0) {
                posLevel = level;
                continue;
            }
            if (posLevel.compareTo(level) >= 0) continue;
            posLevel = level;
        }
        if (useRoles) {
            String possibleColName = "Pr(" + posLevel + ")";
            if (md.nameToOrdinal("PREDICT.prob") == -1 && md.nameToOrdinal(possibleColName) == -1) {
                Vector predVars = md.getDataFieldsWithRole(XTMetaData.PREDICTION_ROLE_ATTRIBUTE_TAG);
                for (int i = 0; i < predVars.size(); ++i) {
                    String predCol = (String)predVars.get(i);
                    if (!predCol.startsWith("Pr(")) continue;
                    posLevel = predCol.substring(3, predCol.length() - 1);
                    break;
                }
            }
        } else {
            String[] path = new String[]{ClassificationAssessmentEngineNode.INPUTS_ATTRIBUTE_TAG, inputNodeID, ClassificationAssessmentEngineNode.EVAL_COLUMN_ATTRIBUTE_TAG};
            String pred = props.getValue(path);
            if (pred.startsWith("Pr(")) {
                posLevel = pred.substring(3, pred.length() - 1);
            }
        }
        return posLevel;
    }

    public void execute(CNKProcJavaTransform proc) {
        boolean results = false;
        for (int inputNum = 0; inputNum < this.m_numInputs; ++inputNum) {
            if (this.m_predictedColumnNums[inputNum] == -1 || this.m_observedDepColumnNums[inputNum] == -1) continue;
            results = true;
            double[] observed = proc.getChunkInputColumnData(inputNum, this.m_observedDepColumnNums[inputNum]);
            double[] predicted = proc.getChunkInputColumnData(inputNum, this.m_predictedColumnNums[inputNum]);
            int totalRows = proc.getChunkInputRows(inputNum);
            for (int rowNum = 0; rowNum < totalRows; ++rowNum) {
                double obs = observed[rowNum];
                double pred = predicted[rowNum];
                if (Double.isNaN(obs) || Double.isNaN(pred)) continue;
                long[] lArray = this.m_counts[inputNum][(int)obs];
                int n = (int)pred;
                lArray[n] = lArray[n] + 1L;
            }
        }
        if (proc.getChunkInputPosition(0) == 0L && !results) {
            proc.setError("no classification data was found in input.");
        }
    }

    public void procExtractResults(CNKProc proc) {
        try {
            XTProps props = new XTProps();
            for (int inputNum = 0; inputNum < this.m_numInputs; ++inputNum) {
                String inputNumStr = ClassificationAssessmentEngineNode.INPUT_PREFIX_TAG + Integer.toString(inputNum);
                if (this.m_predictedColumnNums[inputNum] == -1 || this.m_observedDepColumnNums[inputNum] == -1) {
                    props.set(inputNumStr, "");
                    continue;
                }
                String[] path = new String[4];
                int[] levelPath = new int[2];
                int numCounts = this.m_counts[inputNum].length * this.m_counts[inputNum].length;
                path[0] = inputNumStr;
                path[1] = this.m_observedDepColumnName[inputNum];
                props.set(inputNumStr, ClassificationAssessmentEngineNode.TITLE_ATTRIBUTE_TAG, this.getInputNodeName(inputNum));
                props.set(path[0], path[1], this.m_positiveLevelName[inputNum]);
                for (int count = 0; count < numCounts; ++count) {
                    path[2] = Integer.toString(levelPath[0]);
                    path[3] = Integer.toString(levelPath[1]);
                    props.set(path, Long.toString(this.m_counts[inputNum][levelPath[0]][levelPath[1]]));
                    levelPath[1] = levelPath[1] + 1;
                    if (levelPath[1] % this.m_counts[inputNum].length != 0) continue;
                    levelPath[1] = 0;
                    levelPath[0] = levelPath[0] + 1;
                }
            }
            this.setNodeCache(CLASSIFICATION_AGREEMENT_CACHE, props);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

