/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ActivityNodeArea;
import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.DragAndDropTree;
import com.insightful.miner.IconableTreeCellRenderer;
import com.insightful.miner.LibraryTreeNode;
import com.insightful.miner.WorksheetDocument;
import com.insightful.miner.WorksheetView;
import com.insightful.miner.dndtree.Copyable;
import com.insightful.miner.dndtree.DndId;
import com.insightful.miner.dndtree.DragOverData;
import com.insightful.miner.dndtree.Instrumenter;
import com.insightful.miner.dndtree.NodeFactory;
import com.insightful.miner.dndtree.SubTreeNode;
import com.insightful.miner.dndtree.TreeDragGestureListener;
import com.insightful.miner.dndtree.TreeDropTargetListener;
import com.insightful.miner.dndtree.UndoableInfoEdit;
import com.insightful.miner.dndtree.VetoException;
import com.insightful.miner.dndtree.VetoableTreeStructureChangeEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class DnDTreeUtility
extends Instrumenter
implements NodeFactory {
    private DnDTreeUtility() {
    }

    public static DnDTreeUtility createUtility(DragAndDropTree tree) {
        DnDTreeUtility retval = new DnDTreeUtility();
        retval.instrument(tree, true);
        retval.setNodeFactory(retval);
        return retval;
    }

    private DragAndDropTree.InvisibleNode createNode(TreeNode node, Object obj, boolean parent, boolean copy) {
        DragAndDropTree.InvisibleNode iNode = new DragAndDropTree.InvisibleNode(obj, obj instanceof DragAndDropTree.LibraryFolder, true);
        return iNode;
    }

    public TreeNode cloneNode(TreeNode node) {
        DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)node;
        return this.createNode(node, dmtn.getUserObject(), false, true);
    }

    public TreeNode createNode(TreeNode parent) {
        return this.createNode(parent, parent, true, true);
    }

    public TreeNode createNode(Object obj) {
        return this.createNode(null, obj, false, false);
    }

    public TreeNode createNode(String title, String contents) {
        return this.createNode(null, contents, false, false);
    }

    public Transferable createTransferable(Object node, DndId dndId) throws RuntimeException {
        if (node instanceof DragAndDropTree.InvisibleNode) {
            return DragAndDropTree.convertNodeToTransferable((DragAndDropTree.InvisibleNode)node);
        }
        return null;
    }

    public Transferable createTransferable(Object[] nodes, DndId dndId) throws RuntimeException {
        if (nodes.length > 0 && nodes[0] instanceof DragAndDropTree.InvisibleNode) {
            return DragAndDropTree.convertNodeToTransferable((DragAndDropTree.InvisibleNode)nodes[0]);
        }
        return null;
    }

    protected void configureCellEditor() {
        ((DragAndDropTree.DnDTreeCellEditor)this.m_tree.getCellEditor()).addCellEditorListener(new CellEditorListener(){

            public void editingStopped(ChangeEvent e) {
                DnDTreeUtility.this.getFocusForTree();
            }

            public void editingCanceled(ChangeEvent e) {
                DnDTreeUtility.this.getFocusForTree();
            }
        });
    }

    public void setUseDefaultDnd(boolean b) {
        if (b) {
            DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.m_tree, 3, new TreeDragGestureListener(this.m_tree, this));
            DropTarget target = new DropTarget(this.m_tree, new DnDTreeDropTargetListener(this.m_tree, this));
            this.m_tree.setCellRenderer(new DnDTreeCellRenderer());
        }
    }

    public void fireNodeRename(VetoableTreeStructureChangeEvent e) throws VetoException {
        super.fireNodeRename(e);
    }

    public void renameNode(DefaultTreeModel model, DefaultMutableTreeNode node, String newValue, String oldValue) throws VetoException {
        this.m_undoSupport.postEdit(this.doRenameNode(model, node, newValue, oldValue));
    }

    protected void setUseDefaultCellEditor(boolean b) {
    }

    public void copyNode() {
        TreePath[] paths = this.getSortedSelection(true);
        if (paths == null || paths.length == 0) {
            return;
        }
        paths = DnDTreeUtility.reduceSelection(paths);
        Vector<DnDSubTreeNode> copiedNodes = new Vector<DnDSubTreeNode>(paths.length);
        for (int i = 0; i < paths.length; ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
            copiedNodes.addElement(new DnDSubTreeNode(node, true));
        }
        this.m_arrCopiedNodes = new DnDSubTreeNode[copiedNodes.size()];
        copiedNodes.copyInto(this.m_arrCopiedNodes);
        this.updateActionObjects();
    }

    protected UndoableEdit doMoveNode(DefaultMutableTreeNode orig, DefaultMutableTreeNode dst, int idst) throws VetoException {
        this.fireNodeMove(new VetoableTreeStructureChangeEvent(this, orig, orig.getParent(), orig.getParent().getIndex(orig), dst, idst));
        DnDUndoableInfoEdit unedit = new DnDUndoableInfoEdit((DefaultTreeModel)this.m_tree.getModel(), 3, (DefaultMutableTreeNode)orig.getParent(), orig.getParent().getIndex(orig), dst, idst, orig, false);
        ((DefaultTreeModel)this.m_tree.getModel()).removeNodeFromParent(orig);
        ((DefaultTreeModel)this.m_tree.getModel()).insertNodeInto(orig, dst, idst);
        return unedit;
    }

    protected UndoableEdit doAddNode(DefaultMutableTreeNode parent, DefaultMutableTreeNode node, int index) throws VetoException {
        this.fireNodeCreation(new VetoableTreeStructureChangeEvent(this, node, null, 0, parent, index));
        DnDUndoableInfoEdit unedit = new DnDUndoableInfoEdit((DefaultTreeModel)this.m_tree.getModel(), 1, null, 0, parent, index, node, true);
        ((DefaultTreeModel)this.m_tree.getModel()).insertNodeInto(node, parent, index);
        return unedit;
    }

    protected UndoableEdit doDeleteNode(DefaultMutableTreeNode node) throws VetoException {
        this.fireNodeDeletion(new VetoableTreeStructureChangeEvent(this, node, node.getParent(), node.getParent().getIndex(node), null, 0));
        DnDUndoableInfoEdit unedit = new DnDUndoableInfoEdit((DefaultTreeModel)this.m_tree.getModel(), 2, (DefaultMutableTreeNode)node.getParent(), node.getParent().getIndex(node), null, 0, node, true);
        ((DefaultTreeModel)this.m_tree.getModel()).removeNodeFromParent(node);
        return unedit;
    }

    protected UndoableEdit doRenameNode(DefaultTreeModel model, DefaultMutableTreeNode node, String newValue, String oldValue) throws VetoException {
        this.fireNodeRename(new VetoableTreeStructureChangeEvent(this, node, oldValue, newValue));
        DnDUndoableRenameEdit unedit = new DnDUndoableRenameEdit(model, node, oldValue, newValue);
        return unedit;
    }

    public class DnDUndoableRenameEdit
    extends AbstractUndoableEdit {
        protected String m_oldValue;
        protected String m_newValue;
        protected DefaultMutableTreeNode m_node;
        protected DefaultTreeModel m_model;

        public DnDUndoableRenameEdit(DefaultTreeModel model, DefaultMutableTreeNode node, String oldValue, String newValue) {
            this.m_model = model;
            this.m_node = node;
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        public void die() {
            super.die();
        }

        public String getPresentationName() {
            return "Rename Node" + this.m_newValue;
        }

        protected void rename(DefaultMutableTreeNode node, String oldValue) {
            ((LibraryTreeNode)node.getUserObject()).setLabel(oldValue);
            this.m_model.nodeChanged(node);
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.rename(this.m_node, this.m_oldValue);
        }

        public void redo() throws CannotUndoException {
            super.redo();
            this.rename(this.m_node, this.m_newValue);
        }
    }

    private static class DnDSubTreeNode
    extends SubTreeNode {
        public DnDSubTreeNode(DefaultMutableTreeNode node, boolean deep) {
            super(node, deep);
        }

        public DefaultMutableTreeNode createNode() {
            Object new_contents = this.getContents() instanceof Copyable ? ((Copyable)this.getContents()).copy() : this.getContents();
            DragAndDropTree.InvisibleNode retval = new DragAndDropTree.InvisibleNode(new_contents, new_contents instanceof DragAndDropTree.LibraryFolder, true);
            if (this.m_arrChildren != null) {
                for (int i = 0; i < this.m_arrChildren.length; ++i) {
                    retval.insert(this.m_arrChildren[i].createNode(), i);
                }
            }
            return retval;
        }
    }

    private class DnDUndoableInfoEdit
    extends UndoableInfoEdit {
        public DnDUndoableInfoEdit(DefaultTreeModel model, short type, DefaultMutableTreeNode src, int isrc, DefaultMutableTreeNode dst, int idst, DefaultMutableTreeNode node, boolean deep) {
            super(model, type, src, isrc, dst, idst, node, deep);
        }

        protected void makeTree(DefaultMutableTreeNode node, boolean deep) {
            this.m_tree = new DnDSubTreeNode(node, deep);
        }
    }

    private class DnDTreeCellRenderer
    extends IconableTreeCellRenderer {
        private int m_nDndEffect;

        private DnDTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.m_nDndEffect = value instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)value).getUserObject() instanceof DragOverData ? ((DragOverData)((DefaultMutableTreeNode)value).getUserObject()).getCurrentEffect() : 0;
            Component comp = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (this.m_nDndEffect == 1) {
                comp.setBackground(Color.GRAY);
            }
            if (!((DragAndDropTree)tree).isDropable()) {
                this.m_nDndEffect = 0;
            }
            return comp;
        }

        public void paint(Graphics g) {
            super.paint(g);
            Rectangle bounds = g.getClipBounds();
            switch (this.m_nDndEffect) {
                case 3: {
                    g.fillRect(0, bounds.y + bounds.height - 2, bounds.width, 2);
                    break;
                }
                case 2: {
                    g.fillRect(0, 0, bounds.width, 2);
                    break;
                }
                case 1: {
                    g.fillRect(0, 0, 2, bounds.height);
                    break;
                }
            }
        }
    }

    private class DnDTreeDropTargetListener
    extends TreeDropTargetListener {
        private DataFlavor iDF;
        private DataFlavor aDF;

        public DnDTreeDropTargetListener(JTree tree, Instrumenter inst) {
            super(tree, inst);
            this.iDF = DragAndDropTree.InvisibleNode.nodeFlavor;
            this.aDF = ActivityNodeArea.nodeFlavor;
            this.m_timerExpand = new Timer(500, new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    if (DnDTreeDropTargetListener.this.m_pathToExpand != null && !DnDTreeDropTargetListener.this.m_tree.isExpanded(DnDTreeDropTargetListener.this.m_pathToExpand)) {
                        DnDTreeDropTargetListener.this.m_tree.expandPath(DnDTreeDropTargetListener.this.m_pathToExpand);
                    }
                }
            });
        }

        protected boolean checkFlavourSupported(DataFlavor[] flavours) {
            for (int i = 0; i < flavours.length; ++i) {
                if (!WorksheetView.isIMinerDnDFlavor(flavours)) continue;
                return true;
            }
            return super.checkFlavourSupported(flavours);
        }

        public synchronized void drop(DropTargetDropEvent dropDropEvent) {
            try {
                Object obj;
                int pInd;
                DragAndDropTree tree = (DragAndDropTree)this.m_tree;
                if (!tree.isDropable()) {
                    dropDropEvent.rejectDrop();
                    return;
                }
                Transferable transfer = dropDropEvent.getTransferable();
                int dropAction = dropDropEvent.getDropAction();
                Point loc = dropDropEvent.getLocation();
                DragAndDropTree.InvisibleNode iNode = null;
                if (transfer.isDataFlavorSupported(this.iDF)) {
                    iNode = (DragAndDropTree.InvisibleNode)transfer.getTransferData(this.iDF);
                } else if (transfer.isDataFlavorSupported(WorksheetDocument.getStandardDataFlavor()) || transfer.isDataFlavorSupported(WorksheetDocument.getLocalJVMDataFlavor())) {
                    BaseNodeArea area = BaseNodeArea.convertTransferToArea(transfer);
                    if (area == null) {
                        dropDropEvent.rejectDrop();
                        return;
                    }
                    iNode = new DragAndDropTree.InvisibleNode(area, false, true);
                }
                DefaultMutableTreeNode parentNode = null;
                DefaultMutableTreeNode targetNode = null;
                TreePath targetpath = this.m_tree.getClosestPathForLocation(loc.x, loc.y);
                if (targetpath != null) {
                    boolean isNotFolder;
                    targetNode = parentNode = (DefaultMutableTreeNode)targetpath.getLastPathComponent();
                    pInd = parentNode.getParent() != null ? parentNode.getParent().getIndex(parentNode) : 0;
                    boolean bl = isNotFolder = !(parentNode.getUserObject() instanceof DragAndDropTree.LibraryFolder);
                    if (this.m_nLastDropEffect != 1 || isNotFolder) {
                        parentNode = (DefaultMutableTreeNode)parentNode.getParent();
                        if (this.m_nLastDropEffect == 3 || isNotFolder) {
                            ++pInd;
                        }
                    } else {
                        pInd = 0;
                    }
                } else {
                    parentNode = (DefaultMutableTreeNode)this.m_tree.getModel().getRoot();
                    pInd = 0;
                }
                if (parentNode != null && iNode != null) {
                    TreeModel tm = tree.getModel();
                    DefaultMutableTreeNode[] iNodes = new DragAndDropTree.InvisibleNode[]{iNode};
                    this.m_instrument.addNodes(parentNode, iNodes, pInd);
                    TreePath tp = new TreePath(iNode.getPath()).getParentPath();
                    if (!tree.isExpanded(tp)) {
                        tree.expandPath(tp);
                    }
                    dropDropEvent.acceptDrop(dropAction);
                } else {
                    dropDropEvent.rejectDrop();
                }
                if (targetNode != null && (obj = targetNode.getUserObject()) instanceof DragOverData) {
                    ((DragOverData)obj).setCurrentEffect(0);
                }
                this.m_pathToExpand = null;
            }
            catch (Exception e) {
                dropDropEvent.rejectDrop();
                e.printStackTrace();
            }
        }
    }
}

