/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.DynamicGridBagConstraints;
import com.insightful.miner.DynamicGridBagLayoutInfo;
import com.insightful.miner.IntegerVector;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class DynamicGridBagLayout
implements LayoutManager2,
Serializable {
    protected static final int MAXGRIDSIZE = 512;
    protected static final int MINSIZE = 1;
    protected static final int PREFERREDSIZE = 2;
    protected Hashtable comptable = new Hashtable();
    protected DynamicGridBagConstraints defaultConstraints = new DynamicGridBagConstraints();
    protected DynamicGridBagLayoutInfo layoutInfo;
    public int[] columnWidths;
    public int[] rowHeights;
    public double[] columnWeights;
    public double[] rowWeights;
    transient boolean rightToLeft = false;

    public void setConstraints(Component comp, DynamicGridBagConstraints constraints) {
        this.comptable.put(comp, constraints.clone());
    }

    public DynamicGridBagConstraints getConstraints(Component comp) {
        DynamicGridBagConstraints constraints = (DynamicGridBagConstraints)this.comptable.get(comp);
        if (constraints == null) {
            this.setConstraints(comp, this.defaultConstraints);
            constraints = (DynamicGridBagConstraints)this.comptable.get(comp);
        }
        return (DynamicGridBagConstraints)constraints.clone();
    }

    protected DynamicGridBagConstraints lookupConstraints(Component comp) {
        DynamicGridBagConstraints constraints = (DynamicGridBagConstraints)this.comptable.get(comp);
        if (constraints == null) {
            this.setConstraints(comp, this.defaultConstraints);
            constraints = (DynamicGridBagConstraints)this.comptable.get(comp);
        }
        return constraints;
    }

    private void removeConstraints(Component comp) {
        this.comptable.remove(comp);
    }

    public Point getLayoutOrigin() {
        Point origin = new Point(0, 0);
        if (this.layoutInfo != null) {
            origin.x = this.layoutInfo.startx;
            origin.y = this.layoutInfo.starty;
        }
        return origin;
    }

    public int[][] getLayoutDimensions() {
        if (this.layoutInfo == null) {
            return new int[2][0];
        }
        int[][] dim = new int[][]{new int[this.layoutInfo.width], new int[this.layoutInfo.height]};
        System.arraycopy(this.layoutInfo.minWidth, 0, dim[0], 0, this.layoutInfo.width);
        System.arraycopy(this.layoutInfo.minHeight, 0, dim[1], 0, this.layoutInfo.height);
        return dim;
    }

    public double[][] getLayoutWeights() {
        if (this.layoutInfo == null) {
            return new double[2][0];
        }
        double[][] weights = new double[][]{new double[this.layoutInfo.width], new double[this.layoutInfo.height]};
        System.arraycopy(this.layoutInfo.weightX, 0, weights[0], 0, this.layoutInfo.width);
        System.arraycopy(this.layoutInfo.weightY, 0, weights[1], 0, this.layoutInfo.height);
        return weights;
    }

    public Point location(int x, int y) {
        int i;
        Point loc = new Point(0, 0);
        if (this.layoutInfo == null) {
            return loc;
        }
        int d = this.layoutInfo.startx;
        if (!this.rightToLeft) {
            for (i = 0; i < this.layoutInfo.width && (d += this.getIntegerVal(this.layoutInfo.minWidth, i)) <= x; ++i) {
            }
        } else {
            for (i = this.layoutInfo.width - 1; i >= 0 && d <= x; d += this.getIntegerVal(this.layoutInfo.minWidth, i), --i) {
            }
            ++i;
        }
        loc.x = i;
        d = this.layoutInfo.starty;
        for (i = 0; i < this.layoutInfo.height && (d += this.getIntegerVal(this.layoutInfo.minHeight, i)) <= y; ++i) {
        }
        loc.y = i;
        return loc;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints instanceof DynamicGridBagConstraints) {
            this.setConstraints(comp, (DynamicGridBagConstraints)constraints);
        } else if (constraints != null) {
            throw new IllegalArgumentException("cannot add to layout: constraints must be a GridBagConstraint");
        }
    }

    public void removeLayoutComponent(Component comp) {
        this.removeConstraints(comp);
    }

    public Dimension preferredLayoutSize(Container parent) {
        DynamicGridBagLayoutInfo info = this.getLayoutInfo(parent, 2);
        return this.getMinSize(parent, info);
    }

    public Dimension minimumLayoutSize(Container parent) {
        DynamicGridBagLayoutInfo info = this.getLayoutInfo(parent, 1);
        return this.getMinSize(parent, info);
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }

    public void layoutContainer(Container parent) {
        this.arrangeGrid(parent);
    }

    public String toString() {
        return this.getClass().getName();
    }

    protected DynamicGridBagLayoutInfo getLayoutInfo(Container parent, int sizeflag) {
        return this.GetLayoutInfo(parent, sizeflag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DynamicGridBagLayoutInfo GetLayoutInfo(Container parent, int sizeflag) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int py;
            int i;
            int px;
            int curHeight;
            int curWidth;
            int curY;
            int curX;
            DynamicGridBagConstraints constraints;
            Component comp;
            int compindex;
            DynamicGridBagLayoutInfo r = new DynamicGridBagLayoutInfo();
            Component[] components = parent.getComponents();
            r.height = 0;
            r.width = 0;
            int curCol = -1;
            int curRow = -1;
            IntegerVector xMax = new IntegerVector();
            IntegerVector yMax = new IntegerVector();
            for (compindex = 0; compindex < components.length; ++compindex) {
                comp = components[compindex];
                if (!comp.isVisible()) continue;
                constraints = this.lookupConstraints(comp);
                curX = constraints.gridx;
                curY = constraints.gridy;
                curWidth = constraints.gridwidth;
                if (curWidth <= 0) {
                    curWidth = 1;
                }
                if ((curHeight = constraints.gridheight) <= 0) {
                    curHeight = 1;
                }
                if (curX < 0 && curY < 0) {
                    if (curRow >= 0) {
                        curY = curRow;
                    } else if (curCol >= 0) {
                        curX = curCol;
                    } else {
                        curY = 0;
                    }
                }
                if (curX < 0) {
                    px = 0;
                    for (i = curY; i < curY + curHeight; ++i) {
                        px = Math.max(px, this.getIntegerVal(xMax, i));
                    }
                    if ((curX = px - curX - 1) < 0) {
                        curX = 0;
                    }
                } else if (curY < 0) {
                    py = 0;
                    for (i = curX; i < curX + curWidth; ++i) {
                        py = Math.max(py, this.getIntegerVal(yMax, i));
                    }
                    if ((curY = py - curY - 1) < 0) {
                        curY = 0;
                    }
                }
                px = curX + curWidth;
                while (r.width < px) {
                    ++r.width;
                }
                py = curY + curHeight;
                while (r.height < py) {
                    ++r.height;
                }
                for (i = curX; i < curX + curWidth; ++i) {
                    this.setVectorVal((Vector)yMax, i, py);
                }
                for (i = curY; i < curY + curHeight; ++i) {
                    this.setVectorVal((Vector)xMax, i, px);
                }
                Dimension d = sizeflag == 2 ? comp.getPreferredSize() : comp.getMinimumSize();
                constraints.minWidth = d.width;
                constraints.minHeight = d.height;
                if (constraints.gridheight == 0 && constraints.gridwidth == 0) {
                    curCol = -1;
                    curRow = -1;
                }
                if (constraints.gridheight == 0 && curRow < 0) {
                    curCol = curX + curWidth;
                    continue;
                }
                if (constraints.gridwidth != 0 || curCol >= 0) continue;
                curRow = curY + curHeight;
            }
            if (this.columnWidths != null && r.width < this.columnWidths.length) {
                r.width = this.columnWidths.length;
            }
            if (this.rowHeights != null && r.height < this.rowHeights.length) {
                r.height = this.rowHeights.length;
            }
            curCol = -1;
            curRow = -1;
            xMax = new IntegerVector();
            yMax = new IntegerVector();
            for (compindex = 0; compindex < components.length; ++compindex) {
                comp = components[compindex];
                if (!comp.isVisible()) continue;
                constraints = this.lookupConstraints(comp);
                curX = constraints.gridx;
                curY = constraints.gridy;
                curWidth = constraints.gridwidth;
                curHeight = constraints.gridheight;
                if (curX < 0 && curY < 0) {
                    if (curRow >= 0) {
                        curY = curRow;
                    } else if (curCol >= 0) {
                        curX = curCol;
                    } else {
                        curY = 0;
                    }
                }
                if (curX < 0) {
                    if (curHeight <= 0 && (curHeight += r.height - curY) < 1) {
                        curHeight = 1;
                    }
                    px = 0;
                    for (i = curY; i < curY + curHeight; ++i) {
                        px = Math.max(px, this.getIntegerVal(xMax, i));
                    }
                    if ((curX = px - curX - 1) < 0) {
                        curX = 0;
                    }
                } else if (curY < 0) {
                    if (curWidth <= 0 && (curWidth += r.width - curX) < 1) {
                        curWidth = 1;
                    }
                    py = 0;
                    for (i = curX; i < curX + curWidth; ++i) {
                        py = Math.max(py, this.getIntegerVal(yMax, i));
                    }
                    if ((curY = py - curY - 1) < 0) {
                        curY = 0;
                    }
                }
                if (curWidth <= 0 && (curWidth += r.width - curX) < 1) {
                    curWidth = 1;
                }
                if (curHeight <= 0 && (curHeight += r.height - curY) < 1) {
                    curHeight = 1;
                }
                px = curX + curWidth;
                py = curY + curHeight;
                for (i = curX; i < curX + curWidth; ++i) {
                    this.setVectorVal((Vector)yMax, i, py);
                }
                for (i = curY; i < curY + curHeight; ++i) {
                    this.setVectorVal((Vector)xMax, i, px);
                }
                if (constraints.gridheight == 0 && constraints.gridwidth == 0) {
                    curCol = -1;
                    curRow = -1;
                }
                if (constraints.gridheight == 0 && curRow < 0) {
                    curCol = curX + curWidth;
                } else if (constraints.gridwidth == 0 && curCol < 0) {
                    curRow = curY + curHeight;
                }
                constraints.tempX = curX;
                constraints.tempY = curY;
                constraints.tempWidth = curWidth;
                constraints.tempHeight = curHeight;
            }
            if (this.columnWidths != null) {
                System.arraycopy(this.columnWidths, 0, r.minWidth, 0, this.columnWidths.length);
            }
            if (this.rowHeights != null) {
                System.arraycopy(this.rowHeights, 0, r.minHeight, 0, this.rowHeights.length);
            }
            if (this.columnWeights != null) {
                System.arraycopy(this.columnWeights, 0, r.weightX, 0, this.columnWeights.length);
            }
            if (this.rowWeights != null) {
                System.arraycopy(this.rowWeights, 0, r.weightY, 0, this.rowWeights.length);
            }
            int nextSize = Integer.MAX_VALUE;
            i = 1;
            while (i != Integer.MAX_VALUE) {
                for (compindex = 0; compindex < components.length; ++compindex) {
                    int pixels_diff;
                    double wt;
                    double weight;
                    int k;
                    double weight_diff;
                    comp = components[compindex];
                    if (!comp.isVisible()) continue;
                    constraints = this.lookupConstraints(comp);
                    if (constraints.tempWidth == i) {
                        px = constraints.tempX + constraints.tempWidth;
                        weight_diff = constraints.weightx;
                        for (k = constraints.tempX; k < px; ++k) {
                            weight_diff -= this.getDoubleVal(r.weightX, k);
                        }
                        if (weight_diff > 0.0) {
                            weight = 0.0;
                            for (k = constraints.tempX; k < px; ++k) {
                                weight += this.getDoubleVal(r.weightX, k);
                            }
                            for (k = constraints.tempX; weight > 0.0 && k < px; weight -= wt, ++k) {
                                wt = this.getDoubleVal(r.weightX, k);
                                double dx = wt * weight_diff / weight;
                                this.addVectorVal((Vector)r.weightX, k, dx);
                                weight_diff -= dx;
                            }
                            this.addVectorVal((Vector)r.weightX, px - 1, weight_diff);
                        }
                        pixels_diff = constraints.minWidth + constraints.ipadx + constraints.insets.left + constraints.insets.right;
                        for (k = constraints.tempX; k < px; ++k) {
                            pixels_diff -= this.getIntegerVal(r.minWidth, k);
                        }
                        if (pixels_diff > 0) {
                            weight = 0.0;
                            for (k = constraints.tempX; k < px; ++k) {
                                weight += this.getDoubleVal(r.weightX, k);
                            }
                            for (k = constraints.tempX; weight > 0.0 && k < px; weight -= wt, ++k) {
                                wt = this.getDoubleVal(r.weightX, k);
                                int dx = (int)(wt * (double)pixels_diff / weight);
                                this.addVectorVal((Vector)r.minWidth, k, dx);
                                pixels_diff -= dx;
                            }
                            this.addVectorVal((Vector)r.minWidth, px - 1, pixels_diff);
                        }
                    } else if (constraints.tempWidth > i && constraints.tempWidth < nextSize) {
                        nextSize = constraints.tempWidth;
                    }
                    if (constraints.tempHeight == i) {
                        py = constraints.tempY + constraints.tempHeight;
                        weight_diff = constraints.weighty;
                        for (k = constraints.tempY; k < py; ++k) {
                            weight_diff -= this.getDoubleVal(r.weightY, k);
                        }
                        if (weight_diff > 0.0) {
                            weight = 0.0;
                            for (k = constraints.tempY; k < py; ++k) {
                                weight += this.getDoubleVal(r.weightY, k);
                            }
                            for (k = constraints.tempY; weight > 0.0 && k < py; weight -= wt, ++k) {
                                wt = this.getDoubleVal(r.weightY, k);
                                double dy = wt * weight_diff / weight;
                                this.addVectorVal((Vector)r.weightY, k, dy);
                                weight_diff -= dy;
                            }
                            this.addVectorVal((Vector)r.weightY, py - 1, weight_diff);
                        }
                        pixels_diff = constraints.minHeight + constraints.ipady + constraints.insets.top + constraints.insets.bottom;
                        for (k = constraints.tempY; k < py; ++k) {
                            pixels_diff -= this.getIntegerVal(r.minHeight, k);
                        }
                        if (pixels_diff <= 0) continue;
                        weight = 0.0;
                        for (k = constraints.tempY; k < py; ++k) {
                            weight += this.getDoubleVal(r.weightY, k);
                        }
                        for (k = constraints.tempY; weight > 0.0 && k < py; weight -= wt, ++k) {
                            wt = this.getDoubleVal(r.weightY, k);
                            int dy = (int)(wt * (double)pixels_diff / weight);
                            this.addVectorVal((Vector)r.minHeight, k, dy);
                            pixels_diff -= dy;
                        }
                        this.addVectorVal((Vector)r.minHeight, py - 1, pixels_diff);
                        continue;
                    }
                    if (constraints.tempHeight <= i || constraints.tempHeight >= nextSize) continue;
                    nextSize = constraints.tempHeight;
                }
                i = nextSize;
                nextSize = Integer.MAX_VALUE;
            }
            return r;
        }
    }

    protected void adjustForGravity(DynamicGridBagConstraints constraints, Rectangle r) {
        this.AdjustForGravity(constraints, r);
    }

    protected void AdjustForGravity(DynamicGridBagConstraints constraints, Rectangle r) {
        r.x = !this.rightToLeft ? (r.x += constraints.insets.left) : (r.x -= r.width - constraints.insets.right);
        r.width -= constraints.insets.left + constraints.insets.right;
        r.y += constraints.insets.top;
        r.height -= constraints.insets.top + constraints.insets.bottom;
        int diffx = 0;
        if (constraints.fill != 2 && constraints.fill != 1 && r.width > constraints.minWidth + constraints.ipadx) {
            diffx = r.width - (constraints.minWidth + constraints.ipadx);
            r.width = constraints.minWidth + constraints.ipadx;
        }
        int diffy = 0;
        if (constraints.fill != 3 && constraints.fill != 1 && r.height > constraints.minHeight + constraints.ipady) {
            diffy = r.height - (constraints.minHeight + constraints.ipady);
            r.height = constraints.minHeight + constraints.ipady;
        }
        switch (constraints.anchor) {
            case 10: {
                r.x += diffx / 2;
                r.y += diffy / 2;
                break;
            }
            case 11: 
            case 19: {
                r.x += diffx / 2;
                break;
            }
            case 12: {
                r.x += diffx;
                break;
            }
            case 13: {
                r.x += diffx;
                r.y += diffy / 2;
                break;
            }
            case 14: {
                r.x += diffx;
                r.y += diffy;
                break;
            }
            case 15: 
            case 20: {
                r.x += diffx / 2;
                r.y += diffy;
                break;
            }
            case 16: {
                r.y += diffy;
                break;
            }
            case 17: {
                r.y += diffy / 2;
                break;
            }
            case 18: {
                break;
            }
            case 21: {
                if (this.rightToLeft) {
                    r.x += diffx;
                }
                r.y += diffy / 2;
                break;
            }
            case 22: {
                if (!this.rightToLeft) {
                    r.x += diffx;
                }
                r.y += diffy / 2;
                break;
            }
            case 23: {
                if (!this.rightToLeft) break;
                r.x += diffx;
                break;
            }
            case 24: {
                if (this.rightToLeft) break;
                r.x += diffx;
                break;
            }
            case 25: {
                if (this.rightToLeft) {
                    r.x += diffx;
                }
                r.y += diffy;
                break;
            }
            case 26: {
                if (!this.rightToLeft) {
                    r.x += diffx;
                }
                r.y += diffy;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal anchor value");
            }
        }
    }

    protected Dimension getMinSize(Container parent, DynamicGridBagLayoutInfo info) {
        return this.GetMinSize(parent, info);
    }

    protected Dimension GetMinSize(Container parent, DynamicGridBagLayoutInfo info) {
        int i;
        Dimension d = new Dimension();
        Insets insets = parent.getInsets();
        int t = 0;
        for (i = 0; i < info.width; ++i) {
            t += this.getIntegerVal(info.minWidth, i);
        }
        d.width = t + insets.left + insets.right;
        t = 0;
        for (i = 0; i < info.height; ++i) {
            t += this.getIntegerVal(info.minHeight, i);
        }
        d.height = t + insets.top + insets.bottom;
        return d;
    }

    protected void arrangeGrid(Container parent) {
        this.ArrangeGrid(parent);
    }

    protected void ArrangeGrid(Container parent) {
        int i;
        double weight;
        Insets insets = parent.getInsets();
        Component[] components = parent.getComponents();
        Rectangle r = new Rectangle();
        boolean bl = this.rightToLeft = !parent.getComponentOrientation().isLeftToRight();
        if (!(components.length != 0 || this.columnWidths != null && this.columnWidths.length != 0 || this.rowHeights != null && this.rowHeights.length != 0)) {
            return;
        }
        DynamicGridBagLayoutInfo info = this.getLayoutInfo(parent, 2);
        Dimension d = this.getMinSize(parent, info);
        if (parent.getWidth() < d.width || parent.getHeight() < d.height) {
            info = this.getLayoutInfo(parent, 1);
            d = this.getMinSize(parent, info);
        }
        this.layoutInfo = info;
        r.width = d.width;
        r.height = d.height;
        int diffw = parent.getWidth() - r.width;
        if (diffw != 0) {
            weight = 0.0;
            for (i = 0; i < info.width; ++i) {
                weight += this.getDoubleVal(info.weightX, i);
            }
            if (weight > 0.0) {
                for (i = 0; i < info.width; ++i) {
                    int dx = (int)((double)diffw * this.getDoubleVal(info.weightX, i) / weight);
                    this.addVectorVal((Vector)info.minWidth, i, dx);
                    r.width += dx;
                    if (this.getIntegerVal(info.minWidth, i) >= 0) continue;
                    r.width -= this.getIntegerVal(info.minWidth, i);
                    this.setVectorVal((Vector)info.minWidth, i, 0);
                }
            }
            diffw = parent.getWidth() - r.width;
        } else {
            diffw = 0;
        }
        int diffh = parent.getHeight() - r.height;
        if (diffh != 0) {
            weight = 0.0;
            for (i = 0; i < info.height; ++i) {
                weight += this.getDoubleVal(info.weightY, i);
            }
            if (weight > 0.0) {
                for (i = 0; i < info.height; ++i) {
                    int dy = (int)((double)diffh * this.getDoubleVal(info.weightY, i) / weight);
                    this.addVectorVal((Vector)info.minHeight, i, dy);
                    r.height += dy;
                    if (this.getIntegerVal(info.minHeight, i) >= 0) continue;
                    r.height -= this.getIntegerVal(info.minHeight, i);
                    this.setVectorVal((Vector)info.minHeight, i, 0);
                }
            }
            diffh = parent.getHeight() - r.height;
        } else {
            diffh = 0;
        }
        info.startx = diffw / 2 + insets.left;
        info.starty = diffh / 2 + insets.top;
        for (int compindex = 0; compindex < components.length; ++compindex) {
            Component comp = components[compindex];
            if (!comp.isVisible()) continue;
            DynamicGridBagConstraints constraints = this.lookupConstraints(comp);
            if (!this.rightToLeft) {
                r.x = info.startx;
                for (i = 0; i < constraints.tempX; ++i) {
                    r.x += this.getIntegerVal(info.minWidth, i);
                }
            } else {
                r.x = parent.getWidth() - (diffw / 2 + insets.right);
                for (i = 0; i < constraints.tempX; ++i) {
                    r.x -= this.getIntegerVal(info.minWidth, i);
                }
            }
            r.y = info.starty;
            for (i = 0; i < constraints.tempY; ++i) {
                r.y += this.getIntegerVal(info.minHeight, i);
            }
            r.width = 0;
            for (i = constraints.tempX; i < constraints.tempX + constraints.tempWidth; ++i) {
                r.width += this.getIntegerVal(info.minWidth, i);
            }
            r.height = 0;
            for (i = constraints.tempY; i < constraints.tempY + constraints.tempHeight; ++i) {
                r.height += this.getIntegerVal(info.minHeight, i);
            }
            this.adjustForGravity(constraints, r);
            if (r.x < 0) {
                r.width -= r.x;
                r.x = 0;
            }
            if (r.y < 0) {
                r.height -= r.y;
                r.y = 0;
            }
            if (r.width <= 0 || r.height <= 0) {
                comp.setBounds(0, 0, 0, 0);
                continue;
            }
            if (comp.getX() == r.x && comp.getY() == r.y && comp.getWidth() == r.width && comp.getHeight() == r.height) continue;
            comp.setBounds(r.x, r.y, r.width, r.height);
        }
    }

    private int getIntegerVal(Vector vec, int index) {
        if (vec.capacity() > index) {
            Integer obj = (Integer)vec.get(index);
            if (obj == null) {
                return 0;
            }
            return obj;
        }
        return 0;
    }

    private double getDoubleVal(Vector vec, int index) {
        if (vec.capacity() > index) {
            Double obj = (Double)vec.get(index);
            if (obj == null) {
                return 0.0;
            }
            return obj;
        }
        return 0.0;
    }

    private void addVectorVal(Vector vec, int index, int val) {
        int initial = this.getIntegerVal(vec, index);
        this.setVectorVal(vec, index, initial + val);
    }

    private void addVectorVal(Vector vec, int index, double val) {
        double initial = this.getDoubleVal(vec, index);
        this.setVectorVal(vec, index, initial + val);
    }

    private void setVectorVal(Vector vec, int index, int val) {
        this.setVectorVal(vec, index, new Integer(val));
    }

    private void setVectorVal(Vector vec, int index, double val) {
        this.setVectorVal(vec, index, new Double(val));
    }

    private void setVectorVal(Vector vec, int index, Object val) {
        vec.ensureCapacity(index + 1);
        vec.set(index, val);
    }
}

