/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKBlobClassHandler;
import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.MinerApp;
import com.insightful.miner.ModifyColumnsPanel;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class FilterColumnsDialog
extends NodeDialog {
    private static int iconWidth = 75;
    private static int INCLUDE_COL = 0;
    private static int TYPE_COL = 1;
    private static int ROLE_COL = 2;
    private static int NAME_COL = 3;
    private static int NUM_COL = 4;
    private FCTableModel tableModel;
    private NodeDialog.DialogTable table;
    private AbstractAction selectAllAction;
    private AbstractAction includeAction;
    private AbstractAction excludeAction;
    private static FilterColumnsDialog instance = null;

    public static FilterColumnsDialog getInstance() {
        if (instance == null) {
            instance = new FilterColumnsDialog();
        }
        return instance;
    }

    private FilterColumnsDialog() {
        Dimension min = new Dimension(475, 400);
        this.setMinimumSize(min);
        this.setSize(min);
    }

    public void restoreProperties() {
        super.restoreProperties();
        this.tableModel.clearTable();
        XTProps props = this.getNodeModel().getXTProps();
        XTMetaData metaData = null;
        try {
            metaData = this.getNodeModel().getInputMetaData(0);
        }
        catch (Exception e) {
            AcceleratorOptionPane.showOKDialog(this, MinerApp.getText("NodeDialog_cannotRestoreProperties"), MinerApp.getText("NodeDialog_propertiesNotRestored"), 0);
            e.printStackTrace();
            return;
        }
        Vector names = metaData.getColumnNames();
        Vector types = metaData.getColumnTypes();
        Vector roles = metaData.getColumnRoles();
        Vector propNames = props.getSubProperties("excludeColumns");
        Object[] rowData = new Object[NUM_COL];
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            rowData[FilterColumnsDialog.INCLUDE_COL] = new Boolean(!propNames.contains(name));
            String typeString = (String)types.get(i);
            if (typeString.equals(XTMetaData.BLOB_TYPE_ATTRIBUTE_TAG)) {
                typeString = CNKBlobClassHandler.getDisplayClassName(metaData.getBlobDataFieldClassName(i));
            }
            rowData[FilterColumnsDialog.TYPE_COL] = ModifyColumnsPanel.getIconForString(typeString);
            rowData[FilterColumnsDialog.ROLE_COL] = ModifyColumnsPanel.getIconForString((String)roles.get(i));
            rowData[FilterColumnsDialog.NAME_COL] = name;
            this.tableModel.addRow(rowData);
        }
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        XTProps props = this.getNodeModel().getXTProps();
        props.removeProperty(new String[]{"excludeColumns"});
        int size = this.tableModel.getRowCount();
        for (int i = 0; i < size; ++i) {
            Boolean B = (Boolean)this.table.getValueAt(i, INCLUDE_COL);
            if (B.booleanValue()) continue;
            String name = (String)this.table.getValueAt(i, NAME_COL);
            props.set("excludeColumns", name, true);
        }
    }

    public void createActions() {
        super.createActions();
        this.selectAllAction = new AbstractAction(MinerApp.getText("ModifyColumnsPanel_selectAll")){

            public void actionPerformed(ActionEvent e) {
                if (FilterColumnsDialog.this.table.getRowCount() > 0) {
                    FilterColumnsDialog.this.table.selectAll();
                }
            }
        };
        this.includeAction = new AbstractAction(MinerApp.getText("ModifyColumnsPanel_include")){

            public void actionPerformed(ActionEvent e) {
                FilterColumnsDialog.this.setSelectedColumns(true);
            }
        };
        this.excludeAction = new AbstractAction(MinerApp.getText("ModifyColumnsPanel_exclude")){

            public void actionPerformed(ActionEvent e) {
                FilterColumnsDialog.this.setSelectedColumns(false);
            }
        };
    }

    private void setSelectedColumns(boolean isSelected) {
        Boolean newVal = new Boolean(isSelected);
        int[] rows = this.table.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            this.table.setValueAt(newVal, rows[i], 0);
        }
        this.table.repaint();
        rows = null;
    }

    public JPanel createOptionsPanel() {
        this.tableModel = new FCTableModel();
        this.tableModel.setColumnIdentifiers(new Object[]{" ", MinerApp.getText("ModifyColumnsPanel_types"), MinerApp.getText("ModifyColumnsPanel_roles"), MinerApp.getText("ModifyColumnsPanel_columns")});
        NodeDialog.TableSorter sortingModel = new NodeDialog.TableSorter(this.tableModel);
        this.table = new NodeDialog.DialogTable(sortingModel);
        sortingModel.addMouseListenerToHeaderInTable(this.table);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setAutoResizeMode(0);
        this.table.setRowHeight(25);
        TableColumnModel cm = this.table.getColumnModel();
        TableColumn column = cm.getColumn(0);
        column.setPreferredWidth(30);
        column.setCellEditor(new DefaultCellEditor(new JCheckBox()));
        column.setCellRenderer(new BooleanRenderer());
        for (int i = TYPE_COL; i < NUM_COL; ++i) {
            column = cm.getColumn(i);
            if (i == NAME_COL) {
                column.setPreferredWidth(220);
            } else {
                column.setPreferredWidth(iconWidth);
            }
            column.setCellRenderer(new NodeDialog.GeneralRenderer());
        }
        JScrollPane scrollingTable = new JScrollPane(this.table);
        scrollingTable.setPreferredSize(new Dimension(400, 150));
        JButton selectAll = new JButton(this.selectAllAction);
        selectAll.setMnemonic('a');
        JButton includeButton = new JButton(this.includeAction);
        includeButton.setMnemonic('i');
        JButton excludeButton = new JButton(this.excludeAction);
        excludeButton.setMnemonic('x');
        JPanel selectAllPanel = new JPanel();
        selectAllPanel.setLayout(new BoxLayout(selectAllPanel, 0));
        selectAllPanel.add(Box.createHorizontalGlue());
        selectAllPanel.add(selectAll);
        JPanel inclExclPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 0.5;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 5);
        inclExclPanel.add((Component)includeButton, gbc);
        ++gbc.gridx;
        gbc.insets = new Insets(0, 5, 0, 0);
        inclExclPanel.add((Component)excludeButton, gbc);
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        optionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ModifyColumnsPanel_selectColumns")), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.ipadx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        optionsPanel.add((Component)selectAllPanel, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 0, 5, 0);
        optionsPanel.add((Component)scrollingTable, gbc);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        optionsPanel.add((Component)inclExclPanel, gbc);
        return optionsPanel;
    }

    private class BooleanRenderer
    implements TableCellRenderer {
        private JCheckBox rend = new JCheckBox();

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null || !(value instanceof Boolean)) {
                return null;
            }
            this.rend.setSelected((Boolean)value);
            return this.rend;
        }
    }

    private class FCTableModel
    extends DefaultTableModel {
        private FCTableModel() {
        }

        public void setValueAt(Object aValue, int row, int column) {
            Vector rowVector = (Vector)this.dataVector.elementAt(row);
            rowVector.setElementAt(aValue, column);
        }

        public boolean isCellEditable(int row, int column) {
            return column == INCLUDE_COL;
        }

        public void clearTable() {
            this.dataVector.removeAllElements();
            this.fireTableDataChanged();
        }
    }
}

