/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class FilterRowsDialog
extends NodeDialog {
    private boolean rowsQualifier;
    private JRadioButton selectRowsRadioButton;
    private JRadioButton excludeRowsRadioButton;
    private JTextArea qualifierTextArea;
    private NodeDialog.ExistingColumnInformationPanel existVarPanel;
    private AbstractAction selectRowsQualifierAction;
    private AbstractAction excludeRowsQualifierAction;
    private static FilterRowsDialog instance = null;

    public static FilterRowsDialog getInstance() {
        if (instance == null) {
            instance = new FilterRowsDialog();
        }
        return instance;
    }

    private FilterRowsDialog() {
        this.setMinimumSize(new Dimension(450, 500));
    }

    public boolean displaySeedPanel() {
        return true;
    }

    public void restoreProperties() {
        super.restoreProperties();
        XTProps props = this.getNodeModel().getXTProps();
        this.rowsQualifier = props.getBoolean("includeRows", true);
        if (this.rowsQualifier) {
            this.selectRowsRadioButton.setSelected(true);
        } else {
            this.excludeRowsRadioButton.setSelected(true);
        }
        this.qualifierTextArea.setText(props.getValue("testExpression", ""));
        try {
            this.existVarPanel.restoreProperties(this.getNodeModel().getInputMetaData(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        XTProps props = this.getNodeModel().getXTProps();
        props.set("includeRows", this.rowsQualifier);
        props.set("testExpression", this.qualifierTextArea.getText());
    }

    public void createActions() {
        super.createActions();
        this.selectRowsQualifierAction = new AbstractAction(MinerApp.getText("FilterRowsDialog_selectRowsQualifier")){

            public void actionPerformed(ActionEvent e) {
                FilterRowsDialog.this.rowsQualifier = true;
            }
        };
        this.excludeRowsQualifierAction = new AbstractAction(MinerApp.getText("FilterRowsDialog_excludeRowsQualifier")){

            public void actionPerformed(ActionEvent e) {
                FilterRowsDialog.this.rowsQualifier = false;
            }
        };
    }

    public JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel(new BorderLayout());
        this.existVarPanel = new NodeDialog.ExistingColumnInformationPanel(false, 400, 100);
        JPanel upperPanel = new JPanel(new GridLayout(2, 1));
        upperPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("FilterRowsDialog_selectExclude")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        ButtonGroup selectExcludeGroup = new ButtonGroup();
        this.selectRowsRadioButton = new JRadioButton();
        this.selectRowsRadioButton.setMnemonic(MinerApp.getText("FilterRowsDialog_selectRowsHotkey").charAt(0));
        this.selectRowsRadioButton.setAction(this.selectRowsQualifierAction);
        selectExcludeGroup.add(this.selectRowsRadioButton);
        this.excludeRowsRadioButton = new JRadioButton();
        this.excludeRowsRadioButton.setMnemonic(MinerApp.getText("FilterRowsDialog_excludeRowsHotkey").charAt(0));
        this.excludeRowsRadioButton.setAction(this.excludeRowsQualifierAction);
        selectExcludeGroup.add(this.excludeRowsRadioButton);
        upperPanel.add(this.selectRowsRadioButton);
        upperPanel.add(this.excludeRowsRadioButton);
        JButton parseButton = new JButton(new AbstractAction("Parse Qualifier"){

            public void actionPerformed(ActionEvent e) {
                FilterRowsDialog.this.tryParsingExpression();
            }
        });
        parseButton.setMnemonic('P');
        JPanel centerPanel = new JPanel(new GridBagLayout());
        centerPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel qualifierLabel = new JLabel(MinerApp.getText("FilterRowsDialog_qualifier"));
        this.qualifierTextArea = new JTextArea(3, 30);
        qualifierLabel.setDisplayedMnemonic(MinerApp.getText("FilterRowsDialog_qualifierHotkey").charAt(0));
        qualifierLabel.setLabelFor(this.qualifierTextArea);
        this.qualifierTextArea.setBorder(BorderFactory.createLoweredBevelBorder());
        JScrollPane scrollPane = new JScrollPane(this.qualifierTextArea);
        scrollPane.getViewport().setPreferredSize(this.qualifierTextArea.getPreferredSize());
        constraints.anchor = 18;
        centerPanel.add((Component)qualifierLabel, constraints);
        constraints.gridx = 1;
        constraints.weighty = 1.0;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 15, 0, 0);
        constraints.fill = 1;
        centerPanel.add((Component)scrollPane, constraints);
        JPanel middle = new JPanel();
        middle.setLayout(new BoxLayout(middle, 0));
        middle.add(Box.createGlue());
        middle.add(parseButton);
        constraints.gridy = 2;
        constraints.weighty = 0.0;
        constraints.weightx = 1.0;
        constraints.gridheight = 1;
        constraints.insets = new Insets(5, 0, 5, 0);
        constraints.fill = 1;
        centerPanel.add((Component)middle, constraints);
        constraints.gridy = 3;
        constraints.gridx = 0;
        constraints.weighty = 1.0;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(10, 0, 5, 0);
        constraints.fill = 1;
        constraints.gridwidth = 0;
        centerPanel.add((Component)this.existVarPanel, constraints);
        optionsPanel.add((Component)upperPanel, "North");
        optionsPanel.add((Component)centerPanel, "Center");
        return optionsPanel;
    }

    private void tryParsingExpression() {
        String parseErrors = "";
        try {
            XTProps props = (XTProps)this.getNodeModel().getXTProps().clone();
            props.set("testExpression", this.qualifierTextArea.getText());
            this.getNodeModel().saveGuiNetworkToEngine();
            parseErrors = (String)this.getNodeModel().sendMessageToEngine("getParseErrors", new Object[]{props});
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (parseErrors == null || parseErrors.equals("")) {
            parseErrors = "No parsing errors found.";
        }
        JTextArea errorText = new JTextArea(8, 30);
        errorText.setText(parseErrors);
        errorText.setEditable(false);
        errorText.setBorder(BorderFactory.createLoweredBevelBorder());
        JScrollPane errorScrollPane = new JScrollPane(errorText);
        errorScrollPane.getViewport().setPreferredSize(errorText.getPreferredSize());
        AcceleratorOptionPane.showOKDialog(this.tabbedPane, errorScrollPane, MinerApp.getText("FilterRowsDialog_message_parsingErrors"), 1);
    }
}

