/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.WorksheetPropertiesPanel;
import com.insightful.miner.XTProps;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class GlobalPropertiesDialog
extends NodeDialog {
    private JTextField m_pdfViewerTextField;
    private JTextField m_htmlViewerTextField;
    private JTextField m_workingDirTextField;
    private JTextField m_tempDirTextField;
    private JTextField m_textEditorTextField;
    private JCheckBox m_dblClickShowsViewerCheckBox;
    private JCheckBox m_runToHereShowsViewerCheckBox;
    private JCheckBox m_showStartupDialogCheckBox;
    public static final String DBL_CLICK_SHOW_VIEWER_PROPERTY = "dblClickShowViewer";
    public static final String RUN_TO_HERE_SHOW_VIEWER_PROPERTY = "runToHereShowViewer";
    public static final String WORKING_DIR_PROPERTY = "workingDir";
    public static final String TEMP_DIR_PROPERTY = "tempDir";
    public static final String SHOW_STARTUP_DIALOG_PROPERTY = "showStartup";
    public static final String TEXT_EDITOR_PROPERTY = "textEditor";
    public static final String PDF_VIEWER_PROPERTY = "pdfViewer";
    public static final String HTML_VIEWER_PROPERTY = "htmlViewer";
    public static final String WINDOWS_DEFAULT_TEXT_EDITOR = "notepad.exe";
    public static final String UNIX_DEFAULT_TEXT_EDITOR = "emacs";
    private static GlobalPropertiesDialog m_instance = null;

    public static GlobalPropertiesDialog getInstance() {
        if (m_instance == null) {
            m_instance = new GlobalPropertiesDialog();
        }
        return m_instance;
    }

    private GlobalPropertiesDialog() {
        this.setTitle(MinerApp.getText("GlobalPropertiesDialog_globalProperties"));
        this.getApplyButton().setVisible(false);
        this.getAddButton().setVisible(false);
        Dimension min = new Dimension(625, 300);
        this.setMinimumSize(min);
        this.setSize(min);
        this.setLocationRelativeTo(MinerApp.getMainFrame());
    }

    public void showGlobalProperties() {
        this.show(null);
    }

    public void restoreProperties() {
        XTProps props = MinerApp.getGlobalOptions();
        this.m_workingDirTextField.setText(props.getValue(WORKING_DIR_PROPERTY, MinerApp.getWorkDir()));
        this.m_tempDirTextField.setText(props.getValue(TEMP_DIR_PROPERTY, MinerApp.getTempDir()));
        this.m_textEditorTextField.setText(props.getValue(TEXT_EDITOR_PROPERTY, MinerApp.isWindowsOS() ? WINDOWS_DEFAULT_TEXT_EDITOR : UNIX_DEFAULT_TEXT_EDITOR));
        this.m_pdfViewerTextField.setText(props.getValue(PDF_VIEWER_PROPERTY, ""));
        this.m_htmlViewerTextField.setText(props.getValue(HTML_VIEWER_PROPERTY, ""));
        this.m_showStartupDialogCheckBox.setSelected(props.getBoolean(SHOW_STARTUP_DIALOG_PROPERTY, true));
        this.m_dblClickShowsViewerCheckBox.setSelected(props.getBoolean(DBL_CLICK_SHOW_VIEWER_PROPERTY, false));
        this.m_runToHereShowsViewerCheckBox.setSelected(props.getBoolean(RUN_TO_HERE_SHOW_VIEWER_PROPERTY, false));
    }

    public void saveProperties() throws NodeDialog.DialogException {
        int choice;
        int choice2;
        XTProps props = MinerApp.getGlobalOptions();
        String origWorkDir = props.getValue(WORKING_DIR_PROPERTY, MinerApp.getWorkDir());
        if (!this.m_workingDirTextField.getText().equals(origWorkDir) && (choice2 = AcceleratorOptionPane.showYesNoCancelDialog(MinerApp.getMainFrame(), MinerApp.getText("GlobalPropertiesDialog_workingDirError"), MinerApp.getText("GlobalPropertiesDialog_workingDirErrorTitle"), -1)) != 0) {
            this.m_workingDirTextField.setText(origWorkDir);
            throw new NodeDialog.DialogException();
        }
        String origTempDir = props.getValue(TEMP_DIR_PROPERTY, MinerApp.getTempDir());
        if (!this.m_tempDirTextField.getText().equals(origTempDir) && (choice = AcceleratorOptionPane.showYesNoCancelDialog(MinerApp.getMainFrame(), MinerApp.getText("GlobalPropertiesDialog_tempDirError"), MinerApp.getText("GlobalPropertiesDialog_tempDirErrorTitle"), -1)) != 0) {
            this.m_tempDirTextField.setText(origTempDir);
            throw new NodeDialog.DialogException();
        }
        if (!this.m_workingDirTextField.getText().equals(MinerApp.getWorkDir())) {
            props.set(WORKING_DIR_PROPERTY, this.m_workingDirTextField.getText());
        }
        if (!this.m_tempDirTextField.getText().equals(MinerApp.getTempDir())) {
            props.set(TEMP_DIR_PROPERTY, this.m_tempDirTextField.getText());
        }
        props.set(PDF_VIEWER_PROPERTY, this.m_pdfViewerTextField.getText());
        props.set(HTML_VIEWER_PROPERTY, this.m_htmlViewerTextField.getText());
        props.set(TEXT_EDITOR_PROPERTY, this.m_textEditorTextField.getText());
        props.set(SHOW_STARTUP_DIALOG_PROPERTY, this.m_showStartupDialogCheckBox.isSelected());
        props.set(DBL_CLICK_SHOW_VIEWER_PROPERTY, this.m_dblClickShowsViewerCheckBox.isSelected());
        props.set(RUN_TO_HERE_SHOW_VIEWER_PROPERTY, this.m_runToHereShowsViewerCheckBox.isSelected());
        MinerApp.updateWorksheetPropertiesManager();
    }

    public JPanel createAdvancedPanel() {
        return null;
    }

    public JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel();
        optionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("GlobalPropertiesDialog_options")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        optionsPanel.setLayout(new GridBagLayout());
        this.m_pdfViewerTextField = new JTextField(25);
        JLabel pdfLabel = new JLabel(MinerApp.getText("GlobalPropertiesDialog_pdfViewer"));
        pdfLabel.setDisplayedMnemonic(MinerApp.getText("GlobalPropertiesDialog_pdfViewerHotkey").charAt(0));
        pdfLabel.setLabelFor(this.m_pdfViewerTextField);
        this.m_htmlViewerTextField = new JTextField(25);
        JLabel htmlLabel = new JLabel(MinerApp.getText("GlobalPropertiesDialog_htmlViewer"));
        htmlLabel.setDisplayedMnemonic(MinerApp.getText("GlobalPropertiesDialog_htmlViewerHotkey").charAt(0));
        htmlLabel.setLabelFor(this.m_htmlViewerTextField);
        boolean displayViewerSelectionFields = !MinerApp.isWindowsOS();
        this.m_workingDirTextField = new JTextField(25);
        JLabel workingDirLabel = new JLabel(MinerApp.getText("GlobalPropertiesDialog_workingDir"));
        workingDirLabel.setDisplayedMnemonic(MinerApp.getText("GlobalPropertiesDialog_workingDirHotkey").charAt(0));
        workingDirLabel.setLabelFor(this.m_workingDirTextField);
        JButton workingBrowseButton = WorksheetPropertiesPanel.createButton("GlobalPropertiesDialog_browse", "GlobalPropertiesDialog_browseHotkey", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                String newPath = WorksheetPropertiesPanel.browseForDirectory(m_instance, GlobalPropertiesDialog.this.m_workingDirTextField.getText());
                if (newPath != null) {
                    GlobalPropertiesDialog.this.m_workingDirTextField.setText(newPath);
                }
            }
        });
        this.m_tempDirTextField = new JTextField(25);
        JLabel tempDirLabel = new JLabel(MinerApp.getText("GlobalPropertiesDialog_tempDir"));
        tempDirLabel.setDisplayedMnemonic(MinerApp.getText("GlobalPropertiesDialog_tempDirHotkey").charAt(0));
        tempDirLabel.setLabelFor(this.m_tempDirTextField);
        JButton tempBrowseButton = WorksheetPropertiesPanel.createButton("GlobalPropertiesDialog_browse", "GlobalPropertiesDialog_tempBrowseHotkey", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                String newPath = WorksheetPropertiesPanel.browseForDirectory(m_instance, GlobalPropertiesDialog.this.m_tempDirTextField.getText());
                if (newPath != null) {
                    GlobalPropertiesDialog.this.m_tempDirTextField.setText(newPath);
                }
            }
        });
        this.m_textEditorTextField = new JTextField(25);
        JLabel textEditorLabel = new JLabel(MinerApp.getText("GlobalPropertiesDialog_textEditor"));
        textEditorLabel.setDisplayedMnemonic(MinerApp.getText("GlobalPropertiesDialog_textEditorHotkey").charAt(0));
        textEditorLabel.setLabelFor(this.m_textEditorTextField);
        JButton textEditorBrowseButton = WorksheetPropertiesPanel.createButton("GlobalPropertiesDialog_browse", "GlobalPropertiesDialog_textEditorBrowseHotkey", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                String newPath = WorksheetPropertiesPanel.browseForFile(m_instance, GlobalPropertiesDialog.this.m_textEditorTextField.getText());
                if (newPath != null) {
                    GlobalPropertiesDialog.this.m_textEditorTextField.setText(newPath);
                }
            }
        });
        this.m_showStartupDialogCheckBox = new JCheckBox(MinerApp.getText("GlobalPropertiesDialog_showStartupDialog"));
        this.m_showStartupDialogCheckBox.setMnemonic(MinerApp.getText("GlobalPropertiesDialog_showStartupDialogHotkey").charAt(0));
        this.m_dblClickShowsViewerCheckBox = new JCheckBox(MinerApp.getText("GlobalPropertiesDialog_dblClickViewer"));
        this.m_dblClickShowsViewerCheckBox.setMnemonic(MinerApp.getText("GlobalPropertiesDialog_dblClickViewerHotkey").charAt(0));
        this.m_runToHereShowsViewerCheckBox = new JCheckBox(MinerApp.getText("GlobalPropertiesDialog_runToHereViewer"));
        this.m_runToHereShowsViewerCheckBox.setMnemonic(MinerApp.getText("GlobalPropertiesDialog_runToHereViewerHotkey").charAt(0));
        int gridy = 1;
        Insets none = new Insets(2, 0, 2, 0);
        Insets frontback = new Insets(2, 10, 2, 10);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        optionsPanel.add((Component)workingDirLabel, constraints);
        constraints.gridwidth = 3;
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.insets = frontback;
        constraints.anchor = 10;
        constraints.fill = 2;
        optionsPanel.add((Component)this.m_workingDirTextField, constraints);
        constraints.gridx = 4;
        constraints.weightx = 0.0;
        constraints.gridwidth = 1;
        constraints.insets = none;
        constraints.anchor = 18;
        constraints.fill = 0;
        optionsPanel.add((Component)workingBrowseButton, constraints);
        constraints.gridy = gridy++;
        constraints.gridx = 0;
        optionsPanel.add((Component)tempDirLabel, constraints);
        constraints.gridwidth = 3;
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.insets = frontback;
        constraints.anchor = 10;
        constraints.fill = 2;
        optionsPanel.add((Component)this.m_tempDirTextField, constraints);
        constraints.gridx = 4;
        constraints.weightx = 0.0;
        constraints.gridwidth = 1;
        constraints.insets = none;
        constraints.anchor = 18;
        constraints.fill = 0;
        optionsPanel.add((Component)tempBrowseButton, constraints);
        constraints.gridy = gridy++;
        constraints.gridx = 0;
        constraints.gridwidth = 6;
        constraints.weightx = 1.0;
        constraints.fill = 1;
        constraints.insets = frontback;
        optionsPanel.add((Component)new JSeparator(0), constraints);
        constraints.insets = none;
        constraints.gridy = gridy++;
        constraints.gridx = 0;
        optionsPanel.add((Component)textEditorLabel, constraints);
        constraints.gridwidth = 3;
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.insets = frontback;
        constraints.anchor = 10;
        constraints.fill = 2;
        optionsPanel.add((Component)this.m_textEditorTextField, constraints);
        constraints.gridx = 4;
        constraints.weightx = 0.0;
        constraints.gridwidth = 1;
        constraints.insets = none;
        constraints.anchor = 18;
        constraints.fill = 0;
        optionsPanel.add((Component)textEditorBrowseButton, constraints);
        constraints.gridy = gridy++;
        constraints.gridx = 0;
        constraints.gridwidth = 6;
        constraints.weightx = 1.0;
        constraints.fill = 1;
        constraints.insets = frontback;
        optionsPanel.add((Component)new JSeparator(0), constraints);
        constraints.gridy = gridy++;
        constraints.weightx = 0.0;
        constraints.gridwidth = 2;
        constraints.fill = 0;
        constraints.insets = none;
        optionsPanel.add((Component)this.m_showStartupDialogCheckBox, constraints);
        constraints.gridy = gridy++;
        constraints.weightx = 0.0;
        constraints.gridwidth = 2;
        constraints.fill = 0;
        constraints.insets = none;
        optionsPanel.add((Component)this.m_dblClickShowsViewerCheckBox, constraints);
        constraints.gridy = gridy++;
        constraints.weightx = 0.0;
        constraints.weighty = displayViewerSelectionFields ? 0.0 : 1.0;
        constraints.gridwidth = 2;
        constraints.fill = 0;
        constraints.insets = none;
        optionsPanel.add((Component)this.m_runToHereShowsViewerCheckBox, constraints);
        if (displayViewerSelectionFields) {
            constraints.gridy = gridy++;
            constraints.gridx = 0;
            constraints.gridwidth = 6;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 1;
            constraints.insets = frontback;
            optionsPanel.add((Component)new JSeparator(0), constraints);
            constraints.insets = none;
            constraints.gridy = gridy++;
            constraints.gridx = 0;
            constraints.anchor = 18;
            optionsPanel.add((Component)pdfLabel, constraints);
            constraints.gridwidth = 3;
            constraints.gridx = 1;
            constraints.weightx = 1.0;
            constraints.insets = frontback;
            constraints.fill = 2;
            optionsPanel.add((Component)this.m_pdfViewerTextField, constraints);
            constraints.insets = none;
            constraints.gridy = gridy++;
            constraints.gridx = 0;
            constraints.weighty = 1.0;
            optionsPanel.add((Component)htmlLabel, constraints);
            constraints.gridwidth = 3;
            constraints.gridx = 1;
            constraints.weightx = 1.0;
            constraints.insets = frontback;
            constraints.fill = 2;
            optionsPanel.add((Component)this.m_htmlViewerTextField, constraints);
        }
        return optionsPanel;
    }
}

