/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.util.Vector;

public class HexBinStatisticAccumulator {
    public static String CHARTS_ATTRIBUTE_TAG = "charts";
    public static String I_MAX_ATTRIBUTE_TAG = "iMax";
    public static String J_MAX_ATTRIBUTE_TAG = "jMax";
    public static String MAPPING_ATTRIBUTE_TAG = "mapping";
    public static String COUNTS_ATTRIBUTE_TAG = "counts";
    public static String X_CENTERS_ATTRIBUTE_TAG = "xCenters";
    public static String Y_CENTERS_ATTRIBUTE_TAG = "yCenters";
    private Vector m_xColumnNames;
    private Vector m_yColumnNames;
    private int[][][] m_mapping;
    private long[][][] m_binCounts;
    private double[][][][] m_binCenters;
    private double[] m_xMin;
    private double[] m_yMin;
    private double[] m_xMax;
    private double[] m_yMax;
    private double[] m_c1;
    private double[] m_c2;
    private int m_iMax;
    private int m_jInc;
    private int m_iInc;
    private int m_numBins;
    private double m_shape;
    private double m_numXBins;

    public HexBinStatisticAccumulator(Vector xColumns, Vector yColumns, XTMetaData metaData, double shape, double numXBins) {
        int i;
        this.m_shape = shape;
        this.m_numXBins = numXBins;
        this.m_xColumnNames = xColumns;
        this.m_yColumnNames = yColumns;
        int numXCols = xColumns.size();
        int numYCols = yColumns.size();
        this.m_jInc = (int)Math.floor(numXBins + 1.5001);
        this.m_iMax = (int)(2.0 * Math.floor(numXBins * shape / Math.sqrt(3.0) + 1.5001));
        this.m_numBins = this.m_jInc * this.m_iMax;
        this.m_binCounts = new long[numXCols][numYCols][this.m_numBins];
        this.m_binCenters = new double[numXCols][numYCols][2][this.m_numBins];
        this.m_xMin = new double[numXCols];
        this.m_xMax = new double[numXCols];
        this.m_c1 = new double[numXCols];
        for (i = 0; i < numXCols; ++i) {
            String xCol = (String)this.m_xColumnNames.get(i);
            this.m_xMin[i] = metaData.getColumnMin(xCol);
            this.m_xMax[i] = metaData.getColumnMax(xCol);
            this.m_c1[i] = numXBins / (this.m_xMax[i] - this.m_xMin[i]);
        }
        this.m_yMin = new double[numYCols];
        this.m_yMax = new double[numYCols];
        this.m_c2 = new double[numYCols];
        for (i = 0; i < numYCols; ++i) {
            String yCol = (String)this.m_yColumnNames.get(i);
            this.m_yMin[i] = metaData.getColumnMin(yCol);
            this.m_yMax[i] = metaData.getColumnMax(yCol);
            this.m_c2[i] = numXBins * shape / ((this.m_yMax[i] - this.m_yMin[i]) * Math.sqrt(3.0));
        }
        this.m_iInc = 2 * this.m_jInc;
    }

    public void updateStatistics(double[][] xVals, double[][] yVals, int rowCount) {
        for (int xCol = 0; xCol < xVals.length; ++xCol) {
            for (int yCol = 0; yCol < yVals.length; ++yCol) {
                for (int i = 0; i < rowCount; ++i) {
                    int bin = this.findBin(xVals[xCol][i], yVals[yCol][i], xCol, yCol);
                    long[] lArray = this.m_binCounts[xCol][yCol];
                    int n = bin;
                    lArray[n] = lArray[n] + 1L;
                    this.m_binCenters[xCol][yCol][0][bin] = this.m_binCenters[xCol][yCol][0][bin] + (xVals[xCol][i] - this.m_binCenters[xCol][yCol][0][bin]) / (double)this.m_binCounts[xCol][yCol][bin];
                    this.m_binCenters[xCol][yCol][1][bin] = this.m_binCenters[xCol][yCol][1][bin] + (yVals[yCol][i] - this.m_binCenters[xCol][yCol][1][bin]) / (double)this.m_binCounts[xCol][yCol][bin];
                }
            }
        }
    }

    private int findBin(double xVal, double yVal, int xCol, int yCol) {
        int i2;
        int j2;
        double test;
        double sx = this.m_c1[xCol] * (xVal - this.m_xMin[xCol]);
        int j1 = (int)(sx + 0.5);
        double sy = this.m_c2[yCol] * (yVal - this.m_yMin[yCol]);
        int i1 = (int)(sy + 0.5);
        double dist1 = (sx - (double)j1) * (sx - (double)j1) + 3.0 * (sy - (double)i1) * (sy - (double)i1);
        int bin = dist1 < 0.25 ? i1 * this.m_iInc + j1 : (dist1 > 0.3333333333333333 ? (int)sy * this.m_iInc + (int)sx + this.m_jInc : (dist1 <= (test = (sx - (double)(j2 = (int)sx) - 0.5) * (sx - (double)j2 - 0.5) + 3.0 * (sy - (double)(i2 = (int)sy) - 0.5) * (sy - (double)i2 - 0.5)) ? i1 * this.m_iInc + j1 : i2 * this.m_iInc + j2 + this.m_jInc));
        return bin;
    }

    private void consolidateCounts() {
        int numXCols = this.m_xColumnNames.size();
        int numYCols = this.m_yColumnNames.size();
        int[][] nonZero = new int[numXCols][numYCols];
        for (int x = 0; x < numXCols; ++x) {
            for (int y = 0; y < numYCols; ++y) {
                for (int i = 0; i < this.m_numBins; ++i) {
                    if (this.m_binCounts[x][y][i] <= 0L) continue;
                    int[] nArray = nonZero[x];
                    int n = y;
                    nArray[n] = nArray[n] + 1;
                }
            }
        }
        this.m_mapping = new int[numXCols][numYCols][];
        long[][][] newBinCount = new long[numXCols][numYCols][];
        double[][][][] newBinCenters = new double[numXCols][numYCols][2][];
        int[][] nc = new int[numXCols][numYCols];
        for (int x = 0; x < numXCols; ++x) {
            for (int y = 0; y < numYCols; ++y) {
                int nz = nonZero[x][y];
                this.m_mapping[x][y] = new int[nz];
                newBinCount[x][y] = new long[nz];
                newBinCenters[x][y][0] = new double[nz];
                newBinCenters[x][y][1] = new double[nz];
                for (int i = 0; i < this.m_numBins; ++i) {
                    if (this.m_binCounts[x][y][i] <= 0L) continue;
                    int compressIndex = nc[x][y];
                    this.m_mapping[x][y][compressIndex] = i;
                    newBinCount[x][y][compressIndex] = this.m_binCounts[x][y][i];
                    newBinCenters[x][y][0][compressIndex] = this.m_binCenters[x][y][0][i];
                    newBinCenters[x][y][1][compressIndex] = this.m_binCenters[x][y][1][i];
                    int[] nArray = nc[x];
                    int n = y;
                    nArray[n] = nArray[n] + 1;
                }
            }
        }
        this.m_binCounts = newBinCount;
        this.m_binCenters = newBinCenters;
    }

    public XTProps outputColumnStats() throws Exception {
        XTProps props = new XTProps();
        int numXCols = this.m_xColumnNames.size();
        int numYCols = this.m_yColumnNames.size();
        this.consolidateCounts();
        props.set(I_MAX_ATTRIBUTE_TAG, this.m_iMax);
        props.set(J_MAX_ATTRIBUTE_TAG, this.m_jInc);
        int chart = 0;
        String[] numBinsPath = new String[]{CHARTS_ATTRIBUTE_TAG, ""};
        String[] path = new String[]{CHARTS_ATTRIBUTE_TAG, "", "", ""};
        for (int x = 0; x < numXCols; ++x) {
            for (int y = 0; y < numYCols; ++y) {
                path[1] = Integer.toString(chart);
                numBinsPath[1] = path[1];
                props.set(numBinsPath, Integer.toString(this.m_mapping[x][y].length));
                for (int i = 0; i < this.m_mapping[x][y].length; ++i) {
                    path[2] = MAPPING_ATTRIBUTE_TAG;
                    path[3] = Integer.toString(i);
                    props.set(path, Integer.toString(this.m_mapping[x][y][i] + 1));
                    path[2] = COUNTS_ATTRIBUTE_TAG;
                    props.set(path, Long.toString(this.m_binCounts[x][y][i]));
                    path[2] = X_CENTERS_ATTRIBUTE_TAG;
                    props.set(path, Double.toString(this.m_binCenters[x][y][0][i]));
                    path[2] = Y_CENTERS_ATTRIBUTE_TAG;
                    props.set(path, Double.toString(this.m_binCenters[x][y][1][i]));
                }
                ++chart;
            }
        }
        return props;
    }
}

