/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.InsQuantileDataset;
import com.jrefinery.data.AbstractSeriesDataset;
import com.jrefinery.data.CategoryDataset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;

public class InsDefaultQuantileDataset
extends AbstractSeriesDataset
implements CategoryDataset,
InsQuantileDataset {
    protected Number[][][] data;
    protected String[] seriesNames;
    protected Object[] categories;
    public static final int MIN_VALUE_INDEX = 0;
    public static final int LOWER_QUANTILE_VALUE_INDEX = 1;
    public static final int MEAN_VALUE_INDEX = 2;
    public static final int UPPER_QUANTILE_VALUE_INDEX = 3;
    public static final int MAX_VALUE_INDEX = 4;

    public InsDefaultQuantileDataset(Number[][][] data) {
        this(null, null, data);
    }

    public InsDefaultQuantileDataset(String[] series_names, Number[][][] data) {
        this(series_names, null, data);
    }

    public InsDefaultQuantileDataset(String[] series_names, Object[] categories, Number[][][] data) {
        this.data = data;
        if (data != null) {
            String baseName = "com.jrefinery.data.resources.DataPackageResources";
            ResourceBundle resources = ResourceBundle.getBundle(baseName);
            int series_count = data.length;
            if (series_count > 0) {
                if (this.seriesNames != null) {
                    if (this.seriesNames.length != series_count) {
                        throw new IllegalArgumentException("InsDefaultQuantileDataset: the number of series names does not match the number of series in the data.");
                    }
                } else {
                    String prefix = resources.getString("series.default-prefix") + " ";
                    this.seriesNames = this.generateNames(series_count, prefix);
                }
                int category_count = data[0].length;
                if (categories != null) {
                    if (categories.length != category_count) {
                        throw new IllegalArgumentException("InsDefaultQuantileDataset: the number of categories does not match the number of categories in the data.");
                    }
                    this.categories = categories;
                } else {
                    String prefix = resources.getString("categories.default-prefix") + " ";
                    this.categories = this.generateNames(category_count, prefix);
                }
            } else {
                this.seriesNames = null;
                this.categories = null;
            }
        }
    }

    private int checkArgsAndGetCatIndex(int series, Object category) throws IllegalArgumentException {
        int categoryIndex = -1;
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("InsDefaultQuantileDataset.getValue(...): series index out of range.");
        }
        if (category == null) {
            throw new IllegalArgumentException("InsDefaultQuantileDataset.getValue(...): null category not allowed.");
        }
        categoryIndex = this.getCategoryIndex(category);
        if (categoryIndex < 0) {
            throw new IllegalArgumentException("InsDefaultQuantileDataset.getValue(...): unknown category.");
        }
        return categoryIndex;
    }

    public Number getValue(int series, Object category) {
        int categoryIndex = this.checkArgsAndGetCatIndex(series, category);
        return (Double)this.data[series][categoryIndex][4];
    }

    public Number getMaxValue(int series, Object category) {
        int categoryIndex = this.checkArgsAndGetCatIndex(series, category);
        return (Double)this.data[series][categoryIndex][4];
    }

    public Number getMinValue(int series, Object category) {
        int categoryIndex = this.checkArgsAndGetCatIndex(series, category);
        return (Double)this.data[series][categoryIndex][0];
    }

    public Number get25PercentValue(int series, Object category) {
        int categoryIndex = this.checkArgsAndGetCatIndex(series, category);
        return (Double)this.data[series][categoryIndex][1];
    }

    public Number get75PercentValue(int series, Object category) {
        int categoryIndex = this.checkArgsAndGetCatIndex(series, category);
        return (Double)this.data[series][categoryIndex][3];
    }

    public Number get50PercentValue(int series, Object category) {
        int categoryIndex = this.checkArgsAndGetCatIndex(series, category);
        return (Double)this.data[series][categoryIndex][2];
    }

    public int getSeriesCount() {
        int result = 0;
        if (this.data != null) {
            result = this.data.length;
        }
        return result;
    }

    public String getSeriesName(int series) {
        if (series >= this.getSeriesCount() || series < 0) {
            throw new IllegalArgumentException("InsDefaultQuantileDataset.getSeriesName(int): no such series.");
        }
        return this.seriesNames[series];
    }

    public void setSeriesNames(String[] seriesNames) {
        if (seriesNames == null) {
            throw new IllegalArgumentException("InsDefaultQuantileDataset.setSeriesNames(): null not permitted.");
        }
        if (seriesNames.length != this.getSeriesCount()) {
            throw new IllegalArgumentException("InsDefaultQuantileDataset.setSeriesNames(): the number of series names does not match the data.");
        }
        this.seriesNames = seriesNames;
        this.fireDatasetChanged();
    }

    public int getCategoryCount() {
        int result = 0;
        if (this.data != null && this.getSeriesCount() > 0) {
            result = this.data[0].length;
        }
        return result;
    }

    public List getCategories() {
        if (this.categories == null) {
            return new ArrayList();
        }
        return Collections.unmodifiableList(Arrays.asList(this.categories));
    }

    public void setCategories(Object[] categories) {
        if (categories == null) {
            throw new IllegalArgumentException("InsDefaultQuantileDataset.setCategories(...): null not permitted.");
        }
        if (categories.length != this.data[0].length) {
            throw new IllegalArgumentException("InsDefaultQuantileDataset.setCategories(...): the number of categories does not match the data.");
        }
        for (int i = 0; i < categories.length; ++i) {
            if (categories[i] != null) continue;
            throw new IllegalArgumentException("InsDefaultQuantileDataset.setCategories(...): null category not permitted.");
        }
        this.categories = categories;
        this.fireDatasetChanged();
    }

    private int getCategoryIndex(Object category) {
        int result = -1;
        for (int i = 0; i < this.categories.length; ++i) {
            if (!category.equals(this.categories[i])) continue;
            result = i;
            break;
        }
        return result;
    }

    private String[] generateNames(int count, String prefix) {
        String[] result = new String[count];
        for (int i = 0; i < count; ++i) {
            String name;
            result[i] = name = prefix + (i + 1);
        }
        return result;
    }
}

