/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ActivityNodeArea;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.CollapsedNodeArea;
import com.insightful.miner.WorksheetDocument;
import com.insightful.miner.WorksheetView;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTNetwork;
import com.insightful.miner.dndtree.DragOverData;
import com.nwoods.jgo.JGoObject;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import org.w3c.dom.Element;

public class LibraryTreeNode
implements Serializable,
DragOverData {
    private String m_labelText;
    private String m_treeNodeIconFileName;
    private Element m_xmlElement;
    private String m_className;
    private int m_currentEffect;

    public LibraryTreeNode(Element elt) {
        this.m_xmlElement = elt;
        Element displayInfo = (Element)elt.getElementsByTagName(XTNetwork.DISPLAY_INFO_NODE_TAG).item(0);
        this.m_labelText = displayInfo.getAttribute(XTNetwork.LABEL_TEXT_ATTRIBUTE_TAG);
        this.m_treeNodeIconFileName = displayInfo.getAttribute(XTNetwork.SMALL_ICON_ATTRIBUTE_TAG);
        if (elt.getNodeName().equals(XTNetwork.COLLAPSED_NODE_NODE_TAG) && this.m_treeNodeIconFileName.length() == 0) {
            this.m_treeNodeIconFileName = "collapsed_node_small.gif";
        }
        if (this.m_treeNodeIconFileName == null | this.m_treeNodeIconFileName.length() == 0) {
            this.m_treeNodeIconFileName = "default_small.gif";
        }
    }

    public void setLabel(String newLabel) {
        Element displayInfo = (Element)this.m_xmlElement.getElementsByTagName(XTNetwork.DISPLAY_INFO_NODE_TAG).item(0);
        displayInfo.setAttribute(XTNetwork.LABEL_TEXT_ATTRIBUTE_TAG, newLabel);
        this.m_labelText = newLabel;
    }

    public String getTreeNodeIconFilename() {
        return this.m_treeNodeIconFileName;
    }

    public String toString() {
        return this.m_labelText;
    }

    public Element getXml() {
        return this.m_xmlElement;
    }

    public ActivityNodeModel createActivityModel(boolean copy) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Element elt = copy ? (Element)this.m_xmlElement.cloneNode(true) : this.m_xmlElement;
        return LibraryTreeNode.createActivityModel(elt);
    }

    public static ActivityNodeModel createActivityModel(Element elt) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        String className = elt.getAttribute(XTNetwork.GUI_CLASS_ATTRIBUTE_TAG);
        ActivityNodeModel nodeModel = ActivityNodeModel.createActivityNodeModel(className, elt);
        return nodeModel;
    }

    public BaseNodeArea createBaseNode() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (this.isActivityNode()) {
            return this.createActivityNode();
        }
        WorksheetDocument doc = new WorksheetDocument();
        WorksheetView view = new WorksheetView(doc);
        CollapsedNodeArea area = CollapsedNodeArea.buildCollapsedNodeFromXML(this.getXml(), doc, null);
        doc.removeObject((JGoObject)area);
        return area;
    }

    public boolean isActivityNode() {
        return this.getXml().getNodeName().equals(XTNetwork.ACTIVITY_NODE_NODE_TAG);
    }

    public ActivityNodeArea createActivityNode() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        ActivityNodeModel nodeModel = this.createActivityModel(true);
        ActivityNodeArea nodeArea = new ActivityNodeArea();
        nodeArea.initialize(nodeModel);
        return nodeArea;
    }

    private void writeObject(ObjectOutputStream str) throws Exception {
        str.writeObject(this.m_labelText);
        str.writeObject(this.m_treeNodeIconFileName);
        str.writeObject(new XMLTree(this.m_xmlElement));
        str.writeObject(this.m_className);
    }

    private void readObject(ObjectInputStream in) throws Exception {
        this.m_labelText = (String)in.readObject();
        this.m_treeNodeIconFileName = (String)in.readObject();
        Object obj = in.readObject();
        this.m_xmlElement = obj != null ? ((XMLTree)obj).getXML() : null;
        this.m_className = (String)in.readObject();
    }

    public void setCurrentEffect(int eff) {
        this.m_currentEffect = eff;
    }

    public int getCurrentEffect() {
        return this.m_currentEffect;
    }
}

