/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ModifiableViewerFrame
extends JFrame {
    static Vector m_openFrames = new Vector();
    protected long m_timeCreated;

    public ModifiableViewerFrame(String title) {
        super(title);
        this.init();
    }

    public ModifiableViewerFrame() {
        this.init();
    }

    public void dispose() {
        m_openFrames.remove(this);
        super.dispose();
    }

    public void setVisible(boolean b) {
        if (!b) {
            m_openFrames.remove(this);
        }
        super.setVisible(b);
    }

    private void init() {
        this.m_timeCreated = System.currentTimeMillis();
        m_openFrames.add(this);
    }

    public static void manageOpenFrames(String title) {
        OpenFrameManagerDialog dlg = new OpenFrameManagerDialog(title);
        dlg.show();
    }

    public static void cascadeViewers() {
        MinerApp.getMainFrame().resetNextWindowLocation();
        for (int i = 0; i < m_openFrames.size(); ++i) {
            ModifiableViewerFrame frame = (ModifiableViewerFrame)m_openFrames.get(i);
            frame.setLocation(MinerApp.getNextWindowLocation());
        }
    }

    public static void closeViewers() {
        for (int i = 0; i < m_openFrames.size(); ++i) {
            ModifiableViewerFrame frame = (ModifiableViewerFrame)m_openFrames.get(i);
            frame.setVisible(false);
            frame.dispose();
        }
    }

    public static class OpenFrameManagerDialog
    extends JDialog {
        private FrameTableModel tableModel;

        public OpenFrameManagerDialog(String title) {
            super((Frame)MinerApp.getMainFrame(), title);
            this.init();
        }

        private void init() {
            this.tableModel = new FrameTableModel();
            this.tableModel.setColumnIdentifiers(new Object[]{" ", MinerApp.getText("ModifiableViewerFrame_title"), MinerApp.getText("ModifiableViewerFrame_timeCreated")});
            NodeDialog.TableSorter sortingModel = new NodeDialog.TableSorter(this.tableModel);
            NodeDialog.DialogTable table = new NodeDialog.DialogTable(sortingModel);
            sortingModel.addMouseListenerToHeaderInTable(table);
            table.getTableHeader().setReorderingAllowed(false);
            table.setRowSelectionAllowed(true);
            table.setAutoResizeMode(0);
            table.setRowHeight(25);
            TableColumnModel cm = table.getColumnModel();
            TableColumn column = cm.getColumn(0);
            column.setCellEditor(new DefaultCellEditor(new JCheckBox()));
            column.setCellRenderer(new BooleanRenderer());
            column.setPreferredWidth(30);
            column = cm.getColumn(1);
            column.setPreferredWidth(230);
            column = cm.getColumn(2);
            column.setPreferredWidth(250);
            table.setDefaultRenderer(String.class, new NodeDialog.LeftJustifiedStringRenderer());
            Boolean sel = new Boolean(true);
            for (int i = 0; i < m_openFrames.size(); ++i) {
                ModifiableViewerFrame frame = (ModifiableViewerFrame)m_openFrames.get(i);
                String creation = new Date(frame.m_timeCreated).toString();
                String title = frame.getTitle();
                this.tableModel.addRow(new Object[]{sel, title, creation});
            }
            JScrollPane scrollingTable = new JScrollPane(table);
            scrollingTable.setPreferredSize(new Dimension(400, 150));
            JButton ok = new JButton(new AbstractAction(MinerApp.getText("NodeDialog_ok")){

                public void actionPerformed(ActionEvent e) {
                    Vector oFrames = m_openFrames;
                    for (int i = oFrames.size() - 1; i >= 0; --i) {
                        if (!((Boolean)OpenFrameManagerDialog.this.tableModel.getValueAt(i, 0)).booleanValue()) continue;
                        ((ModifiableViewerFrame)oFrames.get(i)).dispose();
                    }
                    OpenFrameManagerDialog.this.dispose();
                }
            });
            ok.setMnemonic(MinerApp.getText("NodeDialog_okHotkey").charAt(0));
            JButton cancel = new JButton(new AbstractAction(MinerApp.getText("NodeDialog_cancel")){

                public void actionPerformed(ActionEvent e) {
                    OpenFrameManagerDialog.this.dispose();
                }
            });
            cancel.setMnemonic(MinerApp.getText("NodeDialog_cancelHotkey").charAt(0));
            JButton help = new JButton(new AbstractAction(MinerApp.getText("NodeDialog_help")){

                public void actionPerformed(ActionEvent e) {
                    MinerApp.getHelpManager().showTopic("Window Manager");
                }
            });
            help.setMnemonic(MinerApp.getText("NodeDialog_helpHotkey").charAt(0));
            JPanel tablePanel = new JPanel(new GridBagLayout());
            tablePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ModifiableViewerFrame_windowsToClose")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            tablePanel.add((Component)scrollingTable, gbc);
            JPanel buttonsPanel = new JPanel();
            buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
            buttonsPanel.add(Box.createHorizontalGlue());
            buttonsPanel.add(ok);
            buttonsPanel.add(Box.createHorizontalStrut(5));
            buttonsPanel.add(cancel);
            buttonsPanel.add(Box.createHorizontalStrut(5));
            buttonsPanel.add(help);
            Container cont = this.getContentPane();
            cont.setLayout(new GridBagLayout());
            gbc.fill = 1;
            gbc.gridy = 0;
            cont.add((Component)tablePanel, gbc);
            gbc.fill = 2;
            ++gbc.gridy;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(10, 0, 5, 0);
            cont.add((Component)buttonsPanel, gbc);
            this.setSize(550, 300);
            this.setLocationRelativeTo(MinerApp.getMainFrame());
        }

        private class BooleanRenderer
        implements TableCellRenderer {
            private JCheckBox rend = new JCheckBox();

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value == null || !(value instanceof Boolean)) {
                    return null;
                }
                this.rend.setSelected((Boolean)value);
                return this.rend;
            }
        }

        private class FrameTableModel
        extends DefaultTableModel {
            private FrameTableModel() {
            }

            public void setValueAt(Object aValue, int row, int column) {
                Vector rowVector = (Vector)this.dataVector.elementAt(row);
                rowVector.setElementAt(aValue, column);
            }

            public boolean isCellEditable(int row, int column) {
                return column == 0;
            }

            public void clearTable() {
                this.dataVector.removeAllElements();
                this.fireTableDataChanged();
            }
        }
    }
}

