/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class MultiLineDocument
extends PlainDocument {
    public static final int m_lineWidth = 20;
    protected boolean m_useWidth = false;
    protected JTextComponent m_textc;
    protected boolean m_lock;
    protected boolean m_deletePressed = false;
    protected boolean m_backspacePressed = false;

    public MultiLineDocument(JTextComponent component) {
        this(component, false);
    }

    public MultiLineDocument(JTextComponent component, boolean useLimit) {
        this.m_useWidth = useLimit;
        this.m_textc = component;
        this.m_lock = false;
        this.m_textc.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                MultiLineDocument.this.m_deletePressed = e.getKeyCode() == 127;
                MultiLineDocument.this.m_backspacePressed = e.getKeyCode() == 8;
            }
        });
    }

    public void insertString(int offset, String text, AttributeSet attrs) throws BadLocationException {
        if (text.equals("\n")) {
            return;
        }
        String pre = this.getText(0, offset);
        String post = this.getText(offset, this.getLength() - offset);
        String full = pre + text + post;
        String formatted = MultiLineDocument.formatString(full, this.m_useWidth);
        if (!formatted.equals(full)) {
            super.remove(0, pre.length() + post.length());
            super.insertString(0, formatted, attrs);
        } else {
            super.insertString(offset, text, attrs);
        }
        if (!this.m_lock) {
            this.resizeComponent();
        }
        this.moveCaret(formatted, pre.replaceAll("\n", ""), text.replaceAll("\n", ""));
    }

    public void remove(int offset, int length) throws BadLocationException {
        String rem;
        int start = 0;
        int caretPos = this.m_textc.getCaretPosition() - 1;
        if (this.m_deletePressed) {
            ++caretPos;
        }
        if ((rem = this.getText(offset, length)).equals("\n")) {
            if (this.m_deletePressed) {
                ++offset;
            } else if (this.m_backspacePressed) {
                --caretPos;
                --offset;
            }
        }
        String pre = this.getText(start, offset);
        String post = this.getText(start += offset + length, this.getLength() - start);
        String full = pre + post;
        String formatted = MultiLineDocument.formatString(full, this.m_useWidth);
        if (!formatted.equals(full)) {
            super.remove(0, pre.length() + post.length() + rem.length());
            super.insertString(0, formatted, null);
            this.moveCaret(formatted, pre.replaceAll("\n", ""), "");
        } else {
            super.remove(offset, length);
        }
        if (!this.m_lock) {
            this.resizeComponent();
        }
    }

    public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        this.m_lock = true;
        super.replace(offset, length, text, attrs);
        this.resizeComponent();
        this.m_lock = false;
    }

    public void resizeComponent() {
        JTextComponent jtc = this.m_textc;
        if (jtc != null) {
            Dimension oldSize = jtc.getSize();
            Dimension newSize = null;
            if (jtc instanceof JTextArea) {
                JTextArea area = new JTextArea();
                area.setFont(jtc.getFont());
                area.setText(jtc.getText());
                newSize = area.getPreferredSize();
            } else {
                JTextField area = new JTextField();
                area.setFont(jtc.getFont());
                area.setText(jtc.getText());
                newSize = area.getPreferredSize();
            }
            if (newSize.width != oldSize.width || newSize.height != oldSize.height) {
                jtc.setSize(newSize);
            }
        }
    }

    private void moveCaret(String formatted, String pre, String text) {
        int pLength = pre.length();
        int tLength = text.length();
        int f = 0;
        int p = 0;
        while (p < pLength) {
            if (formatted.charAt(f++) != pre.charAt(p)) continue;
            ++p;
        }
        int t = 0;
        while (t < tLength) {
            if (formatted.charAt(f++) != text.charAt(t)) continue;
            ++t;
        }
        this.m_textc.setCaretPosition(f);
    }

    public static String formatString(String text, boolean useWidth) {
        if (!useWidth || text.length() < 20) {
            return text;
        }
        String full = text.replaceAll("\n", "");
        StringBuffer buff = new StringBuffer();
        int iStart = 0;
        int iSpace = -1;
        int i = 0;
        int lngth = 0;
        while (i < full.length()) {
            char iChar = full.charAt(i);
            if (iChar == ' ') {
                iSpace = i;
            }
            if (lngth != 0 && lngth % 20 == 0) {
                if (iSpace > -1) {
                    buff.append(full.substring(iStart, iSpace + 1) + "\n");
                    iStart = iSpace + 1;
                    lngth = i - iStart;
                    iSpace = -1;
                } else {
                    buff.append(full.substring(iStart, i) + "\n");
                    iStart = i;
                    lngth = 0;
                }
            }
            ++i;
            ++lngth;
        }
        if (iStart < full.length()) {
            buff.append(full.substring(iStart));
        }
        return buff.toString();
    }
}

