/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.NormalizeEngineNode;
import com.insightful.miner.SelectColumnsPanel;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class NormalizeDialog
extends NodeDialog {
    private SelectColumnsPanel selectColumnsPanel;
    private JRadioButton[] centerRadioButtons;
    private String[] centerTypes = new String[]{NormalizeEngineNode.NONE_ATTRIBUTE_TAG, NormalizeEngineNode.MEAN_ATTRIBUTE_TAG, NormalizeEngineNode.MEDIAN_ATTRIBUTE_TAG};
    private JRadioButton[] scaleRadioButtons;
    private String[] scaleTypes = new String[]{NormalizeEngineNode.NONE_ATTRIBUTE_TAG, NormalizeEngineNode.RANGE_ATTRIBUTE_TAG, NormalizeEngineNode.STD_DEV_ATTRIBUTE_TAG};
    private JTextField m_kValTextField;
    private static NormalizeDialog instance = null;

    public static NormalizeDialog getInstance() {
        if (instance == null) {
            instance = new NormalizeDialog();
        }
        return instance;
    }

    private NormalizeDialog() {
        this.setResizable(true);
        this.setSize(500, 450);
        this.setMinimumSize(new Dimension(500, 450));
    }

    public void restoreProperties() {
        super.restoreProperties();
        this.selectColumnsPanel.restoreProperties(this.getNodeModel());
        XTProps props = this.getNodeModel().getXTProps();
        String centerMethod = props.getValue(NormalizeEngineNode.CENTER_METHOD_ATTRIBUTE_TAG, NormalizeEngineNode.CENTER_METHOD_DEFAULT);
        for (int i = 0; i < this.centerTypes.length; ++i) {
            if (!centerMethod.equals(this.centerTypes[i])) continue;
            this.centerRadioButtons[i].setSelected(true);
            break;
        }
        String scaleMethod = props.getValue(NormalizeEngineNode.SCALE_ATTRIBUTE_TAG, NormalizeEngineNode.SCALE_METHOD_DEFAULT);
        for (int i = 0; i < this.scaleTypes.length; ++i) {
            if (!scaleMethod.equals(this.scaleTypes[i])) continue;
            this.scaleRadioButtons[i].setSelected(true);
            break;
        }
        this.m_kValTextField.setText(props.getValue(NormalizeEngineNode.K_VALUE_ATTRIBUTE_TAG, Integer.toString(NormalizeEngineNode.DEFAULT_K_VALUE)));
        this.enableKVal();
    }

    public void saveProperties() throws NodeDialog.DialogException {
        int i;
        super.saveProperties();
        this.selectColumnsPanel.saveProperties(this.getNodeModel());
        XTProps props = this.getNodeModel().getXTProps();
        for (i = 0; i < this.centerRadioButtons.length; ++i) {
            if (!this.centerRadioButtons[i].isSelected()) continue;
            props.set(NormalizeEngineNode.CENTER_METHOD_ATTRIBUTE_TAG, this.centerTypes[i]);
        }
        for (i = 0; i < this.scaleRadioButtons.length; ++i) {
            if (!this.scaleRadioButtons[i].isSelected()) continue;
            props.set(NormalizeEngineNode.SCALE_ATTRIBUTE_TAG, this.scaleTypes[i]);
        }
        String str = this.m_kValTextField.getText();
        if (str.length() > 0) {
            props.set(NormalizeEngineNode.K_VALUE_ATTRIBUTE_TAG, str);
        }
    }

    public JPanel createOptionsPanel() {
        this.selectColumnsPanel = new SelectColumnsPanel(this.okAction);
        this.selectColumnsPanel.setExcludedColumnType(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG);
        this.selectColumnsPanel.setExcludedColumnType(XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG);
        this.selectColumnsPanel.setExcludedColumnType(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG);
        this.selectColumnsPanel.setExcludedColumnType(XTMetaData.BLOB_TYPE_ATTRIBUTE_TAG);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.selectColumnsPanel, "Center");
        panel.add((Component)this.getOptionsPanel(), "South");
        return panel;
    }

    private void enableKVal() {
        boolean enabled = this.centerRadioButtons[2].isSelected();
        this.m_kValTextField.setEnabled(enabled);
        this.m_kValTextField.setEditable(enabled);
    }

    private JPanel getOptionsPanel() {
        ButtonGroup centerGroup = new ButtonGroup();
        this.centerRadioButtons = new JRadioButton[3];
        JRadioButton noneRadioButton = new JRadioButton(MinerApp.getText("NormalizeDialog_none"));
        noneRadioButton.setMnemonic(MinerApp.getText("NormalizeDialog_noneHotkey").charAt(0));
        centerGroup.add(noneRadioButton);
        this.centerRadioButtons[0] = noneRadioButton;
        JRadioButton meanRadioButton = new JRadioButton(MinerApp.getText("NormalizeDialog_mean"));
        meanRadioButton.setMnemonic(MinerApp.getText("NormalizeDialog_meanHotkey").charAt(0));
        centerGroup.add(meanRadioButton);
        this.centerRadioButtons[1] = meanRadioButton;
        JRadioButton medianRadioButton = new JRadioButton(MinerApp.getText("NormalizeDialog_median"));
        medianRadioButton.setMnemonic(MinerApp.getText("NormalizeDialog_medianHotkey").charAt(0));
        centerGroup.add(medianRadioButton);
        this.centerRadioButtons[2] = medianRadioButton;
        this.m_kValTextField = new JTextField(10);
        this.m_kValTextField.setDocument(new NodeDialog.InputIntegerDoc());
        JLabel kValLabel = new JLabel(MinerApp.getText("NormalizeDialog_kValue"));
        kValLabel.setDisplayedMnemonic(MinerApp.getText("NormalizeDialog_kValueHotkey").charAt(0));
        kValLabel.setLabelFor(this.m_kValTextField);
        for (int i = 0; i < this.centerRadioButtons.length; ++i) {
            this.centerRadioButtons[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NormalizeDialog.this.enableKVal();
                }
            });
        }
        JPanel centerPanel = new JPanel(new GridBagLayout());
        centerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("NormalizeDialog_center")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        centerPanel.add((Component)noneRadioButton, gbc);
        ++gbc.gridy;
        centerPanel.add((Component)meanRadioButton, gbc);
        ++gbc.gridy;
        centerPanel.add((Component)medianRadioButton, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 25, 0, 0);
        centerPanel.add((Component)kValLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        centerPanel.add((Component)this.m_kValTextField, gbc);
        JPanel scalePanel = new JPanel(new GridBagLayout());
        scalePanel.setLayout(new BoxLayout(scalePanel, 1));
        scalePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("NormalizeDialog_scale")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        ButtonGroup scaleGroup = new ButtonGroup();
        this.scaleRadioButtons = new JRadioButton[3];
        JRadioButton scaleNoneRadioButton = new JRadioButton(MinerApp.getText("NormalizeDialog_none"));
        scaleNoneRadioButton.setMnemonic(MinerApp.getText("NormalizeDialog_scaleNoneHotkey").charAt(0));
        scaleGroup.add(scaleNoneRadioButton);
        this.scaleRadioButtons[0] = scaleNoneRadioButton;
        JRadioButton rangeRadioButton = new JRadioButton(MinerApp.getText("NormalizeDialog_range"));
        rangeRadioButton.setMnemonic(MinerApp.getText("NormalizeDialog_rangeHotkey").charAt(0));
        scaleGroup.add(rangeRadioButton);
        this.scaleRadioButtons[1] = rangeRadioButton;
        JRadioButton stdDevRadioButton = new JRadioButton(MinerApp.getText("NormalizeDialog_stdDev"));
        stdDevRadioButton.setMnemonic('t');
        scaleGroup.add(stdDevRadioButton);
        this.scaleRadioButtons[2] = stdDevRadioButton;
        scalePanel.add(scaleNoneRadioButton);
        scalePanel.add(rangeRadioButton);
        scalePanel.add(stdDevRadioButton);
        scalePanel.add(Box.createGlue());
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        optionsPanel.setLayout(new GridLayout(1, 2));
        optionsPanel.add(centerPanel);
        optionsPanel.add(scalePanel);
        return optionsPanel;
    }
}

