/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcOutlier;
import com.insightful.miner.EngineNode;
import com.insightful.miner.XTMetaData;
import java.util.Vector;

public class OutlierDetectionEngineNode
extends EngineNode {
    public static String SELECTED_COLUMNS_ATTRIBUTE_TAG = "selectedColumns";
    public static String FACTOR_COLUMN_ATTRIBUTE_TAG = "factorColumn";
    public static String OUTPUT_OUTLIER_DISTANCE_ATTRIBUTE_TAG = "outlierDistance";
    public static String OUTPUT_OUTLIER_INDEX_ATTRIBUTE_TAG = "outlierIndex";
    public static String OUTPUT_OUTLIER_STATE_ATTRIBUTE_TAG = "outlierState";
    public static String OUTLIER_DISTANCE_THRESHOLD_ATTRIBUTE_TAG = "outlierDistanceThreshold";
    public static String OUTPUT_ROWS_ATTRIBUTE_TAG = "outputRows";
    public static String ALL_ROWS_ATTRIBUTE_TAG = "allRows";
    public static String NON_OUTLIER_ROWS_ATTRIBUTE_TAG = "nonOutlierRows";
    public static String OUTLIER_ROWS_ATTRIBUTE_TAG = "outlierRows";
    public static String OUTPUT_COPY_INPUTS_ATTRIBUTE_TAG = "copyInputs";

    public boolean hasCNKProc() {
        return true;
    }

    public boolean hasDataCacheProc() {
        return false;
    }

    public CNKProc procCreate() throws Exception {
        String factorColumn = this.getFactorColumn();
        Vector selectedColumns = this.getSelectedColumns();
        XTMetaData md = this.getInputMetaData(0);
        boolean outputDistance = this.getOutputDistance();
        boolean outputIndex = this.getOutputIndex();
        boolean output = this.getOutputFlag();
        if (outputDistance && md.nameToOrdinal("OUTLIER.DISTANCE") != -1) {
            this.printlnError("Attempting to create an output column name (OUTLIER.DISTANCE) that already exists in the input.");
        }
        if (outputIndex && md.nameToOrdinal("OUTLIER.INDEX") != -1) {
            this.printlnError("Attempting to create an output column name (OUTLIER.INDEX) that already exists in the input.");
        }
        if (output && md.nameToOrdinal("OUTLIER.STATE") != -1) {
            this.printlnError("Attempting to create an output column name (OUTLIER.STATE) that already exists in the input.");
        }
        if (selectedColumns.size() < 1) {
            throw new Exception("can't run because no continuous columns");
        }
        if (this.getSelectedColumns(false).size() < 1) {
            this.printlnInformation(this.getNodeName() + ": no columns selected, so using all " + selectedColumns.size() + " continuous input columns");
        }
        if (factorColumn != null) {
            this.printlnInformation(this.getNodeName() + ": using categorical column " + factorColumn);
        }
        CNKProcOutlier proc = new CNKProcOutlier();
        proc.setThreshold(this.getThreshold());
        proc.setOutputDistance(outputDistance);
        proc.setOutputIndex(outputIndex);
        proc.setOutputFlag(output);
        proc.setOutputWhichRows(this.getOutputWhichRows());
        proc.setCopyInputs(this.getCopyInputs());
        if (factorColumn == null || md.nameToOrdinal(factorColumn) < 0) {
            proc.setFactorColumn(-1, 1);
        } else {
            int factorColumnNum = md.nameToOrdinal(factorColumn);
            Vector factorLevels = md.getCategoricalDataFieldLevels(factorColumn);
            proc.setFactorColumn(factorColumnNum, factorLevels.size());
        }
        proc.clearCalcColumns();
        for (int i = 0; i < selectedColumns.size(); ++i) {
            String varName = (String)selectedColumns.get(i);
            int colNum = md.nameToOrdinal(varName);
            if (colNum >= 0) {
                proc.defineCalcColumn(colNum);
                continue;
            }
            this.printlnWarning(this.getNodeName() + ": bad column name: " + varName);
        }
        return proc;
    }

    private Vector getSelectedColumns() {
        return this.getSelectedColumns(true);
    }

    private Vector getSelectedColumns(boolean getAllByDefault) {
        Vector selectedVars = this.getNodeProperties().getSubProperties(SELECTED_COLUMNS_ATTRIBUTE_TAG);
        if (getAllByDefault && selectedVars.size() < 1) {
            selectedVars = this.getInputMetaData(0).getDataFieldsWithType(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG);
        }
        return selectedVars;
    }

    private String getFactorColumn() {
        String factorVar = this.getNodeProperties().getValue(FACTOR_COLUMN_ATTRIBUTE_TAG, null);
        if (factorVar != null && factorVar.length() > 0) {
            return factorVar;
        }
        return null;
    }

    private String getOutputWhichRows() {
        String whichRows = this.getNodeProperties().getValue(OUTPUT_ROWS_ATTRIBUTE_TAG, ALL_ROWS_ATTRIBUTE_TAG);
        if (whichRows.equals(OUTLIER_ROWS_ATTRIBUTE_TAG)) {
            return "outliers";
        }
        if (whichRows.equals(NON_OUTLIER_ROWS_ATTRIBUTE_TAG)) {
            return "non.outliers";
        }
        return "all";
    }

    private boolean getOutputDistance() {
        boolean showIt = this.getNodeProperties().getBoolean(OUTPUT_OUTLIER_DISTANCE_ATTRIBUTE_TAG, true);
        return showIt;
    }

    private boolean getOutputIndex() {
        boolean showIt = this.getNodeProperties().getBoolean(OUTPUT_OUTLIER_INDEX_ATTRIBUTE_TAG, true);
        return showIt;
    }

    private boolean getOutputFlag() {
        boolean showIt = this.getNodeProperties().getBoolean(OUTPUT_OUTLIER_STATE_ATTRIBUTE_TAG, true);
        return showIt;
    }

    private boolean getCopyInputs() {
        boolean showIt = this.getNodeProperties().getBoolean(OUTPUT_COPY_INPUTS_ATTRIBUTE_TAG, true);
        return showIt;
    }

    private double getThreshold() {
        double val = this.getNodeProperties().getDouble(OUTLIER_DISTANCE_THRESHOLD_ATTRIBUTE_TAG, 0.95);
        if (val <= 0.0) {
            val = 0.001;
        } else if (val >= 1.0) {
            val = 0.99;
        }
        return val;
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        XTMetaData md = null;
        try {
            md = this.getCopyInputs() ? (XTMetaData)this.getInputMetaData(0).clone() : new XTMetaData();
            if (this.getOutputDistance()) {
                md.appendContinousDataField("OUTLIER.DISTANCE");
            }
            if (this.getOutputIndex()) {
                md.appendContinousDataField("OUTLIER.INDEX");
            }
            if (this.getOutputFlag()) {
                md.appendCategoricalDataField("OUTLIER.STATE", new String[]{"no", "yes"});
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return md;
    }
}

