/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AppAction;
import com.insightful.miner.MinerApp;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.MatteBorder;

public class PrintPreview
extends JFrame {
    protected int m_wPage;
    protected int m_hPage;
    protected int m_orientation;
    protected Printable m_target;
    protected JComboBox m_cbScale;
    protected PreviewContainer m_preview;
    protected JComponent m_rootFocus;

    public PrintPreview(Printable target) {
        this(target, null);
    }

    public PrintPreview(Printable target, JComponent rootFocus) {
        this(target, "Print Preview", MinerApp.getMainFrame() != null ? MinerApp.getMainFrame().getIconImage() : null, MinerApp.getDefaultPageFormat().getOrientation(), rootFocus);
    }

    public PrintPreview(Printable target, String title, Image icon, int orientation) {
        this(target, title, icon, orientation, null);
    }

    public PrintPreview(Printable target, String title, Image icon, int orientation, JComponent rootFocus) {
        super(title);
        if (icon != null) {
            this.setIconImage(icon);
        }
        Dimension screenSize = this.getToolkit().getScreenSize();
        this.setLocation((screenSize.width - 400) / 2, (screenSize.height - 550) / 2);
        this.setSize(400, 550);
        this.getContentPane().setLayout(new BorderLayout());
        this.m_target = target;
        this.m_orientation = orientation;
        this.m_rootFocus = rootFocus;
        JToolBar tb = new JToolBar();
        AppAction print = new AppAction("Print", MinerApp.getResourceManager().getIcon("print.gif")){

            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.runPrintThread();
            }

            public boolean canAct() {
                return true;
            }
        };
        AppAction printSetup = new AppAction("Print Setup", MinerApp.getResourceManager().getIcon("properties.gif")){

            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.runPageSetupThread();
            }

            public boolean canAct() {
                return true;
            }
        };
        AppAction close = new AppAction("Close", MinerApp.getResourceManager().getIcon("delete.gif")){

            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.setVisible(false);
                PrintPreview.this.dispose();
            }

            public boolean canAct() {
                return true;
            }
        };
        tb.registerKeyboardAction(close, KeyStroke.getKeyStroke("ESCAPE"), 2);
        tb.add(MinerApp.newButton(print));
        tb.add(MinerApp.newButton(printSetup));
        tb.addSeparator();
        tb.add(MinerApp.newButton(close));
        tb.addSeparator();
        String[] scales = new String[]{"10 %", "25 %", "50 %", "100 %"};
        this.m_cbScale = new JComboBox<String>(scales);
        this.m_cbScale.setSelectedIndex(2);
        ActionListener lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread runner = new Thread(){

                    public void run() {
                        String str = PrintPreview.this.m_cbScale.getSelectedItem().toString();
                        if (str.endsWith("%")) {
                            str = str.substring(0, str.length() - 1);
                        }
                        str = str.trim();
                        int scale = 0;
                        try {
                            scale = Integer.parseInt(str);
                        }
                        catch (NumberFormatException ex) {
                            return;
                        }
                        int w = PrintPreview.this.m_wPage * scale / 100;
                        int h = PrintPreview.this.m_hPage * scale / 100;
                        Component[] comps = PrintPreview.this.m_preview.getComponents();
                        for (int k = 0; k < comps.length; ++k) {
                            if (!(comps[k] instanceof PagePreview)) continue;
                            PagePreview pp = (PagePreview)comps[k];
                            pp.setScaledSize(w, h);
                        }
                        PrintPreview.this.m_preview.doLayout();
                        PrintPreview.this.m_preview.getParent().getParent().validate();
                    }
                };
                runner.start();
            }
        };
        this.m_cbScale.addActionListener(lst);
        this.m_cbScale.setMaximumSize(this.m_cbScale.getPreferredSize());
        this.m_cbScale.setEditable(true);
        tb.addSeparator();
        tb.add(this.m_cbScale);
        this.getContentPane().add((Component)tb, "North");
        this.m_preview = new PreviewContainer();
        this.initPreview();
        JScrollPane scrollPane = new JScrollPane(this.m_preview);
        this.getContentPane().add((Component)scrollPane, "Center");
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    private void runPrintThread() {
        new PrintThread(this).start();
    }

    private void runPageSetupThread() {
        new PageSetupThread(this).start();
    }

    private void initPreview() {
        this.m_preview.removeAll();
        PrinterJob prnJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = prnJob.validatePage(MinerApp.getDefaultPageFormat());
        if (pageFormat.getHeight() == 0.0 || pageFormat.getWidth() == 0.0) {
            System.err.println("Unable to determine default page size");
            return;
        }
        this.m_wPage = (int)pageFormat.getWidth();
        this.m_hPage = (int)pageFormat.getHeight();
        String str = this.m_cbScale.getSelectedItem().toString();
        if (str.endsWith("%")) {
            str = str.substring(0, str.length() - 1);
        }
        str = str.trim();
        int scale = Integer.parseInt(str);
        int w = this.m_wPage * scale / 100;
        int h = this.m_hPage * scale / 100;
        int pageIndex = 0;
        try {
            while (true) {
                BufferedImage img = new BufferedImage(this.m_wPage, this.m_hPage, 1);
                Graphics g = img.getGraphics();
                g.setColor(Color.white);
                g.fillRect(0, 0, this.m_wPage, this.m_hPage);
                if (this.m_target.print(g, pageFormat, pageIndex) == 0) {
                    PagePreview pp = new PagePreview(w, h, img);
                    this.m_preview.add(pp);
                    ++pageIndex;
                    continue;
                }
                break;
            }
        }
        catch (PrinterException e) {
            e.printStackTrace();
            System.err.println("Printing error: " + e.toString());
        }
        this.setSize(this.getWidth() + 1, this.getHeight() + 1);
        this.setSize(this.getWidth() - 1, this.getHeight() - 1);
    }

    class PagePreview
    extends JPanel {
        protected int m_w;
        protected int m_h;
        protected Image m_source;
        protected Image m_img;

        public PagePreview(int w, int h, Image source) {
            this.m_w = w;
            this.m_h = h;
            this.m_source = source;
            this.m_img = this.m_source.getScaledInstance(this.m_w, this.m_h, 4);
            this.m_img.flush();
            this.setBackground(Color.white);
            this.setBorder(new MatteBorder(1, 1, 2, 2, Color.black));
        }

        public void setScaledSize(int w, int h) {
            this.m_w = w;
            this.m_h = h;
            this.m_img = this.m_source.getScaledInstance(this.m_w, this.m_h, 4);
            this.repaint();
        }

        public Dimension getPreferredSize() {
            Insets ins = this.getInsets();
            return new Dimension(this.m_w + ins.left + ins.right, this.m_h + ins.top + ins.bottom);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(this.m_img, 0, 0, this);
            this.paintBorder(g);
        }
    }

    class PreviewContainer
    extends JPanel {
        protected int H_GAP = 16;
        protected int V_GAP = 10;

        PreviewContainer() {
        }

        public Dimension getPreferredSize() {
            int n = this.getComponentCount();
            if (n == 0) {
                return new Dimension(this.H_GAP, this.V_GAP);
            }
            Component comp = this.getComponent(0);
            Dimension dc = comp.getPreferredSize();
            int w = dc.width;
            int h = dc.height;
            Dimension dp = this.getParent().getSize();
            int nCol = Math.max((dp.width - this.H_GAP) / (w + this.H_GAP), 1);
            int nRow = n / nCol;
            if (nRow * nCol < n) {
                ++nRow;
            }
            int ww = nCol * (w + this.H_GAP) + this.H_GAP;
            int hh = nRow * (h + this.V_GAP) + this.V_GAP;
            Insets ins = this.getInsets();
            return new Dimension(ww + ins.left + ins.right, hh + ins.top + ins.bottom);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void doLayout() {
            Insets ins = this.getInsets();
            int x = ins.left + this.H_GAP;
            int y = ins.top + this.V_GAP;
            int n = this.getComponentCount();
            if (n == 0) {
                return;
            }
            Component comp = this.getComponent(0);
            Dimension dc = comp.getPreferredSize();
            int w = dc.width;
            int h = dc.height;
            Dimension dp = this.getParent().getSize();
            int nCol = Math.max((dp.width - this.H_GAP) / (w + this.H_GAP), 1);
            int nRow = n / nCol;
            if (nRow * nCol < n) {
                ++nRow;
            }
            int index = 0;
            for (int k = 0; k < nRow; ++k) {
                for (int m = 0; m < nCol; ++m) {
                    if (index >= n) {
                        return;
                    }
                    comp = this.getComponent(index++);
                    comp.setBounds(x, y, w, h);
                    x += w + this.H_GAP;
                }
                y += h + this.V_GAP;
                x = ins.left + this.H_GAP;
            }
        }
    }

    class PageSetupThread
    extends Thread {
        private PrintPreview instance = null;

        public PageSetupThread(PrintPreview pp) {
            this.instance = pp;
        }

        public void run() {
            PrinterJob job = PrinterJob.getPrinterJob();
            MinerApp.setDefaultPageFormat(job.pageDialog(MinerApp.getPrintAttributeSet()));
            this.instance.initPreview();
            if (MinerApp.getMainFrame() != null) {
                MinerApp.getMainFrame().requestFocus();
            }
            if (PrintPreview.this.m_rootFocus != null) {
                PrintPreview.this.m_rootFocus.requestFocus();
            }
            this.instance.requestFocus();
        }
    }

    class PrintThread
    extends Thread {
        private JRootPane instance = null;

        public PrintThread(PrintPreview pp) {
            this.instance = pp.getRootPane();
        }

        public void run() {
            boolean wasDblBuff = this.instance.isDoubleBuffered();
            this.instance.setDoubleBuffered(false);
            PrinterJob prnJob = PrinterJob.getPrinterJob();
            PageFormat pageFormat = prnJob.validatePage(MinerApp.getDefaultPageFormat());
            prnJob.setPrintable(PrintPreview.this.m_target, pageFormat);
            if (prnJob.printDialog(MinerApp.getPrintAttributeSet())) {
                new MinerApp.GenericPrintThread(prnJob).start();
            }
            this.instance.setDoubleBuffered(wasDblBuff);
            if (MinerApp.getMainFrame() != null) {
                MinerApp.getMainFrame().requestFocus();
            }
            if (PrintPreview.this.m_rootFocus != null) {
                PrintPreview.this.m_rootFocus.requestFocus();
            }
            this.instance.requestFocus();
        }
    }
}

