/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.MessagePaneTransferHandler;
import com.insightful.miner.MinerApp;
import com.insightful.miner.WideFileChooser;
import com.insightful.splus.SaveAsable;
import com.insightful.splus.SplusOutputHandler;
import com.insightful.splus.SplusPrintable;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.TextPrinter;
import com.insightful.splus.util.FileUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.print.PageFormat;
import java.io.File;
import java.io.FileOutputStream;
import java.rmi.RemoteException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class TextOutputScrollPane
extends JScrollPane
implements SplusOutputHandler,
SplusPrintable,
SaveAsable {
    private int m_uninitialized = 0;
    private int MAX_TEXT_ROWS = 2048;
    private int MAX_TEXT_INC = 200;
    private int m_lineCount = 0;
    private static Style m_def = StyleContext.getDefaultStyleContext().getStyle("default");
    public JTextPane m_textArea = new JTextPane();
    private JTextPane m_iconArea = new JTextPane();
    private TextPrinter m_printer;

    public TextOutputScrollPane() {
        this.m_textArea.setFont(new Font("Monospaced", 0, 12));
        this.m_iconArea.setFont(new Font("Monospaced", 0, 12));
        this.m_textArea.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                TextOutputScrollPane.this.m_textArea.getCaret().setVisible(true);
            }

            public void focusLost(FocusEvent e) {
                TextOutputScrollPane.this.m_textArea.getCaret().setVisible(false);
            }
        });
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(30);
        Insets insets = this.getInsets();
        this.getVerticalScrollBar().setUnitIncrement(insets.bottom + insets.top + this.getFont().getSize());
        this.getHorizontalScrollBar().setUnitIncrement(10);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.m_iconArea, "West");
        panel.add((Component)this.m_textArea, "Center");
        this.setViewportView(panel);
        this.m_textArea.setTransferHandler(new MessagePaneTransferHandler());
    }

    public void clearPane() {
        try {
            Document doc = this.m_textArea.getDocument();
            Document icon_doc = this.m_iconArea.getDocument();
            doc.remove(0, doc.getLength());
            icon_doc.remove(0, icon_doc.getLength());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_lineCount = 0;
    }

    public synchronized void append(String str, int severity) {
        if (this.m_uninitialized++ == 0 && MinerApp.isSplusLicensed()) {
            return;
        }
        this.m_printer = null;
        try {
            int index = 0;
            int numCR = 0;
            while (index >= 0) {
                if ((index = str.indexOf("\n", index)) < 0) continue;
                ++numCR;
                ++index;
            }
            this.m_lineCount += numCR;
            Document doc = this.m_textArea.getDocument();
            Document icon_doc = this.m_iconArea.getDocument();
            if (numCR > 0) {
                StringBuffer iconStringToAppend = new StringBuffer();
                switch (severity) {
                    case 4: {
                        StyleConstants.setForeground(m_def, Color.red);
                        iconStringToAppend.append("!!!\n");
                        break;
                    }
                    case 3: {
                        StyleConstants.setForeground(m_def, Color.orange);
                        iconStringToAppend.append("???\n");
                        break;
                    }
                    default: {
                        iconStringToAppend.append("   \n");
                    }
                }
                for (int i = 1; i < numCR; ++i) {
                    iconStringToAppend.append("   \n");
                }
                icon_doc.insertString(icon_doc.getLength(), iconStringToAppend.toString(), m_def);
            }
            StyleConstants.setForeground(m_def, Color.black);
            doc.insertString(doc.getLength(), str, m_def);
            int numRowsToDelete = this.m_lineCount - this.MAX_TEXT_ROWS;
            if (numRowsToDelete > 0) {
                int numRowsDeleted;
                numRowsToDelete += this.MAX_TEXT_INC;
                String text = this.m_textArea.getText();
                String icon = this.m_iconArea.getText();
                int endTextRemSel = 0;
                int endIconRemSel = 0;
                for (numRowsDeleted = 0; numRowsDeleted < numRowsToDelete; ++numRowsDeleted) {
                    int newEndTextRemSel = text.indexOf("\n", endTextRemSel);
                    int newEndIconRemSel = icon.indexOf("\n", endIconRemSel);
                    if (newEndTextRemSel != -1 || newEndIconRemSel != -1) break;
                    endTextRemSel = newEndTextRemSel + 1;
                    endIconRemSel = newEndIconRemSel + 1;
                }
                this.m_lineCount -= numRowsDeleted;
                doc.remove(0, endTextRemSel -= numRowsDeleted);
                icon_doc.remove(0, endIconRemSel -= numRowsDeleted);
            }
            this.m_textArea.setCaretPosition(doc.getLength());
            this.m_iconArea.setCaretPosition(icon_doc.getLength());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!this.isVisible()) {
            this.setVisible(true);
        }
    }

    public void write(String data, boolean prompted) throws RemoteException {
        this.append(data, MinerApp.getMessageSeverity());
    }

    public void setEditable(boolean b) {
        this.m_textArea.setEditable(b);
    }

    public boolean isEditable() {
        return this.m_textArea.isEditable();
    }

    public File saveAs(Frame fr, File fiCurrentDirectory) {
        WideFileChooser jfc = new WideFileChooser(fiCurrentDirectory, SplusSystem.getServerFileHandler().getServerFileSystemView());
        jfc.setDialogType(1);
        jfc.setDialogTitle("Save As");
        while (jfc.showSaveDialog(fr) == 0) {
            String fileName = jfc.getSelectedFile().getAbsolutePath();
            if (!FileUtilities.confirmSaveAs((Component)fr, (String)fileName)) continue;
            try {
                FileOutputStream fos = SplusSystem.getServerFileHandler().getServerFileOutputStream(fileName);
                fos.write(this.m_textArea.getText().getBytes());
                fos.close();
            }
            catch (Exception e) {
                AcceleratorOptionPane.showOKDialog(fr, MinerApp.getText("TextOutputScrollPane_msg_problemSavingFile") + "\n" + e.getMessage(), MinerApp.getText("TextOutputScrollPane_msg_fileSaveError"), 2);
            }
            return jfc.getCurrentDirectory();
        }
        return fiCurrentDirectory;
    }

    public void save() {
    }

    public int getNumberOfPages() {
        if (this.m_printer == null) {
            this.m_printer = new TextPrinter(this.m_textArea.getText(), this.m_textArea.getFont());
        }
        return this.m_printer.getNumberOfPages();
    }

    public int print(Graphics g, PageFormat pf, int iPage) {
        if (this.m_printer == null) {
            this.m_printer = new TextPrinter(this.m_textArea.getText(), this.m_textArea.getFont());
        }
        return this.m_printer.print(g, pf, iPage);
    }
}

