/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.DataCacheRowBuf;
import com.insightful.miner.EngineNode;
import com.insightful.miner.SortAndShuffle;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Vector;

public class UniqueEngineNode
extends EngineNode {
    public static String EQUALITY_COLUMNS_ATTRIBUTE_TAG = "equalityColumns";
    public static final String INDEX_COL_NAME = ".im_index_im.";
    protected XTMetaData m_indexedMD = null;
    protected XTMetaData m_sortedMD = null;
    protected XTMetaData m_modifiedMD = null;
    protected XTMetaData m_unsortedMD = null;
    protected File m_indexedFile = null;
    protected File m_sortedFile = null;
    protected File m_modifiedFile = null;
    protected File m_unsortedFile = null;
    protected File m_indexedBlobFile = null;
    protected File m_sortedBlobFile = null;
    protected File m_modifiedBlobFile = null;
    protected File m_unsortedBlobFile = null;
    protected String[] m_equalityColNames = null;
    protected int[] m_equalityColNums = null;
    protected static final int INDEX = 0;
    protected static final int SORT = 1;
    protected static final int MANIP = 2;
    protected static final int UNSORT = 3;
    protected static final int DROP = 4;

    public boolean hasCNKProc() {
        return false;
    }

    public boolean hasDataCacheProc() {
        return true;
    }

    protected void setEqualityColumns(XTProps props, XTMetaData md) {
        Vector eCols = props.getSubProperties(EQUALITY_COLUMNS_ATTRIBUTE_TAG);
        int numCols = eCols.size();
        if (eCols.size() == 0) {
            numCols = md.getNumColumns();
            eCols = md.getColumnNames();
        }
        this.m_equalityColNames = new String[numCols];
        this.m_equalityColNums = new int[numCols];
        for (int i = 0; i < numCols; ++i) {
            this.m_equalityColNames[i] = (String)eCols.get(i);
            this.m_equalityColNums[i] = md.nameToOrdinal(this.m_equalityColNames[i]);
        }
    }

    protected void refreshPropsForCalculateOutputMetaData(XTProps props) {
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        this.refreshPropsForCalculateOutputMetaData(this.getNodeProperties());
        return this.getOutputMD();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeDataCacheProc() throws Exception {
        boolean bl;
        block35: {
            block33: {
                boolean bl2;
                block34: {
                    this.initVars();
                    XTMetaData md = this.getInputMD();
                    XTProps props = this.getNodeProperties();
                    this.setEqualityColumns(props, md);
                    if (this.handleIndex() && this.handleSort() && this.handleRows() && this.handleUnsort() && this.handleOutput()) break block33;
                    bl2 = false;
                    Object var6_6 = null;
                    if (this.m_indexedFile == null) break block34;
                    this.m_indexedFile.delete();
                }
                if (this.m_sortedFile != null) {
                    this.m_sortedFile.delete();
                }
                if (this.m_unsortedFile != null) {
                    this.m_unsortedFile.delete();
                }
                if (this.m_modifiedFile != null) {
                    this.m_modifiedFile.delete();
                }
                if (this.m_indexedBlobFile != null) {
                    this.m_indexedBlobFile.delete();
                }
                if (this.m_sortedBlobFile != null) {
                    this.m_sortedBlobFile.delete();
                }
                if (this.m_unsortedBlobFile != null) {
                    this.m_unsortedBlobFile.delete();
                }
                if (this.m_modifiedBlobFile != null) {
                    this.m_modifiedBlobFile.delete();
                }
                return bl2;
            }
            try {
                bl = true;
                Object var6_7 = null;
                if (this.m_indexedFile == null) break block35;
                this.m_indexedFile.delete();
            }
            catch (Exception e) {
                boolean bl3;
                block36: {
                    try {
                        e.printStackTrace();
                        bl3 = false;
                        Object var6_8 = null;
                        if (this.m_indexedFile == null) break block36;
                        this.m_indexedFile.delete();
                    }
                    catch (Throwable throwable) {
                        block37: {
                            Object var6_9 = null;
                            if (this.m_indexedFile != null) {
                                this.m_indexedFile.delete();
                            }
                            if (this.m_sortedFile != null) {
                                this.m_sortedFile.delete();
                            }
                            if (this.m_unsortedFile != null) {
                                this.m_unsortedFile.delete();
                            }
                            if (this.m_modifiedFile != null) {
                                this.m_modifiedFile.delete();
                            }
                            if (this.m_indexedBlobFile != null) {
                                this.m_indexedBlobFile.delete();
                            }
                            if (this.m_sortedBlobFile != null) {
                                this.m_sortedBlobFile.delete();
                            }
                            if (this.m_unsortedBlobFile != null) {
                                this.m_unsortedBlobFile.delete();
                            }
                            if (this.m_modifiedBlobFile == null) break block37;
                            this.m_modifiedBlobFile.delete();
                        }
                        throw throwable;
                    }
                }
                if (this.m_sortedFile != null) {
                    this.m_sortedFile.delete();
                }
                if (this.m_unsortedFile != null) {
                    this.m_unsortedFile.delete();
                }
                if (this.m_modifiedFile != null) {
                    this.m_modifiedFile.delete();
                }
                if (this.m_indexedBlobFile != null) {
                    this.m_indexedBlobFile.delete();
                }
                if (this.m_sortedBlobFile != null) {
                    this.m_sortedBlobFile.delete();
                }
                if (this.m_unsortedBlobFile != null) {
                    this.m_unsortedBlobFile.delete();
                }
                if (this.m_modifiedBlobFile != null) {
                    this.m_modifiedBlobFile.delete();
                }
                return bl3;
            }
        }
        if (this.m_sortedFile != null) {
            this.m_sortedFile.delete();
        }
        if (this.m_unsortedFile != null) {
            this.m_unsortedFile.delete();
        }
        if (this.m_modifiedFile != null) {
            this.m_modifiedFile.delete();
        }
        if (this.m_indexedBlobFile != null) {
            this.m_indexedBlobFile.delete();
        }
        if (this.m_sortedBlobFile != null) {
            this.m_sortedBlobFile.delete();
        }
        if (this.m_unsortedBlobFile != null) {
            this.m_unsortedBlobFile.delete();
        }
        if (this.m_modifiedBlobFile != null) {
            this.m_modifiedBlobFile.delete();
        }
        return bl;
    }

    protected void initVars() {
        this.m_unsortedMD = null;
        this.m_modifiedMD = null;
        this.m_sortedMD = null;
        this.m_indexedMD = null;
        this.m_unsortedFile = null;
        this.m_modifiedFile = null;
        this.m_sortedFile = null;
        this.m_indexedFile = null;
        this.m_unsortedBlobFile = null;
        this.m_modifiedBlobFile = null;
        this.m_sortedBlobFile = null;
        this.m_indexedBlobFile = null;
        this.m_equalityColNames = null;
        this.m_equalityColNums = null;
    }

    protected boolean fileManipulation(File preFile, File preBlobFile, XTMetaData preMD, File newFile, File newBlobFile, XTMetaData newMD, int function) throws Exception {
        FileInputStream stream = new FileInputStream(preFile);
        BufferedInputStream buffer = new BufferedInputStream(stream);
        DataInputStream inputStream = new DataInputStream(buffer);
        DataCacheRowBuf lastBuf = new DataCacheRowBuf(preMD);
        DataCacheRowBuf buf = new DataCacheRowBuf(preMD);
        RandomAccessFile blobFile = null;
        if (buf.containsBlobs()) {
            blobFile = new RandomAccessFile(preBlobFile, "r");
            buf.setReadBlobFile(blobFile);
        }
        FileOutputStream oStream = new FileOutputStream(newFile.getAbsolutePath());
        BufferedOutputStream oBuffer = new BufferedOutputStream(oStream);
        DataOutputStream outputStream = new DataOutputStream(oBuffer);
        DataCacheRowBuf outputBuf = new DataCacheRowBuf(newMD);
        BufferedOutputStream outBlobFile = null;
        if (outputBuf.containsBlobs()) {
            outBlobFile = new BufferedOutputStream(new FileOutputStream(newBlobFile, false));
            outputBuf.setWriteBlobFile(outBlobFile);
        }
        switch (function) {
            case 0: {
                if (this.index(buf, inputStream, outputBuf, outputStream, preMD, newMD)) break;
                return false;
            }
            case 1: {
                outputStream.close();
                outputStream = null;
                if (this.sort()) break;
                return false;
            }
            case 2: {
                if (this.manip(buf, inputStream, outputBuf, outputStream, preMD, newMD)) break;
                return false;
            }
            case 3: {
                outputStream.close();
                outputStream = null;
                if (this.unsort()) break;
                return false;
            }
            case 4: {
                if (this.drop(buf, inputStream, outputBuf, outputStream, preMD, newMD)) break;
                return false;
            }
        }
        inputStream.close();
        if (outputStream != null) {
            outputStream.flush();
            outputStream.close();
        }
        if (outBlobFile != null) {
            ((OutputStream)outBlobFile).flush();
            ((OutputStream)outBlobFile).close();
        }
        return true;
    }

    protected boolean handleIndex() throws Exception {
        String inputDCF = this.getInputDataCacheFileName(0);
        XTMetaData inputMD = this.getInputMD();
        XTMetaData indexedMD = this.getIndexedMD();
        indexedMD.setNumRows(inputMD.getNumRows());
        this.m_indexedFile = this.createWorkspaceTempFile("index", "tmp");
        this.m_indexedBlobFile = this.createWorkspaceTempFile("index", "tmp");
        return this.fileManipulation(new File(inputDCF), new File(this.getNetworkManager().getInputDataBlobFileName(this.getNodeID(), 0)), inputMD, this.m_indexedFile, this.m_indexedBlobFile, indexedMD, 0);
    }

    protected String getIndexColNameForAddingIndex() {
        return INDEX_COL_NAME;
    }

    protected double getIndexStartVal() {
        return 0.0;
    }

    protected boolean index(DataCacheRowBuf preBuf, DataInput preStream, DataCacheRowBuf newBuf, DataOutput newStream, XTMetaData preMD, XTMetaData newMD) {
        int indexColNum = newMD.nameToOrdinal(this.getIndexColNameForAddingIndex());
        int numColumns = newMD.getNumColumns();
        long numRows = preMD.getNumRows();
        double rowNum = this.getIndexStartVal();
        while (rowNum < (double)numRows + this.getIndexStartVal()) {
            try {
                preBuf.readRow(preStream);
                int decrement = 0;
                for (int i = 0; i < numColumns; ++i) {
                    if (i == indexColNum) {
                        double d = rowNum;
                        rowNum = d + 1.0;
                        newBuf.setDouble(indexColNum, d);
                        decrement = 1;
                        continue;
                    }
                    newBuf.copyColumn(i, i - decrement, preBuf);
                }
                newBuf.writeRow(newStream);
            }
            catch (Exception e) {
                break;
            }
        }
        return true;
    }

    protected boolean handleSort() throws Exception {
        this.m_sortedFile = this.createWorkspaceTempFile("sort", "tmp");
        this.m_sortedBlobFile = this.createWorkspaceTempFile("sort", "tmp");
        return this.fileManipulation(this.m_indexedFile, this.m_indexedBlobFile, this.getIndexedMD(), this.m_sortedFile, this.m_sortedBlobFile, this.getSortedMD(), 1);
    }

    protected boolean sort() throws Exception {
        String[] sortNames = new String[this.m_equalityColNames.length + 1];
        boolean[] ascend = new boolean[this.m_equalityColNames.length + 1];
        boolean[] naTop = new boolean[this.m_equalityColNames.length + 1];
        for (int i = 0; i < this.m_equalityColNames.length; ++i) {
            sortNames[i] = this.m_equalityColNames[i];
            naTop[i] = true;
            ascend[i] = true;
        }
        sortNames[this.m_equalityColNames.length] = this.getIndexColNameForAddingIndex();
        ascend[this.m_equalityColNames.length] = true;
        naTop[this.m_equalityColNames.length] = true;
        return SortAndShuffle.sort(this.m_indexedFile, this.m_sortedFile, this.m_indexedMD, (EngineNode)this, this.getMaxRowsPerBlock(), sortNames, ascend, naTop, true, true);
    }

    protected boolean handleRows() throws Exception {
        this.m_modifiedFile = this.createWorkspaceTempFile("mod", "tmp");
        this.m_modifiedBlobFile = this.createWorkspaceTempFile("mod", "tmp");
        return this.fileManipulation(this.m_sortedFile, this.m_sortedBlobFile, this.getSortedMD(), this.m_modifiedFile, this.m_modifiedBlobFile, this.getModifiedMD(), 2);
    }

    protected boolean manip(DataCacheRowBuf preBuf, DataInput preStream, DataCacheRowBuf newBuf, DataOutput newStream, XTMetaData preMD, XTMetaData newMD) {
        DataCacheRowBuf lastRow = new DataCacheRowBuf(newMD);
        long numRows = preMD.getNumRows();
        long rowsOutput = 0L;
        for (long rowNum = 0L; rowNum < numRows; ++rowNum) {
            try {
                preBuf.readRow(preStream);
                if (rowNum != 0L) {
                    if (!preBuf.isSame(lastRow, this.m_equalityColNums)) {
                        newBuf.copyAllColumns(preBuf);
                        newBuf.writeRow(newStream);
                        ++rowsOutput;
                    }
                } else {
                    newBuf.copyAllColumns(preBuf);
                    newBuf.writeRow(newStream);
                    ++rowsOutput;
                }
                lastRow.copyAllColumns(preBuf);
                continue;
            }
            catch (Exception e) {
                // empty catch block
                break;
            }
        }
        newMD.setNumRows(rowsOutput);
        return true;
    }

    protected boolean handleUnsort() throws Exception {
        this.m_unsortedFile = this.createWorkspaceTempFile("unsort", "tmp");
        this.m_unsortedBlobFile = this.createWorkspaceTempFile("unsort", "tmp");
        this.m_unsortedMD = (XTMetaData)this.m_modifiedMD.clone();
        return this.fileManipulation(this.m_modifiedFile, this.m_modifiedBlobFile, this.getModifiedMD(), this.m_unsortedFile, this.m_unsortedBlobFile, this.getUnsortedMD(), 3);
    }

    protected boolean unsort() throws Exception {
        return SortAndShuffle.sort(this.m_modifiedFile, this.m_unsortedFile, this.m_modifiedMD, (EngineNode)this, this.getMaxRowsPerBlock(), new String[]{INDEX_COL_NAME}, new boolean[]{true}, new boolean[]{true}, true, true);
    }

    protected boolean handleOutput() throws Exception {
        File outputFile = new File(this.getOutputDataCacheFileName(0));
        File outputBlobFile = new File(this.getNetworkManager().getOutputDataBlobFileName(this.getNodeID(), 0));
        XTMetaData outputMD = this.getOutputMD();
        this.setOutputMetaData(0, outputMD);
        return this.fileManipulation(this.m_unsortedFile, this.m_unsortedBlobFile, this.getUnsortedMD(), outputFile, outputBlobFile, outputMD, 4);
    }

    protected boolean drop(DataCacheRowBuf preBuf, DataInput preStream, DataCacheRowBuf newBuf, DataOutput newStream, XTMetaData preMD, XTMetaData newMD) {
        long numRows = preMD.getNumRows();
        int indexColNum = preMD.nameToOrdinal(INDEX_COL_NAME);
        int numColumns = preMD.getNumColumns();
        for (long rowNum = 0L; rowNum < numRows; ++rowNum) {
            try {
                preBuf.readRow(preStream);
                int c = 0;
                for (int i = 0; i < numColumns; ++i) {
                    if (i == indexColNum) continue;
                    newBuf.copyColumn(c++, i, preBuf);
                }
                newBuf.writeRow(newStream);
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        return true;
    }

    protected XTMetaData getInputMD() {
        return this.getInputMetaData(0);
    }

    protected XTMetaData getIndexedMD() {
        if (this.m_indexedMD == null) {
            this.m_indexedMD = (XTMetaData)this.getInputMD().clone();
            this.m_indexedMD.appendContinousDataField(INDEX_COL_NAME);
        }
        return this.m_indexedMD;
    }

    protected XTMetaData getSortedMD() {
        if (this.m_sortedMD == null) {
            this.m_sortedMD = (XTMetaData)this.getIndexedMD().clone();
        }
        return this.m_sortedMD;
    }

    protected XTMetaData getModifiedMD() {
        if (this.m_modifiedMD == null) {
            this.m_modifiedMD = (XTMetaData)this.getSortedMD().clone();
        }
        return this.m_modifiedMD;
    }

    protected XTMetaData getUnsortedMD() {
        if (this.m_unsortedMD == null) {
            this.m_unsortedMD = (XTMetaData)this.getModifiedMD().clone();
        }
        return this.m_unsortedMD;
    }

    protected XTMetaData getOutputMD() {
        XTMetaData md = (XTMetaData)this.getUnsortedMD().clone();
        md.removeDataField(INDEX_COL_NAME);
        return md;
    }
}

