/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.ReadExcelFileDialog;
import com.insightful.miner.ReadOtherFileDialog;
import com.insightful.miner.WriteOtherFileDialog;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class WriteExcelFileDialog
extends WriteOtherFileDialog {
    private JTextField m_worksheetTextField;
    private static String[] m_typeCodeList = new String[]{"EXCEL", "EXCELX"};
    private static String[] m_typeDescriptionList = new String[]{"Microsoft Excel (*.xls)", "Microsoft Excel 2007 (*.xlsx)"};
    private static String[][] m_extensionList = new String[][]{{".xls"}, {".xlsx"}};
    private static WriteExcelFileDialog m_WriteExcelFileDialog = null;

    public static WriteExcelFileDialog getWriteExcelFileDialog() {
        if (m_WriteExcelFileDialog == null) {
            m_WriteExcelFileDialog = new WriteExcelFileDialog();
        }
        return m_WriteExcelFileDialog;
    }

    protected WriteExcelFileDialog() {
        Dimension min = new Dimension(525, 525);
        this.setMinimumSize(min);
        this.setSize(min);
    }

    public void restoreWriteProperties(XTProps props) {
        String worksheet = props.getValue("worksheet");
        this.m_worksheetTextField.setText(worksheet);
        String currentPath = props.getValue("filePath");
        this.fileNameTextField.setText(currentPath);
    }

    public void saveWriteProperties(XTProps props) throws NodeDialog.DialogException {
        String path = this.fileNameTextField.getText();
        WriteOtherFileDialog.directoryCreationCheck(this.tabbedPane, path);
        props.set("filePath", path);
        String worksheet = this.m_worksheetTextField.getText();
        props.set("worksheet", worksheet);
        props.set("fileType", m_typeCodeList[0]);
    }

    public void browseExcelPages() {
        try {
            ActivityNodeModel model = this.getNodeModel();
            XTProps currentProps = new XTProps();
            this.saveWriteProperties(currentProps);
            currentProps.removeProperty(new String[]{"worksheet"});
            this.getNodeModel().saveGuiNetworkToEngine();
            if (this.getNodeModel().getDocument().isDummyEngineConnection()) {
                return;
            }
            String[] pageList = (String[])model.sendMessageToEngine("getExcelPageList", new Object[]{currentProps});
            XTProps dataInfo = (XTProps)model.sendMessageToEngine("getNodeCacheXTProps", new Object[]{"datasourceInfo"});
            ReadOtherFileDialog.checkForErrorInDataSourceProps(this, dataInfo, "", false);
            if (pageList != null && pageList.length > 0) {
                ReadExcelFileDialog.WorksheetSelectionDialog dlg = new ReadExcelFileDialog.WorksheetSelectionDialog(this, pageList, this.m_worksheetTextField);
                dlg.show();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JPanel createOptionsPanel() {
        JPanel saveFilePanel = new JPanel(new GridBagLayout());
        this.fileNameTextField = new JTextField(25);
        this.fileNameTextField.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.checkWriteFileName(WriteExcelFileDialog.this.fileNameTextField, m_extensionList, null);
            }
        });
        this.fileNameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    ReadOtherFileDialog.checkWriteFileName(WriteExcelFileDialog.this.fileNameTextField, m_extensionList, null);
                }
            }
        });
        JLabel fileNameLabel = new JLabel(MinerApp.getText("ReadTextFileDialog_filename"));
        fileNameLabel.setDisplayedMnemonic(70);
        JButton browseButton = new JButton(new AbstractAction(MinerApp.getText("ReadTextFileDialog_browse")){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.browseWriteFileName(m_WriteExcelFileDialog, WriteExcelFileDialog.this.fileNameTextField, m_extensionList, m_typeDescriptionList, null);
            }
        });
        browseButton.setMnemonic(66);
        fileNameLabel.setLabelFor(browseButton);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridwidth = 2;
        constraints.weightx = 0.0;
        saveFilePanel.add((Component)fileNameLabel, constraints);
        constraints.gridwidth = 6;
        constraints.gridx = 2;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        saveFilePanel.add((Component)this.fileNameTextField, constraints);
        constraints.gridx = 8;
        constraints.weightx = 0.0;
        constraints.gridwidth = 2;
        constraints.fill = 0;
        saveFilePanel.add((Component)browseButton, constraints);
        JPanel moreOptionsPanel = new JPanel(new GridBagLayout());
        moreOptionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ReadTextFileDialog_options")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel worksheetLabel = new JLabel(MinerApp.getText("ReadOtherFileDialog_worksheet"));
        worksheetLabel.setDisplayedMnemonic(MinerApp.getText("ReadOtherFileDialog_worksheetHotkey").charAt(0));
        this.m_worksheetTextField = new JTextField(25);
        worksheetLabel.setLabelFor(this.m_worksheetTextField);
        JButton wrkshtBrowse = new JButton(new AbstractAction(MinerApp.getText("ReadExcelFileDialog_browse")){

            public void actionPerformed(ActionEvent e) {
                WriteExcelFileDialog.this.browseExcelPages();
            }
        });
        wrkshtBrowse.setMnemonic(MinerApp.getText("ReadExcelFileDialog_browseHotkey").charAt(0));
        Insets noIndent = new Insets(0, 0, 0, 8);
        Insets indent = new Insets(0, 5, 0, 8);
        GridBagConstraints optionsConstraints = new GridBagConstraints();
        optionsConstraints.anchor = 18;
        optionsConstraints.fill = 0;
        moreOptionsPanel.add((Component)worksheetLabel, optionsConstraints);
        optionsConstraints.gridx = 1;
        optionsConstraints.weightx = 1.0;
        optionsConstraints.insets = indent;
        optionsConstraints.fill = 2;
        moreOptionsPanel.add((Component)this.m_worksheetTextField, optionsConstraints);
        optionsConstraints.gridx = 2;
        optionsConstraints.weightx = 0.0;
        optionsConstraints.weighty = 1.0;
        optionsConstraints.insets = noIndent;
        moreOptionsPanel.add((Component)wrkshtBrowse, optionsConstraints);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        topPanel.add((Component)saveFilePanel, "North");
        return topPanel;
    }
}

