/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.comments;

import com.insightful.miner.comments.InvalidXMLCommentException;
import com.insightful.miner.comments.XMLCommentEditor;
import com.insightful.miner.comments.XMLCommentEditorFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class SimpleXMLCommentEditor
implements XMLCommentEditor {
    public static int CANCEL_OPTION = 1;
    public static int APPROVE_OPTION = 2;
    public static int ERROR_OPTION = 3;
    private StreamSource xSLStylesheetStreamSource = null;
    protected Element commentElement = null;
    private TransformerFactory transformerFactory = null;
    private Transformer transformer = null;
    private StreamResult hTMLComment = null;
    private Document document = null;
    private String userName = "Anonymous Guest";
    private boolean isAuthor = false;
    private String componentName = "Unknown";
    private int returnValue = ERROR_OPTION;
    private boolean showEditorDialog = true;
    private JDialog jDialog = new JDialog();
    private static int DIALOG_WIDTH = 475;
    private static int DIALOG_HEIGHT = 447;
    private boolean hasBeenInitialized = false;
    private BorderLayout borderLayoutMain = new BorderLayout();
    private JPanel jPanelMain = new JPanel();
    private JScrollPane jScrollPaneComments = new JScrollPane();
    private JEditorPane jEditorPaneComments = new JEditorPane();
    private JComboBox jComboBoxCommentType = new JComboBox();
    private JTextArea jTextAreaNewComment = new JTextArea();
    private JLabel jLabelSubmit = new JLabel();
    private JButton jButtonSubmit = new JButton();
    private JButton jButtonOk = new JButton();
    private JButton jButtonCancel = new JButton();

    public SimpleXMLCommentEditor(File xSLStylesheet, Element xMLInitialStateElement, String userName, boolean isAuthor) throws InvalidXMLCommentException {
        this.setXSLStylesheet(xSLStylesheet);
        this.userName = userName;
        this.isAuthor = isAuthor;
        this.commentElement = xMLInitialStateElement;
        this.document = this.commentElement.getOwnerDocument();
        this.initializeDialog(new Frame());
        this.setCommentElement(this.commentElement);
    }

    public SimpleXMLCommentEditor(File xSLStylesheet, String userName, boolean isAuthor) throws InvalidXMLCommentException {
        this.setXSLStylesheet(xSLStylesheet);
        this.userName = userName;
        this.isAuthor = isAuthor;
        this.commentElement = this.generateDefaultCommentElement();
        this.document = this.commentElement.getOwnerDocument();
        this.initializeDialog(new Frame());
        this.setCommentElement(this.commentElement);
    }

    public int showEditorDialog(Frame parent) {
        return this.showEditorDialog(parent, "Comment Editor");
    }

    public int showEditorDialog(Frame parent, String title) {
        this.initializeDialog(parent);
        this.jDialog.setTitle(title);
        Point p = parent.getLocation();
        p.translate(100, 100);
        this.jDialog.setLocation(p);
        this.jEditorPaneComments.setCaretPosition(0);
        this.jDialog.show();
        return this.returnValue;
    }

    private void initializeDialog(Frame parent) {
        this.jDialog = new JDialog(parent);
        this.borderLayoutMain = new BorderLayout();
        this.jPanelMain = new JPanel();
        this.jScrollPaneComments = new JScrollPane();
        this.jEditorPaneComments = new JEditorPane();
        this.jComboBoxCommentType = new JComboBox();
        this.jTextAreaNewComment = new JTextArea();
        this.jLabelSubmit = new JLabel();
        this.jButtonSubmit = new JButton();
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.jDialog.setModal(true);
        this.jDialog.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent event) {
                if (event.getSource() instanceof JDialog) {
                    Dimension dim = SimpleXMLCommentEditor.this.jDialog.getSize();
                    dim.height = Math.max(dim.height, DIALOG_HEIGHT);
                    dim.width = Math.max(dim.width, DIALOG_WIDTH);
                    SimpleXMLCommentEditor.this.jDialog.setSize(dim);
                }
            }
        });
        this.jDialog.setDefaultCloseOperation(1);
        this.jDialog.pack();
        this.jDialog.setSize(DIALOG_WIDTH, DIALOG_HEIGHT);
        this.jDialog.getContentPane().setLayout(this.borderLayoutMain);
        Container contentPane = this.jDialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.jEditorPaneComments.setBorder(BorderFactory.createEtchedBorder());
        this.jEditorPaneComments.setPreferredSize(new Dimension(452, 21));
        this.jEditorPaneComments.setContentType("text/html");
        this.jEditorPaneComments.setFont(this.jComboBoxCommentType.getFont());
        this.jScrollPaneComments.getViewport().add((Component)this.jEditorPaneComments, null);
        this.jTextAreaNewComment.setLineWrap(true);
        this.jTextAreaNewComment.setWrapStyleWord(true);
        this.jTextAreaNewComment.setBorder(BorderFactory.createEtchedBorder());
        this.jTextAreaNewComment.setFont(this.jComboBoxCommentType.getFont());
        this.jPanelMain.setBorder(BorderFactory.createEtchedBorder());
        this.borderLayoutMain.setHgap(5);
        JScrollPane textAreaScrollPane = new JScrollPane(this.jTextAreaNewComment);
        this.jDialog.getContentPane().add((Component)this.jPanelMain, "Center");
        this.jPanelMain.setLayout(new GridBagLayout());
        GridBagConstraints pConstraints = new GridBagConstraints();
        pConstraints.anchor = 18;
        pConstraints.fill = 1;
        pConstraints.insets = new Insets(5, 5, 5, 5);
        pConstraints.weightx = 1.0;
        pConstraints.weighty = 1.0;
        JPanel editPanel = new JPanel();
        JPanel typePanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        typePanel.setLayout(new BoxLayout(typePanel, 0));
        typePanel.add(Box.createHorizontalGlue());
        typePanel.add(this.jLabelSubmit);
        typePanel.add(this.jComboBoxCommentType);
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(this.jButtonSubmit);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.jButtonOk);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.jButtonCancel);
        editPanel.setLayout(new GridBagLayout());
        GridBagConstraints eConstraints = new GridBagConstraints();
        eConstraints.anchor = 18;
        eConstraints.fill = 1;
        eConstraints.insets = new Insets(3, 3, 3, 3);
        eConstraints.weightx = 1.0;
        eConstraints.weighty = 0.8;
        eConstraints.gridy = 0;
        editPanel.add((Component)this.jScrollPaneComments, eConstraints);
        ++eConstraints.gridy;
        eConstraints.weighty = 0.0;
        editPanel.add((Component)typePanel, eConstraints);
        ++eConstraints.gridy;
        eConstraints.weighty = 0.2;
        editPanel.add((Component)textAreaScrollPane, eConstraints);
        ++eConstraints.gridy;
        eConstraints.weighty = 0.0;
        editPanel.add((Component)buttonPanel, eConstraints);
        this.jPanelMain.add((Component)editPanel, pConstraints);
        this.jLabelSubmit.setText("Submit:");
        this.jLabelSubmit.setForeground(SystemColor.activeCaption);
        this.jButtonSubmit.setText("Submit");
        this.jButtonSubmit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleXMLCommentEditor.this.jButtonSubmit_actionPerformed(e);
            }
        });
        this.jButtonOk.setText("Ok");
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleXMLCommentEditor.this.jButtonOk_actionPerformed(e);
            }
        });
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleXMLCommentEditor.this.jButtonCancel_actionPerformed(e);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jComboBoxCommentType.addItem("Description");
        this.jComboBoxCommentType.addItem("Discussion");
        this.jComboBoxCommentType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleXMLCommentEditor.this.jComboBoxCommentType_actionPerformed(e);
            }
        });
        try {
            this.setCommentElement(this.commentElement);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        NodeList nL = this.commentElement.getElementsByTagName("AuthorCommentText");
        nL = this.commentElement.getElementsByTagName("AuthorCommentTitle");
        Text tempNode = this.document.createTextNode(this.getComponentName());
        nL.item(0).replaceChild(tempNode, nL.item(0).getFirstChild());
        try {
            this.setCommentElement(this.commentElement);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public Element getCommentElement() {
        return this.commentElement;
    }

    public void setXSLStylesheet(File xSLStylesheet) throws InvalidXMLCommentException {
        try {
            this.xSLStylesheetStreamSource = new StreamSource(xSLStylesheet.getAbsolutePath());
        }
        catch (Exception e) {
            throw new InvalidXMLCommentException("Problems reading XSLStylesheet upon setting XSLStylesheet.", e);
        }
    }

    public void setCommentElement(Element xMLCommentElement) throws InvalidXMLCommentException {
        this.commentElement = xMLCommentElement;
        this.document = this.commentElement.getOwnerDocument();
        try {
            this.hTMLComment = new StreamResult(new ByteArrayOutputStream());
            this.transformerFactory = TransformerFactory.newInstance();
            this.transformer = this.transformerFactory.newTransformer(this.xSLStylesheetStreamSource);
            this.transformer.transform(new DOMSource(this.document), this.hTMLComment);
        }
        catch (Exception e) {
            throw new InvalidXMLCommentException("Problems reading XSLStylesheet or XML/XSL not compatible.", e);
        }
        String hTMLCommentString = this.hTMLComment.getOutputStream().toString();
        this.jEditorPaneComments.setDocument(this.jEditorPaneComments.getEditorKit().createDefaultDocument());
        this.jEditorPaneComments.getDocument().putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        this.jEditorPaneComments.setEditable(false);
        this.jEditorPaneComments.setText(hTMLCommentString);
        this.jEditorPaneComments.validate();
        this.jEditorPaneComments.setFont(this.jComboBoxCommentType.getFont());
        String tempString = (String)this.jComboBoxCommentType.getSelectedItem();
        if (tempString.equals("Description")) {
            this.jEditorPaneComments.setCaretPosition(0);
            JScrollBar tempSB = this.jScrollPaneComments.getVerticalScrollBar();
            tempSB.setValue(0);
        }
    }

    private String generateDefaultCommentState() {
        StringBuffer tempSB = new StringBuffer();
        tempSB.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        tempSB.append("<?xml-stylesheet type=\"text/xsl\" href=\"CommentsStylesheet.xsl\"?>");
        tempSB.append("<ComponentComments>");
        tempSB.append("\t<AuthorComments>");
        tempSB.append("\t\t<AuthorName>Not Provided</AuthorName>");
        tempSB.append("\t\t<AuthorCommentTitle>Not Provided</AuthorCommentTitle>");
        tempSB.append("\t\t<AuthorCommentDateCreated>Not Provided</AuthorCommentDateCreated>");
        tempSB.append("\t\t<AuthorCommentText>Not Provided</AuthorCommentText>");
        tempSB.append("\t</AuthorComments>");
        tempSB.append("\t<DiscussionComments>");
        tempSB.append("\t\t<Comment>");
        tempSB.append("\t\t\t<CommentAuthor>Not Provided</CommentAuthor>");
        tempSB.append("\t\t\t<CommentDateCreated>Not Provided</CommentDateCreated>");
        tempSB.append("\t\t\t<CommentTitle>Not Provided</CommentTitle>");
        tempSB.append("\t\t\t<CommentText>Not Provided</CommentText>");
        tempSB.append("\t\t</Comment>");
        tempSB.append("\t</DiscussionComments>");
        tempSB.append("</ComponentComments>");
        return tempSB.toString();
    }

    private InputSource generateDefaultCommentSource() {
        StringReader stringReader = new StringReader(this.generateDefaultCommentState());
        return new InputSource(stringReader);
    }

    protected Element generateDefaultCommentElement() {
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(this.generateDefaultCommentSource());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document.getDocumentElement();
    }

    private void jComboBoxCommentType_actionPerformed(ActionEvent e) {
    }

    private void jButtonOk_actionPerformed(ActionEvent e) {
        this.setReturnValue(2);
        this.jDialog.hide();
    }

    private void jButtonSubmit_actionPerformed(ActionEvent e) {
        String tempString = (String)this.jComboBoxCommentType.getSelectedItem();
        if (this.jTextAreaNewComment.getText().equals("")) {
            System.err.println("No comment to add.");
        } else {
            if (tempString.equals("Description")) {
                NodeList nL = this.commentElement.getElementsByTagName("AuthorCommentText");
                Text tempNode = this.document.createTextNode(this.jTextAreaNewComment.getText());
                nL.item(0).replaceChild(tempNode, nL.item(0).getFirstChild());
                nL = this.commentElement.getElementsByTagName("AuthorCommentDateCreated");
                Date tempDate = new Date();
                SimpleDateFormat formatter = new SimpleDateFormat("MMMMM dd, yyyyy");
                String strDate = formatter.format(tempDate);
                tempNode = this.document.createTextNode(strDate);
                nL.item(0).replaceChild(tempNode, nL.item(0).getFirstChild());
                nL = this.commentElement.getElementsByTagName("AuthorName");
                tempNode = this.document.createTextNode(this.getUserName());
                nL.item(0).replaceChild(tempNode, nL.item(0).getFirstChild());
                nL = this.commentElement.getElementsByTagName("AuthorCommentTitle");
                tempNode = this.document.createTextNode(this.getComponentName());
                nL.item(0).replaceChild(tempNode, nL.item(0).getFirstChild());
            } else {
                NodeList nL1 = this.commentElement.getElementsByTagName("Comment");
                Element tempCommentElement = (Element)nL1.item(0).cloneNode(true);
                NodeList nL2 = tempCommentElement.getElementsByTagName("CommentText");
                Element tempCommentText = (Element)nL2.item(0);
                boolean replaceCommentTextRoot = false;
                if (tempCommentText.toString().regionMatches(13, "Not Provided", 0, 12)) {
                    replaceCommentTextRoot = true;
                }
                Text tempNode = this.document.createTextNode(this.jTextAreaNewComment.getText());
                tempCommentText.replaceChild(tempNode, tempCommentText.getFirstChild());
                nL2 = tempCommentElement.getElementsByTagName("CommentAuthor");
                Element tempCommentAuthor = (Element)nL2.item(0);
                tempNode = this.document.createTextNode(this.getUserName());
                tempCommentAuthor.replaceChild(tempNode, tempCommentAuthor.getFirstChild());
                nL2 = tempCommentElement.getElementsByTagName("CommentDateCreated");
                Element tempCommentDateCreated = (Element)nL2.item(0);
                Date tempDate = new Date();
                SimpleDateFormat formatter = new SimpleDateFormat("MM.dd.yy 'at' hh:mm a");
                String strDate = formatter.format(tempDate);
                tempNode = this.document.createTextNode(strDate);
                tempCommentDateCreated.replaceChild(tempNode, tempCommentDateCreated.getFirstChild());
                if (replaceCommentTextRoot) {
                    nL1.item(0).getParentNode().replaceChild(tempCommentElement, nL1.item(0));
                } else {
                    nL1.item(0).getParentNode().appendChild(tempCommentElement);
                }
            }
            try {
                this.setCommentElement(this.commentElement);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        this.jTextAreaNewComment.setText("");
    }

    private void jButtonCancel_actionPerformed(ActionEvent e) {
        this.setReturnValue(1);
        this.jDialog.hide();
    }

    protected void setReturnValue(int returnValue) {
        this.returnValue = returnValue;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public boolean isAuthor() {
        return this.isAuthor;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setIsAuthor(boolean isAuthor) {
        this.isAuthor = isAuthor;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public static void main(String[] args) {
        XMLCommentEditorFactory factory = new XMLCommentEditorFactory(new File("config/CommentsStylesheet.xsl"));
        XMLCommentEditor editor = factory.createXMLCommentEditor(XMLCommentEditorFactory.SIMPLE_XML_COMMENT_EDITOR);
        editor.setUserName("Anonymous Guest");
        editor.setComponentName("Unknown");
        editor.showEditorDialog(new Frame(), "Comment Editor");
    }
}

