/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.sql;

import com.insightful.miner.sql.Binary;
import com.insightful.miner.sql.Expression;
import com.insightful.miner.sql.HsqlDateTime;
import com.insightful.miner.sql.HsqlException;
import com.insightful.miner.sql.HsqlNameManager;
import com.insightful.miner.sql.JavaObject;
import com.insightful.miner.sql.Library;
import com.insightful.miner.sql.Trace;
import com.insightful.miner.sql.Types;
import com.insightful.miner.sql.lib.BooleanConverter;
import com.insightful.miner.sql.lib.HsqlByteArrayInputStream;
import com.insightful.miner.sql.lib.HsqlByteArrayOutputStream;
import com.insightful.miner.sql.lib.StringConverter;
import com.insightful.miner.sql.lib.ValuePool;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Collator;

public class Column {
    public HsqlNameManager.HsqlName columnName;
    private int colType;
    private int colSize;
    private int colScale;
    private boolean isNullable;
    private boolean isIdentity;
    private boolean isPrimaryKey;
    private Expression defaultExpression;
    long identityStart;
    long identityIncrement;
    static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    static final BigInteger MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    static final BigInteger MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);
    static final BigDecimal BIG_DECIMAL_0 = new BigDecimal(0);
    static final BigDecimal BIG_DECIMAL_1 = new BigDecimal(1);
    private static Collator i18nCollator = Collator.getInstance();
    static boolean sql_compare_in_locale = false;

    Column(HsqlNameManager.HsqlName name, boolean nullable, int type, int size, int scale, boolean identity, long startvalue, long increment, boolean primarykey, Expression defexpression) throws HsqlException {
        this.columnName = name;
        this.isNullable = nullable;
        this.colType = type;
        this.colSize = size;
        this.colScale = scale;
        this.isIdentity = identity;
        this.identityStart = startvalue;
        this.identityIncrement = increment;
        this.isPrimaryKey = primarykey;
        this.defaultExpression = defexpression;
        if (this.isIdentity && type == 4 && (this.identityStart > Integer.MAX_VALUE || this.identityIncrement > Integer.MAX_VALUE)) {
            throw Trace.error(65, name.statementName);
        }
    }

    boolean isIdentity() {
        return this.isIdentity;
    }

    boolean isNullable() {
        return this.isNullable;
    }

    void setNullable(boolean value) {
        this.isNullable = value;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    void setPrimaryKey(boolean value) {
        this.isPrimaryKey = value;
    }

    String getDefaultDDL() {
        String ddl = null;
        try {
            ddl = this.defaultExpression == null ? null : this.defaultExpression.getDDL();
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
        return ddl;
    }

    Expression getDefaultExpression() {
        return this.defaultExpression;
    }

    void setDefaultExpression(Expression expr) {
        this.defaultExpression = expr;
    }

    int getType() {
        return this.colType;
    }

    int getDIType() {
        return this.colType == 100 ? 12 : this.colType;
    }

    int getDITypeSub() {
        if (this.colType == 100) {
            return 4;
        }
        return 1;
    }

    int getSize() {
        return this.colSize;
    }

    int getScale() {
        return this.colScale;
    }

    static Object add(Object a, Object b, int type) throws HsqlException {
        if (a == null || b == null) {
            return null;
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double ad = ((Number)a).doubleValue();
                double bd = ((Number)b).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(ad + bd));
            }
            case -1: 
            case 1: 
            case 12: 
            case 100: {
                return (String)a + (String)b;
            }
            case 2: 
            case 3: {
                BigDecimal abd = (BigDecimal)a;
                BigDecimal bbd = (BigDecimal)b;
                return abd.add(bbd);
            }
            case -6: 
            case 4: 
            case 5: {
                int ai = ((Number)a).intValue();
                int bi = ((Number)b).intValue();
                return ValuePool.getInt(ai + bi);
            }
            case -5: {
                long longa = ((Number)a).longValue();
                long longb = ((Number)b).longValue();
                return ValuePool.getLong(longa + longb);
            }
        }
        throw Trace.error(20, Types.getTypeString(type));
    }

    static Object concat(Object a, Object b) throws HsqlException {
        if (a == null || b == null) {
            return null;
        }
        return Column.convertObject(a) + Column.convertObject(b);
    }

    static Object negate(Object a, int type) throws HsqlException {
        if (a == null) {
            return null;
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double ad = -((Number)a).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(ad));
            }
            case 2: 
            case 3: {
                return ((BigDecimal)a).negate();
            }
            case -6: 
            case 4: 
            case 5: {
                return ValuePool.getInt(-((Number)a).intValue());
            }
            case -5: {
                return ValuePool.getLong(-((Number)a).longValue());
            }
        }
        throw Trace.error(20, Types.getTypeString(type));
    }

    static Object multiply(Object a, Object b, int type) throws HsqlException {
        if (a == null || b == null) {
            return null;
        }
        if (!(a instanceof Number) || !(b instanceof Number)) {
            a = Column.convertObject(b, type);
            b = Column.convertObject(b, type);
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double ad = ((Number)a).doubleValue();
                double bd = ((Number)b).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(ad * bd));
            }
            case 2: 
            case 3: {
                BigDecimal abd = (BigDecimal)a;
                BigDecimal bbd = (BigDecimal)b;
                return abd.multiply(bbd);
            }
            case -6: 
            case 4: 
            case 5: {
                int ai = ((Number)a).intValue();
                int bi = ((Number)b).intValue();
                return ValuePool.getInt(ai * bi);
            }
            case -5: {
                long longa = ((Number)a).longValue();
                long longb = ((Number)b).longValue();
                return ValuePool.getLong(longa * longb);
            }
        }
        throw Trace.error(20, Types.getTypeString(type));
    }

    static Object divide(Object a, Object b, int type) throws HsqlException {
        if (a == null || b == null) {
            return null;
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double ad = ((Number)a).doubleValue();
                double bd = ((Number)b).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(ad / bd));
            }
            case 2: 
            case 3: {
                BigDecimal abd = (BigDecimal)a;
                BigDecimal bbd = (BigDecimal)b;
                int scale = abd.scale() > bbd.scale() ? abd.scale() : bbd.scale();
                return bbd.signum() == 0 ? null : abd.divide(bbd, scale, 5);
            }
            case -6: 
            case 4: 
            case 5: {
                int ai = ((Number)a).intValue();
                int bi = ((Number)b).intValue();
                Trace.check(bi != 0, 6);
                return ValuePool.getInt(ai / bi);
            }
            case -5: {
                long longa = ((Number)a).longValue();
                long longb = ((Number)b).longValue();
                return longb == 0L ? null : ValuePool.getLong(longa / longb);
            }
        }
        throw Trace.error(20, Types.getTypeString(type));
    }

    static Object subtract(Object a, Object b, int type) throws HsqlException {
        if (a == null || b == null) {
            return null;
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double ad = ((Number)a).doubleValue();
                double bd = ((Number)b).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(ad - bd));
            }
            case 2: 
            case 3: {
                BigDecimal abd = (BigDecimal)a;
                BigDecimal bbd = (BigDecimal)b;
                return abd.subtract(bbd);
            }
            case -6: 
            case 4: 
            case 5: {
                int ai = ((Number)a).intValue();
                int bi = ((Number)b).intValue();
                return ValuePool.getInt(ai - bi);
            }
            case -5: {
                long longa = ((Number)a).longValue();
                long longb = ((Number)b).longValue();
                return ValuePool.getLong(longa - longb);
            }
        }
        throw Trace.error(20, Types.getTypeString(type));
    }

    static void setCompareInLocal(boolean value) {
        sql_compare_in_locale = value;
    }

    static int compare(Object a, Object b, int type) throws HsqlException {
        int i = 0;
        if (a == b) {
            return 0;
        }
        if (a == null) {
            if (b == null) {
                return 0;
            }
            return -1;
        }
        if (b == null) {
            return 1;
        }
        switch (type) {
            case 0: {
                return 0;
            }
            case -1: 
            case 12: {
                if (sql_compare_in_locale) {
                    i = i18nCollator.compare((String)a, (String)b);
                    break;
                }
                i = ((String)a).compareTo((String)b);
                break;
            }
            case 1: {
                if (sql_compare_in_locale) {
                    i = i18nCollator.compare(Library.rtrim((String)a), Library.rtrim((String)b));
                    break;
                }
                i = Library.rtrim((String)a).compareTo(Library.rtrim((String)b));
                break;
            }
            case 100: {
                if (sql_compare_in_locale) {
                    i = i18nCollator.compare(((String)a).toUpperCase(), ((String)b).toUpperCase());
                    break;
                }
                i = ((String)a).toUpperCase().compareTo(((String)b).toUpperCase());
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                int ai = ((Number)a).intValue();
                int bi = ((Number)b).intValue();
                return ai > bi ? 1 : (bi > ai ? -1 : 0);
            }
            case -5: {
                long longa = ((Number)a).longValue();
                long longb = ((Number)b).longValue();
                return longa > longb ? 1 : (longb > longa ? -1 : 0);
            }
            case 6: 
            case 7: 
            case 8: {
                double ad = ((Number)a).doubleValue();
                double bd = ((Number)b).doubleValue();
                return ad > bd ? 1 : (bd > ad ? -1 : 0);
            }
            case 2: 
            case 3: {
                i = ((BigDecimal)a).compareTo((BigDecimal)b);
                break;
            }
            case 91: {
                if (((Date)a).after((Date)b)) {
                    return 1;
                }
                if (((Date)a).before((Date)b)) {
                    return -1;
                }
                return 0;
            }
            case 92: {
                return HsqlDateTime.compare((Time)a, (Time)b);
            }
            case 93: {
                if (((Timestamp)a).after((Timestamp)b)) {
                    return 1;
                }
                if (((Timestamp)a).before((Timestamp)b)) {
                    return -1;
                }
                return 0;
            }
            case 16: {
                boolean boola = (Boolean)a;
                boolean boolb = (Boolean)b;
                return boola == boolb ? 0 : (boolb ? -1 : 1);
            }
            case -4: 
            case -3: 
            case -2: {
                if (a instanceof Binary && b instanceof Binary) {
                    i = Column.compareTo(((Binary)a).getBytes(), ((Binary)b).getBytes());
                    break;
                }
                throw Trace.error(95, Types.getTypeString(type));
            }
            case 1111: {
                return 0;
            }
            default: {
                throw Trace.error(95, Types.getTypeString(type));
            }
        }
        return i == 0 ? 0 : (i < 0 ? -1 : 1);
    }

    static String convertObject(Object o) {
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public static Object convertObject(Object o, int type) throws HsqlException {
        try {
            if (o == null) {
                return null;
            }
            switch (type) {
                case 0: {
                    return null;
                }
                case -6: {
                    if (o instanceof Boolean) {
                        return (Boolean)o != false ? ValuePool.getInt(1) : ValuePool.getInt(0);
                    }
                    if (o instanceof String) {
                        o = Library.trim((String)o, " ", true, true);
                        int val = Integer.parseInt((String)o);
                        o = ValuePool.getInt(val);
                    }
                    if (o instanceof Integer) {
                        int temp = ((Number)o).intValue();
                        if (127 < temp || temp < -128) {
                            throw Trace.error(65);
                        }
                        return o;
                    }
                    if (o instanceof Byte) {
                        return ValuePool.getInt(((Number)o).intValue());
                    }
                    if (!(o instanceof Number)) break;
                    return Column.convertObject(Column.convertToInt(o), type);
                }
                case 5: {
                    if (o instanceof Boolean) {
                        return (Boolean)o != false ? ValuePool.getInt(1) : ValuePool.getInt(0);
                    }
                    if (o instanceof String) {
                        o = Library.trim((String)o, " ", true, true);
                        int val = Integer.parseInt((String)o);
                        o = ValuePool.getInt(val);
                    }
                    if (o instanceof Integer) {
                        int temp = ((Number)o).intValue();
                        if (Short.MAX_VALUE < temp || temp < Short.MIN_VALUE) {
                            throw Trace.error(65);
                        }
                        return o;
                    }
                    if (o instanceof Byte || o instanceof Short) {
                        return ValuePool.getInt(((Number)o).intValue());
                    }
                    if (!(o instanceof Number)) break;
                    return Column.convertObject(Column.convertToInt(o), type);
                }
                case 4: {
                    if (o instanceof Boolean) {
                        return (Boolean)o != false ? ValuePool.getInt(1) : ValuePool.getInt(0);
                    }
                    if (o instanceof Integer) {
                        return o;
                    }
                    if (o instanceof String) {
                        o = Library.trim((String)o, " ", true, true);
                        int val = Integer.parseInt((String)o);
                        return ValuePool.getInt(val);
                    }
                    if (o instanceof Long) {
                        long temp = ((Number)o).longValue();
                        if (Integer.MAX_VALUE < temp || temp < Integer.MIN_VALUE) {
                            throw Trace.error(65);
                        }
                        return ValuePool.getInt(((Number)o).intValue());
                    }
                    if (o instanceof Number) {
                        return Column.convertToInt(o);
                    }
                    if (!(o instanceof Boolean)) break;
                    return ValuePool.getInt((Boolean)o != false ? 1 : 0);
                }
                case -5: {
                    if (o instanceof Boolean) {
                        return (Boolean)o != false ? ValuePool.getLong(1L) : ValuePool.getLong(0L);
                    }
                    if (o instanceof Long) {
                        return o;
                    }
                    if (o instanceof String) {
                        o = Library.trim((String)o, " ", true, true);
                        long val = Long.parseLong((String)o);
                        return ValuePool.getLong(val);
                    }
                    if (o instanceof Integer) {
                        return ValuePool.getLong(((Integer)o).longValue());
                    }
                    if (!(o instanceof Number)) break;
                    return Column.convertToLong(o);
                }
                case 6: 
                case 7: 
                case 8: {
                    if (o instanceof Boolean) {
                        return (Boolean)o != false ? ValuePool.getDouble(1L) : ValuePool.getDouble(0L);
                    }
                    if (o instanceof Double) {
                        return o;
                    }
                    if (o instanceof String) {
                        o = Library.trim((String)o, " ", true, true);
                        double d = new Double((String)o);
                        long l = Double.doubleToLongBits(d);
                        return ValuePool.getDouble(l);
                    }
                    if (!(o instanceof Number)) break;
                    return Column.convertToDouble(o);
                }
                case 2: 
                case 3: {
                    if (o instanceof Boolean) {
                        return (Boolean)o != false ? BIG_DECIMAL_1 : BIG_DECIMAL_0;
                    }
                    if (!(o instanceof BigDecimal)) break;
                    return o;
                }
                case 16: {
                    if (o instanceof Boolean) {
                        return (Boolean)o;
                    }
                    if (o instanceof String) {
                        o = Library.trim((String)o, " ", true, true);
                        return BooleanConverter.getBoolean((String)o);
                    }
                    if (o instanceof Integer) {
                        return BooleanConverter.getBoolean((Integer)o);
                    }
                    if (o instanceof Long) {
                        return BooleanConverter.getBoolean((Long)o);
                    }
                    if (o instanceof Double) {
                        return BooleanConverter.getBoolean((Double)o);
                    }
                    if (!(o instanceof BigDecimal)) break;
                    return BooleanConverter.getBoolean((BigDecimal)o);
                }
                case -1: 
                case 1: 
                case 12: 
                case 100: {
                    if (o instanceof String) {
                        return o;
                    }
                    if (o instanceof Time) {
                        return HsqlDateTime.getTimeString((Time)o, null);
                    }
                    if (o instanceof Timestamp) {
                        return HsqlDateTime.getTimestampString((Timestamp)o, null);
                    }
                    if (o instanceof Date) {
                        return HsqlDateTime.getDateString((Date)o, null);
                    }
                    if (!(o instanceof byte[])) break;
                    return StringConverter.byteToHex((byte[])o);
                }
                case 92: {
                    if (o instanceof Time) {
                        return HsqlDateTime.getNormalisedTime((Time)o);
                    }
                    if (o instanceof Timestamp) {
                        return HsqlDateTime.getNormalisedTime((Timestamp)o);
                    }
                    if (o instanceof String) {
                        return HsqlDateTime.timeValue((String)o);
                    }
                    if (!(o instanceof Date)) break;
                    throw Trace.error(95, Types.getTypeString(type));
                }
                case 93: {
                    if (o instanceof Timestamp) {
                        return o;
                    }
                    if (o instanceof Time) {
                        return HsqlDateTime.getNormalisedTimestamp((Time)o);
                    }
                    if (o instanceof Date) {
                        return HsqlDateTime.getNormalisedTimestamp((Date)o);
                    }
                    if (!(o instanceof String)) break;
                    return HsqlDateTime.timestampValue((String)o);
                }
                case 91: {
                    if (o instanceof Date) {
                        return HsqlDateTime.getNormalisedDate((Date)o);
                    }
                    if (o instanceof Timestamp) {
                        return HsqlDateTime.getNormalisedDate((Timestamp)o);
                    }
                    if (o instanceof String) {
                        return HsqlDateTime.dateValue((String)o);
                    }
                    if (!(o instanceof Time)) break;
                    throw Trace.error(95, Types.getTypeString(type));
                }
                case -4: 
                case -3: 
                case -2: {
                    if (o instanceof Binary) {
                        return o;
                    }
                    if (o instanceof byte[]) {
                        return new Binary((byte[])o, false);
                    }
                    if (o instanceof String) {
                        return new Binary(StringConverter.hexToByte((String)o), false);
                    }
                    throw Trace.error(95, Types.getTypeString(type));
                }
                case 1111: {
                    if (o instanceof JavaObject) {
                        return o;
                    }
                    if (o instanceof String) {
                        return new JavaObject(StringConverter.hexToByte((String)o));
                    }
                    if (o instanceof Binary) {
                        return new JavaObject(((Binary)o).getBytes());
                    }
                    return new JavaObject((Serializable)o);
                }
            }
            if (o instanceof JavaObject) {
                o = ((JavaObject)o).getObject();
                return Column.convertObject(o, type);
            }
            return Column.convertString(o.toString(), type);
        }
        catch (HsqlException e) {
            throw e;
        }
        catch (Exception e) {
            throw Trace.error(16, e.getMessage());
        }
    }

    private static Object convertString(String s, int type) throws HsqlException {
        switch (type) {
            case -6: 
            case 5: {
                return Column.convertObject(s, type);
            }
            case 4: {
                int val = Integer.parseInt(s);
                return ValuePool.getInt(val);
            }
            case -5: {
                return ValuePool.getLong(Long.parseLong(s));
            }
            case 6: 
            case 7: 
            case 8: {
                double d = new Double(s);
                long l = Double.doubleToLongBits(d);
                return ValuePool.getDouble(l);
            }
            case -1: 
            case 1: 
            case 12: 
            case 100: {
                return s;
            }
            case 91: {
                return HsqlDateTime.dateValue(s);
            }
            case 92: {
                return HsqlDateTime.timeValue(s);
            }
            case 93: {
                return HsqlDateTime.timestampValue(s);
            }
            case 2: 
            case 3: {
                s = Library.trim(s, " ", true, true);
                return new BigDecimal(s);
            }
            case 16: {
                return BooleanConverter.getBoolean(s);
            }
        }
        throw Trace.error(95, Types.getTypeString(type));
    }

    static String createSQLString(Object o, int type) throws HsqlException {
        if (o == null) {
            return "NULL";
        }
        switch (type) {
            case 0: {
                return "NULL";
            }
            case 6: 
            case 7: 
            case 8: {
                return Column.createSQLString(((Number)o).doubleValue());
            }
            case 91: 
            case 92: 
            case 93: {
                return StringConverter.toQuotedString(o.toString(), '\'', false);
            }
            case -4: 
            case -3: 
            case -2: {
                if (!(o instanceof Binary)) {
                    throw Trace.error(95);
                }
                return StringConverter.toQuotedString(StringConverter.byteToHex(((Binary)o).getBytes()), '\'', false);
            }
            case 1111: {
                if (!(o instanceof JavaObject)) {
                    throw Trace.error(18);
                }
                return StringConverter.toQuotedString(StringConverter.byteToHex(((JavaObject)o).getBytes()), '\'', false);
            }
            case -1: 
            case 1: 
            case 12: 
            case 100: {
                return Column.createSQLString((String)o);
            }
        }
        return o.toString();
    }

    public static String createSQLString(double x) {
        if (x == Double.NEGATIVE_INFINITY) {
            return "-1E0/0";
        }
        if (x == Double.POSITIVE_INFINITY) {
            return "1E0/0";
        }
        if (Double.isNaN(x)) {
            return "0E0/0E0";
        }
        String s = Double.toString(x);
        if (s.indexOf(69) < 0) {
            s = s.concat("E0");
        }
        return s;
    }

    public static String createSQLString(String s) {
        if (s == null) {
            return "NULL";
        }
        return StringConverter.toQuotedString(s, '\'', true);
    }

    static Integer convertToInt(Object o) throws HsqlException {
        int val = ((Number)o).intValue();
        if (o instanceof BigDecimal) {
            BigInteger bi = ((BigDecimal)o).toBigInteger();
            if (bi.compareTo(MAX_INT) > 0 || bi.compareTo(MIN_INT) < 0) {
                throw Trace.error(65);
            }
            return ValuePool.getInt(val);
        }
        if (o instanceof Double) {
            double d = (Double)o;
            if (Double.isNaN(d) || d >= 2.147483648E9 || d <= -2.147483649E9) {
                throw Trace.error(65);
            }
            return ValuePool.getInt(val);
        }
        throw Trace.error(95);
    }

    static Long convertToLong(Object o) throws HsqlException {
        long val = ((Number)o).longValue();
        if (o instanceof BigDecimal) {
            BigInteger bi = ((BigDecimal)o).toBigInteger();
            if (bi.compareTo(MAX_LONG) > 0 || bi.compareTo(MIN_LONG) < 0) {
                throw Trace.error(65);
            }
            return ValuePool.getLong(val);
        }
        if (o instanceof Double) {
            double d = (Double)o;
            if (Double.isNaN(d) || d >= 9.223372036854776E18 || d <= -9.223372036854776E18) {
                throw Trace.error(65);
            }
            return ValuePool.getLong(val);
        }
        throw Trace.error(95);
    }

    static Double convertToDouble(Object o) throws HsqlException {
        BigDecimal bd;
        int signum;
        BigDecimal bo;
        double val = ((Number)o).doubleValue();
        if (o instanceof BigDecimal && (bo = new BigDecimal(val + (double)(signum = (bd = (BigDecimal)o).signum()))).compareTo(bd) != signum) {
            throw Trace.error(65);
        }
        return ValuePool.getDouble(Double.doubleToLongBits(val));
    }

    static int getCombinedNumberType(int type1, int type2, int expType) {
        int typeWidth1 = Column.getNumTypeWidth(type1);
        int typeWidth2 = Column.getNumTypeWidth(type2);
        if (typeWidth1 == 16 || typeWidth2 == 16) {
            return 8;
        }
        switch (expType) {
            case 14: 
            case 70: {
                return typeWidth1 > typeWidth2 ? type1 : type2;
            }
        }
        int sum = typeWidth1 + typeWidth2;
        if (sum <= 4) {
            return 4;
        }
        if (sum <= 8) {
            return -5;
        }
        return 2;
    }

    private static int getNumTypeWidth(int type) {
        switch (type) {
            case -6: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case -5: {
                return 8;
            }
            case 6: 
            case 7: 
            case 8: {
                return 16;
            }
            case 2: 
            case 3: {
                return 32;
            }
        }
        return 32;
    }

    public static byte[] hexToByteArray(String hexString) throws HsqlException {
        try {
            return StringConverter.hexToByte(hexString);
        }
        catch (IOException e) {
            throw Trace.error(81);
        }
    }

    static int compareTo(byte[] o1, byte[] o2) {
        int len = o1.length;
        int lenb = o2.length;
        int i = 0;
        while (true) {
            int a = 0;
            int b = 0;
            if (i < len) {
                a = o1[i] & 0xFF;
            } else if (i >= lenb) {
                return 0;
            }
            if (i < lenb) {
                b = o2[i] & 0xFF;
            }
            if (a > b) {
                return 1;
            }
            if (b > a) {
                return -1;
            }
            ++i;
        }
    }

    static byte[] serialize(Serializable s) throws HsqlException {
        HsqlByteArrayOutputStream bo = new HsqlByteArrayOutputStream();
        try {
            ObjectOutputStream os = new ObjectOutputStream(bo);
            os.writeObject(s);
            return bo.toByteArray();
        }
        catch (Exception e) {
            throw Trace.error(18, e.getMessage());
        }
    }

    static Serializable deserialize(byte[] ba) throws HsqlException {
        try {
            HsqlByteArrayInputStream bi = new HsqlByteArrayInputStream(ba);
            ObjectInputStream is = new ObjectInputStream(bi);
            return (Serializable)is.readObject();
        }
        catch (Exception e) {
            throw Trace.error(18, e.getMessage());
        }
    }
}

