/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.sql.lib;

import com.insightful.miner.sql.lib.BaseHashMap;
import java.sql.Date;

public class ValuePoolHashMap
extends BaseHashMap {
    public ValuePoolHashMap(int initialCapacity, int maxCapacity, int purgePolicy) throws IllegalArgumentException {
        super(initialCapacity, 1.0f, 3, 0);
        this.accessTable = new int[initialCapacity];
        this.maxCapacity = maxCapacity;
        this.purgePolicy = purgePolicy;
    }

    public void resetCapacity(int maxCapacity, int purgePolicy) throws IllegalArgumentException {
        if (this.hashIndex.elementCount > maxCapacity) {
            int surplus = 128 + this.hashIndex.elementCount - maxCapacity;
            if (surplus > this.hashIndex.elementCount) {
                surplus = this.hashIndex.elementCount;
            }
            this.clear(surplus);
        }
        if (maxCapacity < this.threshold) {
            this.rehash(maxCapacity);
        }
        this.maxCapacity = maxCapacity;
        this.purgePolicy = purgePolicy;
    }

    protected Integer getOrAddInteger(int intKey) {
        Integer testValue;
        int index = this.hashIndex.getHashIndex(intKey);
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        while (lookup >= 0) {
            testValue = (Integer)this.objectKeyTable[lookup];
            if (testValue == intKey) {
                ++this.accessCount;
                return testValue;
            }
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddInteger(intKey);
        }
        lookup = this.hashIndex.linkNode(index, lastLookup);
        testValue = new Integer(intKey);
        this.objectKeyTable[lookup] = testValue;
        ++this.accessCount;
        return testValue;
    }

    protected Long getOrAddLong(long longKey) {
        Long testValue;
        int index = this.hashIndex.getHashIndex((int)(longKey ^ longKey >>> 32));
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        while (lookup >= 0) {
            testValue = (Long)this.objectKeyTable[lookup];
            if (testValue == longKey) {
                ++this.accessCount;
                return testValue;
            }
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddLong(longKey);
        }
        lookup = this.hashIndex.linkNode(index, lastLookup);
        testValue = new Long(longKey);
        this.objectKeyTable[lookup] = testValue;
        ++this.accessCount;
        return testValue;
    }

    protected String getOrAddString(Object key) {
        String testValue;
        int index = this.hashIndex.getHashIndex(key.hashCode());
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        while (lookup >= 0) {
            testValue = (String)this.objectKeyTable[lookup];
            if (key.equals(testValue)) {
                ++this.accessCount;
                return testValue;
            }
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddString(key);
        }
        testValue = key.toString();
        lookup = this.hashIndex.linkNode(index, lastLookup);
        this.objectKeyTable[lookup] = testValue;
        ++this.accessCount;
        return testValue;
    }

    protected Date getOrAddDate(long longKey) {
        Date testValue;
        int hash = (int)longKey ^ (int)(longKey >>> 32);
        int index = this.hashIndex.getHashIndex(hash);
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        while (lookup >= 0) {
            testValue = (Date)this.objectKeyTable[lookup];
            if (testValue.getTime() == longKey) {
                ++this.accessCount;
                return testValue;
            }
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddDate(longKey);
        }
        lookup = this.hashIndex.linkNode(index, lastLookup);
        testValue = new Date(longKey);
        this.objectKeyTable[lookup] = testValue;
        ++this.accessCount;
        return testValue;
    }

    protected Double getOrAddDouble(long longKey) {
        Double testValue;
        int index = this.hashIndex.getHashIndex((int)(longKey ^ longKey >>> 32));
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        while (lookup >= 0) {
            testValue = (Double)this.objectKeyTable[lookup];
            if (Double.doubleToLongBits(testValue) == longKey) {
                ++this.accessCount;
                return testValue;
            }
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddDouble(longKey);
        }
        lookup = this.hashIndex.linkNode(index, lastLookup);
        testValue = new Double(Double.longBitsToDouble(longKey));
        this.objectKeyTable[lookup] = testValue;
        ++this.accessCount;
        return testValue;
    }

    protected Object getOrAddObject(Object key) {
        int index = this.hashIndex.getHashIndex(key.hashCode());
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        while (lookup >= 0) {
            Object testValue = this.objectKeyTable[lookup];
            if (testValue.equals(key)) {
                ++this.accessCount;
                return testValue;
            }
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddObject(key);
        }
        lookup = this.hashIndex.linkNode(index, lastLookup);
        this.objectKeyTable[lookup] = key;
        ++this.accessCount;
        return key;
    }
}

