/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Random;

public class MersenneTwister
extends Random
implements Serializable {
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int TEMPERING_MASK_B = -1658038656;
    private static final int TEMPERING_MASK_C = -272236544;
    private int[] mt;
    private int mti;
    private int[] mag01;
    private static final long GOOD_SEED = 4357L;
    private double __nextNextGaussian;
    private boolean __haveNextNextGaussian;

    public MersenneTwister() {
        super(4357L);
        this.setSeed(4357L);
    }

    public MersenneTwister(long seed) {
        super(seed);
        this.setSeed(seed);
    }

    public synchronized void setSeedOld(long seed) {
        super.setSeed(seed);
        this.__haveNextNextGaussian = false;
        this.mt = new int[624];
        this.mt[0] = (int)seed;
        this.mti = 1;
        while (this.mti < 624) {
            this.mt[this.mti] = 69069 * this.mt[this.mti - 1];
            ++this.mti;
        }
        this.mag01 = new int[2];
        this.mag01[0] = 0;
        this.mag01[1] = -1727483681;
    }

    public synchronized void setSeed(int[] array) {
        super.setSeed(4357L);
        this.__haveNextNextGaussian = false;
        this.mt = new int[624];
        System.arraycopy(array, 0, this.mt, 0, 624);
        this.mti = 624;
        this.mag01 = new int[2];
        this.mag01[0] = 0;
        this.mag01[1] = -1727483681;
    }

    public synchronized void setSeed(long seed) {
        super.setSeed(seed);
        int _seed = (int)seed;
        this.__haveNextNextGaussian = false;
        this.mt = new int[624];
        int i = 0;
        while (i < 624) {
            this.mt[i] = _seed & 0xFFFF0000;
            _seed = 69069 * _seed + 1;
            int n = i++;
            this.mt[n] = this.mt[n] | (_seed & 0xFFFF0000) >>> 16;
            _seed = 69069 * _seed + 1;
        }
        this.mti = 624;
        this.mag01 = new int[2];
        this.mag01[0] = 0;
        this.mag01[1] = -1727483681;
    }

    protected synchronized int next(int bits) {
        int y;
        if (this.mti >= 624) {
            int kk;
            for (kk = 0; kk < 227; ++kk) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ this.mag01[y & 1];
            }
            while (kk < 623) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + -227] ^ y >>> 1 ^ this.mag01[y & 1];
                ++kk;
            }
            y = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ y >>> 1 ^ this.mag01[y & 1];
            this.mti = 0;
        }
        y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return y >>> 32 - bits;
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    public boolean nextBoolean(float probability) {
        if (probability < 0.0f || probability > 1.0f) {
            throw new IllegalArgumentException("probability must be between 0.0 and 1.0 inclusive.");
        }
        return this.nextFloat() < probability;
    }

    public boolean nextBoolean(double probability) {
        if (probability < 0.0 || probability > 1.0) {
            throw new IllegalArgumentException("probability must be between 0.0 and 1.0 inclusive.");
        }
        return this.nextDouble() < probability;
    }

    public int nextInt(int n) {
        int val;
        int bits;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be >= 0");
        }
        if ((n & -n) == n) {
            return (int)((long)n * (long)this.next(31) >> 31);
        }
        while ((bits = this.next(31)) - (val = bits % n) + (n - 1) < 0) {
        }
        return val;
    }

    public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) / 9.007199254740992E15;
    }

    public float nextFloat() {
        return (float)this.next(24) / 1.6777216E7f;
    }

    public void nextBytes(byte[] bytes) {
        for (int x = 0; x < bytes.length; ++x) {
            bytes[x] = (byte)this.next(8);
        }
    }

    public char nextChar() {
        return (char)this.next(16);
    }

    public short nextShort() {
        return (short)this.next(16);
    }

    public byte nextByte() {
        return (byte)this.next(8);
    }

    public synchronized double nextGaussian() {
        double v2;
        double v1;
        double s;
        if (this.__haveNextNextGaussian) {
            this.__haveNextNextGaussian = false;
            return this.__nextNextGaussian;
        }
        while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double multiplier = Math.sqrt(-2.0 * Math.log(s) / s);
        this.__nextNextGaussian = v2 * multiplier;
        this.__haveNextNextGaussian = true;
        return v1 * multiplier;
    }

    public static void main(String[] args) {
        int j;
        System.out.println("\nGrab the first 1000 booleans");
        MersenneTwister r = new MersenneTwister();
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextBoolean() + " ");
            if (j % 8 != 7) continue;
            System.out.println();
        }
        if (j % 8 != 7) {
            System.out.println();
        }
        System.out.println("\nGrab 1000 booleans of increasing probability using nextBoolean(double)");
        r = new MersenneTwister();
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextBoolean((double)j / 999.0) + " ");
            if (j % 8 != 7) continue;
            System.out.println();
        }
        if (j % 8 != 7) {
            System.out.println();
        }
        System.out.println("\nGrab 1000 booleans of increasing probability using nextBoolean(float)");
        r = new MersenneTwister();
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextBoolean((float)j / 999.0f) + " ");
            if (j % 8 != 7) continue;
            System.out.println();
        }
        if (j % 8 != 7) {
            System.out.println();
        }
        byte[] bytes = new byte[1000];
        System.out.println("\nGrab the first 1000 bytes using nextBytes");
        r = new MersenneTwister();
        r.nextBytes(bytes);
        for (j = 0; j < 1000; ++j) {
            System.out.print(bytes[j] + " ");
            if (j % 16 != 15) continue;
            System.out.println();
        }
        if (j % 16 != 15) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 bytes -- must be same as nextBytes");
        r = new MersenneTwister();
        for (j = 0; j < 1000; ++j) {
            byte b = r.nextByte();
            System.out.print(b + " ");
            if (b != bytes[j]) {
                System.out.print("BAD ");
            }
            if (j % 16 != 15) continue;
            System.out.println();
        }
        if (j % 16 != 15) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 shorts");
        r = new MersenneTwister();
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextShort() + " ");
            if (j % 8 != 7) continue;
            System.out.println();
        }
        if (j % 8 != 7) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 ints");
        r = new MersenneTwister();
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextInt() + " ");
            if (j % 4 != 3) continue;
            System.out.println();
        }
        if (j % 4 != 3) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 ints of different sizes");
        r = new MersenneTwister();
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextInt(j + 1) + " ");
            if (j % 4 != 3) continue;
            System.out.println();
        }
        if (j % 4 != 3) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 longs");
        r = new MersenneTwister();
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextLong() + " ");
            if (j % 3 != 2) continue;
            System.out.println();
        }
        if (j % 3 != 2) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 floats");
        r = new MersenneTwister();
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextFloat() + " ");
            if (j % 4 != 3) continue;
            System.out.println();
        }
        if (j % 4 != 3) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 doubles");
        r = new MersenneTwister();
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextDouble() + " ");
            if (j % 3 != 2) continue;
            System.out.println();
        }
        if (j % 3 != 2) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 gaussian doubles");
        r = new MersenneTwister();
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextGaussian() + " ");
            if (j % 3 != 2) continue;
            System.out.println();
        }
        if (j % 3 != 2) {
            System.out.println();
        }
    }
}

