/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Vector;

public class SJDBCDataFrame {
    private ArrayList<Object> data = new ArrayList(5);
    private Vector<String> colNames = new Vector(5);
    private Vector<Integer> colTypes = new Vector(5);
    private int rows = 0;
    private int columns = 0;
    private static final int INIT_COLUMNS = 5;

    public void addIntegerColumn(String string, int[] nArray) throws Exception {
        if (this.columns == 0) {
            this.rows = nArray.length;
        }
        if (nArray.length != this.rows) {
            throw new Exception("Length of column data does not match existing data.");
        }
        this.data.add(nArray);
        this.colNames.add(string);
        this.colTypes.add(4);
        ++this.columns;
    }

    public void addDoubleColumn(String string, double[] dArray) throws Exception {
        if (this.columns == 0) {
            this.rows = dArray.length;
        }
        if (dArray.length != this.rows) {
            throw new Exception("Length of column data does not match existing data.");
        }
        this.data.add(dArray);
        this.colNames.add(string);
        this.colTypes.add(8);
        ++this.columns;
    }

    public void addStringColumn(String string, String[] stringArray) throws Exception {
        if (this.columns == 0) {
            this.rows = stringArray.length;
        }
        if (stringArray.length != this.rows) {
            throw new Exception("Length of column data does not match existing data.");
        }
        this.data.add(stringArray);
        this.colNames.add(string);
        this.colTypes.add(12);
        ++this.columns;
    }

    public void addDateColumn(String string, String[] stringArray) throws Exception {
        if (this.columns == 0) {
            this.rows = stringArray.length;
        }
        if (stringArray.length != this.rows) {
            throw new Exception("Length of column data does not match existing data.");
        }
        Timestamp[] timestampArray = new Timestamp[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                timestampArray[i] = Timestamp.valueOf(stringArray[i]);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                timestampArray[i] = null;
            }
        }
        this.data.add(timestampArray);
        this.colNames.add(string);
        this.colTypes.add(93);
        ++this.columns;
    }

    public String[] getColNames() {
        return this.colNames.toArray(new String[0]);
    }

    public Integer[] getColTypes() {
        return this.colTypes.toArray(new Integer[0]);
    }

    public int length() {
        return this.rows;
    }

    public int columns() {
        return this.columns;
    }

    public int getIntegerData(int n, int n2) {
        return ((int[])this.data.get(n))[n2];
    }

    public double getDoubleData(int n, int n2) {
        return ((double[])this.data.get(n))[n2];
    }

    public String getStringData(int n, int n2) {
        return ((String[])this.data.get(n))[n2];
    }

    public Timestamp getDateData(int n, int n2) {
        return ((Timestamp[])this.data.get(n))[n2];
    }
}

