/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splusserver.api;

import com.insightful.splusserver.api.bridge.ICommonServerBridge;
import com.insightful.splusserver.domain.Authentication;
import com.insightful.splusserver.domain.Exception;
import com.insightful.splusserver.exception.GenericException;
import com.insightful.splusserver.exception.IException;
import com.insightful.splusserver.exception.NotAuthenticatedException;
import com.insightful.splusserver.exception.api.ApiException;
import com.insightful.splusserver.exception.api.BridgeException;
import com.insightful.splusserver.util.XmlUtil;
import org.apache.commons.logging.Log;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public abstract class CommonApi {
    private ICommonServerBridge mServerBridge = null;

    public String getPassword() {
        return this.mServerBridge.getPassword();
    }

    public void setPassword(String password) {
        this.mServerBridge.setPassword(password);
    }

    public String getUserName() {
        return this.mServerBridge.getUserName();
    }

    public void setUserName(String userName) {
        this.mServerBridge.setUserName(userName);
    }

    public Boolean validateUserCredentials() throws ApiException {
        try {
            return this.mServerBridge.validateUserCredentials();
        }
        catch (BridgeException e) {
            this.getLogger().error((Object)"validateUserCredentials threw an exception", (Throwable)e);
            throw new ApiException((Throwable)e);
        }
    }

    public Boolean validateUserCredentials(String userName, String password) throws ApiException {
        try {
            return this.mServerBridge.validateUserCredentials(userName, password);
        }
        catch (BridgeException e) {
            this.getLogger().error((Object)"validateUserCredentials threw an exception", (Throwable)e);
            throw new ApiException((Throwable)e);
        }
    }

    protected void checkAuthentication(String xml) throws NotAuthenticatedException, GenericException {
        try {
            Authentication auth = (Authentication)XmlUtil.unmarshal(Authentication.class, xml);
            if (!auth.getStatus().booleanValue()) {
                throw new NotAuthenticatedException("Not authenticated");
            }
        }
        catch (MarshalException e) {
            throw new GenericException("XML marshal error: " + xml);
        }
        catch (ValidationException e) {
            throw new GenericException("XML validation error: " + xml);
        }
        catch (MappingException e) {
            throw new GenericException("XML mapping error: " + xml);
        }
    }

    protected void checkException(String xml) throws IException {
        try {
            Exception ex = (Exception)XmlUtil.unmarshal(Exception.class, xml);
            IException e = ex.getException();
            throw e;
        }
        catch (MarshalException e) {
            this.checkAuthentication(xml);
        }
        catch (ValidationException e) {
            throw new GenericException("XML validation error: " + xml);
        }
        catch (MappingException e) {
            throw new GenericException("XML mapping error: " + xml);
        }
    }

    protected ICommonServerBridge getServerBridge() {
        return this.mServerBridge;
    }

    protected void setServerBridge(ICommonServerBridge client) {
        this.mServerBridge = client;
    }

    protected abstract Log getLogger();
}

