/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splusserver.util;

import com.insightful.splusserver.util.AuthenticationUtil;
import com.insightful.splusserver.util.DefaultAuthenticationUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;

public class UrlUtil {
    private AuthenticationUtil mAuthenticationUtil = new DefaultAuthenticationUtil();

    public Boolean checkUrlConnection(String url) {
        Boolean result = Boolean.FALSE;
        try {
            URLConnection urlConnection = this.mAuthenticationUtil.getUrlConnection(url);
            InputStream i = urlConnection.getInputStream();
            result = Boolean.TRUE;
            i.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public URLConnection getUrlConnection(String url) throws MalformedURLException, IOException {
        return this.mAuthenticationUtil.getUrlConnection(url);
    }

    public String getStringFromUrl(String url) throws IOException {
        URLConnection urlConnection = this.getUrlConnection(url);
        BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
        String line = null;
        StringBuffer result = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            result.append(line);
        }
        return result.toString();
    }

    public static URL createUrlFromHostAndPath(String host, String path) throws MalformedURLException {
        return new URL(UrlUtil.createUrlStringFromHostAndPath(host, path));
    }

    public static String createUrlStringFromHostAndPath(String host, String path) {
        String result = "";
        if (!StringUtils.isEmpty((String)host) && !StringUtils.isEmpty((String)path)) {
            String separator = "";
            if (host.charAt(host.length() - 1) != '/') {
                separator = "/";
            }
            result = host + separator + path;
        }
        return result;
    }

    public static String readUrlResult(URL url) throws IOException {
        URLConnection urlConnection = url.openConnection();
        urlConnection.connect();
        BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
        String line = null;
        StringBuffer result = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            result.append(line);
        }
        return result.toString();
    }

    public static String escapeUrl(String url) {
        String newUrl = url;
        try {
            newUrl = URLEncoder.encode(url, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newUrl;
    }

    public AuthenticationUtil getAuthenticationUtil() {
        return this.mAuthenticationUtil;
    }

    public void setAuthenticationUtil(AuthenticationUtil authenticationUtil) {
        this.mAuthenticationUtil = authenticationUtil;
    }
}

