/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor;

import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.connection.DefaultConnection;
import com.insightful.splus.eclipse.connection.NoConnection;
import com.insightful.splus.eclipse.editors.spluseditor.SplusContentOutlinePage;
import com.insightful.splus.eclipse.editors.spluseditor.actions.ToggleCommentAction;
import com.insightful.splus.eclipse.editors.spluseditor.context.SplusCompletionProcessor;
import com.insightful.splus.eclipse.editors.spluseditor.context.SplusPairMatcher;
import com.insightful.splus.eclipse.editors.spluseditor.util.DefaultSplusFoldingStructureProvider;
import com.insightful.splus.eclipse.editors.spluseditor.util.ExternalFileEditorInput;
import com.insightful.splus.eclipse.editors.spluseditor.util.SplusActionContributor;
import com.insightful.splus.eclipse.editors.spluseditor.util.SplusEditorMessages;
import com.insightful.splus.eclipse.editors.spluseditor.util.SplusSourceViewerConfiguration;
import com.insightful.splus.eclipse.parser.SplusParseTreeBuilder;
import com.insightful.splus.eclipse.preferences.SplusEditorPreferencePage;
import com.insightful.splus.eclipse.preferences.SplusPreferencePage;
import com.insightful.splus.eclipse.views.util.ConsoleHistoryDocument;
import com.insightful.splus.parser.PObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class SplusEditor
extends AbstractDecoratedTextEditor {
    private SplusContentOutlinePage fOutlinePage;
    private ProjectionSupport fProjectionSupport;
    private DefaultSplusFoldingStructureProvider fProjectionModelUpdater;
    private SplusSourceViewerConfiguration fSplusSourceViewerConfiguration;
    public static final String GOTO_MATCHING_BRACKET_ACTION_HELP = "com.insightful.splus.eclipse.editors.spluseditor.goto_matching_bracket_action";
    public static final String GOTO_MATCHING_BRACKET_ID = "com.insightful.splus.eclipse.editors.spluseditor.goto.matching.bracket";
    public static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']'};
    public SplusPairMatcher fBracketMatcher = new SplusPairMatcher(BRACKETS);
    public static final String ID = "org.eclipse.ui.SplusEditor";
    public static final String TOGGLE_COMMENT_ACTION_CMD = "ToggleComment";
    public static final String TOGGLE_COMMENT_ACTION_CMD_CTXT = "ToggleComment.CTXT";
    public static final String TOGGLE_COMMENT_ACTION_ID = "com.insightful.splus.eclipse.splus.toggle.comment";
    public static final String TOGGLE_COMMENT_COMMAND_ID = "com.insightful.splus.eclipse.editors.spluseditor.toggle.comment";
    public static final String FORMAT_ACTION_CMD = "Format";
    public static final String FORMAT_ACTION_CMD_CTXT = "Format.CTXT";
    public static final String FORMAT_ACTION_ID = "com.insightful.splus.eclipse.splus.format";
    public static final String FORMAT_COMMAND_ID = "com.insightful.splus.eclipse.editors.spluseditor.format";
    public static final String FOLDING_ACTION_CMD = "DefineFoldingRegion";
    public static final String FOLDING_ACTION_CMD_CTXT = "DefineFoldingRegion.CTXT";
    public static final String FOLDING_ACTION_ID = "com.insightful.splus.eclipse.editors.spluseditor.folding";
    public static final String HELP_TOPIC_ACTION_CMD = "SplusHelpTopic";
    public static final String HELP_TOPIC_ACTION_CMD_CTXT = "SplusHelpTopic.CTXT";
    public static final String HELP_TOPIC_ID = "com.insightful.splus.eclipse.splus.help.topic";
    public static final String HELP_ACTION_CMD = "SplusHelp";
    public static final String HELP_ACTION_CMD_CTXT = "SplusHelp.CTXT";
    public static final String HELP_ID = "com.insightful.splus.eclipse.splus.help";
    public static final String COPY_TO_CONSOLE_ACTION_CMD = "CopyToConsole";
    public static final String COPY_TO_CONSOLE_ACTION_CMD_CTXT = "CopyToConsole.CTXT";
    public static final String COPY_TO_CONSOLE_ACTION_ID = "com.insightful.splus.eclipse.editors.spluseditor.copy2Console";
    public static final String SRC_CUR_FILE_ACTION_CMD = "SourceCurrentFile";
    public static final String SRC_CUR_FILE_ACTION_CMD_CTXT = "SourceCurrentFile.CTXT";
    public static final String SRC_CUR_FILE_ACTION_ID = "com.insightful.splus.eclipse.splus.runFile";
    public static final String EDIT_CUR_FXN_ACTION_CMD = "EditCurrentFunction";
    public static final String EDIT_CUR_FXN_ACTION_CMD_CTXT = "EditCurrentFunction.CTXT";
    public static final String EDIT_CUR_FXN_ACTION_ID = "com.insightful.splus.eclipse.editors.spluseditor.find.method";
    public static final String FIND_CUR_FXN_REFS_ACTION_CMD = "FindCurrentFunctionRefs";
    public static final String FIND_CUR_FXN_REFS_ACTION_CMD_CTXT = "FindCurrentFunctionRefs.CTXT";
    public static final String FIND_CUR_FXN_REFS_ACTION_ID = "com.insightful.splus.eclipse.editors.spluseditor.find.references";
    public static final String FIND_ACTION_CMD = "FindSelection";
    public static final String FIND_ACTION_CMD_CTXT = "FindSelection.CTXT";
    public static final String FIND_ACTION_ID = "com.insightful.splus.eclipse.editors.spluseditor.findSel";
    public static final String RUN_COMMAND_ID = "com.insightful.splus.eclipse.debug.runSplusAction.command";
    public static final String RUN_ACTION_ID = "com.insightful.splus.eclipse.splus.runSelection";
    public static final String RUN_ACTION_CMD = "Run";
    public static final String RUN_ACTION_CMD_CTXT = "Run.CTXT";
    public static final String RUN_NEXT_ACTION_ID = "com.insightful.splus.eclipse.splus.runNextSelection";
    public static final String RUN_NEXT_ACTION_CMD = "RunNext";
    public static final String RUN_NEXT_ACTION_CMD_CTXT = "RunNext.CTXT";
    private Color fDefaultBackgroundColor;
    private boolean m_updateParseTree = false;
    private PObject m_parseTree = null;

    public SplusEditor() {
        this.setDocumentProvider(SplusEditorPlugin.getDefault().getDocumentProvider());
        this.setEditorContextMenuId("#SplusFileEditorContext");
        this.setRulerContextMenuId("#SplusFileRulerContext");
    }

    protected void createActions() {
        super.createActions();
        IAction iAction = SplusActionContributor.getFoldingAction(this);
        iAction = SplusActionContributor.getCopy2ConsoleAction(this);
        iAction = SplusActionContributor.getSplusHelpAction(this);
        iAction = SplusActionContributor.getSplusHelpTopicAction(this);
        iAction = SplusActionContributor.getSearchAction(this);
        iAction = SplusActionContributor.getGotoMatchingBracketAction(this);
        iAction = SplusActionContributor.getToggleCommentAction(this);
        iAction = SplusActionContributor.getFormatAction(this);
        iAction = SplusActionContributor.getFindDefinitionAction(this);
        iAction = SplusActionContributor.getFindReferencesAction(this);
        iAction = SplusActionContributor.getRunFileAction(this);
        iAction = SplusActionContributor.getRunAction(this);
        iAction = SplusActionContributor.getRunNextAction(this);
    }

    public String getSelectedText(boolean bl) {
        IDocument iDocument = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        TextSelection textSelection = (TextSelection)this.getSelectionProvider().getSelection();
        String string = textSelection.getText();
        if (string.length() == 0 && bl) {
            return iDocument.get();
        }
        return string;
    }

    public boolean doRun(boolean bl) {
        String string = this.getSelectedText(true);
        ConsoleHistoryDocument.runText(string, bl);
        return true;
    }

    public boolean doRunNext(boolean bl) {
        try {
            IDocument iDocument = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            TextSelection textSelection = (TextSelection)this.getSelectionProvider().getSelection();
            int n = textSelection.getOffset();
            int n2 = iDocument.getLineOfOffset(n);
            int n3 = n - iDocument.getLineOffset(n2);
            textSelection = this.getSelectedExpression(n2, n3, false);
            if (textSelection != null) {
                String string = textSelection.getText();
                boolean bl2 = SplusPreferencePage.getSendRunOutputToConsole();
                if (bl2) {
                    if (!string.endsWith(ConsoleHistoryDocument.g_lineDelimiter)) {
                        string = string + ConsoleHistoryDocument.g_lineDelimiter;
                    }
                    ConsoleHistoryDocument.copyToConsole(string);
                } else {
                    ConsoleHistoryDocument.runText(string, bl);
                }
                this.getSelectedExpression(n2, n3, true);
                return true;
            }
            MessageBox messageBox = new MessageBox(this.getSite().getShell());
            messageBox.setMessage("Cannot Run Next S-PLUS Command because editor contains syntax errors.");
            messageBox.setText("Error in Run Next S-PLUS Command");
            messageBox.open();
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return false;
    }

    private TextSelection getSelectedExpression(int n, int n2, boolean bl) throws BadLocationException {
        IDocument iDocument = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        PObject pObject = SplusParseTreeBuilder.findFirstPObject(this.getParseTree(), n, n2, bl);
        if (!pObject.poIsNull()) {
            int n3 = SplusParseTreeBuilder.getStartLine(pObject);
            int n4 = SplusParseTreeBuilder.getEndLine(pObject);
            int n5 = SplusParseTreeBuilder.getStartColumn(pObject);
            int n6 = SplusParseTreeBuilder.getEndColumn(pObject);
            int n7 = iDocument.getLineOffset(n3) + n5;
            int n8 = iDocument.getLineOffset(n4) + n6;
            TextSelection textSelection = new TextSelection(iDocument, n7, 1 + n8 - n7);
            this.getSelectionProvider().setSelection((ISelection)textSelection);
            return textSelection;
        }
        return null;
    }

    public void doHelpForSelection() {
        String string = this.getSelectedText(false);
        SplusEditorPlugin.getDefault().sendCmd("help(\"" + string + "\")");
    }

    public void doFindSelection() {
        String string = this.getSelectedText(false);
        NewSearchUI.openSearchDialog(null, null);
    }

    public void doHelp() {
        SplusEditorPlugin.getDefault().sendCmd("help()");
    }

    public void configureToggleCommentAction(String string) {
        IAction iAction = this.getAction(string);
        if (iAction instanceof ToggleCommentAction) {
            ISourceViewer iSourceViewer = this.getSourceViewer();
            ((ToggleCommentAction)iAction).configure(iSourceViewer, this.getSourceViewerConfiguration());
        }
    }

    public void dispose() {
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.uninstall();
            this.fProjectionModelUpdater = null;
        }
        if (this.fBracketMatcher != null) {
            this.fBracketMatcher.dispose();
            this.fBracketMatcher = null;
        }
        if (this.fOutlinePage != null) {
            this.fOutlinePage.setInput(null);
        }
        super.dispose();
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport sourceViewerDecorationSupport) {
        sourceViewerDecorationSupport.setCharacterPairMatcher((ICharacterPairMatcher)this.fBracketMatcher);
        sourceViewerDecorationSupport.setMatchingCharacterPainterPreferenceKeys("matchingBrackets", "matchingBracketsColor");
        super.configureSourceViewerDecorationSupport(sourceViewerDecorationSupport);
    }

    protected IRegion getSignedSelection(ISourceViewer iSourceViewer) {
        StyledText styledText = iSourceViewer.getTextWidget();
        Point point = styledText.getSelectionRange();
        if (styledText.getCaretOffset() == point.x) {
            point.x += point.y;
            point.y = -point.y;
        }
        point.x = SplusEditor.widgetOffset2ModelOffset((ISourceViewer)iSourceViewer, (int)point.x);
        return new Region(point.x, point.y);
    }

    private static boolean isBracket(char c) {
        for (int i = 0; i != BRACKETS.length; ++i) {
            if (c != BRACKETS[i]) continue;
            return true;
        }
        return false;
    }

    private static boolean isSurroundedByBrackets(IDocument iDocument, int n) {
        if (n == 0 || n == iDocument.getLength()) {
            return false;
        }
        try {
            return SplusEditor.isBracket(iDocument.getChar(n - 1)) && SplusEditor.isBracket(iDocument.getChar(n));
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected void setStatusLineErrorMessage(String string) {
        IEditorStatusLine iEditorStatusLine = (IEditorStatusLine)this.getAdapter(IEditorStatusLine.class);
        if (iEditorStatusLine != null) {
            iEditorStatusLine.setMessage(true, string, null);
        }
    }

    public void gotoMatchingBracket() {
        IRegion iRegion;
        ISourceViewer iSourceViewer = this.getSourceViewer();
        IDocument iDocument = iSourceViewer.getDocument();
        if (iDocument == null) {
            return;
        }
        IRegion iRegion2 = this.getSignedSelection(iSourceViewer);
        int n = Math.abs(iRegion2.getLength());
        if (n > 1) {
            this.setStatusLineErrorMessage(SplusEditorMessages.getString("GotoMatchingBracket.error.invalidSelection"));
            iSourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int n2 = iRegion2.getOffset() + iRegion2.getLength();
        if (SplusEditor.isSurroundedByBrackets(iDocument, n2)) {
            n2 -= iRegion2.getLength();
        }
        if ((iRegion = this.fBracketMatcher.match(iDocument, n2)) == null) {
            this.setStatusLineErrorMessage(SplusEditorMessages.getString("GotoMatchingBracket.error.noMatchingBracket"));
            iSourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int n3 = iRegion.getOffset();
        int n4 = iRegion.getLength();
        if (n4 < 1) {
            return;
        }
        int n5 = this.fBracketMatcher.getAnchor();
        int n6 = 0 == n5 ? n3 + 1 : n3 + n4;
        boolean bl = false;
        if (iSourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)iSourceViewer;
            bl = iTextViewerExtension5.modelOffset2WidgetOffset(n6) > -1;
        } else {
            IRegion iRegion3 = iSourceViewer.getVisibleRegion();
            boolean bl2 = bl = n6 >= iRegion3.getOffset() && n6 <= iRegion3.getOffset() + iRegion3.getLength();
        }
        if (!bl) {
            this.setStatusLineErrorMessage(SplusEditorMessages.getString("GotoMatchingBracket.error.bracketOutsideSelectedElement"));
            iSourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        if (iRegion2.getLength() < 0) {
            n6 -= iRegion2.getLength();
        }
        iSourceViewer.setSelectedRange(n6, iRegion2.getLength());
        iSourceViewer.revealRange(n6, iRegion2.getLength());
    }

    public void doRevertToSaved() {
        super.doRevertToSaved();
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        IEditorInput iEditorInput;
        IFile iFile;
        super.doSave(iProgressMonitor);
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.update();
        }
        IFile iFile2 = iFile = (iEditorInput = this.getEditorInput()) instanceof IFileEditorInput ? ((IFileEditorInput)iEditorInput).getFile() : null;
        if (iFile != null) {
            SplusEditorPlugin.savingFile(iFile.getFullPath().makeAbsolute().toString());
        }
    }

    public void doSaveAs() {
        super.doSaveAs();
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performSaveAs(IProgressMonitor iProgressMonitor) {
        Object object;
        IFile iFile;
        Shell shell = this.getSite().getShell();
        IEditorInput iEditorInput = this.getEditorInput();
        SaveAsDialog saveAsDialog = new SaveAsDialog(shell);
        IFile iFile2 = iFile = iEditorInput instanceof IFileEditorInput ? ((IFileEditorInput)iEditorInput).getFile() : null;
        if (iFile != null) {
            saveAsDialog.setOriginalFile(iFile);
        }
        saveAsDialog.create();
        IDocumentProvider iDocumentProvider = this.getDocumentProvider();
        if (iDocumentProvider == null) {
            return;
        }
        if (iDocumentProvider.isDeleted((Object)iEditorInput) && iFile != null) {
            object = "Error in Save As: " + iFile.getName();
            saveAsDialog.setErrorMessage(null);
            saveAsDialog.setMessage((String)object, 2);
        }
        if (saveAsDialog.open() == 1) {
            if (iProgressMonitor != null) {
                iProgressMonitor.setCanceled(true);
            }
            return;
        }
        object = saveAsDialog.getResult();
        if (object == null) {
            if (iProgressMonitor != null) {
                iProgressMonitor.setCanceled(true);
            }
            return;
        }
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IFile iFile3 = iWorkspace.getRoot().getFile(object);
        FileEditorInput fileEditorInput = new FileEditorInput(iFile3);
        boolean bl = false;
        try {
            iDocumentProvider.aboutToChange((Object)fileEditorInput);
            iDocumentProvider.saveDocument(iProgressMonitor, (Object)fileEditorInput, iDocumentProvider.getDocument((Object)iEditorInput), true);
            bl = true;
        }
        catch (CoreException coreException) {
            IStatus iStatus = coreException.getStatus();
            if (iStatus == null || iStatus.getSeverity() != 8) {
                String string = "Error in Save As";
                String string2 = coreException.getMessage();
                if (iStatus != null) {
                    switch (iStatus.getSeverity()) {
                        case 1: {
                            MessageDialog.openInformation((Shell)shell, (String)string, (String)string2);
                            break;
                        }
                        case 2: {
                            MessageDialog.openWarning((Shell)shell, (String)string, (String)string2);
                            break;
                        }
                        default: {
                            MessageDialog.openError((Shell)shell, (String)string, (String)string2);
                            break;
                        }
                    }
                } else {
                    MessageDialog.openError((Shell)shell, (String)string, (String)string2);
                }
            }
        }
        catch (Exception exception) {
            String string = "Error in Save As";
            String string3 = exception.getMessage();
            if (string3.startsWith("Attempted to begin")) {
                string3 = "Failed attempting to save file onto an existing project file.  \nRemove existing file from project first.";
            }
            MessageDialog.openError((Shell)shell, (String)string, (String)string3);
        }
        finally {
            iDocumentProvider.changed((Object)fileEditorInput);
            if (bl) {
                this.setInput((IEditorInput)fileEditorInput);
            }
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.setCanceled(!bl);
        }
        if (iFile != null) {
            SplusEditorPlugin.savingFile(iFile3.getFullPath().makeAbsolute().toString());
        }
    }

    private Class findClassOrNull(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    public boolean isSaveAsAllowed() {
        Class clazz = this.findClassOrNull("org.eclipse.ui.part.FileEditorInput");
        Class clazz2 = this.findClassOrNull("org.eclipse.ui.internal.editors.text.JavaFileEditorInput");
        Class clazz3 = this.findClassOrNull("org.eclipse.ui.ide.FileStoreEditorInput");
        Class clazz4 = this.findClassOrNull("com.insightful.splus.eclipse.editors.spluseditor.util.ExternalFileEditorInput");
        IEditorInput iEditorInput = this.getEditorInput();
        return clazz != null && clazz.isInstance(iEditorInput) || clazz2 != null && clazz2.isInstance(iEditorInput) || clazz3 != null && clazz3.isInstance(iEditorInput) || clazz4 != null && clazz4.isInstance(iEditorInput);
    }

    public void doSetInput(IEditorInput iEditorInput) throws CoreException {
        super.doSetInput(iEditorInput);
        if (this.fOutlinePage != null) {
            this.fOutlinePage.setInput(iEditorInput);
        }
        this.configureToggleCommentAction(TOGGLE_COMMENT_ACTION_CMD);
        this.configureToggleCommentAction(TOGGLE_COMMENT_ACTION_CMD_CTXT);
        IDocument iDocument = this.getDocumentProvider().getDocument((Object)iEditorInput);
        iDocument.addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent documentEvent) {
                SplusEditor.this.m_updateParseTree = true;
            }

            public void documentAboutToBeChanged(DocumentEvent documentEvent) {
            }
        });
        this.updateParseTree();
    }

    public void updateParseTree() {
        IEditorInput iEditorInput = this.getEditorInput();
        String string = this.getDocumentProvider().getDocument((Object)iEditorInput).get();
        this.m_parseTree = SplusParseTreeBuilder.getInstance().getParseTree(string);
        this.m_updateParseTree = false;
    }

    public PObject getParseTree() {
        if (this.m_updateParseTree) {
            this.updateParseTree();
        }
        return this.m_parseTree;
    }

    protected void editorContextMenuAboutToShow(IMenuManager iMenuManager) {
        super.editorContextMenuAboutToShow(iMenuManager);
        iMenuManager.add((IContributionItem)new Separator());
        this.addAction(iMenuManager, FORMAT_ACTION_CMD_CTXT);
        this.addAction(iMenuManager, TOGGLE_COMMENT_ACTION_CMD_CTXT);
        this.addAction(iMenuManager, "ShiftRight");
        this.addAction(iMenuManager, "ShiftLeft");
        iMenuManager.add((IContributionItem)new Separator());
        this.addAction(iMenuManager, FOLDING_ACTION_CMD_CTXT);
        iMenuManager.add((IContributionItem)new Separator());
        this.addAction(iMenuManager, RUN_ACTION_CMD_CTXT);
        this.addAction(iMenuManager, SRC_CUR_FILE_ACTION_CMD_CTXT);
        iMenuManager.add((IContributionItem)new Separator());
        this.addAction(iMenuManager, FIND_ACTION_CMD_CTXT);
        IAction iAction = this.getAction(EDIT_CUR_FXN_ACTION_CMD_CTXT);
        String string = this.getSelectedText(false);
        int n = string.length();
        if (n > 10) {
            string = string.substring(0, 10) + "...";
        }
        iAction.setText("Find \"" + string + "\"");
        iAction.setEnabled(n != 0);
        this.addAction(iMenuManager, EDIT_CUR_FXN_ACTION_CMD_CTXT);
        iAction = this.getAction(FIND_CUR_FXN_REFS_ACTION_CMD_CTXT);
        iAction.setEnabled(n != 0);
        this.addAction(iMenuManager, FIND_CUR_FXN_REFS_ACTION_CMD_CTXT);
        this.addAction(iMenuManager, COPY_TO_CONSOLE_ACTION_CMD_CTXT);
        iMenuManager.add((IContributionItem)new Separator());
        this.addAction(iMenuManager, HELP_TOPIC_ACTION_CMD_CTXT);
    }

    public Object getAdapter(Class clazz) {
        Object object;
        if (IContentOutlinePage.class.equals((Object)clazz)) {
            if (this.fOutlinePage == null) {
                this.fOutlinePage = new SplusContentOutlinePage(this.getDocumentProvider(), (ITextEditor)this);
                if (this.getEditorInput() != null) {
                    this.fOutlinePage.setInput(this.getEditorInput());
                }
            }
            return this.fOutlinePage;
        }
        if (this.fProjectionSupport != null && (object = this.fProjectionSupport.getAdapter(this.getSourceViewer(), clazz)) != null) {
            return object;
        }
        return super.getAdapter(clazz);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        IPreferenceStore iPreferenceStore = EditorsPlugin.getDefault().getPreferenceStore();
        this.fSplusSourceViewerConfiguration = new SplusSourceViewerConfiguration(this, iPreferenceStore);
        this.setSourceViewerConfiguration(this.fSplusSourceViewerConfiguration);
    }

    protected ISourceViewer createSourceViewer(Composite composite, IVerticalRuler iVerticalRuler, int n) {
        this.fAnnotationAccess = this.createAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        ProjectionViewer projectionViewer = new ProjectionViewer(composite, iVerticalRuler, this.getOverviewRuler(), this.isOverviewRulerVisible(), n);
        this.getSourceViewerDecorationSupport((ISourceViewer)projectionViewer);
        KeyListener keyListener = new KeyListener((ISourceViewer)projectionViewer){
            final /* synthetic */ ISourceViewer val$viewer;
            {
                this.val$viewer = iSourceViewer;
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 27) {
                    SplusEditor.this.doEscape();
                } else if (keyEvent.keyCode == 8) {
                    ContentAssistant contentAssistant = SplusEditor.this.fSplusSourceViewerConfiguration.getContentAssistant();
                    SplusCompletionProcessor splusCompletionProcessor = SplusEditor.this.fSplusSourceViewerConfiguration.getSplusCompletionProcessor();
                    String string = splusCompletionProcessor.getWordSoFar((ITextViewer)this.val$viewer, this.val$viewer.getTextWidget().getCaretOffset(), 1);
                    if (string != null && string.length() != 0) {
                        contentAssistant.showPossibleCompletions();
                    }
                }
            }

            public void keyPressed(KeyEvent keyEvent) {
            }
        };
        projectionViewer.getTextWidget().addKeyListener(keyListener);
        projectionViewer.getTextWidget().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                try {
                    IEditorInput iEditorInput = SplusEditor.this.getEditorInput();
                    String string = null;
                    if (iEditorInput instanceof ExternalFileEditorInput) {
                        string = ((ExternalFileEditorInput)iEditorInput).getFullPath().toOSString();
                    } else if (iEditorInput instanceof FileEditorInput) {
                        IFile iFile = ((FileEditorInput)iEditorInput).getFile();
                        string = iFile.getFullPath().makeRelative().toString();
                    }
                    if (string != null) {
                        SplusEditor.this.getEditorSite().getActionBars().getStatusLineManager().setMessage(string);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
        return projectionViewer;
    }

    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.fProjectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.fProjectionSupport.install();
        this.fDefaultBackgroundColor = projectionViewer.getTextWidget().getBackground();
        Color color = SplusEditorPreferencePage.getBackground();
        if (color != null) {
            projectionViewer.getTextWidget().setBackground(color);
        }
        this.fProjectionModelUpdater = new DefaultSplusFoldingStructureProvider();
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.install((ITextEditor)this, projectionViewer);
        }
        projectionViewer.doOperation(19);
        projectionViewer.doOperation(20);
    }

    protected void adjustHighlightRange(int n, int n2) {
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)iSourceViewer;
            iTextViewerExtension5.exposeModelRange((IRegion)new Region(n, n2));
        }
    }

    public void highlightRange(int n, int n2) {
        super.setHighlightRange(n, n2, true);
        this.getViewer().setSelectedRange(n, n2);
    }

    public ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    public void setEditable(boolean bl) {
        this.getSourceViewer().setEditable(bl);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent propertyChangeEvent) {
        SplusSourceViewerConfiguration splusSourceViewerConfiguration = (SplusSourceViewerConfiguration)this.getSourceViewerConfiguration();
        if (splusSourceViewerConfiguration != null) {
            splusSourceViewerConfiguration.handlePropertyChangeEvent(propertyChangeEvent);
        }
        if (propertyChangeEvent.getProperty().equals("editorCustomBackground") || propertyChangeEvent.getProperty().equals("editorBackgroundFont")) {
            Color color = SplusEditorPreferencePage.getBackground();
            if (color == null) {
                this.getViewer().getTextWidget().setBackground(this.fDefaultBackgroundColor);
            } else {
                this.getViewer().getTextWidget().setBackground(color);
            }
        }
        super.handlePreferenceStoreChanged(propertyChangeEvent);
    }

    private void doEscape() {
        NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
        if (noConnection instanceof DefaultConnection) {
            ((DefaultConnection)noConnection).setEscaped();
        }
    }

    protected void rulerContextMenuAboutToShow(IMenuManager iMenuManager) {
        super.rulerContextMenuAboutToShow(iMenuManager);
        MenuManager menuManager = new MenuManager("Folding", "projection");
        iMenuManager.appendToGroup("rulers", (IContributionItem)menuManager);
        IAction iAction = this.getAction("FoldingToggle");
        menuManager.add(iAction);
        iAction = this.getAction("FoldingExpandAll");
        menuManager.add(iAction);
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] stringArray = super.collectContextMenuPreferencePages();
        String string = "com.insightful.splus.eclipse.editors.spluseditor.preferences.SplusEditorPreferencePage";
        String[] stringArray2 = new String[stringArray.length + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            if (i == 0) {
                stringArray2[0] = string;
            }
            stringArray2[i + 1] = stringArray[i];
        }
        return stringArray2;
    }
}

