/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.actions;

import com.insightful.splus.eclipse.editors.spluseditor.util.SplusEditorMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;

public class FoldingActionGroup
extends ActionGroup {
    private ProjectionViewer fViewer;
    private TextOperationAction fToggle;
    private TextOperationAction fExpand;
    private TextOperationAction fCollapse;
    private TextOperationAction fExpandAll;
    private IProjectionListener fProjectionListener;

    public FoldingActionGroup(ITextEditor iTextEditor, ITextViewer iTextViewer) {
        if (iTextViewer instanceof ProjectionViewer) {
            this.fViewer = (ProjectionViewer)iTextViewer;
            this.fProjectionListener = new IProjectionListener(){

                public void projectionEnabled() {
                    FoldingActionGroup.this.update();
                }

                public void projectionDisabled() {
                    FoldingActionGroup.this.update();
                }
            };
            this.fViewer.addProjectionListener(this.fProjectionListener);
            this.fToggle = new TextOperationAction(SplusEditorMessages.getResourceBundle(), "Projection.Toggle.", iTextEditor, 19, true);
            this.fToggle.setChecked(true);
            this.fToggle.setActionDefinitionId("org.eclipse.ui.edit.text.folding.toggle");
            iTextEditor.setAction("FoldingToggle", (IAction)this.fToggle);
            this.fExpandAll = new TextOperationAction(SplusEditorMessages.getResourceBundle(), "Projection.ExpandAll.", iTextEditor, 20, true);
            this.fExpandAll.setActionDefinitionId("org.eclipse.ui.edit.text.folding.expand_all");
            iTextEditor.setAction("FoldingExpandAll", (IAction)this.fExpandAll);
            this.fExpand = new TextOperationAction(SplusEditorMessages.getResourceBundle(), "Projection.Expand.", iTextEditor, 17, true);
            this.fExpand.setActionDefinitionId("org.eclipse.ui.edit.text.folding.expand");
            iTextEditor.setAction("FoldingExpand", (IAction)this.fExpand);
            this.fCollapse = new TextOperationAction(SplusEditorMessages.getResourceBundle(), "Projection.Collapse.", iTextEditor, 18, true);
            this.fCollapse.setActionDefinitionId("org.eclipse.ui.edit.text.folding.collapse");
            iTextEditor.setAction("FoldingCollapse", (IAction)this.fCollapse);
        }
    }

    protected boolean isEnabled() {
        return this.fViewer != null;
    }

    public void dispose() {
        if (this.isEnabled()) {
            this.fViewer.removeProjectionListener(this.fProjectionListener);
            this.fViewer = null;
        }
        super.dispose();
    }

    protected void update() {
        if (this.isEnabled()) {
            this.fToggle.update();
            this.fToggle.setChecked(this.fViewer.getProjectionAnnotationModel() != null);
            this.fExpand.update();
            this.fExpandAll.update();
            this.fCollapse.update();
        }
    }

    public void fillMenu(IMenuManager iMenuManager) {
        if (this.isEnabled()) {
            this.update();
            iMenuManager.add((IAction)this.fToggle);
            iMenuManager.add((IAction)this.fExpandAll);
            iMenuManager.add((IAction)this.fExpand);
            iMenuManager.add((IAction)this.fCollapse);
        }
    }

    public void updateActionBars() {
        this.update();
    }
}

