/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.context;

import com.insightful.splus.eclipse.editors.spluseditor.context.SplusIncrementalBuilder;
import com.insightful.splus.eclipse.parser.SplusParseTreeBuilder;
import com.insightful.splus.parser.PObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class SplusIncrementalParser
extends SplusIncrementalBuilder {
    private static String FUNCTION_DEFINITION_TYPE = "com.insightful.splus.eclipse.debug.splusFunctionsDefinedMarker";
    private static String NUM_FUNS = "numFunsDefined";
    private static String FUN_ATTR = "funDef";
    private static HashMap g_functionResourceMap = null;
    public static final String P_BUILDER_ID = "com.insightful.splus.eclipse.parser";

    private void createIncompleteMarker(IResource iResource) throws CoreException {
        IMarker iMarker = iResource.createMarker("org.eclipse.core.resources.problemmarker");
        iMarker.setAttributes(new String[]{"message", "severity", "done", "userEditable"}, new Object[]{"Syntactically correct but incomplete.", new Integer(2), new Boolean(false), new Boolean(false)});
    }

    private void createErrorMarker(IResource iResource, String string, int n) throws CoreException {
        IMarker iMarker = iResource.createMarker("org.eclipse.core.resources.problemmarker");
        iMarker.setAttributes(new String[]{"message", "severity", "done", "lineNumber", "userEditable"}, new Object[]{string.trim(), new Integer(2), new Boolean(false), new Integer(n), new Boolean(false)});
    }

    private void doVisit(IResource iResource) {
        if (iResource.exists()) {
            String string = SplusParseTreeBuilder.toString(iResource.getLocation().toFile());
            try {
                PObject pObject = SplusParseTreeBuilder.getInstance().getParseTree(string);
                this.findSyntaxErrors((IFile)iResource, pObject);
                this.findFunctions(pObject, iResource);
                this.storeFunctions(iResource);
            }
            catch (Throwable throwable) {
                try {
                    this.createErrorMarker(iResource, "Error in parse: " + throwable.getMessage(), 1);
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
                throwable.printStackTrace();
            }
        }
    }

    private void storeFunctions(IResource iResource) {
        try {
            iResource.deleteMarkers(FUNCTION_DEFINITION_TYPE, true, 2);
            IMarker iMarker = iResource.createMarker(FUNCTION_DEFINITION_TYPE);
            Object[] objectArray = ((HashMap)g_functionResourceMap.get(iResource)).keySet().toArray();
            iMarker.setAttribute(NUM_FUNS, (Object)new Integer(objectArray.length));
            for (int i = 0; i < objectArray.length; ++i) {
                String string = FUN_ATTR + Integer.toString(i);
                iMarker.setAttribute(string, objectArray[i]);
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    private void findSyntaxErrors(IFile iFile, PObject pObject) {
        try {
            iFile.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            boolean bl = SplusParseTreeBuilder.getInstance().isComplete(pObject);
            String[] stringArray = SplusParseTreeBuilder.getInstance().getSyntaxErrors(pObject);
            double[] dArray = SplusParseTreeBuilder.getInstance().getSyntaxErrorLines(pObject);
            if (!bl) {
                this.createIncompleteMarker((IResource)iFile);
            } else if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.createErrorMarker((IResource)iFile, stringArray[i], (int)dArray[i] + 1);
                }
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    protected IResourceVisitor getFullVisitor() {
        return new FullBuildVisitor();
    }

    protected IResourceDeltaVisitor getIncrementalVisitor() {
        return new IncrementalBuildDeltaVisitor();
    }

    public static void addBuilderToProject(IProject iProject) {
        SplusIncrementalParser.addBuilderToProject(iProject, P_BUILDER_ID);
    }

    public static void removeBuilderFromProject(IProject iProject) {
        SplusIncrementalParser.removeBuilderFromProject(iProject, P_BUILDER_ID);
    }

    private void getResourceFunctionDefinitions() {
        try {
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            this.initialize();
            for (int i = 0; i < iProjectArray.length; ++i) {
                if (!iProjectArray[i].isAccessible()) continue;
                iProjectArray[i].accept((IResourceVisitor)new InitializeFunctionDefinitionsVisitor());
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    public static IResource[] getFunctionResource(String string) {
        IResource[] iResourceArray;
        if (g_functionResourceMap == null) {
            g_functionResourceMap = new HashMap();
            new SplusIncrementalParser().getResourceFunctionDefinitions();
        }
        Iterator iterator = g_functionResourceMap.keySet().iterator();
        Vector<IResource[]> vector = new Vector<IResource[]>();
        while (iterator.hasNext()) {
            iResourceArray = (IResource[])iterator.next();
            HashMap hashMap = (HashMap)g_functionResourceMap.get(iResourceArray);
            if (hashMap.get(string) == null) continue;
            vector.add(iResourceArray);
        }
        iResourceArray = new IResource[vector.size()];
        vector.toArray(iResourceArray);
        return iResourceArray;
    }

    private void findFunctions(PObject pObject, IResource iResource) {
        if (g_functionResourceMap == null) {
            g_functionResourceMap = new HashMap();
        }
        HashMap hashMap = new HashMap();
        SplusParseTreeBuilder.getFunctionsDefined(pObject, hashMap);
        g_functionResourceMap.put(iResource, hashMap);
    }

    class IncrementalBuildDeltaVisitor
    implements IResourceDeltaVisitor {
        IncrementalBuildDeltaVisitor() {
        }

        public boolean visit(IResourceDelta iResourceDelta) {
            if (SplusIncrementalBuilder.ignoreChildren(iResourceDelta.getResource())) {
                return false;
            }
            IPath iPath = iResourceDelta.getFullPath();
            if (SplusIncrementalBuilder.isBuildable(iPath.getFileExtension())) {
                if (SplusIncrementalParser.this.checkCancel()) {
                    return false;
                }
                try {
                    SplusIncrementalParser.this.doVisit(iResourceDelta.getResource());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return true;
        }
    }

    class FullBuildVisitor
    implements IResourceVisitor {
        FullBuildVisitor() {
        }

        public boolean visit(IResource iResource) {
            if (SplusIncrementalBuilder.ignoreChildren(iResource)) {
                return false;
            }
            IPath iPath = iResource.getFullPath();
            if (iResource.getType() == 1 && SplusIncrementalBuilder.isBuildable(iPath.getFileExtension())) {
                if (SplusIncrementalParser.this.checkCancel()) {
                    return false;
                }
                SplusIncrementalParser.this.doVisit(iResource);
            }
            return true;
        }
    }

    class InitializeFunctionDefinitionsVisitor
    implements IResourceVisitor {
        InitializeFunctionDefinitionsVisitor() {
        }

        public boolean visit(IResource iResource) {
            if (iResource.getType() == 1 && SplusIncrementalBuilder.isBuildable(iResource.getFullPath().getFileExtension()) && g_functionResourceMap.get(iResource) == null) {
                try {
                    IMarker[] iMarkerArray = iResource.findMarkers(FUNCTION_DEFINITION_TYPE, false, 2);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    for (int i = 0; i < iMarkerArray.length; ++i) {
                        int n = (Integer)iMarkerArray[i].getAttribute(NUM_FUNS);
                        for (int j = 0; j < n; ++j) {
                            String string = iMarkerArray[i].getAttribute(FUN_ATTR + Integer.toString(j)).toString();
                            hashMap.put(string, string);
                        }
                    }
                    g_functionResourceMap.put(iResource, hashMap);
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
            }
            return true;
        }
    }
}

