/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.context;

import com.insightful.splus.eclipse.editors.spluseditor.context.SplusIncrementalBuilder;
import com.insightful.splus.eclipse.preferences.SplusTaskPreferencePage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class SplusIncrementalTaskFinder
extends SplusIncrementalBuilder {
    private String[][] fTaskList = null;
    private String[] fTasks = null;
    private String[] fSeverities = null;
    private int[] fSeverityNums = null;
    public static final String TF_BUILDER_ID = "com.insightful.splus.eclipse.taskfinder";

    public void initialize() {
        super.initialize();
        this.fTaskList = SplusTaskPreferencePage.getTasks();
        this.fTasks = this.fTaskList[0];
        this.fSeverities = this.fTaskList[1];
        this.fSeverityNums = new int[this.fSeverities.length];
        for (int i = 0; i < this.fSeverityNums.length; ++i) {
            this.fSeverityNums[i] = this.fSeverities[i].equals("HIGH") ? 2 : (this.fSeverities[i].equals("LOW") ? 0 : 1);
        }
    }

    protected IResourceVisitor getFullVisitor() {
        return new FullBuildVisitor();
    }

    protected IResourceDeltaVisitor getIncrementalVisitor() {
        return new IncrementalBuildDeltaVisitor();
    }

    private void findTasksforPath(IPath iPath) {
        IFile iFile = this.getProject().getFile(iPath);
        this.readFile(iFile, true);
    }

    private String readFile(IFile iFile, boolean bl) {
        if (!iFile.exists()) {
            return "";
        }
        InputStream inputStream = null;
        try {
            inputStream = iFile.getContents();
            iFile.deleteMarkers("org.eclipse.core.resources.taskmarker", true, 2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            boolean bl2 = false;
            boolean bl3 = false;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while ((n = ((Reader)bufferedReader).read()) != -1) {
                switch (n) {
                    case 13: {
                        ++n4;
                        bl2 = true;
                        break;
                    }
                    case 10: {
                        if (n2 != 13) {
                            ++n4;
                        }
                        bl2 = true;
                        break;
                    }
                    case 35: {
                        bl3 = true;
                    }
                }
                if (!bl2) {
                    stringBuffer2.append((char)n);
                } else {
                    if (bl3) {
                        String string = stringBuffer2.toString();
                        for (int i = 0; i < this.fTasks.length; ++i) {
                            int n5 = string.indexOf(this.fTasks[i]);
                            if (n5 == -1) continue;
                            try {
                                IMarker iMarker = iFile.createMarker("org.eclipse.core.resources.taskmarker");
                                iMarker.setAttributes(new String[]{"message", "priority", "done", "charStart", "charEnd", "lineNumber", "userEditable"}, new Object[]{string.substring(n5).trim(), new Integer(this.fSeverityNums[i]), new Boolean(false), new Integer(n3 + n5), new Integer(n3 + n5 + this.fTasks[i].length()), new Integer(n4), new Boolean(false)});
                                continue;
                            }
                            catch (CoreException coreException) {
                                coreException.printStackTrace();
                            }
                        }
                    }
                    stringBuffer2.append((char)n);
                    n3 += stringBuffer2.length();
                    stringBuffer.append(stringBuffer2.toString());
                    stringBuffer2.setLength(0);
                    bl2 = false;
                    bl3 = false;
                }
                n2 = n;
            }
            if (stringBuffer2.length() != 0) {
                n3 += stringBuffer2.length();
                stringBuffer.append(stringBuffer2.toString());
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        return "";
    }

    public static void addBuilderToProject(IProject iProject) {
        SplusIncrementalTaskFinder.addBuilderToProject(iProject, TF_BUILDER_ID);
    }

    public static void removeBuilderFromProject(IProject iProject) {
        SplusIncrementalTaskFinder.removeBuilderFromProject(iProject, TF_BUILDER_ID);
    }

    class IncrementalBuildDeltaVisitor
    implements IResourceDeltaVisitor {
        IncrementalBuildDeltaVisitor() {
        }

        public boolean visit(IResourceDelta iResourceDelta) {
            if (SplusIncrementalBuilder.ignoreChildren(iResourceDelta.getResource())) {
                return false;
            }
            if (SplusIncrementalBuilder.isBuildable(iResourceDelta.getFullPath().getFileExtension())) {
                if (SplusIncrementalTaskFinder.this.checkCancel()) {
                    return false;
                }
                SplusIncrementalTaskFinder.this.findTasksforPath(iResourceDelta.getProjectRelativePath());
            }
            return true;
        }
    }

    class FullBuildVisitor
    implements IResourceVisitor {
        FullBuildVisitor() {
        }

        public boolean visit(IResource iResource) {
            if (SplusIncrementalBuilder.ignoreChildren(iResource)) {
                return false;
            }
            if (iResource.getType() == 1 && SplusIncrementalBuilder.isBuildable(iResource.getFullPath().getFileExtension())) {
                if (SplusIncrementalTaskFinder.this.checkCancel()) {
                    return false;
                }
                SplusIncrementalTaskFinder.this.findTasksforPath(iResource.getProjectRelativePath());
            }
            return true;
        }
    }
}

