/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.util;

import com.insightful.splus.eclipse.editors.spluseditor.util.SplusEditorMessages;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultAutoIndentStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;

public class SplusAutoIndentStrategy
extends DefaultAutoIndentStrategy {
    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        if (documentCommand.length == 0 && documentCommand.text != null && this.endsWithDelimiter(iDocument, documentCommand.text)) {
            this.smartIndentAfterNewLine(iDocument, documentCommand);
        } else if ("}".equals(documentCommand.text)) {
            this.smartInsertAfterBracket(iDocument, documentCommand);
        }
    }

    private boolean endsWithDelimiter(IDocument iDocument, String string) {
        String[] stringArray = iDocument.getLegalLineDelimiters();
        if (stringArray != null) {
            return TextUtilities.endsWith((String[])stringArray, (String)string) > -1;
        }
        return false;
    }

    protected int findMatchingOpenBracket(IDocument iDocument, int n, int n2, int n3) throws BadLocationException {
        int n4 = iDocument.getLineOffset(n);
        for (int i = this.getBracketCount(iDocument, n4, n2, false) - n3; i < 0; i += this.getBracketCount(iDocument, n4, n2, false)) {
            if (--n < 0) {
                return -1;
            }
            n4 = iDocument.getLineOffset(n);
            n2 = n4 + iDocument.getLineLength(n) - 1;
        }
        return n;
    }

    private int getBracketCount(IDocument iDocument, int n, int n2, boolean bl) throws BadLocationException {
        int n3 = n;
        int n4 = 0;
        block7: while (n3 < n2) {
            char c = iDocument.getChar(n3);
            ++n3;
            switch (c) {
                case '/': {
                    if (n3 >= n2) break;
                    char c2 = iDocument.getChar(n3);
                    if (c2 == '*') {
                        n3 = this.getCommentEnd(iDocument, n3 + 1, n2);
                        break;
                    }
                    if (c2 != '/') continue block7;
                    n3 = n2;
                    break;
                }
                case '*': {
                    if (n3 >= n2) break;
                    char c2 = iDocument.getChar(n3);
                    if (c2 != '/') continue block7;
                    n4 = 0;
                    ++n3;
                    break;
                }
                case '{': {
                    ++n4;
                    bl = false;
                    break;
                }
                case '}': {
                    if (bl) break;
                    --n4;
                    break;
                }
                case '\"': 
                case '\'': {
                    n3 = this.getStringEnd(iDocument, n3, n2, c);
                    break;
                }
            }
        }
        return n4;
    }

    private int getCommentEnd(IDocument iDocument, int n, int n2) throws BadLocationException {
        int n3 = n;
        while (n3 < n2) {
            char c = iDocument.getChar(n3);
            if (c != '*' || ++n3 >= n2 || iDocument.getChar(n3) != '/') continue;
            return n3 + 1;
        }
        return n2;
    }

    protected String getIndentOfLine(IDocument iDocument, int n) throws BadLocationException {
        if (n > -1) {
            int n2 = iDocument.getLineOffset(n);
            int n3 = n2 + iDocument.getLineLength(n) - 1;
            int n4 = this.findEndOfWhiteSpace(iDocument, n2, n3);
            return iDocument.get(n2, n4 - n2);
        }
        return "";
    }

    private int getStringEnd(IDocument iDocument, int n, int n2, char c) throws BadLocationException {
        int n3 = n;
        while (n3 < n2) {
            char c2 = iDocument.getChar(n3);
            ++n3;
            if (c2 == '\\') {
                ++n3;
                continue;
            }
            if (c2 != c) continue;
            return n3;
        }
        return n2;
    }

    protected void smartIndentAfterNewLine(IDocument iDocument, DocumentCommand documentCommand) {
        int n = iDocument.getLength();
        if (documentCommand.offset == -1 || n == 0) {
            return;
        }
        try {
            int n2 = documentCommand.offset == n ? documentCommand.offset - 1 : documentCommand.offset;
            int n3 = iDocument.getLineOfOffset(n2);
            StringBuffer stringBuffer = new StringBuffer(documentCommand.text);
            if (documentCommand.offset < n && iDocument.getChar(documentCommand.offset) == '}') {
                int n4 = this.findMatchingOpenBracket(iDocument, n3, documentCommand.offset, 0);
                if (n4 == -1) {
                    n4 = n3;
                }
                stringBuffer.append(this.getIndentOfLine(iDocument, n4));
            } else {
                int n5 = iDocument.getLineOffset(n3);
                int n6 = this.findEndOfWhiteSpace(iDocument, n5, documentCommand.offset);
                stringBuffer.append(iDocument.get(n5, n6 - n5));
                if (this.getBracketCount(iDocument, n5, documentCommand.offset, true) > 0) {
                    stringBuffer.append('\t');
                }
            }
            documentCommand.text = stringBuffer.toString();
        }
        catch (BadLocationException badLocationException) {
            System.out.println(SplusEditorMessages.getString("AutoIndent.error.bad_location_1"));
        }
    }

    protected void smartInsertAfterBracket(IDocument iDocument, DocumentCommand documentCommand) {
        if (documentCommand.offset == -1 || iDocument.getLength() == 0) {
            return;
        }
        try {
            int n;
            int n2 = documentCommand.offset == iDocument.getLength() ? documentCommand.offset - 1 : documentCommand.offset;
            int n3 = iDocument.getLineOfOffset(n2);
            int n4 = iDocument.getLineOffset(n3);
            int n5 = this.findEndOfWhiteSpace(iDocument, n4, documentCommand.offset);
            if (n5 == documentCommand.offset && (n = this.findMatchingOpenBracket(iDocument, n3, documentCommand.offset, 1)) != -1 && n != n3) {
                StringBuffer stringBuffer = new StringBuffer(this.getIndentOfLine(iDocument, n));
                stringBuffer.append(iDocument.get(n5, documentCommand.offset - n5));
                stringBuffer.append(documentCommand.text);
                documentCommand.length = documentCommand.offset - n4;
                documentCommand.offset = n4;
                documentCommand.text = stringBuffer.toString();
            }
        }
        catch (BadLocationException badLocationException) {
            System.out.println(SplusEditorMessages.getString("AutoIndent.error.bad_location_2"));
        }
    }
}

